/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.pr.client.editors.definition.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.Range;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.ga.model.PortableQueryFilter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.jbpm.console.ng.gc.forms.client.display.views.FormDisplayerView;
import org.jbpm.console.ng.pr.client.i18n.Constants;
import org.jbpm.console.ng.pr.forms.client.display.providers.StartProcessFormDisplayProviderImpl;
import org.jbpm.console.ng.pr.forms.client.display.views.PopupFormDisplayerView;
import org.jbpm.console.ng.pr.forms.display.process.api.ProcessDisplayerConfig;
import org.jbpm.console.ng.pr.model.ProcessDefinitionKey;
import org.jbpm.console.ng.pr.model.ProcessSummary;
import org.jbpm.console.ng.pr.service.ProcessDefinitionService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="Process Definition List")
public class ProcessDefinitionListPresenter
extends AbstractScreenListPresenter<ProcessSummary> {
    @Inject
    PopupFormDisplayerView formDisplayPopUp;
    @Inject
    StartProcessFormDisplayProviderImpl startProcessDisplayProvider;
    @Inject
    private ProcessDefinitionListView view;
    @Inject
    private Caller<ProcessDefinitionService> processDefinitionService;
    private Constants constants = (Constants)GWT.create(Constants.class);

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Process_Definitions();
    }

    @WorkbenchPartView
    public UberView<ProcessDefinitionListPresenter> getView() {
        return this.view;
    }

    public void openGenericForm(String processDefId, String deploymentId, String processDefName) {
        ProcessDisplayerConfig config = new ProcessDisplayerConfig(new ProcessDefinitionKey(deploymentId, processDefId), processDefName);
        this.formDisplayPopUp.setTitle(processDefName);
        this.startProcessDisplayProvider.setup(config, (FormDisplayerView)this.formDisplayPopUp);
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
        if (this.currentFilter == null) {
            this.currentFilter = new PortableQueryFilter(visibleRange.getStart(), visibleRange.getLength(), false, "", columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "", columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true);
        }
        if (this.currentFilter.getParams() == null || this.currentFilter.getParams().isEmpty() || this.currentFilter.getParams().get("textSearch") == null || this.currentFilter.getParams().get("textSearch").equals("")) {
            this.currentFilter.setOffset(Integer.valueOf(visibleRange.getStart()));
            this.currentFilter.setCount(Integer.valueOf(visibleRange.getLength()));
        } else {
            this.currentFilter.setOffset(Integer.valueOf(0));
            this.currentFilter.setCount(Integer.valueOf(this.view.getListGrid().getPageSize()));
        }
        this.currentFilter.setOrderBy(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
        this.currentFilter.setIsAscending(Boolean.valueOf(columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true));
        ((ProcessDefinitionService)this.processDefinitionService.call((RemoteCallback)new RemoteCallback<PageResponse<ProcessSummary>>(){

            public void callback(PageResponse<ProcessSummary> response) {
                ProcessDefinitionListPresenter.this.updateDataOnCallback(response);
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ProcessDefinitionListPresenter.this.view.hideBusyIndicator();
                ProcessDefinitionListPresenter.this.view.displayNotification(ProcessDefinitionListPresenter.this.constants.ErrorRetrievingProcessDefinitions(throwable.getMessage()));
                GWT.log((String)throwable.toString());
                return true;
            }
        })).getData(this.currentFilter);
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build();
    }

    public static interface ProcessDefinitionListView
    extends AbstractListView.ListView<ProcessSummary, ProcessDefinitionListPresenter> {
    }
}

