/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.server.impl;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jbpm.console.ng.bd.service.AdministrationService;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.screens.workbench.backend.BaseAppSetup;
import org.uberfire.commons.services.cdi.ApplicationStarted;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.io.IOService;

@ApplicationScoped
@Startup
public class AppSetup
extends BaseAppSetup {
    private static final String JBPM_WB_PLAYGROUND_ALIAS = "jbpm-playground";
    private static final String JBPM_WB_PLAYGROUND_ORIGIN = "https://github.com/droolsjbpm/jbpm-playground.git";
    private AdministrationService administrationService;
    private Event<ApplicationStarted> applicationStartedEvent;

    protected AppSetup() {
    }

    @Inject
    public AppSetup(@Named(value="ioStrategy") IOService ioService, RepositoryService repositoryService, OrganizationalUnitService organizationalUnitService, KieProjectService projectService, ConfigurationService configurationService, ConfigurationFactory configurationFactory, AdministrationService administrationService, Event<ApplicationStarted> applicationStartedEvent) {
        super(ioService, repositoryService, organizationalUnitService, projectService, configurationService, configurationFactory);
        this.administrationService = administrationService;
        this.applicationStartedEvent = applicationStartedEvent;
    }

    @PostConstruct
    public void onStartup() {
        if (!"false".equalsIgnoreCase(System.getProperty("org.kie.demo"))) {
            this.administrationService.bootstrapRepository("demo", JBPM_WB_PLAYGROUND_ALIAS, JBPM_WB_PLAYGROUND_ORIGIN, "", "");
        } else if ("true".equalsIgnoreCase(System.getProperty("org.kie.example"))) {
            this.administrationService.bootstrapRepository("example", "repository1", null, "", "");
            this.administrationService.bootstrapProject("repository1", "org.kie.example", "project1", "1.0.0-SNAPSHOT");
        }
        this.administrationService.bootstrapConfig();
        this.administrationService.bootstrapDeployments();
        this.configurationService.addConfiguration(this.getGlobalConfiguration());
        this.applicationStartedEvent.fire((Object)new ApplicationStarted());
    }

    private ConfigGroup getGlobalConfiguration() {
        ConfigGroup group = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "settings", "");
        group.addConfigItem(this.configurationFactory.newConfigItem("build.enable-incremental", "true"));
        group.addConfigItem(this.configurationFactory.newConfigItem("support.runtime.deploy", "true"));
        return group;
    }
}

