/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.AssetTypeMapper;
import org.jbpm.designer.repository.Directory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AssetServiceServlet
extends HttpServlet {
    private static final Logger _logger = Logger.getLogger(AssetServiceServlet.class);
    private static final String ACTION_CREATE_ASSET = "createasset";
    private static final String ACTION_UPDATE_ASSET = "updateasset";
    private static final String ACTION_DELETE_ASSET = "deleteasset";
    private static final String ACTION_ASSET_EXISTS = "existsasset";
    private static final String ACTION_CREATE_DIRECTORY = "createdir";
    private static final String ACTION_DELETE_DIRECTORY = "deletedir";
    private static final String ACTION_DIRECTORY_EXISTS = "existsdir";
    private static final String ACTION_LIST_DIRECTORIES = "listdirs";
    private static final String ACTION_LIST_ASSETS = "listassets";
    private static final String ACTION_GET_ASSET_INFO = "getassetinfo";
    private static final String ACTION_GET_ASSET_SOURCE = "getassetsource";
    private static final String OPTION_BY_PATH = "optionbypath";
    private static final String OPTION_BY_ID = "optionbyid";
    private static final String TRANSFORMATION_JSON_TO_BPMN2 = "jsontobpmn2";
    private IDiagramProfile profile;
    @Inject
    private IDiagramProfileService _profileService = null;

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block53: {
            String profileName = req.getParameter("profile");
            String action = req.getParameter("action");
            String preprocessingData = req.getParameter("pp");
            String assetId = req.getParameter("assetid");
            String assetType = req.getParameter("assettype");
            String assetName = req.getParameter("assetname");
            String assetContent = req.getParameter("assetcontent");
            String assetContentTransform = req.getParameter("assetcontenttransform");
            String assetLocation = req.getParameter("assetlocation");
            String loadoption = req.getParameter("loadoption");
            JSONObject returnObj = new JSONObject();
            JSONArray errorsArray = new JSONArray();
            try {
                if (this.profile == null) {
                    this.profile = this._profileService.findProfile(req, profileName);
                }
                Repository repository = this.profile.getRepository();
                if (action != null && action.equals(ACTION_CREATE_ASSET)) {
                    try {
                        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Text);
                        builder.content("").type(assetType).name(assetName).location(assetLocation);
                        String id = repository.createAsset(builder.getAsset());
                        if (id == null) {
                            _logger.error((Object)("Unable to create asset: " + assetLocation));
                            this.addError(errorsArray, "Unable to create asset: " + assetLocation);
                        }
                        returnObj.put("assetId", (Object)id);
                    }
                    catch (Exception e) {
                        _logger.error((Object)("Error creating asset: " + e.getMessage()));
                        this.addError(errorsArray, "Error creating asset: " + e.getMessage());
                    }
                    this.jsonResponse(returnObj, errorsArray, resp);
                    break block53;
                }
                if (action != null && action.equals(ACTION_UPDATE_ASSET)) {
                    try {
                        if (assetContentTransform != null && assetContentTransform.equals(TRANSFORMATION_JSON_TO_BPMN2)) {
                            assetContent = this.profile.createMarshaller().parseModel(assetContent, preprocessingData);
                        }
                        Asset currentAsset = repository.loadAsset(assetId);
                        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder(currentAsset);
                        builder.content(assetContent);
                        String id = repository.updateAsset(builder.getAsset());
                        if (id == null) {
                            _logger.error((Object)("Unable to store asset: " + assetLocation));
                            this.addError(errorsArray, "Unable to store asset: " + assetLocation);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        _logger.error((Object)("Error storing asset: " + e.getMessage()));
                        this.addError(errorsArray, "Error storing asset: " + e.getMessage());
                    }
                    this.jsonResponse(returnObj, errorsArray, resp);
                    break block53;
                }
                if (action != null && action.equals(ACTION_DELETE_ASSET)) {
                    try {
                        Boolean ret = repository.deleteAsset(assetId);
                        if (!ret.booleanValue()) {
                            _logger.error((Object)("Unable to delete asset: " + assetId));
                            this.addError(errorsArray, "Unable to delete asset: " + assetId);
                        }
                    }
                    catch (Exception e) {
                        _logger.error((Object)("Error deleting asset: " + e.getMessage()));
                        this.addError(errorsArray, "Error deleting asset: " + e.getMessage());
                    }
                    this.jsonResponse(returnObj, errorsArray, resp);
                    break block53;
                }
                if (action != null && action.equals(ACTION_ASSET_EXISTS)) {
                    try {
                        Boolean ret = repository.assetExists(assetId);
                        returnObj.put("answer", (Object)String.valueOf(ret));
                    }
                    catch (Exception e) {
                        _logger.error((Object)("Error: " + e.getMessage()));
                        returnObj.put("answer", (Object)"false");
                        this.addError(errorsArray, "Error: " + e.getMessage());
                    }
                    this.jsonResponse(returnObj, errorsArray, resp);
                    break block53;
                }
                if (action != null && action.equals(ACTION_CREATE_DIRECTORY)) {
                    Directory ret = repository.createDirectory(assetLocation);
                    if (ret == null) {
                        _logger.error((Object)("Unable to create asset: " + assetLocation));
                        this.addError(errorsArray, "Unable to create asset: " + assetLocation);
                    }
                    this.jsonResponse(returnObj, errorsArray, resp);
                    break block53;
                }
                if (action != null && action.equals(ACTION_DELETE_DIRECTORY)) {
                    try {
                        Boolean ret = repository.deleteDirectory(assetLocation, false);
                        returnObj.put("answer", (Object)String.valueOf(ret));
                    }
                    catch (Exception e) {
                        _logger.error((Object)("Error: " + e.getMessage()));
                        returnObj.put("answer", (Object)"false");
                        this.addError(errorsArray, "Error: " + e.getMessage());
                    }
                    this.jsonResponse(returnObj, errorsArray, resp);
                    break block53;
                }
                if (action != null && action.equals(ACTION_DIRECTORY_EXISTS)) {
                    try {
                        Boolean ret = repository.directoryExists(assetLocation);
                        returnObj.put("answer", (Object)String.valueOf(ret));
                    }
                    catch (Exception e) {
                        _logger.error((Object)("Error: " + e.getMessage()));
                        returnObj.put("answer", (Object)"false");
                        this.addError(errorsArray, "Error: " + e.getMessage());
                    }
                    this.jsonResponse(returnObj, errorsArray, resp);
                    break block53;
                }
                if (action != null && action.equals(ACTION_LIST_DIRECTORIES)) {
                    try {
                        Collection<Directory> dirCollection = repository.listDirectories(assetLocation);
                        if (dirCollection != null) {
                            JSONArray dirListingArray = new JSONArray();
                            for (Directory dir : dirCollection) {
                                JSONObject dirObj = new JSONObject();
                                dirObj.put("name", (Object)dir.getName());
                                dirListingArray.put((Object)dirObj);
                            }
                            returnObj.put("answer", (Object)dirListingArray);
                        } else {
                            returnObj.put("answer", (Object)new JSONArray());
                        }
                    }
                    catch (Exception e) {
                        _logger.error((Object)("Error: " + e.getMessage()));
                        returnObj.put("answer", (Object)new JSONArray());
                        this.addError(errorsArray, "Error: " + e.getMessage());
                    }
                    this.jsonResponse(returnObj, errorsArray, resp);
                    break block53;
                }
                if (action != null && action.equals(ACTION_LIST_ASSETS)) {
                    try {
                        Collection<Asset> assetCollection = repository.listAssets(assetLocation);
                        if (assetCollection != null) {
                            JSONArray assetListingArray = new JSONArray();
                            for (Asset asset : assetCollection) {
                                JSONObject assetObj = new JSONObject();
                                assetObj.put("fullname", (Object)asset.getFullName());
                                assetObj.put("name", (Object)asset.getName());
                                assetObj.put("description", (Object)asset.getDescription());
                                assetObj.put("owner", (Object)asset.getOwner());
                                assetObj.put("version", (Object)asset.getVersion());
                                assetObj.put("id", (Object)asset.getUniqueId());
                                assetObj.put("location", (Object)asset.getAssetLocation());
                                assetObj.put("type", (Object)asset.getAssetType());
                                assetObj.put("created", (Object)asset.getCreationDate());
                                assetObj.put("modified", (Object)asset.getLastModificationDate());
                                assetListingArray.put((Object)assetObj);
                            }
                            returnObj.put("answer", (Object)assetListingArray);
                        } else {
                            returnObj.put("answer", (Object)new JSONArray());
                        }
                    }
                    catch (JSONException e) {
                        _logger.error((Object)("Error: " + e.getMessage()));
                        returnObj.put("answer", (Object)new JSONArray());
                        this.addError(errorsArray, "Error: " + e.getMessage());
                    }
                    this.jsonResponse(returnObj, errorsArray, resp);
                    break block53;
                }
                if (action != null && action.equals(ACTION_GET_ASSET_SOURCE)) {
                    try {
                        Asset asset = null;
                        if (loadoption != null && loadoption.equals(OPTION_BY_ID)) {
                            asset = repository.loadAsset(assetId);
                        } else if (loadoption != null && loadoption.equals(OPTION_BY_PATH)) {
                            asset = repository.loadAssetFromPath(assetLocation);
                        }
                        if (asset != null) {
                            this.assetSourceResponse((String)asset.getAssetContent(), AssetTypeMapper.findMimeType(asset), resp);
                        }
                        break block53;
                    }
                    catch (Exception e) {
                        _logger.error((Object)e.getMessage());
                    }
                    break block53;
                }
                if (action != null && action.equals(ACTION_GET_ASSET_INFO)) {
                    try {
                        Asset asset = null;
                        if (loadoption != null && loadoption.equals(OPTION_BY_ID)) {
                            asset = repository.loadAsset(assetId);
                        } else if (loadoption != null && loadoption.equals(OPTION_BY_PATH)) {
                            asset = repository.loadAssetFromPath(assetLocation);
                        }
                        if (asset != null) {
                            JSONArray assetInfoArray = new JSONArray();
                            JSONObject assetObj = new JSONObject();
                            assetObj.put("fullname", (Object)asset.getFullName());
                            assetObj.put("name", (Object)asset.getName());
                            assetObj.put("description", (Object)asset.getDescription());
                            assetObj.put("owner", (Object)asset.getOwner());
                            assetObj.put("version", (Object)asset.getVersion());
                            assetObj.put("id", (Object)asset.getUniqueId());
                            assetObj.put("location", (Object)asset.getAssetLocation());
                            assetObj.put("type", (Object)asset.getAssetType());
                            assetObj.put("created", (Object)asset.getCreationDate());
                            assetObj.put("modified", (Object)asset.getLastModificationDate());
                            assetInfoArray.put((Object)assetObj);
                            returnObj.put("answer", (Object)assetInfoArray);
                            this.jsonResponse(returnObj, errorsArray, resp);
                            break block53;
                        }
                        returnObj.put("answer", (Object)new JSONArray());
                        this.addError(errorsArray, "Invalid asset");
                    }
                    catch (Exception e) {
                        _logger.error((Object)("Invalid asset: " + e.getMessage()));
                        returnObj.put("answer", (Object)new JSONArray());
                        this.addError(errorsArray, "Invalid asset: " + e.getMessage());
                    }
                    break block53;
                }
                _logger.error((Object)"Invalid action specified");
                this.addError(errorsArray, "Invalid action specified");
                this.jsonResponse(returnObj, errorsArray, resp);
            }
            catch (Exception e) {
                e.printStackTrace();
                _logger.error((Object)e.getMessage());
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    private void addError(JSONArray errorArray, String errorMessage) {
        if (errorArray != null) {
            try {
                JSONObject error = new JSONObject();
                error.put("message", (Object)errorMessage);
                errorArray.put((Object)error);
            }
            catch (JSONException e) {
                _logger.error((Object)("Unable to add error message: " + errorMessage));
            }
        }
    }

    private void jsonResponse(JSONObject returnObj, JSONArray errorsArray, HttpServletResponse resp) throws Exception {
        returnObj.put("errors", (Object)errorsArray);
        PrintWriter pw = resp.getWriter();
        resp.setContentType("text/json");
        resp.setCharacterEncoding("UTF-8");
        pw.write(returnObj.toString());
    }

    private void assetSourceResponse(String content, String type, HttpServletResponse resp) throws Exception {
        PrintWriter pw = resp.getWriter();
        resp.setContentType(type);
        resp.setCharacterEncoding("UTF-8");
        pw.write(content);
    }
}

