/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.profile.impl;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.servlet.ServletContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.jackson.JsonParseException;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.emf.ecore.resource.Resource;
import org.jbpm.designer.bpmn2.impl.Bpmn2JsonUnmarshaller;
import org.jbpm.designer.bpmn2.resource.JBPMBpmn2ResourceImpl;
import org.jbpm.designer.epn.impl.EpnJsonMarshaller;
import org.jbpm.designer.epn.impl.EpnJsonUnmarshaller;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.util.ConfigurationProvider;
import org.jbpm.designer.web.plugin.IDiagramPlugin;
import org.jbpm.designer.web.plugin.impl.PluginServiceImpl;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class EpnProfileImpl
implements IDiagramProfile {
    private static Logger _logger = LoggerFactory.getLogger(EpnProfileImpl.class);
    private Map<String, IDiagramPlugin> _plugins = new LinkedHashMap<String, IDiagramPlugin>();
    private String _stencilSet;
    private String _localHistoryEnabled;
    private String _localHistoryTimeout;
    private String _repositoryId;
    private String _repositoryRoot;
    private String _repositoryName;
    private String _repositoryHost;
    private String _repositoryProtocol;
    private String _repositorySubdomain;
    private String _repositoryUsr;
    private String _repositoryPwd;
    private String _repositoryGlobalDir;

    public EpnProfileImpl() {
    }

    public EpnProfileImpl(ServletContext servletContext) {
        this(servletContext, true);
    }

    public EpnProfileImpl(ServletContext servletContext, boolean initializeLocalPlugins) {
        if (initializeLocalPlugins) {
            this.initializeLocalPlugins(servletContext);
        }
    }

    private void initializeLocalPlugins(ServletContext context) {
        Map<String, IDiagramPlugin> registry = PluginServiceImpl.getLocalPluginsRegistry(context);
        FileInputStream fileStream = null;
        try {
            try {
                fileStream = new FileInputStream(context.getRealPath("/") + "/" + ConfigurationProvider.getInstance().getDesignerContext() + "profiles" + "/" + "epn.xml");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(fileStream, "UTF-8");
            while (reader.hasNext()) {
                int i;
                if (reader.next() != 1) continue;
                if ("profile".equals(reader.getLocalName())) {
                    for (i = 0; i < reader.getAttributeCount(); ++i) {
                        if (!"stencilset".equals(reader.getAttributeLocalName(i))) continue;
                        this._stencilSet = reader.getAttributeValue(i);
                    }
                    continue;
                }
                if ("plugin".equals(reader.getLocalName())) {
                    String name = null;
                    for (int i2 = 0; i2 < reader.getAttributeCount(); ++i2) {
                        if (!"name".equals(reader.getAttributeLocalName(i2))) continue;
                        name = reader.getAttributeValue(i2);
                    }
                    this._plugins.put(name, registry.get(name));
                    continue;
                }
                if (!"repository".equals(reader.getLocalName())) continue;
                for (i = 0; i < reader.getAttributeCount(); ++i) {
                    String repositoryUsr;
                    String repositorySubdomain;
                    String repositoryHost;
                    String repositoryProtocol;
                    String repositoryName;
                    String repositoryRoot;
                    if ("id".equals(reader.getAttributeLocalName(i))) {
                        String repositoryId = reader.getAttributeValue(i);
                        if (!this.isEmpty(repositoryId)) {
                            this._repositoryId = repositoryId;
                        } else {
                            _logger.info("Invalid repository id specified");
                        }
                    }
                    if ("globaldir".equals(reader.getAttributeLocalName(i))) {
                        String repositoryGlobalDir = reader.getAttributeValue(i);
                        this._repositoryGlobalDir = !this.isEmpty(repositoryGlobalDir) ? repositoryGlobalDir : "repository";
                    }
                    if ("root".equals(reader.getAttributeLocalName(i)) && !this.isEmpty(repositoryRoot = reader.getAttributeValue(i))) {
                        this._repositoryRoot = repositoryRoot;
                    }
                    if ("name".equals(reader.getAttributeLocalName(i)) && !this.isEmpty(repositoryName = reader.getAttributeValue(i))) {
                        this._repositoryName = repositoryName;
                    }
                    if ("protocol".equals(reader.getAttributeLocalName(i)) && !this.isEmpty(repositoryProtocol = reader.getAttributeValue(i))) {
                        this._repositoryProtocol = repositoryProtocol;
                    }
                    if ("host".equals(reader.getAttributeLocalName(i)) && !this.isEmpty(repositoryHost = reader.getAttributeValue(i))) {
                        this._repositoryHost = repositoryHost;
                    }
                    if ("subdomain".equals(reader.getAttributeLocalName(i)) && !this.isEmpty(repositorySubdomain = reader.getAttributeValue(i))) {
                        if (repositorySubdomain.startsWith("/")) {
                            repositorySubdomain = repositorySubdomain.substring(1);
                        }
                        if (repositorySubdomain.endsWith("/")) {
                            repositorySubdomain = repositorySubdomain.substring(0, repositorySubdomain.length() - 1);
                        }
                        this._repositorySubdomain = repositorySubdomain;
                    }
                    if ("usr".equals(reader.getAttributeLocalName(i)) && !this.isEmpty(repositoryUsr = reader.getAttributeValue(i))) {
                        this._repositoryUsr = repositoryUsr;
                    }
                    if (!"pwd".equals(reader.getAttributeLocalName(i))) continue;
                    this._repositoryPwd = reader.getAttributeValue(i);
                }
            }
        }
        catch (XMLStreamException e) {
            _logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public String getName() {
        return "epn";
    }

    @Override
    public String getTitle() {
        return "EPN Designer";
    }

    @Override
    public String getStencilSet() {
        return this._stencilSet;
    }

    @Override
    public Collection<String> getStencilSetExtensions() {
        return Collections.emptyList();
    }

    @Override
    public String getSerializedModelExtension() {
        return "epn";
    }

    @Override
    public String getStencilSetURL() {
        return "/org.jbpm.designer.jBPMDesigner/stencilsets/epn/epn.json";
    }

    @Override
    public String getStencilSetNamespaceURL() {
        return "http://b3mn.org/stencilset/epn#";
    }

    @Override
    public String getStencilSetExtensionURL() {
        return "http://oryx-editor.org/stencilsets/extensions/epn#";
    }

    @Override
    public Collection<String> getPlugins() {
        return Collections.unmodifiableCollection(this._plugins.keySet());
    }

    @Override
    public IDiagramProfile.IDiagramMarshaller createMarshaller() {
        return new IDiagramProfile.IDiagramMarshaller(){

            public String parseModel(String jsonModel, String preProcessingData) {
                EpnJsonUnmarshaller unmarshaller = new EpnJsonUnmarshaller();
                try {
                    Object def = unmarshaller.unmarshall(jsonModel);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    return outputStream.toString();
                }
                catch (JsonParseException e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
                return "";
            }

            public Definitions getDefinitions(String jsonModel, String preProcessingData) {
                try {
                    Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
                    JBPMBpmn2ResourceImpl res = (JBPMBpmn2ResourceImpl)unmarshaller.unmarshall(jsonModel, preProcessingData);
                    return (Definitions)res.getContents().get(0);
                }
                catch (JsonParseException e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
                return null;
            }

            public Resource getResource(String jsonModel, String preProcessingData) {
                try {
                    Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
                    return (JBPMBpmn2ResourceImpl)unmarshaller.unmarshall(jsonModel, preProcessingData);
                }
                catch (JsonParseException e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
                return null;
            }
        };
    }

    @Override
    public IDiagramProfile.IDiagramUnmarshaller createUnmarshaller() {
        return new IDiagramProfile.IDiagramUnmarshaller(){

            public String parseModel(String xmlModel, IDiagramProfile profile, String preProcessingData) {
                EpnJsonMarshaller marshaller = new EpnJsonMarshaller();
                marshaller.setProfile(profile);
                try {
                    return marshaller.marshall("");
                }
                catch (Exception e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                    return "";
                }
            }
        };
    }

    private boolean isEmpty(CharSequence str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public String getRepositoryId() {
        return this._repositoryId;
    }

    public String getRepositoryRoot() {
        return this._repositoryRoot;
    }

    public String getRepositoryName() {
        return this._repositoryName;
    }

    public String getRepositoryHost() {
        return this._repositoryHost;
    }

    public String getRepositoryProtocol() {
        return this._repositoryProtocol;
    }

    public String getRepositorySubdomain() {
        return this._repositorySubdomain;
    }

    public String getRepositoryUsr() {
        return this._repositoryUsr;
    }

    public String getRepositoryPwd() {
        return this._repositoryPwd;
    }

    @Override
    public String getRepositoryGlobalDir() {
        return this._repositoryGlobalDir;
    }

    @Override
    public String getLocalHistoryEnabled() {
        return this._localHistoryEnabled;
    }

    @Override
    public String getLocalHistoryTimeout() {
        return this._localHistoryTimeout;
    }

    @Override
    public Repository getRepository() {
        return null;
    }

    @Override
    public void init(ServletContext context) {
        this.initializeLocalPlugins(context);
    }
}

