/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.server.ServletUtil;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalledElementServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private ServletConfig config;
    @Inject
    private IDiagramProfileService _profileService = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String profileName = req.getParameter("profile");
        String uuid = req.getParameter("uuid");
        String processPackage = req.getParameter("ppackage");
        String processId = req.getParameter("pid");
        String action = req.getParameter("action");
        IDiagramProfile profile = this._profileService.findProfile(req, profileName);
        if (action != null && action.equals("imageview")) {
            String retValue = "";
            List<String> allPackageNames = ServletUtil.getPackageNamesFromRepository(profile);
            if (allPackageNames != null && allPackageNames.size() > 0) {
                block0: for (String packageName : allPackageNames) {
                    List<String> allProcessesInPackage = ServletUtil.getAllProcessesInPackage(packageName, profile);
                    if (allProcessesInPackage == null || allProcessesInPackage.size() <= 0) continue;
                    for (String p : allProcessesInPackage) {
                        Asset processContent = ServletUtil.getProcessSourceContent(p, profile);
                        Pattern idPattern = Pattern.compile("<\\S*process[^\"]+id=\"([^_\"]+)\"", 8);
                        Matcher idMatcher = idPattern.matcher((CharSequence)processContent.getAssetContent());
                        if (!idMatcher.find()) continue;
                        String pid = idMatcher.group(1);
                        String pidcontent = ServletUtil.getProcessImageContent(packageName, pid, profile);
                        if (pid == null || !pid.equals(processId)) continue;
                        retValue = pidcontent != null ? pidcontent : "";
                        continue block0;
                    }
                }
            }
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("text/plain");
            resp.getWriter().write(retValue);
        } else {
            String retValue = "false";
            List<String> allPackageNames = ServletUtil.getPackageNamesFromRepository(profile);
            HashMap<String, String> processInfo = new HashMap<String, String>();
            if (allPackageNames != null && allPackageNames.size() > 0) {
                for (String packageName : allPackageNames) {
                    List<String> allProcessesInPackage = ServletUtil.getAllProcessesInPackage(packageName, profile);
                    if (allProcessesInPackage == null || allProcessesInPackage.size() <= 0) continue;
                    for (String p : allProcessesInPackage) {
                        Asset processContent = ServletUtil.getProcessSourceContent(p, profile);
                        Pattern idPattern = Pattern.compile("<\\S*process[^\"]+id=\"([^_\"]+)\"", 8);
                        Matcher idMatcher = idPattern.matcher((CharSequence)processContent.getAssetContent());
                        if (!idMatcher.find()) continue;
                        String pid = idMatcher.group(1);
                        String pidcontent = ServletUtil.getProcessImageContent(processContent.getAssetLocation(), pid, profile);
                        if (pid == null || packageName.equals(processPackage) && pid.equals(processId)) continue;
                        processInfo.put(pid + "|" + processContent.getAssetLocation(), pidcontent != null ? pidcontent : "");
                    }
                }
            }
            retValue = this.getProcessInfoAsJSON(processInfo).toString();
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            resp.getWriter().write(retValue);
        }
    }

    public JSONObject getProcessInfoAsJSON(Map<String, String> processInfo) {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, String> error : processInfo.entrySet()) {
            try {
                jsonObject.put(error.getKey(), (Object)error.getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }
}

