/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.validation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ComplexGateway;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Relationship;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.ScriptTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.CostParameters;
import org.jboss.drools.DecimalParameterType;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.ElementParameters;
import org.jboss.drools.FloatingParameterType;
import org.jboss.drools.ProcessAnalysisDataType;
import org.jboss.drools.ResourceParameters;
import org.jboss.drools.Scenario;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.bpmn2.validation.SyntaxChecker;
import org.jbpm.designer.bpmn2.validation.SyntaxCheckerUtils;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.json.JSONObject;

public class BPMN2SyntaxChecker
implements SyntaxChecker {
    protected Map<String, List<String>> errors = new HashMap<String, List<String>>();
    private String json;
    private String preprocessingData;
    private IDiagramProfile profile;
    private String defaultResourceId = "";
    private String uuid;
    private Repository repository;

    public BPMN2SyntaxChecker(String json, String preprocessingData, IDiagramProfile profile, String uuid) {
        this.json = json;
        this.preprocessingData = preprocessingData;
        this.profile = profile;
        this.uuid = uuid;
        this.repository = profile.getRepository();
    }

    @Override
    public void checkSyntax() {
        DroolsFactoryImpl.init();
        Definitions def = this.profile.createMarshaller().getDefinitions(this.json, this.preprocessingData);
        List rootElements = def.getRootElements();
        Scenario defaultScenario = this.getDefaultScenario(def);
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            if (process.getFlowElements() != null && process.getFlowElements().size() > 0) {
                this.defaultResourceId = ((FlowElement)process.getFlowElements().get(0)).getId();
            }
            if (BPMN2SyntaxChecker.isEmpty(process.getId())) {
                this.addError(this.defaultResourceId, "Process has no id.");
            } else if (!SyntaxCheckerUtils.isNCName(process.getId())) {
                this.addError(this.defaultResourceId, "Invalid process id. See http://www.w3.org/TR/REC-xml-names/#NT-NCName for more info.");
            }
            String pname = null;
            Iterator iter = process.getAnyAttribute().iterator();
            boolean foundPackageName = false;
            while (iter.hasNext()) {
                FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
                if (!entry.getEStructuralFeature().getName().equals("packageName")) continue;
                foundPackageName = true;
                pname = (String)entry.getValue();
                if (!BPMN2SyntaxChecker.isEmpty(pname)) continue;
                this.addError(this.defaultResourceId, "Process has no package name.");
            }
            if (!foundPackageName) {
                this.addError(this.defaultResourceId, "Process has no package name.");
            }
            if (BPMN2SyntaxChecker.isEmpty(process.getName())) {
                this.addError(this.defaultResourceId, "Process has no name.");
            }
            boolean foundStartEvent = false;
            boolean foundEndEvent = false;
            List flowElements = process.getFlowElements();
            for (FlowElement fe : flowElements) {
                if (fe instanceof StartEvent) {
                    foundStartEvent = true;
                }
                if (!(fe instanceof EndEvent)) continue;
                foundEndEvent = true;
            }
            if (!foundStartEvent && !this.isAdHocProcess(process)) {
                this.addError(this.defaultResourceId, "Process has no start node.");
            }
            if (!foundEndEvent && !this.isAdHocProcess(process)) {
                this.addError(this.defaultResourceId, "Process has no end node.");
            }
            this.checkFlowElements((FlowElementsContainer)process, process, defaultScenario);
        }
    }

    private void checkFlowElements(FlowElementsContainer container, Process process, Scenario defaultScenario) {
        for (FlowElement fe : container.getFlowElements()) {
            CallActivity ca;
            FormalExpression conditionalExp;
            TimerEventDefinition ted;
            List eventdefs;
            CatchEvent event;
            ScriptTask st;
            if (fe instanceof StartEvent) {
                StartEvent se = (StartEvent)fe;
                if (se.getOutgoing() == null || se.getOutgoing().size() < 1) {
                    this.addError((BaseElement)se, "Start node has no outgoing connections");
                }
            } else if (fe instanceof EndEvent) {
                EndEvent ee = (EndEvent)fe;
                if (ee.getIncoming() == null || ee.getIncoming().size() < 1) {
                    this.addError((BaseElement)ee, "End node has no incoming connections");
                }
            } else if (fe instanceof FlowNode) {
                FlowNode fn = (FlowNode)fe;
                if (!(fn.getOutgoing() != null && fn.getOutgoing().size() >= 1 || this.isAdHocProcess(process))) {
                    this.addError((BaseElement)fn, "Node has no outgoing connections");
                }
                if (!(fn instanceof BoundaryEvent || fn.getIncoming() != null && fn.getIncoming().size() >= 1 || this.isAdHocProcess(process))) {
                    this.addError((BaseElement)fn, "Node has no incoming connections");
                }
            }
            if (fe instanceof BusinessRuleTask) {
                BusinessRuleTask bt = (BusinessRuleTask)fe;
                Iterator biter = bt.getAnyAttribute().iterator();
                boolean foundRuleflowGroup = false;
                while (biter.hasNext()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)biter.next();
                    if (!entry.getEStructuralFeature().getName().equals("ruleFlowGroup")) continue;
                    foundRuleflowGroup = true;
                    String ruleflowGroup = (String)entry.getValue();
                    if (!BPMN2SyntaxChecker.isEmpty(ruleflowGroup)) continue;
                    this.addError((BaseElement)bt, "Business Rule Task has no ruleflow-group.");
                }
                if (!foundRuleflowGroup) {
                    this.addError((BaseElement)bt, "Business Rule Task has no ruleflow-group.");
                }
            }
            if (fe instanceof ScriptTask) {
                st = (ScriptTask)fe;
                if (BPMN2SyntaxChecker.isEmpty(st.getScript())) {
                    this.addError((BaseElement)st, "Script Task has no script.");
                }
                if (BPMN2SyntaxChecker.isEmpty(st.getScriptFormat())) {
                    this.addError((BaseElement)st, "Script Task has no script format.");
                }
            }
            if (fe instanceof SendTask && (st = (SendTask)fe).getMessageRef() == null) {
                this.addError((BaseElement)st, "Send Task has no message.");
            }
            if (fe instanceof ServiceTask && (st = (ServiceTask)fe).getOperationRef() == null) {
                this.addError((BaseElement)st, "Service Task has no operation.");
            }
            if (fe instanceof UserTask) {
                UserTask ut = (UserTask)fe;
                String taskName = null;
                Iterator utiter = ut.getAnyAttribute().iterator();
                boolean foundTaskName = false;
                while (utiter.hasNext()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)utiter.next();
                    if (!entry.getEStructuralFeature().getName().equals("taskName")) continue;
                    foundTaskName = true;
                    taskName = (String)entry.getValue();
                    if (!BPMN2SyntaxChecker.isEmpty(taskName)) continue;
                    this.addError((BaseElement)ut, "User Task has no task name.");
                }
                if (!foundTaskName) {
                    this.addError((BaseElement)ut, "User Task has no task name.");
                }
                if (defaultScenario != null && defaultScenario.getElementParameters() != null) {
                    for (ElementParameters eleType : defaultScenario.getElementParameters()) {
                        FloatingParameterType quantityVal;
                        double val;
                        ResourceParameters resourceParams;
                        if (!eleType.getElementId().equals(ut.getId()) || eleType.getResourceParameters() == null || (resourceParams = eleType.getResourceParameters()).getQuantity() == null || !((val = (quantityVal = (FloatingParameterType)resourceParams.getQuantity().getParameterValue().get(0)).getValue()) < 0.0)) continue;
                        this.addError((BaseElement)ut, "Staff Availability value must be positive.");
                    }
                }
            }
            if (fe instanceof Task) {
                Task ta = (Task)fe;
                if (defaultScenario != null && defaultScenario.getElementParameters() != null) {
                    for (ElementParameters eleType : defaultScenario.getElementParameters()) {
                        FloatingParameterType workingHoursVal;
                        ResourceParameters resourceParams;
                        DecimalParameterType unitCostVal;
                        BigDecimal val;
                        CostParameters costParams;
                        if (!eleType.getElementId().equals(ta.getId())) continue;
                        if (eleType.getCostParameters() != null && (costParams = eleType.getCostParameters()).getUnitCost() != null && (val = (unitCostVal = (DecimalParameterType)costParams.getUnitCost().getParameterValue().get(0)).getValue()).doubleValue() < 0.0) {
                            this.addError((BaseElement)ta, "Cost per Time Unit value must be positive.");
                        }
                        if (eleType.getResourceParameters() == null || (resourceParams = eleType.getResourceParameters()).getWorkinghours() == null || !((workingHoursVal = (FloatingParameterType)resourceParams.getWorkinghours().getParameterValue().get(0)).getValue() < 0.0)) continue;
                        this.addError((BaseElement)ta, "Working Hours value must be positive.");
                    }
                }
            }
            if (fe instanceof CatchEvent) {
                event = (CatchEvent)fe;
                eventdefs = event.getEventDefinitions();
                for (EventDefinition ed : eventdefs) {
                    if (ed instanceof TimerEventDefinition) {
                        ted = (TimerEventDefinition)ed;
                        boolean gotTimerDef = ted.getTimeDate() != null || ted.getTimeDuration() != null || ted.getTimeCycle() != null;
                        if (gotTimerDef) continue;
                        this.addError((BaseElement)event, "Catch Event has no timedate.");
                        this.addError((BaseElement)event, "Catch Event has no timeduration.");
                        this.addError((BaseElement)event, "Catch Event has no timecycle.");
                        continue;
                    }
                    if (ed instanceof SignalEventDefinition) {
                        if (((SignalEventDefinition)ed).getSignalRef() != null) continue;
                        this.addError((BaseElement)event, "Catch Event has no signalref.");
                        continue;
                    }
                    if (ed instanceof ErrorEventDefinition) {
                        if (((ErrorEventDefinition)ed).getErrorRef() != null && ((ErrorEventDefinition)ed).getErrorRef().getErrorCode() != null) continue;
                        this.addError((BaseElement)event, "Catch Event has no errorref.");
                        continue;
                    }
                    if (ed instanceof ConditionalEventDefinition) {
                        conditionalExp = (FormalExpression)((ConditionalEventDefinition)ed).getCondition();
                        if (conditionalExp.getBody() != null) continue;
                        this.addError((BaseElement)event, "Catch Event has no conditionexpression.");
                        continue;
                    }
                    if (ed instanceof EscalationEventDefinition) {
                        if (((EscalationEventDefinition)ed).getEscalationRef() != null) continue;
                        this.addError((BaseElement)event, "Catch Event has no escalationref.");
                        continue;
                    }
                    if (ed instanceof MessageEventDefinition) {
                        if (((MessageEventDefinition)ed).getMessageRef() != null) continue;
                        this.addError((BaseElement)event, "Catch Event has no messageref.");
                        continue;
                    }
                    if (!(ed instanceof CompensateEventDefinition) || ((CompensateEventDefinition)ed).getActivityRef() != null) continue;
                    this.addError((BaseElement)event, "Catch Event has no activityref.");
                }
            }
            if (fe instanceof ThrowEvent) {
                event = (ThrowEvent)fe;
                eventdefs = event.getEventDefinitions();
                for (EventDefinition ed : eventdefs) {
                    if (ed instanceof TimerEventDefinition) {
                        ted = (TimerEventDefinition)ed;
                        if (ted.getTimeDate() == null) {
                            this.addError((BaseElement)event, "Throw Event has no timedate.");
                        }
                        if (ted.getTimeDuration() == null) {
                            this.addError((BaseElement)event, "Throw Event has no timeduration.");
                        }
                        if (ted.getTimeCycle() == null) continue;
                        this.addError((BaseElement)event, "Throw Event has no timecycle.");
                        continue;
                    }
                    if (ed instanceof SignalEventDefinition) {
                        if (((SignalEventDefinition)ed).getSignalRef() != null) continue;
                        this.addError((BaseElement)event, "Throw Event has no signalref.");
                        continue;
                    }
                    if (ed instanceof ErrorEventDefinition) {
                        if (((ErrorEventDefinition)ed).getErrorRef() != null && ((ErrorEventDefinition)ed).getErrorRef().getErrorCode() != null) continue;
                        this.addError((BaseElement)event, "Throw Event has no errorref.");
                        continue;
                    }
                    if (ed instanceof ConditionalEventDefinition) {
                        conditionalExp = (FormalExpression)((ConditionalEventDefinition)ed).getCondition();
                        if (conditionalExp.getBody() != null) continue;
                        this.addError((BaseElement)event, "Throw Event has no conditional expression.");
                        continue;
                    }
                    if (ed instanceof EscalationEventDefinition) {
                        if (((EscalationEventDefinition)ed).getEscalationRef() != null) continue;
                        this.addError((BaseElement)event, "Throw Event has no conditional escalationref.");
                        continue;
                    }
                    if (ed instanceof MessageEventDefinition) {
                        if (((MessageEventDefinition)ed).getMessageRef() != null) continue;
                        this.addError((BaseElement)event, "Throw Event has no conditional messageref.");
                        continue;
                    }
                    if (!(ed instanceof CompensateEventDefinition) || ((CompensateEventDefinition)ed).getActivityRef() != null) continue;
                    this.addError((BaseElement)event, "Throw Event has no conditional activityref.");
                }
            }
            if (fe instanceof SequenceFlow) {
                SequenceFlow sf = (SequenceFlow)fe;
                if (sf.getSourceRef() == null) {
                    this.addError((BaseElement)((SequenceFlow)fe), "An Edge must have a source node.");
                }
                if (sf.getTargetRef() == null) {
                    this.addError((BaseElement)((SequenceFlow)fe), "An Edge must have a target node.");
                }
            }
            if (fe instanceof Gateway) {
                List outgoingGwSequenceFlows;
                Gateway gw = (Gateway)fe;
                if (gw.getGatewayDirection() == null || gw.getGatewayDirection().getValue() == GatewayDirection.UNSPECIFIED.getValue()) {
                    this.addError((BaseElement)((Gateway)fe), "Gateway does not specify a valid direction.");
                }
                if (gw instanceof ExclusiveGateway && gw.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue() && gw.getGatewayDirection().getValue() != GatewayDirection.CONVERGING.getValue()) {
                    this.addError((BaseElement)((Gateway)fe), "Invalid Gateway direction for Exclusing Gateway. It should be 'Converging' or 'Diverging'.");
                }
                if (gw instanceof EventBasedGateway && gw.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue()) {
                    this.addError((BaseElement)((Gateway)fe), "Invalid Gateway direction for EventBased Gateway. It should be 'Diverging'.");
                }
                if (gw instanceof ParallelGateway && gw.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue() && gw.getGatewayDirection().getValue() != GatewayDirection.CONVERGING.getValue()) {
                    this.addError((BaseElement)((Gateway)fe), "Invalid Gateway direction for Parallel Gateway. It should be 'Converging' or 'Diverging'.");
                }
                if (gw instanceof InclusiveGateway && gw.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue()) {
                    this.addError((BaseElement)((Gateway)fe), "Invalid Gateway direction for Inclusive Gateway. It should be 'Diverging'.");
                }
                if (gw instanceof ComplexGateway && gw.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue() && gw.getGatewayDirection().getValue() != GatewayDirection.CONVERGING.getValue()) {
                    this.addError((BaseElement)((Gateway)fe), "Invalid Gateway direction for Complex Gateway. It should be 'Converging' or 'Diverging'.");
                }
                if (!(gw instanceof ParallelGateway) && (outgoingGwSequenceFlows = gw.getOutgoing()) != null && outgoingGwSequenceFlows.size() > 0) {
                    double sum = 0.0;
                    for (SequenceFlow sf : outgoingGwSequenceFlows) {
                        if (defaultScenario.getElementParameters() == null) continue;
                        for (ElementParameters eleType : defaultScenario.getElementParameters()) {
                            if (!eleType.getElementId().equals(sf.getId())) continue;
                            if (eleType.getControlParameters() != null && eleType.getControlParameters().getProbability() != null) {
                                FloatingParameterType valType = (FloatingParameterType)eleType.getControlParameters().getProbability().getParameterValue().get(0);
                                if (valType.getValue() < 0.0) {
                                    this.addError((BaseElement)sf, "Probability value must be positive.");
                                    continue;
                                }
                                sum += valType.getValue();
                                continue;
                            }
                            this.addError((BaseElement)sf, "Sequence Flow has no probability defined.");
                        }
                    }
                    if (sum != 100.0) {
                        this.addError((BaseElement)gw, "The sum of probability values of all outgoing Sequence Flows must be equal 100.");
                    }
                }
            }
            if (fe instanceof CallActivity && ((ca = (CallActivity)fe).getCalledElement() == null || ca.getCalledElement().length() < 1)) {
                this.addError((BaseElement)((CallActivity)fe), "Reusable Subprocess has no called element specified.");
            }
            if (fe instanceof DataObject) {
                DataObject dao = (DataObject)fe;
                if (dao.getName() == null || dao.getName().length() < 1) {
                    this.addError((BaseElement)((DataObject)fe), "Data Object has no name defined.");
                } else if (this.containsWhiteSpace(dao.getName())) {
                    this.addError((BaseElement)((DataObject)fe), "Data Object name contains white spaces.");
                }
            }
            if (!(fe instanceof SubProcess)) continue;
            this.checkFlowElements((FlowElementsContainer)((SubProcess)fe), process, defaultScenario);
        }
    }

    @Override
    public Map<String, List<String>> getErrors() {
        return this.errors;
    }

    @Override
    public JSONObject getErrorsAsJson() {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, List<String>> error : this.getErrors().entrySet()) {
            try {
                jsonObject.put(error.getKey(), (Collection)error.getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    @Override
    public boolean errorsFound() {
        return this.errors.size() > 0;
    }

    @Override
    public void clearErrors() {
        this.errors.clear();
    }

    private void addError(BaseElement element, String error) {
        this.addError(element.getId(), error);
    }

    private void addError(String resourceId, String error) {
        if (this.errors.containsKey(resourceId) && this.errors.get(resourceId) != null) {
            this.errors.get(resourceId).add(error);
        } else {
            ArrayList<String> value = new ArrayList<String>();
            value.add(error);
            this.errors.put(resourceId, value);
        }
    }

    private static boolean isEmpty(CharSequence str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    private boolean isAdHocProcess(Process process) {
        for (FeatureMap.Entry entry : process.getAnyAttribute()) {
            if (!entry.getEStructuralFeature().getName().equals("adHoc")) continue;
            return Boolean.parseBoolean(((String)entry.getValue()).trim());
        }
        return false;
    }

    private boolean containsWhiteSpace(String testString) {
        if (testString != null) {
            for (int i = 0; i < testString.length(); ++i) {
                if (!Character.isWhitespace(testString.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    private Scenario getDefaultScenario(Definitions def) {
        if (def.getRelationships() != null && def.getRelationships().size() > 0) {
            Relationship relationship = (Relationship)def.getRelationships().get(0);
            for (ExtensionAttributeValue extattrval : relationship.getExtensionValues()) {
                ProcessAnalysisDataType processAnalysis;
                FeatureMap extensionElements = extattrval.getValue();
                List processAnalysisExtensions = (List)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__PROCESS_ANALYSIS_DATA, true);
                if (processAnalysisExtensions == null || processAnalysisExtensions.size() <= 0 || (processAnalysis = (ProcessAnalysisDataType)processAnalysisExtensions.get(0)).getScenario() == null || processAnalysis.getScenario().size() <= 0) continue;
                return (Scenario)processAnalysis.getScenario().get(0);
            }
        }
        return null;
    }
}

