/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.profile.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileFactory;
import org.jbpm.designer.web.profile.IDiagramProfileService;

@ApplicationScoped
public class ProfileServiceImpl
implements IDiagramProfileService {
    private Map<String, IDiagramProfile> _registry = new HashMap<String, IDiagramProfile>();
    private Set<IDiagramProfileFactory> _factories = new HashSet<IDiagramProfileFactory>();
    private IDiagramProfile userProfile;
    private Instance<IDiagramProfile> profiles;

    public ProfileServiceImpl() {
    }

    @Inject
    public ProfileServiceImpl(@Any Instance<IDiagramProfile> profiles) {
        this.profiles = profiles;
    }

    @Override
    public void init(ServletContext context) {
        if (this.profiles != null) {
            for (IDiagramProfile profile : this.profiles) {
                profile.init(context);
                this._registry.put(profile.getName(), profile);
                System.out.println("Profile " + profile.getName() + " registered");
            }
        }
    }

    private Map<String, IDiagramProfile> assembleProfiles(HttpServletRequest request) {
        HashMap<String, IDiagramProfile> profiles = new HashMap<String, IDiagramProfile>(this._registry);
        if (request != null) {
            for (IDiagramProfileFactory factory : this._factories) {
                for (IDiagramProfile p : factory.getProfiles(request)) {
                    profiles.put(p.getName(), p);
                }
            }
        }
        return profiles;
    }

    @Override
    public IDiagramProfile findProfile(HttpServletRequest request, String name) {
        this.userProfile = this.assembleProfiles(request).get(name);
        return this.userProfile;
    }

    @Override
    public Collection<IDiagramProfile> getProfiles(HttpServletRequest request) {
        return this.assembleProfiles(request).values();
    }

    public Set<IDiagramProfileFactory> getFactories() {
        return this._factories;
    }
}

