/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import bpsim.impl.BpsimFactoryImpl;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.bpmn2.Definitions;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.bpmn2.impl.Bpmn2JsonUnmarshaller;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.taskforms.TaskFormInfo;
import org.jbpm.designer.taskforms.TaskFormTemplateManager;
import org.jbpm.designer.util.ConfigurationProvider;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;

public class TaskFormsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = Logger.getLogger(TaskFormsServlet.class);
    private static final String TASKFORMS_PATH = "taskforms";
    private static final String FORMTEMPLATE_FILE_EXTENSION = "ftl";
    public static final String designer_path = ConfigurationProvider.getInstance().getDesignerContext();
    private IDiagramProfile profile;
    @Inject
    private IDiagramProfileService _profileService = null;

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        String json = req.getParameter("json");
        String uuid = req.getParameter("uuid");
        String profileName = req.getParameter("profile");
        String preprocessingData = req.getParameter("ppdata");
        if (this.profile == null) {
            this.profile = this._profileService.findProfile(req, profileName);
        }
        Repository repository = this.profile.getRepository();
        Asset processAsset = null;
        try {
            processAsset = repository.loadAsset(uuid);
            DroolsFactoryImpl.init();
            BpsimFactoryImpl.init();
            Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
            Definitions def = (Definitions)unmarshaller.unmarshall(json, preprocessingData).getContents().get(0);
            TaskFormTemplateManager templateManager = new TaskFormTemplateManager(this.profile, processAsset.getAssetLocation(), processAsset.getName(), this.getServletContext().getRealPath(designer_path + TASKFORMS_PATH), def);
            templateManager.processTemplates();
            this.storeInRepository(templateManager, processAsset.getAssetLocation(), repository);
            resp.setContentType("text/plain");
            resp.getWriter().write("success");
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            resp.setContentType("text/plain");
            resp.getWriter().write("fail");
        }
    }

    public void storeInRepository(TaskFormTemplateManager templateManager, String location, Repository repository) throws Exception {
        List<TaskFormInfo> taskForms = templateManager.getTaskFormInformationList();
        for (TaskFormInfo taskForm : taskForms) {
            this.storeTaskForm(taskForm, location, repository);
        }
    }

    public void storeTaskForm(TaskFormInfo taskForm, String location, Repository repository) throws Exception {
        try {
            repository.deleteAssetFromPath("/" + taskForm.getPkgName() + "/" + taskForm.getId() + "." + FORMTEMPLATE_FILE_EXTENSION);
            AssetBuilder builder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte);
            builder.name(taskForm.getId()).location(location).type(FORMTEMPLATE_FILE_EXTENSION).content(taskForm.getOutput().getBytes("UTF-8"));
            repository.createAsset(builder.getAsset());
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
        }
    }
}

