/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import bpsim.impl.BpsimFactoryImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.fop.svg.PDFTranscoder;
import org.apache.log4j.Logger;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.DcFactory;
import org.eclipse.dd.dc.Point;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EAttributeImpl;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.bpmn2.resource.JBPMBpmn2ResourceFactoryImpl;
import org.jbpm.designer.bpmn2.resource.JBPMBpmn2ResourceImpl;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.AssetNotFoundException;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;
import org.jbpm.migration.JbpmMigration;
import sun.misc.BASE64Encoder;

public class TransformerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = Logger.getLogger(TransformerServlet.class);
    private static final String TO_PDF = "pdf";
    private static final String TO_PNG = "png";
    private static final String TO_SVG = "svg";
    private static final String JPDL_TO_BPMN2 = "jpdl2bpmn2";
    private static final String BPMN2_TO_JSON = "bpmn2json";
    private static final String RESPACTION_SHOWURL = "showurl";
    private static final String RESPACTION_SHOWEMBEDDABLE = "showembeddable";
    @Inject
    private IDiagramProfileService _profileService = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block27: {
            String rawSvg;
            req.setCharacterEncoding("UTF-8");
            String formattedSvgEncoded = req.getParameter("fsvg");
            String rawSvgEncoded = req.getParameter("rsvg");
            String uuid = req.getParameter("uuid");
            String profileName = req.getParameter("profile");
            String transformto = req.getParameter("transformto");
            String jpdl = req.getParameter("jpdl");
            String gpd = req.getParameter("gpd");
            String bpmn2in = req.getParameter("bpmn2");
            String respaction = req.getParameter("respaction");
            String pp = req.getParameter("pp");
            String processid = req.getParameter("processid");
            String sourceEnc = req.getParameter("enc");
            String formattedSvg = formattedSvgEncoded == null ? "" : new String(Base64.decodeBase64((String)formattedSvgEncoded));
            String string = rawSvg = rawSvgEncoded == null ? "" : new String(Base64.decodeBase64((String)rawSvgEncoded));
            if (sourceEnc != null && sourceEnc.equals("true")) {
                bpmn2in = new String(Base64.decodeBase64((String)bpmn2in), "UTF-8");
            }
            IDiagramProfile profile = this._profileService.findProfile(req, profileName);
            DroolsFactoryImpl.init();
            BpsimFactoryImpl.init();
            Repository repository = profile.getRepository();
            if (transformto != null && transformto.equals(TO_PDF)) {
                try {
                    if (respaction != null && respaction.equals(RESPACTION_SHOWURL)) {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        PDFTranscoder t = new PDFTranscoder();
                        TranscoderInput input = new TranscoderInput((Reader)new StringReader(formattedSvg));
                        TranscoderOutput output = new TranscoderOutput((OutputStream)bout);
                        t.transcode(input, output);
                        resp.setCharacterEncoding("UTF-8");
                        resp.setContentType("text/plain");
                        BASE64Encoder enc = new BASE64Encoder();
                        resp.getWriter().write("<object data=\"data:application/pdf;base64," + enc.encode(bout.toByteArray()) + "\" type=\"application/pdf\"></object>");
                        break block27;
                    }
                    this.storeInRepository(uuid, rawSvg, transformto, processid, repository);
                    resp.setContentType("application/pdf");
                    if (processid != null) {
                        resp.setHeader("Content-Disposition", "attachment; filename=\"" + processid + ".pdf\"");
                    } else {
                        resp.setHeader("Content-Disposition", "attachment; filename=\"" + uuid + ".pdf\"");
                    }
                    PDFTranscoder t = new PDFTranscoder();
                    TranscoderInput input = new TranscoderInput((Reader)new StringReader(formattedSvg));
                    TranscoderOutput output = new TranscoderOutput((OutputStream)resp.getOutputStream());
                    t.transcode(input, output);
                }
                catch (TranscoderException e) {
                    resp.sendError(500, e.getMessage());
                }
            } else if (transformto != null && transformto.equals(TO_PNG)) {
                try {
                    if (respaction != null && respaction.equals(RESPACTION_SHOWURL)) {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        PNGTranscoder t = new PNGTranscoder();
                        t.addTranscodingHint(ImageTranscoder.KEY_MEDIA, (Object)"screen");
                        TranscoderInput input = new TranscoderInput((Reader)new StringReader(formattedSvg));
                        TranscoderOutput output = new TranscoderOutput((OutputStream)bout);
                        t.transcode(input, output);
                        resp.setCharacterEncoding("UTF-8");
                        resp.setContentType("text/plain");
                        BASE64Encoder enc = new BASE64Encoder();
                        resp.getWriter().write("<img src=\"data:image/png;base64," + enc.encode(bout.toByteArray()) + "\">");
                        break block27;
                    }
                    this.storeInRepository(uuid, rawSvg, transformto, processid, repository);
                    resp.setContentType("image/png");
                    if (processid != null) {
                        resp.setHeader("Content-Disposition", "attachment; filename=\"" + processid + ".png\"");
                    } else {
                        resp.setHeader("Content-Disposition", "attachment; filename=\"" + uuid + ".png\"");
                    }
                    PNGTranscoder t = new PNGTranscoder();
                    t.addTranscodingHint(ImageTranscoder.KEY_MEDIA, (Object)"screen");
                    TranscoderInput input = new TranscoderInput((Reader)new StringReader(formattedSvg));
                    TranscoderOutput output = new TranscoderOutput((OutputStream)resp.getOutputStream());
                    t.transcode(input, output);
                }
                catch (TranscoderException e) {
                    resp.sendError(500, e.getMessage());
                }
            } else if (transformto != null && transformto.equals(TO_SVG)) {
                this.storeInRepository(uuid, rawSvg, transformto, processid, repository);
            } else if (transformto != null && transformto.equals(JPDL_TO_BPMN2)) {
                String bpmn2 = JbpmMigration.transform((String)jpdl);
                Definitions def = ((JbpmProfileImpl)profile).getDefinitions(bpmn2);
                this.addBpmnDiInfo(def, gpd);
                this.revisitSequenceFlows(def, bpmn2);
                this.revisitNodeNames(def);
                ResourceSetImpl rSet = new ResourceSetImpl();
                rSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpmn2", new JBPMBpmn2ResourceFactoryImpl());
                JBPMBpmn2ResourceImpl bpmn2resource = (JBPMBpmn2ResourceImpl)rSet.createResource(URI.createURI((String)"virtual.bpmn2"));
                rSet.getResources().add((Object)bpmn2resource);
                bpmn2resource.getContents().add((Object)def);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                bpmn2resource.save(outputStream, new HashMap());
                String fullXmlModel = outputStream.toString();
                String json = profile.createUnmarshaller().parseModel(fullXmlModel, profile, pp);
                resp.setContentType("application/json");
                resp.getWriter().print(json);
            } else if (transformto != null && transformto.equals(BPMN2_TO_JSON)) {
                Definitions def = ((JbpmProfileImpl)profile).getDefinitions(bpmn2in);
                if (uuid != null && sourceEnc == null) {
                    String packageName = null;
                    try {
                        Asset processAsset = repository.loadAsset(uuid);
                        packageName = processAsset.getAssetLocation();
                        if (packageName.startsWith("/")) {
                            packageName = packageName.substring(1, packageName.length());
                        }
                        if ((packageName = packageName.replaceAll("/", ".")).startsWith(".")) {
                            packageName = packageName.substring(1, packageName.length());
                        }
                    }
                    catch (AssetNotFoundException e) {
                        _logger.error((Object)("Process with uuid " + uuid + " was not found"));
                    }
                    List rootElements = def.getRootElements();
                    for (RootElement root : rootElements) {
                        if (!(root instanceof Process)) continue;
                        Process process = (Process)root;
                        Iterator iter = process.getAnyAttribute().iterator();
                        FeatureMap.Entry toDeleteFeature = null;
                        while (iter.hasNext()) {
                            String pname;
                            FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
                            if (!entry.getEStructuralFeature().getName().equals("packageName") || (pname = (String)entry.getValue()) != null && pname.equals(packageName)) continue;
                            toDeleteFeature = entry;
                        }
                        if (toDeleteFeature == null) continue;
                        process.getAnyAttribute().remove(toDeleteFeature);
                        ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
                        EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "packageName", false, false);
                        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)packageName);
                        process.getAnyAttribute().add((Object)extensionEntry);
                    }
                }
                ResourceSetImpl rSet = new ResourceSetImpl();
                rSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpmn2", new JBPMBpmn2ResourceFactoryImpl());
                JBPMBpmn2ResourceImpl bpmn2resource = (JBPMBpmn2ResourceImpl)rSet.createResource(URI.createURI((String)"virtual.bpmn2"));
                rSet.getResources().add((Object)bpmn2resource);
                bpmn2resource.getContents().add((Object)def);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                bpmn2resource.save(outputStream, new HashMap());
                String revisedXmlModel = outputStream.toString();
                String json = profile.createUnmarshaller().parseModel(revisedXmlModel, profile, pp);
                resp.setContentType("application/json");
                resp.getWriter().print(json);
            }
        }
    }

    private void revisitNodeNames(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            List flowElements = process.getFlowElements();
            for (FlowElement fe : flowElements) {
                if (fe.getName() == null || !fe.getId().equals(fe.getName())) continue;
                fe.setName("_" + fe.getName());
            }
        }
    }

    private void revisitSequenceFlows(Definitions def, String orig) {
        try {
            HashMap sequenceFlowMapping = new HashMap();
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(orig));
            while (reader.hasNext()) {
                if (reader.next() != 1 || !"sequenceFlow".equals(reader.getLocalName())) continue;
                String id = "";
                String source = "";
                String target = "";
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    if ("id".equals(reader.getAttributeLocalName(i))) {
                        id = reader.getAttributeValue(i);
                    }
                    if ("sourceRef".equals(reader.getAttributeLocalName(i))) {
                        source = reader.getAttributeValue(i);
                    }
                    if (!"targetRef".equals(reader.getAttributeLocalName(i))) continue;
                    target = reader.getAttributeValue(i);
                }
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put("sourceRef", source);
                valueMap.put("targetRef", target);
                sequenceFlowMapping.put(id, valueMap);
            }
            List rootElements = def.getRootElements();
            for (RootElement root : rootElements) {
                if (!(root instanceof Process)) continue;
                Process process = (Process)root;
                List flowElements = process.getFlowElements();
                for (FlowElement fe : flowElements) {
                    if (!(fe instanceof SequenceFlow)) continue;
                    SequenceFlow sf = (SequenceFlow)fe;
                    if (sequenceFlowMapping.containsKey(sf.getId())) {
                        sf.setSourceRef(this.getFlowNode(def, (String)((Map)sequenceFlowMapping.get(sf.getId())).get("sourceRef")));
                        sf.setTargetRef(this.getFlowNode(def, (String)((Map)sequenceFlowMapping.get(sf.getId())).get("targetRef")));
                        continue;
                    }
                    _logger.error((Object)("Could not find mapping for sequenceFlow: " + sf.getId()));
                }
            }
        }
        catch (FactoryConfigurationError e) {
            _logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private FlowNode getFlowNode(Definitions def, String nodeId) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            List flowElements = process.getFlowElements();
            for (FlowElement fe : flowElements) {
                if (!(fe instanceof FlowNode) || !fe.getId().equals(nodeId)) continue;
                return (FlowNode)fe;
            }
        }
        return null;
    }

    private void addBpmnDiInfo(Definitions def, String gpd) {
        try {
            HashMap<String, Bounds> _bounds = new HashMap<String, Bounds>();
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(gpd));
            while (reader.hasNext()) {
                if (reader.next() != 1 || !"node".equals(reader.getLocalName())) continue;
                Bounds b = DcFactory.eINSTANCE.createBounds();
                String nodeName = null;
                String nodeX = null;
                String nodeY = null;
                String nodeWidth = null;
                String nodeHeight = null;
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    if ("name".equals(reader.getAttributeLocalName(i))) {
                        nodeName = reader.getAttributeValue(i);
                        continue;
                    }
                    if ("x".equals(reader.getAttributeLocalName(i))) {
                        nodeX = reader.getAttributeValue(i);
                        continue;
                    }
                    if ("y".equals(reader.getAttributeLocalName(i))) {
                        nodeY = reader.getAttributeValue(i);
                        continue;
                    }
                    if ("width".equals(reader.getAttributeLocalName(i))) {
                        nodeWidth = reader.getAttributeValue(i);
                        continue;
                    }
                    if (!"height".equals(reader.getAttributeLocalName(i))) continue;
                    nodeHeight = reader.getAttributeValue(i);
                }
                b.setX(new Float(nodeX).floatValue());
                b.setY(new Float(nodeY).floatValue());
                b.setWidth(new Float(nodeWidth).floatValue());
                b.setHeight(new Float(nodeHeight).floatValue());
                _bounds.put(nodeName, b);
            }
            for (RootElement rootElement : def.getRootElements()) {
                if (!(rootElement instanceof Process)) continue;
                Process process = (Process)rootElement;
                BpmnDiFactory diFactory = BpmnDiFactory.eINSTANCE;
                BPMNDiagram diagram = diFactory.createBPMNDiagram();
                BPMNPlane plane = diFactory.createBPMNPlane();
                plane.setBpmnElement((BaseElement)process);
                diagram.setPlane(plane);
                for (FlowElement flowElement : process.getFlowElements()) {
                    if (flowElement instanceof FlowNode) {
                        Bounds b = (Bounds)_bounds.get(flowElement.getId());
                        if (b == null) continue;
                        BPMNShape shape = diFactory.createBPMNShape();
                        shape.setBpmnElement((BaseElement)flowElement);
                        shape.setBounds(b);
                        plane.getPlaneElement().add(shape);
                        continue;
                    }
                    if (!(flowElement instanceof SequenceFlow)) continue;
                    SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
                    BPMNEdge edge = diFactory.createBPMNEdge();
                    edge.setBpmnElement((BaseElement)flowElement);
                    DcFactory dcFactory = DcFactory.eINSTANCE;
                    Point point = dcFactory.createPoint();
                    if (sequenceFlow.getSourceRef() != null) {
                        Bounds sourceBounds = (Bounds)_bounds.get(sequenceFlow.getSourceRef().getId());
                        point.setX(sourceBounds.getX() + sourceBounds.getWidth() / 2.0f);
                        point.setY(sourceBounds.getY() + sourceBounds.getHeight() / 2.0f);
                    }
                    edge.getWaypoint().add(point);
                    point = dcFactory.createPoint();
                    if (sequenceFlow.getTargetRef() != null) {
                        Bounds targetBounds = (Bounds)_bounds.get(sequenceFlow.getTargetRef().getId());
                        point.setX(targetBounds.getX() + targetBounds.getWidth() / 2.0f);
                        point.setY(targetBounds.getY() + targetBounds.getHeight() / 2.0f);
                    }
                    edge.getWaypoint().add(point);
                    plane.getPlaneElement().add(edge);
                }
                def.getDiagrams().add(diagram);
            }
        }
        catch (FactoryConfigurationError e) {
            _logger.error((Object)("Exception adding bpmndi info: " + e.getMessage()));
        }
        catch (Exception e) {
            _logger.error((Object)("Exception adding bpmndi info: " + e.getMessage()));
        }
    }

    private void storeInRepository(String uuid, String rawSvg, String transformto, String processid, Repository repository) {
        try {
            if (processid != null) {
                TranscoderInput input;
                PDFTranscoder t;
                Asset processAsset = repository.loadAsset(uuid);
                String assetExt = "";
                String assetFileExt = "";
                if (transformto.equals(TO_PDF)) {
                    assetExt = "-pdf";
                    assetFileExt = ".pdf";
                }
                if (transformto.equals(TO_PNG)) {
                    assetExt = "-image";
                    assetFileExt = ".png";
                }
                if (transformto.equals(TO_SVG)) {
                    assetExt = "-svg";
                    assetFileExt = ".svg";
                }
                if (processid.startsWith(".")) {
                    processid = processid.substring(1, processid.length());
                }
                String assetFullName = processid + assetExt + assetFileExt;
                repository.deleteAssetFromPath(processAsset.getAssetLocation() + assetFullName);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                if (transformto.equals(TO_PDF)) {
                    t = new PDFTranscoder();
                    input = new TranscoderInput((Reader)new StringReader(rawSvg));
                    TranscoderOutput output = new TranscoderOutput((OutputStream)outputStream);
                    t.transcode(input, output);
                } else if (transformto.equals(TO_PNG)) {
                    t = new PNGTranscoder();
                    t.addTranscodingHint(ImageTranscoder.KEY_MEDIA, (Object)"screen");
                    input = new TranscoderInput((Reader)new StringReader(rawSvg));
                    TranscoderOutput output = new TranscoderOutput((OutputStream)outputStream);
                    try {
                        t.transcode(input, output);
                    }
                    catch (Exception e) {
                        _logger.debug((Object)e.getMessage());
                    }
                } else if (transformto.equals(TO_SVG)) {
                    OutputStreamWriter outStreamWriter = new OutputStreamWriter(outputStream);
                    outStreamWriter.write(rawSvg);
                    outStreamWriter.close();
                }
                AssetBuilder builder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte);
                builder.name(processid + assetExt).type(assetFileExt.substring(1)).location(processAsset.getAssetLocation()).version(processAsset.getVersion()).content(outputStream.toByteArray());
                Asset resourceAsset = builder.getAsset();
                repository.createAsset(resourceAsset);
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private String getProcessContent(String uuid, Repository repository) {
        try {
            Asset processAsset = repository.loadAsset(uuid);
            return (String)processAsset.getAssetContent();
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            return "";
        }
    }
}

