/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.preprocessing.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestIDiagramProfile;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.VFSFileSystemProducer;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.preprocessing.impl.JbpmPreprocessingUnit;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JbpmPreprocessingUnitVFSTest
extends RepositoryBaseTest {
    @Before
    public void setup() {
        new File(REPOSITORY_ROOT).mkdir();
        this.profile = new JbpmProfileImpl();
        this.producer = new VFSFileSystemProducer();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("repository.root", VFS_REPOSITORY_ROOT);
        env.put("repository.globaldir", "/global");
        this.descriptor = this.producer.produceFileSystem(env);
    }

    @After
    public void teardown() {
        File repo = new File(REPOSITORY_ROOT);
        if (repo.exists()) {
            this.deleteFiles(repo);
        }
        repo.delete();
    }

    @Test
    public void testProprocess() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        repository.createDirectory("/myprocesses");
        repository.createDirectory("/global");
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"bpmn2 content").type("bpmn2").name("process").location("/myprocesses");
        String uniqueId = repository.createAsset(builder.getAsset());
        JbpmPreprocessingUnit preprocessingUnitVFS = new JbpmPreprocessingUnit((ServletContext)new TestServletContext(), "/");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uniqueId);
        preprocessingUnitVFS.preprocess((HttpServletRequest)new TestHttpServletRequest(params), null, (IDiagramProfile)new TestIDiagramProfile((Repository)repository), null);
        Collection globalAssets = repository.listAssets("/global");
        Assert.assertNotNull((Object)globalAssets);
        Assert.assertEquals((long)29L, (long)globalAssets.size());
        repository.assetExists("/global/backboneformsinclude.fw");
        repository.assetExists("/global/backbonejsinclude.fw");
        repository.assetExists("/global/cancelbutton.fw");
        repository.assetExists("/global/checkbox.fw");
        repository.assetExists("/global/customeditors.json");
        repository.assetExists("/global/div.fw");
        repository.assetExists("/global/dropdownmenu.fw");
        repository.assetExists("/global/fieldset.fw");
        repository.assetExists("/global/form.fw");
        repository.assetExists("/global/handlebarsinclude.fw");
        repository.assetExists("/global/htmlbasepage.fw");
        repository.assetExists("/global/image.fw");
        repository.assetExists("/global/jqueryinclude.fw");
        repository.assetExists("/global/jquerymobileinclude.fw");
        repository.assetExists("/global/link.fw");
        repository.assetExists("/global/mobilebasepage.fw");
        repository.assetExists("/global/orderedlist.fw");
        repository.assetExists("/global/passwordfield.fw");
        repository.assetExists("/global/radiobutton.fw");
        repository.assetExists("/global/script.fw");
        repository.assetExists("/global/submitbutton.fw");
        repository.assetExists("/global/table.fw");
        repository.assetExists("/global/textarea.fw");
        repository.assetExists("/global/textfield.fw");
        repository.assetExists("/global/themes.json");
        repository.assetExists("/global/unorderedlist.fw");
        repository.assetExists("/global/defaultemailicon.gif");
        repository.assetExists("/global/defaultlogicon.gif");
        repository.assetExists("/global/defaultservicenodeicon.png");
        Collection defaultStuff = repository.listAssets("/myprocesses");
        Assert.assertNotNull((Object)defaultStuff);
        Assert.assertEquals((long)2L, (long)defaultStuff.size());
        repository.assetExists("/myprocesses/WorkDefinitions.wid");
        repository.assetExists("/myprocesses/process.bpmn2");
    }
}

