/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.validation;

import bpsim.BPSimDataType;
import bpsim.BpsimPackage;
import bpsim.CostParameters;
import bpsim.ElementParameters;
import bpsim.FloatingParameterType;
import bpsim.ResourceParameters;
import bpsim.Scenario;
import bpsim.impl.BpsimFactoryImpl;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ComplexGateway;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Relationship;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.ScriptTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.designer.bpmn2.validation.SyntaxChecker;
import org.jbpm.designer.bpmn2.validation.SyntaxCheckerUtils;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.validation.RuleFlowProcessValidator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPMN2SyntaxChecker
implements SyntaxChecker {
    public static final String BPMN2_TYPE = "BPMN2";
    public static final String SIMULATION_TYPE = "Simulation";
    public static final String PROCESS_TYPE = "Process";
    private static final Logger _logger = LoggerFactory.getLogger(BPMN2SyntaxChecker.class);
    protected Map<String, List<ValidationSyntaxError>> errors = new HashMap<String, List<ValidationSyntaxError>>();
    private String json;
    private String preprocessingData;
    private IDiagramProfile profile;
    private String defaultResourceId = "processerrors";
    private String uuid;
    private Repository repository;

    public BPMN2SyntaxChecker(String json, String preprocessingData, IDiagramProfile profile, String uuid) {
        this.json = json;
        this.preprocessingData = preprocessingData;
        this.profile = profile;
        this.uuid = uuid;
        this.repository = profile.getRepository();
    }

    @Override
    public void checkSyntax() {
        DroolsFactoryImpl.init();
        BpsimFactoryImpl.init();
        Definitions def = this.profile.createMarshaller().getDefinitions(this.json, this.preprocessingData);
        List rootElements = def.getRootElements();
        Scenario defaultScenario = this.getDefaultScenario(def);
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            if (process.getFlowElements() != null && process.getFlowElements().size() > 0) {
                this.defaultResourceId = ((FlowElement)process.getFlowElements().get(0)).getId();
            }
            if (BPMN2SyntaxChecker.isEmpty(process.getId())) {
                this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Process has no id."));
            } else if (!SyntaxCheckerUtils.isNCName(process.getId())) {
                this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Invalid process id. See http://www.w3.org/TR/REC-xml-names/#NT-NCName for more info."));
            }
            Iterator iter = process.getAnyAttribute().iterator();
            boolean foundPackageName = false;
            while (iter.hasNext()) {
                FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
                if (!entry.getEStructuralFeature().getName().equals("packageName")) continue;
                foundPackageName = true;
                String pname = (String)entry.getValue();
                if (!BPMN2SyntaxChecker.isEmpty(pname)) continue;
                this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Process has no package name."));
            }
            if (!foundPackageName) {
                this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Process has no package name."));
            }
            if (BPMN2SyntaxChecker.isEmpty(process.getName())) {
                this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Process has no name."));
            }
            boolean foundStartEvent = false;
            boolean foundEndEvent = false;
            List flowElements = process.getFlowElements();
            for (FlowElement fe : flowElements) {
                if (fe instanceof StartEvent) {
                    foundStartEvent = true;
                }
                if (!(fe instanceof EndEvent)) continue;
                foundEndEvent = true;
            }
            if (!foundStartEvent && !this.isAdHocProcess(process)) {
                this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Process has no start node."));
            }
            if (!foundEndEvent && !this.isAdHocProcess(process)) {
                this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Process has no end node."));
            }
            this.checkFlowElements((FlowElementsContainer)process, process, defaultScenario);
        }
        if (this.errors.size() < 1) {
            try {
                SemanticModules modules = new SemanticModules();
                modules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
                modules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
                XmlProcessReader xmlReader = new XmlProcessReader(modules, this.getClass().getClassLoader());
                List processes = xmlReader.read((Reader)new StringReader(this.profile.createMarshaller().parseModel(this.json, this.preprocessingData)));
                if (processes != null) {
                    ProcessValidationError[] errors;
                    for (ProcessValidationError er : errors = RuleFlowProcessValidator.getInstance().validateProcess((RuleFlowProcess)processes.get(0))) {
                        this.addError(this.defaultResourceId, new ValidationSyntaxError(null, PROCESS_TYPE, er.getMessage()));
                    }
                }
            }
            catch (Exception e) {
                _logger.warn("Could not parse to RuleFlowProcess.");
                this.addError(this.defaultResourceId, new ValidationSyntaxError(null, PROCESS_TYPE, "Could not parse BPMN2 to RuleFlowProcess."));
            }
        }
    }

    private void checkFlowElements(FlowElementsContainer container, Process process, Scenario defaultScenario) {
        for (FlowElement fe : container.getFlowElements()) {
            CallActivity ca;
            FormalExpression conditionalExp;
            TimerEventDefinition ted;
            List eventdefs;
            CatchEvent event;
            ScriptTask st;
            if (fe instanceof StartEvent) {
                StartEvent se = (StartEvent)fe;
                if (se.getOutgoing() == null || se.getOutgoing().size() < 1) {
                    this.addError((BaseElement)se, new ValidationSyntaxError((BaseElement)se, BPMN2_TYPE, "Start node has no outgoing connections"));
                }
            } else if (fe instanceof EndEvent) {
                EndEvent ee = (EndEvent)fe;
                if (ee.getIncoming() == null || ee.getIncoming().size() < 1) {
                    this.addError((BaseElement)ee, new ValidationSyntaxError((BaseElement)ee, BPMN2_TYPE, "End node has no incoming connections"));
                }
            } else if (fe instanceof FlowNode) {
                FlowNode fn = (FlowNode)fe;
                if (!(fn.getOutgoing() != null && fn.getOutgoing().size() >= 1 || this.isAdHocProcess(process))) {
                    this.addError((BaseElement)fn, new ValidationSyntaxError((BaseElement)fn, BPMN2_TYPE, "Node has no outgoing connections"));
                }
                if (!(fn instanceof BoundaryEvent || fn.getIncoming() != null && fn.getIncoming().size() >= 1 || this.isAdHocProcess(process))) {
                    this.addError((BaseElement)fn, new ValidationSyntaxError((BaseElement)fn, BPMN2_TYPE, "Node has no incoming connections"));
                }
            }
            if (fe instanceof BusinessRuleTask) {
                BusinessRuleTask bt = (BusinessRuleTask)fe;
                Iterator biter = bt.getAnyAttribute().iterator();
                boolean foundRuleflowGroup = false;
                while (biter.hasNext()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)biter.next();
                    if (!entry.getEStructuralFeature().getName().equals("ruleFlowGroup")) continue;
                    foundRuleflowGroup = true;
                    String ruleflowGroup = (String)entry.getValue();
                    if (!BPMN2SyntaxChecker.isEmpty(ruleflowGroup)) continue;
                    this.addError((BaseElement)bt, new ValidationSyntaxError((BaseElement)bt, BPMN2_TYPE, "Business Rule Task has no ruleflow-group."));
                }
                if (!foundRuleflowGroup) {
                    this.addError((BaseElement)bt, new ValidationSyntaxError((BaseElement)bt, BPMN2_TYPE, "Business Rule Task has no ruleflow-group."));
                }
            }
            if (fe instanceof ScriptTask) {
                st = (ScriptTask)fe;
                if (BPMN2SyntaxChecker.isEmpty(st.getScript())) {
                    this.addError((BaseElement)st, new ValidationSyntaxError((BaseElement)st, BPMN2_TYPE, "Script Task has no script."));
                }
                if (BPMN2SyntaxChecker.isEmpty(st.getScriptFormat())) {
                    this.addError((BaseElement)st, new ValidationSyntaxError((BaseElement)st, BPMN2_TYPE, "Script Task has no script format."));
                }
            }
            if (fe instanceof SendTask && (st = (SendTask)fe).getMessageRef() == null) {
                this.addError((BaseElement)st, new ValidationSyntaxError((BaseElement)st, BPMN2_TYPE, "Send Task has no message."));
            }
            if (fe instanceof ServiceTask && (st = (ServiceTask)fe).getOperationRef() == null) {
                this.addError((BaseElement)st, new ValidationSyntaxError((BaseElement)st, BPMN2_TYPE, "Service Task has no operation."));
            }
            if (fe instanceof UserTask) {
                UserTask ut = (UserTask)fe;
                String taskName = null;
                Iterator utiter = ut.getAnyAttribute().iterator();
                boolean foundTaskName = false;
                while (utiter.hasNext()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)utiter.next();
                    if (!entry.getEStructuralFeature().getName().equals("taskName")) continue;
                    foundTaskName = true;
                    taskName = (String)entry.getValue();
                    if (!BPMN2SyntaxChecker.isEmpty(taskName)) continue;
                    this.addError((BaseElement)ut, new ValidationSyntaxError((BaseElement)ut, BPMN2_TYPE, "User Task has no task name."));
                }
                if (!foundTaskName) {
                    this.addError((BaseElement)ut, new ValidationSyntaxError((BaseElement)ut, BPMN2_TYPE, "User Task has no task name."));
                }
                if (defaultScenario != null && defaultScenario.getElementParameters() != null) {
                    for (ElementParameters eleType : defaultScenario.getElementParameters()) {
                        FloatingParameterType quantityVal;
                        double val;
                        ResourceParameters resourceParams;
                        if (!eleType.getElementRef().equals(ut.getId()) || eleType.getResourceParameters() == null || (resourceParams = eleType.getResourceParameters()).getQuantity() == null || !((val = (quantityVal = (FloatingParameterType)resourceParams.getQuantity().getParameterValue().get(0)).getValue()) < 0.0)) continue;
                        this.addError((BaseElement)ut, new ValidationSyntaxError((BaseElement)ut, SIMULATION_TYPE, "Staff Availability value must be positive."));
                    }
                }
            }
            if (fe instanceof Task) {
                Task ta = (Task)fe;
                if (defaultScenario != null && defaultScenario.getElementParameters() != null) {
                    for (ElementParameters eleType : defaultScenario.getElementParameters()) {
                        FloatingParameterType workingHoursVal;
                        ResourceParameters resourceParams;
                        FloatingParameterType unitCostVal;
                        Double val;
                        CostParameters costParams;
                        if (!eleType.getElementRef().equals(ta.getId())) continue;
                        if (eleType.getCostParameters() != null && (costParams = eleType.getCostParameters()).getUnitCost() != null && (val = Double.valueOf((unitCostVal = (FloatingParameterType)costParams.getUnitCost().getParameterValue().get(0)).getValue())) < 0.0) {
                            this.addError((BaseElement)ta, new ValidationSyntaxError((BaseElement)ta, SIMULATION_TYPE, "Cost per Time Unit value must be positive."));
                        }
                        if (eleType.getResourceParameters() == null || (resourceParams = eleType.getResourceParameters()).getQuantity() == null || !((workingHoursVal = (FloatingParameterType)resourceParams.getQuantity().getParameterValue().get(0)).getValue() < 0.0)) continue;
                        this.addError((BaseElement)ta, new ValidationSyntaxError((BaseElement)ta, SIMULATION_TYPE, "Working Hours value must be positive."));
                    }
                }
            }
            if (fe instanceof CatchEvent) {
                event = (CatchEvent)fe;
                eventdefs = event.getEventDefinitions();
                for (EventDefinition ed : eventdefs) {
                    if (ed instanceof TimerEventDefinition) {
                        ted = (TimerEventDefinition)ed;
                        if (ted.getTimeDate() != null && ted.getTimeDuration() != null && ted.getTimeCycle() != null) {
                            this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Even has timeDate and timeDuration and timeCycle defined."));
                        } else if (ted.getTimeDate() != null && ted.getTimeDuration() != null) {
                            this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Even has both timeDate and timeDuration defined."));
                        } else if (ted.getTimeDate() != null && ted.getTimeCycle() != null) {
                            this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Even has both timeDate and timeCycle defined."));
                        } else if (ted.getTimeDuration() != null && ted.getTimeCycle() != null) {
                            this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Even has both timeduration and timecycle defined."));
                        }
                        if (ted.getTimeDate() != null || ted.getTimeDuration() != null || ted.getTimeCycle() != null) continue;
                        this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Even has no timeDate or timeDuration or timeCycle defined."));
                        continue;
                    }
                    if (ed instanceof SignalEventDefinition) {
                        if (((SignalEventDefinition)ed).getSignalRef() != null) continue;
                        this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Event has no signalref."));
                        continue;
                    }
                    if (ed instanceof ErrorEventDefinition) {
                        if (((ErrorEventDefinition)ed).getErrorRef() != null && ((ErrorEventDefinition)ed).getErrorRef().getErrorCode() != null) continue;
                        this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Event has no errorref."));
                        continue;
                    }
                    if (ed instanceof ConditionalEventDefinition) {
                        conditionalExp = (FormalExpression)((ConditionalEventDefinition)ed).getCondition();
                        if (conditionalExp.getBody() != null) continue;
                        this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Event has no conditionexpression."));
                        continue;
                    }
                    if (ed instanceof EscalationEventDefinition) {
                        if (((EscalationEventDefinition)ed).getEscalationRef() != null) continue;
                        this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Event has no escalationref."));
                        continue;
                    }
                    if (ed instanceof MessageEventDefinition) {
                        if (((MessageEventDefinition)ed).getMessageRef() != null) continue;
                        this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Event has no messageref."));
                        continue;
                    }
                    if (!(ed instanceof CompensateEventDefinition) || ((CompensateEventDefinition)ed).getActivityRef() != null) continue;
                    this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Event has no activityref."));
                }
            }
            if (fe instanceof ThrowEvent) {
                event = (ThrowEvent)fe;
                eventdefs = event.getEventDefinitions();
                for (EventDefinition ed : eventdefs) {
                    if (ed instanceof TimerEventDefinition) {
                        ted = (TimerEventDefinition)ed;
                        if (ted.getTimeDate() != null && ted.getTimeDuration() != null && ted.getTimeCycle() != null) {
                            this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Even has timeDate and timeDuration and timeCycle defined."));
                        } else if (ted.getTimeDate() != null && ted.getTimeDuration() != null) {
                            this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Even has both timeDate and timeDuration defined."));
                        } else if (ted.getTimeDate() != null && ted.getTimeCycle() != null) {
                            this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Even has both timeDate and timeCycle defined."));
                        } else if (ted.getTimeDuration() != null && ted.getTimeCycle() != null) {
                            this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Even has both timeduration and timecycle defined."));
                        }
                        if (ted.getTimeDate() != null || ted.getTimeDuration() != null || ted.getTimeCycle() != null) continue;
                        this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Catch Even has no timeDate or timeDuration or timeCycle defined."));
                        continue;
                    }
                    if (ed instanceof SignalEventDefinition) {
                        if (((SignalEventDefinition)ed).getSignalRef() != null) continue;
                        this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Throw Event has no signalref."));
                        continue;
                    }
                    if (ed instanceof ErrorEventDefinition) {
                        if (((ErrorEventDefinition)ed).getErrorRef() != null && ((ErrorEventDefinition)ed).getErrorRef().getErrorCode() != null) continue;
                        this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Throw Event has no errorref."));
                        continue;
                    }
                    if (ed instanceof ConditionalEventDefinition) {
                        conditionalExp = (FormalExpression)((ConditionalEventDefinition)ed).getCondition();
                        if (conditionalExp.getBody() != null) continue;
                        this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Throw Event has no conditional expression."));
                        continue;
                    }
                    if (ed instanceof EscalationEventDefinition) {
                        if (((EscalationEventDefinition)ed).getEscalationRef() != null) continue;
                        this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Throw Event has no conditional escalationref."));
                        continue;
                    }
                    if (ed instanceof MessageEventDefinition) {
                        if (((MessageEventDefinition)ed).getMessageRef() != null) continue;
                        this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Throw Event has no conditional messageref."));
                        continue;
                    }
                    if (!(ed instanceof CompensateEventDefinition) || ((CompensateEventDefinition)ed).getActivityRef() != null) continue;
                    this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, "Throw Event has no conditional activityref."));
                }
            }
            if (fe instanceof SequenceFlow) {
                SequenceFlow sf = (SequenceFlow)fe;
                if (sf.getSourceRef() == null) {
                    this.addError((BaseElement)((SequenceFlow)fe), new ValidationSyntaxError((BaseElement)fe, BPMN2_TYPE, "An Edge must have a source node."));
                }
                if (sf.getTargetRef() == null) {
                    this.addError((BaseElement)((SequenceFlow)fe), new ValidationSyntaxError((BaseElement)fe, BPMN2_TYPE, "An Edge must have a target node."));
                }
            }
            if (fe instanceof Gateway) {
                List outgoingGwSequenceFlows;
                List outgoingFlows;
                Gateway gw = (Gateway)fe;
                if (gw.getGatewayDirection() == null || gw.getGatewayDirection().getValue() == GatewayDirection.UNSPECIFIED.getValue()) {
                    this.addError((BaseElement)((Gateway)fe), new ValidationSyntaxError((BaseElement)fe, BPMN2_TYPE, "Gateway does not specify a valid direction."));
                }
                if (gw instanceof ExclusiveGateway && gw.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue() && gw.getGatewayDirection().getValue() != GatewayDirection.CONVERGING.getValue()) {
                    this.addError((BaseElement)fe, new ValidationSyntaxError((BaseElement)fe, BPMN2_TYPE, "Invalid Gateway direction for Exclusing Gateway. It should be 'Converging' or 'Diverging'."));
                }
                if (gw instanceof EventBasedGateway && gw.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue()) {
                    this.addError((BaseElement)fe, new ValidationSyntaxError((BaseElement)fe, BPMN2_TYPE, "Invalid Gateway direction for EventBased Gateway. It should be 'Diverging'."));
                }
                if (gw instanceof ParallelGateway && gw.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue() && gw.getGatewayDirection().getValue() != GatewayDirection.CONVERGING.getValue()) {
                    this.addError((BaseElement)fe, new ValidationSyntaxError((BaseElement)fe, BPMN2_TYPE, "Invalid Gateway direction for Parallel Gateway. It should be 'Converging' or 'Diverging'."));
                }
                if (gw instanceof InclusiveGateway && gw.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue()) {
                    this.addError((BaseElement)fe, new ValidationSyntaxError((BaseElement)fe, BPMN2_TYPE, "Invalid Gateway direction for Inclusive Gateway. It should be 'Diverging'."));
                }
                if (gw instanceof ComplexGateway && gw.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue() && gw.getGatewayDirection().getValue() != GatewayDirection.CONVERGING.getValue()) {
                    this.addError((BaseElement)fe, new ValidationSyntaxError((BaseElement)fe, BPMN2_TYPE, "Invalid Gateway direction for Complex Gateway. It should be 'Converging' or 'Diverging'."));
                }
                if ((gw instanceof ExclusiveGateway || gw instanceof InclusiveGateway) && gw.getGatewayDirection().getValue() == GatewayDirection.DIVERGING.getValue() && (outgoingFlows = gw.getOutgoing()) != null && outgoingFlows.size() > 0) {
                    for (SequenceFlow flow : outgoingFlows) {
                        if (flow.getConditionExpression() == null) {
                            this.addError((BaseElement)flow, new ValidationSyntaxError((BaseElement)flow, BPMN2_TYPE, "Sequence flow has no condition expression defined."));
                            continue;
                        }
                        if (flow.getConditionExpression() instanceof FormalExpression) {
                            FormalExpression formalExp = (FormalExpression)flow.getConditionExpression();
                            if (formalExp.getBody() != null || formalExp.getBody().length() >= 1) continue;
                            this.addError((BaseElement)flow, new ValidationSyntaxError((BaseElement)flow, BPMN2_TYPE, "Sequence flow has no condition expression defined."));
                            continue;
                        }
                        this.addError((BaseElement)flow, new ValidationSyntaxError((BaseElement)flow, BPMN2_TYPE, "Invalid condition expression on sequence flow."));
                    }
                }
                if (!(gw instanceof ParallelGateway) && (outgoingGwSequenceFlows = gw.getOutgoing()) != null && outgoingGwSequenceFlows.size() > 0) {
                    double sum = 0.0;
                    for (SequenceFlow sf : outgoingGwSequenceFlows) {
                        if (defaultScenario.getElementParameters() == null) continue;
                        for (ElementParameters eleType : defaultScenario.getElementParameters()) {
                            if (!eleType.getElementRef().equals(sf.getId())) continue;
                            if (eleType.getControlParameters() != null && eleType.getControlParameters().getProbability() != null) {
                                FloatingParameterType valType = (FloatingParameterType)eleType.getControlParameters().getProbability().getParameterValue().get(0);
                                if (valType.getValue() < 0.0) {
                                    this.addError((BaseElement)sf, new ValidationSyntaxError((BaseElement)sf, SIMULATION_TYPE, "Probability value must be positive."));
                                    continue;
                                }
                                sum += valType.getValue();
                                continue;
                            }
                            this.addError((BaseElement)sf, new ValidationSyntaxError((BaseElement)sf, SIMULATION_TYPE, "Sequence Flow has no probability defined."));
                        }
                    }
                    if (sum != 100.0) {
                        this.addError((BaseElement)gw, new ValidationSyntaxError((BaseElement)gw, SIMULATION_TYPE, "The sum of probability values of all outgoing Sequence Flows must be equal 100."));
                    }
                }
            }
            if (fe instanceof CallActivity && ((ca = (CallActivity)fe).getCalledElement() == null || ca.getCalledElement().length() < 1)) {
                this.addError((BaseElement)((CallActivity)fe), new ValidationSyntaxError((BaseElement)fe, BPMN2_TYPE, "Reusable Subprocess has no called element specified."));
            }
            if (fe instanceof DataObject) {
                DataObject dao = (DataObject)fe;
                if (dao.getName() == null || dao.getName().length() < 1) {
                    this.addError((BaseElement)((DataObject)fe), new ValidationSyntaxError((BaseElement)fe, BPMN2_TYPE, "Data Object has no name defined."));
                } else if (this.containsWhiteSpace(dao.getName())) {
                    this.addError((BaseElement)((DataObject)fe), new ValidationSyntaxError((BaseElement)fe, BPMN2_TYPE, "Data Object name contains white spaces."));
                }
            }
            if (!(fe instanceof SubProcess)) continue;
            this.checkFlowElements((FlowElementsContainer)((SubProcess)fe), process, defaultScenario);
        }
    }

    @Override
    public Map<String, List<ValidationSyntaxError>> getErrors() {
        return this.errors;
    }

    @Override
    public JSONObject getErrorsAsJson() {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, List<ValidationSyntaxError>> error : this.getErrors().entrySet()) {
            try {
                JSONArray errorsArray = new JSONArray();
                for (ValidationSyntaxError se : error.getValue()) {
                    errorsArray.put((Object)se.toJSON());
                }
                jsonObject.put(error.getKey(), (Object)errorsArray);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    @Override
    public boolean errorsFound() {
        return this.errors.size() > 0;
    }

    @Override
    public void clearErrors() {
        this.errors.clear();
    }

    private void addError(BaseElement element, ValidationSyntaxError error) {
        this.addError(element.getId(), error);
    }

    private void addError(String resourceId, ValidationSyntaxError error) {
        if (this.errors.containsKey(resourceId) && this.errors.get(resourceId) != null) {
            this.errors.get(resourceId).add(error);
        } else {
            ArrayList<ValidationSyntaxError> value = new ArrayList<ValidationSyntaxError>();
            value.add(error);
            this.errors.put(resourceId, value);
        }
    }

    private static boolean isEmpty(CharSequence str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    private boolean isAdHocProcess(Process process) {
        for (FeatureMap.Entry entry : process.getAnyAttribute()) {
            if (!entry.getEStructuralFeature().getName().equals("adHoc")) continue;
            return Boolean.parseBoolean(((String)entry.getValue()).trim());
        }
        return false;
    }

    private boolean containsWhiteSpace(String testString) {
        if (testString != null) {
            for (int i = 0; i < testString.length(); ++i) {
                if (!Character.isWhitespace(testString.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    private Scenario getDefaultScenario(Definitions def) {
        if (def.getRelationships() != null && def.getRelationships().size() > 0) {
            Relationship relationship = (Relationship)def.getRelationships().get(0);
            for (ExtensionAttributeValue extattrval : relationship.getExtensionValues()) {
                BPSimDataType processAnalysis;
                FeatureMap extensionElements = extattrval.getValue();
                List bpsimExtensions = (List)extensionElements.get((EStructuralFeature)BpsimPackage.Literals.DOCUMENT_ROOT__BP_SIM_DATA, true);
                if (bpsimExtensions == null || bpsimExtensions.size() <= 0 || (processAnalysis = (BPSimDataType)bpsimExtensions.get(0)).getScenario() == null || processAnalysis.getScenario().size() <= 0) continue;
                return (Scenario)processAnalysis.getScenario().get(0);
            }
        }
        return null;
    }

    public class ValidationSyntaxError {
        private BaseElement element;
        private String error;
        private String type;

        public ValidationSyntaxError(BaseElement element, String type, String error) {
            this.element = element;
            this.error = error;
            this.type = type;
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject errorJSON = new JSONObject();
            errorJSON.put("id", (Object)(this.element == null ? "" : this.element.getId()));
            errorJSON.put("type", (Object)this.type);
            errorJSON.put("error", (Object)this.error);
            return errorJSON;
        }

        public BaseElement getElement() {
            return this.element;
        }

        public String getError() {
            return this.error;
        }
    }
}

