/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server;

import bpsim.impl.BpsimFactoryImpl;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.Result;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.WeakHashMap;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.util.ConfigurationProvider;
import org.jbpm.designer.web.plugin.IDiagramPlugin;
import org.jbpm.designer.web.plugin.IDiagramPluginService;
import org.jbpm.designer.web.plugin.impl.PluginServiceImpl;
import org.jbpm.designer.web.preprocessing.IDiagramPreprocessingService;
import org.jbpm.designer.web.preprocessing.IDiagramPreprocessingUnit;
import org.jbpm.designer.web.preprocessing.impl.PreprocessingServiceImpl;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.profile.impl.RepositoryInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.javascript.EvaluatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

public class EditorHandler
extends HttpServlet {
    private static final long serialVersionUID = -7439613152623067053L;
    private static final Logger _logger = LoggerFactory.getLogger(EditorHandler.class);
    public static final String designer_path = ConfigurationProvider.getInstance().getDesignerContext();
    public static final String DEV = "designer.dev";
    public static final String PREPROCESS = "designer.preprocess";
    public static final String SKIN = "designer.skin";
    public static final String BUNDLE_VERSION = "Bundle-Version";
    private boolean _devMode;
    private boolean _preProcess;
    private String _skin;
    private String _designerVersion;
    private String _doc;
    @Inject
    private IDiagramProfileService _profileService = null;
    @Inject
    private VFSService vfsServices;
    @Inject
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    @Inject
    private Event<ResourceAddedEvent> resourceAddedEvent;
    private IDiagramPreprocessingService _preProcessingService = null;
    private IDiagramPluginService _pluginService = null;
    private List<String> _envFiles = new ArrayList<String>();
    private Map<String, List<IDiagramPlugin>> _pluginfiles = new HashMap<String, List<IDiagramPlugin>>();
    private Map<String, List<IDiagramPlugin>> _uncompressedPlugins = new WeakHashMap<String, List<IDiagramPlugin>>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        DroolsFactoryImpl.init();
        BpsimFactoryImpl.init();
        this._profileService.init(config.getServletContext());
        this._pluginService = PluginServiceImpl.getInstance(config.getServletContext());
        this._preProcessingService = PreprocessingServiceImpl.INSTANCE;
        this._preProcessingService.init(config.getServletContext(), this.vfsServices, this.resourceUpdatedEvent, this.resourceAddedEvent);
        this._devMode = Boolean.parseBoolean(System.getProperty(DEV) == null ? config.getInitParameter(DEV) : System.getProperty(DEV));
        this._preProcess = Boolean.parseBoolean(System.getProperty(PREPROCESS) == null ? config.getInitParameter(PREPROCESS) : System.getProperty(PREPROCESS));
        this._skin = System.getProperty(SKIN) == null ? config.getInitParameter(SKIN) : System.getProperty(SKIN);
        this._designerVersion = EditorHandler.readDesignerVersion(config.getServletContext());
        String editor_file = config.getServletContext().getRealPath(designer_path + "editor.st");
        try {
            this._doc = this.readFile(editor_file);
        }
        catch (Exception e) {
            throw new ServletException("Error while parsing editor.st", (Throwable)e);
        }
        if (this._doc == null) {
            _logger.error("Invalid editor.st, could not be read as a document.");
            throw new ServletException("Invalid editor.st, could not be read as a document.");
        }
        try {
            this.initEnvFiles(this.getServletContext(), config);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEnvFiles(ServletContext context, ServletConfig config) throws IOException {
        try {
            JSONObject obj = new JSONObject(EditorHandler.readEnvFiles(context));
            JSONArray array = obj.getJSONArray("files");
            for (int i = 0; i < array.length(); ++i) {
                this._envFiles.add(array.getString(i));
            }
        }
        catch (JSONException e) {
            _logger.error("invalid js_files.json");
            _logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Error initializing the environment of the editor");
        }
        if (!this._devMode) {
            if (_logger.isInfoEnabled()) {
                _logger.info("The diagram editor is running in production mode. Javascript will be served compressed");
            }
            StringWriter sw = new StringWriter();
            ArrayList<InputStream> codes = new ArrayList<InputStream>();
            for (String file : this._envFiles) {
                codes.add(new FileInputStream(new File(this.getServletContext().getRealPath(designer_path + file))));
            }
            try {
                sw.append(EditorHandler.compileJS(this._envFiles, codes));
                sw.append("\n");
            }
            catch (EvaluatorException e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    for (InputStream inputStream : codes) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {}
            }
            try {
                FileWriter w = new FileWriter(context.getRealPath(designer_path + "jsc/env_combined.js"));
                w.write(sw.toString());
                w.close();
            }
            catch (IOException e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
        } else if (_logger.isInfoEnabled()) {
            _logger.info("The diagram editor is running in development mode. Javascript will be served uncompressed");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONArray scriptsArray;
        IDiagramProfile profile;
        String profileName = request.getParameter("profile");
        String uuid = request.getParameter("uuid");
        String editorID = request.getParameter("editorid");
        String encodedActiveNodes = request.getParameter("activenodes");
        byte[] activeNodesByteArray = Base64.decodeBase64((String)encodedActiveNodes);
        String activeNodes = new String(activeNodesByteArray, "UTF-8");
        String encodedCompletedNodes = request.getParameter("completednodes");
        byte[] completedNodesByteArray = Base64.decodeBase64((String)encodedCompletedNodes);
        String completedNodes = new String(completedNodesByteArray, "UTF-8");
        String readOnly = request.getParameter("readonly");
        if (profileName == null || profileName.length() < 1) {
            profileName = "jbpm";
        }
        if ((profile = this._profileService.findProfile(request, profileName)) == null) {
            _logger.error("No profile with the name " + profileName + " was registered");
            throw new IllegalArgumentException("No profile with the name " + profileName + " was registered");
        }
        IDiagramPreprocessingUnit preprocessingUnit = null;
        if (this._preProcess) {
            if (_logger.isInfoEnabled()) {
                _logger.info("Performing diagram information pre-processing steps. ");
            }
            preprocessingUnit = this._preProcessingService.findPreprocessingUnit(request, profile);
            preprocessingUnit.preprocess(request, response, profile, this.getServletContext());
        }
        if (this._devMode) {
            scriptsArray = new JSONArray();
            for (String nextScript : this._envFiles) {
                scriptsArray.put((Object)(designer_path + nextScript));
            }
        } else {
            scriptsArray = new JSONArray();
            scriptsArray.put((Object)(designer_path + "jsc/env_combined.js"));
        }
        if (this._pluginfiles.get(profileName) == null) {
            ArrayList<IDiagramPlugin> compressed = new ArrayList<IDiagramPlugin>();
            ArrayList<IDiagramPlugin> uncompressed = new ArrayList<IDiagramPlugin>();
            this._pluginfiles.put(profileName, compressed);
            this._uncompressedPlugins.put(profileName, uncompressed);
            for (String pluginName : profile.getPlugins()) {
                IDiagramPlugin plugin = this._pluginService.findPlugin(request, pluginName);
                if (plugin == null) {
                    _logger.warn("Could not find the plugin " + pluginName + " requested by the profile " + profile.getName());
                    continue;
                }
                if (plugin.isCompressable()) {
                    compressed.add(plugin);
                    continue;
                }
                uncompressed.add(plugin);
            }
            if (!this._devMode) {
                String rs = EditorHandler.compressJS((Collection<IDiagramPlugin>)this._pluginfiles.get(profileName), this.getServletContext());
                try {
                    FileWriter w = new FileWriter(this.getServletContext().getRealPath(designer_path + "jsc/plugins_" + profileName + ".js"));
                    w.write(rs.toString());
                    w.close();
                }
                catch (Exception e) {
                    _logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        JSONArray pluginsArray = new JSONArray();
        if (this._devMode) {
            for (IDiagramPlugin jsFile : this._pluginfiles.get(profileName)) {
                pluginsArray.put((Object)("/plugin/" + jsFile.getName() + ".js"));
            }
        } else {
            pluginsArray.put((Object)(designer_path + "jsc/plugins_" + profileName + ".js"));
        }
        for (IDiagramPlugin uncompressed : this._uncompressedPlugins.get(profileName)) {
            pluginsArray.put((Object)(designer_path + "plugin/" + uncompressed.getName() + ".js"));
        }
        ST editorTemplate = new ST(this._doc, '$', '$');
        editorTemplate.add("editorprofile", (Object)profileName);
        editorTemplate.add("editoruuid", (Object)uuid);
        editorTemplate.add("editorid", (Object)editorID);
        editorTemplate.add("activenodes", (Object)activeNodes);
        editorTemplate.add("completednodes", (Object)completedNodes);
        editorTemplate.add("readonly", (Object)readOnly);
        editorTemplate.add("allscripts", (Object)scriptsArray.toString());
        editorTemplate.add("allplugins", (Object)pluginsArray.toString());
        editorTemplate.add("title", (Object)profile.getTitle());
        editorTemplate.add("stencilset", (Object)profile.getStencilSet());
        editorTemplate.add("debug", (Object)this._devMode);
        editorTemplate.add("preprocessing", (Object)(preprocessingUnit == null ? "" : preprocessingUnit.getOutData()));
        editorTemplate.add("externalprotocol", (Object)(RepositoryInfo.getRepositoryProtocol(profile) == null ? "" : RepositoryInfo.getRepositoryProtocol(profile)));
        editorTemplate.add("externalhost", (Object)RepositoryInfo.getRepositoryHost(profile));
        editorTemplate.add("externalsubdomain", (Object)(RepositoryInfo.getRepositorySubdomain(profile) != null ? RepositoryInfo.getRepositorySubdomain(profile).substring(0, RepositoryInfo.getRepositorySubdomain(profile).indexOf("/")) : ""));
        editorTemplate.add("repositoryid", (Object)"designer");
        editorTemplate.add("localhistoryenabled", (Object)profile.getLocalHistoryEnabled());
        editorTemplate.add("localhistorytimeout", (Object)profile.getLocalHistoryTimeout());
        editorTemplate.add("designerversion", (Object)this._designerVersion);
        editorTemplate.add("storesvgonsave", (Object)profile.getStoreSVGonSaveOption());
        editorTemplate.add("defaultSkin", (Object)(designer_path + "css/theme-default.css"));
        String overlaySkin = "";
        if (this._skin != null && !this._skin.equals("default")) {
            overlaySkin = designer_path + "css/theme-" + this._skin + ".css";
        }
        editorTemplate.add("overlaySkin", (Object)overlaySkin);
        StringBuilder plugins = new StringBuilder();
        boolean commaNeeded = false;
        for (String ext : profile.getPlugins()) {
            if (commaNeeded) {
                plugins.append(",");
            } else {
                commaNeeded = true;
            }
            plugins.append("\"").append(ext).append("\"");
        }
        editorTemplate.add("profileplugins", (Object)plugins.toString());
        StringBuilder ssexts = new StringBuilder();
        commaNeeded = false;
        for (String ext : profile.getStencilSetExtensions()) {
            if (commaNeeded) {
                ssexts.append(",");
            } else {
                commaNeeded = true;
            }
            ssexts.append("\"").append(ext).append("\"");
        }
        editorTemplate.add("ssextensions", (Object)ssexts.toString());
        editorTemplate.add("contextroot", (Object)request.getContextPath());
        response.setContentType("text/javascript; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(editorTemplate.render());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readEnvFiles(ServletContext context) throws IOException {
        FileInputStream core_scripts = new FileInputStream(context.getRealPath(designer_path + "js/js_files.json"));
        try {
            int read;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((read = core_scripts.read(buffer)) != -1) {
                stream.write(buffer, 0, read);
            }
            String string = stream.toString();
            return string;
        }
        finally {
            try {
                core_scripts.close();
            }
            catch (IOException e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String compressJS(Collection<IDiagramPlugin> plugins, ServletContext context) {
        StringWriter sw = new StringWriter();
        for (IDiagramPlugin plugin : plugins) {
            sw.append("/* ").append(plugin.getName()).append(" */\n");
            InputStream input = plugin.getContents();
            try {
                sw.append(EditorHandler.compileJS(plugin.getName(), input));
            }
            catch (EvaluatorException e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                _logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
            sw.append("\n");
        }
        return sw.toString();
    }

    private static boolean isIE(HttpServletRequest request) {
        return request.getHeader("USER-AGENT").toLowerCase().indexOf("msie") > 0;
    }

    private static String readDesignerVersion(ServletContext context) {
        String retStr = "";
        try {
            String line;
            InputStream inputStream = context.getResourceAsStream("/META-INF/MANIFEST.MF");
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith(BUNDLE_VERSION)) continue;
                retStr = line.substring(BUNDLE_VERSION.length() + 1);
                retStr = retStr.trim();
            }
            inputStream.close();
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
        return retStr;
    }

    public static String compileJS(String filename, InputStream code) throws IOException {
        ArrayList<String> filenames = new ArrayList<String>();
        ArrayList<InputStream> codes = new ArrayList<InputStream>();
        filenames.add(filename);
        codes.add(code);
        return EditorHandler.compileJS(filenames, codes);
    }

    public static String compileJS(List<String> filenames, List<InputStream> codes) throws IOException {
        Compiler compiler = new Compiler();
        CompilerOptions options = new CompilerOptions();
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        JSSourceFile extern = JSSourceFile.fromCode((String)"externs.js", (String)"function alert(x) {}");
        ArrayList<JSSourceFile> inputs = new ArrayList<JSSourceFile>();
        for (int i = 0; i < filenames.size(); ++i) {
            inputs.add(JSSourceFile.fromInputStream((String)filenames.get(i), (InputStream)codes.get(i)));
        }
        Result results = compiler.compile(extern, inputs.toArray(new JSSourceFile[inputs.size()]), options);
        return compiler.toSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String pathname) throws IOException {
        StringBuilder fileContents = new StringBuilder();
        Scanner scanner = new Scanner(new File(pathname), "UTF-8");
        String lineSeparator = System.getProperty("line.separator");
        try {
            while (scanner.hasNextLine()) {
                fileContents.append(scanner.nextLine() + lineSeparator);
            }
            String string = fileContents.toString();
            return string;
        }
        finally {
            scanner.close();
        }
    }
}

