/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.taskforms;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.PotentialOwner;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.ResourceRole;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.UserTask;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.taskforms.TaskFormInfo;
import org.jbpm.designer.taskforms.TaskFormInput;
import org.jbpm.designer.taskforms.TaskFormOutput;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.formModeler.designer.integration.BPMNFormBuilderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STRawGroupDir;
import org.uberfire.backend.vfs.Path;

public class TaskFormTemplateManager {
    private static final Logger _logger = LoggerFactory.getLogger(TaskFormTemplateManager.class);
    private static final String[] validStructureRefs = new String[]{"Float", "Integer", "String", "Object", "Boolean", "Undefined"};
    public static final String TASKFORMS_PATH = "stencilsets";
    private IDiagramProfile profile;
    private String packageName;
    private String assetName;
    private Asset processAsset;
    private String templatesPath;
    private Definitions def;
    private List<TaskFormInfo> taskFormInformationList = new ArrayList<TaskFormInfo>();
    private Path myPath;
    private BPMNFormBuilderService formModelerService;

    public TaskFormTemplateManager(Path myPath, BPMNFormBuilderService formModelerService, IDiagramProfile profile, Asset processAsset, String templatesPath, Definitions def) {
        this.myPath = myPath;
        this.formModelerService = formModelerService;
        this.profile = profile;
        this.packageName = processAsset.getAssetLocation();
        this.assetName = processAsset.getName();
        this.processAsset = processAsset;
        this.templatesPath = templatesPath;
        this.def = def;
    }

    public void processTemplates() {
        List rootElements = this.def.getRootElements();
        for (RootElement re : rootElements) {
            if (!(re instanceof Process)) continue;
            Process process = (Process)re;
            if (process != null && process.getId() != null && process.getId().length() > 0) {
                TaskFormInfo tfi = new TaskFormInfo();
                tfi.setId(process.getId() + "-taskform");
                if (process.getName() != null && process.getName().length() > 0) {
                    tfi.setProcessName(process.getName());
                } else {
                    tfi.setProcessName(process.getId());
                }
                tfi.setProcessId(process.getId());
                tfi.setPkgName(this.packageName);
                List processProperties = process.getProperties();
                for (Property prop : processProperties) {
                    if (!this.isValidStructureRef(prop.getItemSubjectRef().getStructureRef())) continue;
                    TaskFormInput input = new TaskFormInput();
                    input.setName(prop.getId());
                    input.setRefType(prop.getItemSubjectRef().getStructureRef());
                    tfi.getTaskInputs().add(input);
                }
                tfi.setProcessForm(true);
                tfi.setUserTaskForm(false);
                this.taskFormInformationList.add(tfi);
                for (FlowElement fe : process.getFlowElements()) {
                    if (fe instanceof UserTask) {
                        this.getTaskInfoForUserTask((UserTask)fe, process, processProperties);
                        continue;
                    }
                    if (!(fe instanceof FlowElementsContainer)) continue;
                    this.getTaskInfoForContainers((FlowElementsContainer)fe, process, processProperties);
                }
                this.generateTemplates();
                continue;
            }
            _logger.info("Invalid process. Not templates are generated");
        }
    }

    private void getTaskInfoForContainers(FlowElementsContainer container, Process process, List<Property> processProperties) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof UserTask) {
                this.getTaskInfoForUserTask((UserTask)fe, process, processProperties);
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.getTaskInfoForContainers((FlowElementsContainer)fe, process, processProperties);
        }
    }

    private void getTaskInfoForUserTask(UserTask utask, Process process, List<Property> processProperties) {
        TaskFormInfo usertfi = new TaskFormInfo();
        if (process.getName() != null && process.getName().length() > 0) {
            usertfi.setProcessName(process.getName());
        } else {
            usertfi.setProcessName(process.getId());
        }
        usertfi.setProcessId(process.getId());
        usertfi.setTaskId(utask.getId());
        usertfi.setPkgName(this.packageName);
        boolean validTaskName = false;
        List dataInputs = Collections.emptyList();
        List dataOutputs = Collections.emptyList();
        List dataInputAssociations = Collections.emptyList();
        List dataOutputAssociations = Collections.emptyList();
        if (utask.getIoSpecification() != null) {
            dataInputs = utask.getIoSpecification().getDataInputs();
            dataOutputs = utask.getIoSpecification().getDataOutputs();
            dataInputAssociations = utask.getDataInputAssociations();
            dataOutputAssociations = utask.getDataOutputAssociations();
            for (DataInput din : dataInputs) {
                List assignments;
                if (din.getName().equals("TaskName")) {
                    for (DataInputAssociation inputAssociation : dataInputAssociations) {
                        assignments = inputAssociation.getAssignment();
                        for (Assignment assignment : assignments) {
                            String taskName;
                            if (!((FormalExpression)assignment.getTo()).getBody().equals(din.getId()) || (taskName = ((FormalExpression)assignment.getFrom()).getBody()) == null || taskName.length() <= 0) continue;
                            usertfi.setId(taskName + "-taskform");
                            usertfi.setTaskName(taskName);
                            validTaskName = true;
                        }
                    }
                }
                if (din.getName().equals("ActorId")) {
                    for (DataInputAssociation inputAssociation : dataInputAssociations) {
                        assignments = inputAssociation.getAssignment();
                        for (Assignment assignment : assignments) {
                            String actorid;
                            if (!((FormalExpression)assignment.getTo()).getBody().equals(din.getId()) || (actorid = ((FormalExpression)assignment.getFrom()).getBody()) == null || actorid.length() <= 0) continue;
                            usertfi.setActorId(this.replaceInterpolations(actorid));
                        }
                    }
                }
                if (din.getName().equals("GroupId")) {
                    for (DataInputAssociation inputAssociation : dataInputAssociations) {
                        assignments = inputAssociation.getAssignment();
                        for (Assignment assignment : assignments) {
                            String groupid;
                            if (!((FormalExpression)assignment.getTo()).getBody().equals(din.getId()) || (groupid = ((FormalExpression)assignment.getFrom()).getBody()) == null || groupid.length() <= 0) continue;
                            usertfi.setGroupId(this.replaceInterpolations(groupid));
                        }
                    }
                }
                if (din.getName().equals("Skippable")) {
                    for (DataInputAssociation inputAssociation : dataInputAssociations) {
                        assignments = inputAssociation.getAssignment();
                        for (Assignment assignment : assignments) {
                            String skippable;
                            if (!((FormalExpression)assignment.getTo()).getBody().equals(din.getId()) || (skippable = ((FormalExpression)assignment.getFrom()).getBody()) == null || skippable.length() <= 0) continue;
                            usertfi.setSkippable(this.replaceInterpolations(skippable));
                        }
                    }
                }
                if (din.getName().equals("Priority")) {
                    for (DataInputAssociation inputAssociation : dataInputAssociations) {
                        assignments = inputAssociation.getAssignment();
                        for (Assignment assignment : assignments) {
                            String priority;
                            if (!((FormalExpression)assignment.getTo()).getBody().equals(din.getId()) || (priority = ((FormalExpression)assignment.getFrom()).getBody()) == null || priority.length() <= 0) continue;
                            usertfi.setPriority(this.replaceInterpolations(priority));
                        }
                    }
                }
                if (!din.getName().equals("Comment")) continue;
                for (DataInputAssociation inputAssociation : dataInputAssociations) {
                    assignments = inputAssociation.getAssignment();
                    for (Assignment assignment : assignments) {
                        String comment;
                        if (!((FormalExpression)assignment.getTo()).getBody().equals(din.getId()) || (comment = ((FormalExpression)assignment.getFrom()).getBody()) == null || comment.length() <= 0) continue;
                        usertfi.setComment(this.replaceInterpolations(comment));
                    }
                }
            }
        }
        if (validTaskName) {
            List utaskroles = utask.getResources();
            for (ResourceRole role : utaskroles) {
                FormalExpression ownerexp;
                if (!(role instanceof PotentialOwner) || (ownerexp = (FormalExpression)((PotentialOwner)role).getResourceAssignmentExpression().getExpression()).getBody() == null || ownerexp.getBody().length() <= 0) continue;
                usertfi.getTaskOwners().add(this.replaceInterpolations(ownerexp.getBody()));
            }
            for (DataInput dinput : dataInputs) {
                if (dinput.getName().equals("TaskName") || dinput.getName().equals("ActorId") || dinput.getName().equals("GroupId") || dinput.getName().equals("Skippable") || dinput.getName().equals("Priority") || dinput.getName().equals("Comment")) continue;
                TaskFormInput input = new TaskFormInput();
                input.setName(dinput.getName());
                for (DataInputAssociation inputAssociation : dataInputAssociations) {
                    List assignments = inputAssociation.getAssignment();
                    if (assignments != null && assignments.size() > 0) {
                        for (Assignment assignment : assignments) {
                            if (!((FormalExpression)assignment.getTo()).getBody().equals(dinput.getId())) continue;
                            input.setValue(((FormalExpression)assignment.getFrom()).getBody());
                        }
                        continue;
                    }
                    if (!inputAssociation.getTargetRef().getId().equals(dinput.getId())) continue;
                    for (Property prop : processProperties) {
                        if (!prop.getId().equals(((ItemAwareElement)inputAssociation.getSourceRef().get(0)).getId())) continue;
                        input.setRefType(prop.getItemSubjectRef().getStructureRef());
                    }
                    if (input.getRefType() != null && input.getRefType().equals("Date")) {
                        input.setValue("${" + ((DataInput)inputAssociation.getTargetRef()).getName() + "?date} ${" + ((DataInput)inputAssociation.getTargetRef()).getName() + "?time}");
                        continue;
                    }
                    input.setValue("${" + ((DataInput)inputAssociation.getTargetRef()).getName() + "}");
                }
                usertfi.getTaskInputs().add(input);
            }
            for (DataOutput dout : dataOutputs) {
                TaskFormOutput out = new TaskFormOutput();
                out.setName(dout.getName());
                for (DataOutputAssociation outputAssociation : dataOutputAssociations) {
                    List sources = outputAssociation.getSourceRef();
                    for (ItemAwareElement iae : sources) {
                        if (!iae.getId().equals(dout.getId())) continue;
                        for (Property prop : processProperties) {
                            if (!prop.getId().equals(outputAssociation.getTargetRef().getId())) continue;
                            out.setRefType(prop.getItemSubjectRef().getStructureRef());
                        }
                    }
                }
                usertfi.getTaskOutputs().add(out);
            }
            usertfi.setUserTaskForm(true);
            usertfi.setProcessForm(false);
            boolean merged = false;
            for (TaskFormInfo existingForm : this.taskFormInformationList) {
                if (!existingForm.getId().equals(usertfi.getId())) continue;
                this.mergeUserTaskForms(usertfi, existingForm);
                merged = true;
                break;
            }
            if (!merged) {
                this.taskFormInformationList.add(usertfi);
            }
        } else {
            _logger.info("Could not generate task form for usertask id: " + utask.getId() + ". No task name specified.");
        }
    }

    private void mergeUserTaskForms(TaskFormInfo sourceForm, TaskFormInfo targetForm) {
        ArrayList<TaskFormInput> toMergeTaskInputs = new ArrayList<TaskFormInput>();
        ArrayList<TaskFormOutput> toMergeTaskOutputs = new ArrayList<TaskFormOutput>();
        for (String sourceOwner : sourceForm.getTaskOwners()) {
            if (targetForm.getTaskOwners().contains(sourceOwner)) continue;
            targetForm.getTaskOwners().add(sourceOwner);
        }
        for (TaskFormInput sourceInput : sourceForm.getTaskInputs()) {
            boolean foundInput = false;
            for (TaskFormInput targetInput : targetForm.getTaskInputs()) {
                if (!targetInput.getName().equals(sourceInput.getName())) continue;
                foundInput = true;
            }
            if (foundInput) continue;
            toMergeTaskInputs.add(sourceInput);
        }
        for (TaskFormOutput sourceOutput : sourceForm.getTaskOutputs()) {
            boolean foundOutput = false;
            for (TaskFormOutput targetOutput : targetForm.getTaskOutputs()) {
                if (!targetOutput.getName().equals(sourceOutput.getName())) continue;
                foundOutput = true;
            }
            if (foundOutput) continue;
            toMergeTaskOutputs.add(sourceOutput);
        }
        for (TaskFormInput input : toMergeTaskInputs) {
            targetForm.getTaskInputs().add(input);
        }
        for (TaskFormOutput output : toMergeTaskOutputs) {
            targetForm.getTaskOutputs().add(output);
        }
    }

    private boolean isValidStructureRef(String structureRef) {
        if (structureRef != null && structureRef.length() > 0) {
            return Arrays.asList(validStructureRefs).contains(structureRef);
        }
        return true;
    }

    public void generateTemplates() {
        for (TaskFormInfo tfi : this.taskFormInformationList) {
            if (tfi.isProcessForm()) {
                this.generateProcessTemplate(tfi);
                continue;
            }
            this.generateUserTaskTemplate(tfi);
        }
    }

    private void generateProcessTemplate(TaskFormInfo tfi) {
        STRawGroupDir templates = new STRawGroupDir(this.templatesPath, '$', '$');
        ST processFormTemplate = templates.getInstanceOf("processtaskform");
        processFormTemplate.add("tfi", (Object)tfi);
        processFormTemplate.add("bopen", (Object)"{");
        processFormTemplate.add("bclose", (Object)"}");
        tfi.setMetaOutput(processFormTemplate.render());
        String modelerFileName = tfi.getId() + ".form";
        String modelerURI = this.myPath.toURI();
        modelerURI = modelerURI.substring(0, modelerURI.lastIndexOf("/"));
        modelerURI = modelerURI + "/" + modelerFileName;
        try {
            tfi.setModelerOutput(this.formModelerService.buildFormXML(this.myPath.getFileSystem(), modelerFileName, modelerURI, this.def, tfi.getTaskId()));
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private void generateUserTaskTemplate(TaskFormInfo tfi) {
        STRawGroupDir templates = new STRawGroupDir(this.templatesPath, '$', '$');
        ST usertaskFormTemplate = templates.getInstanceOf("usertaskform");
        usertaskFormTemplate.add("tfi", (Object)tfi);
        usertaskFormTemplate.add("bopen", (Object)"{");
        usertaskFormTemplate.add("bclose", (Object)"}");
        tfi.setMetaOutput(usertaskFormTemplate.render());
        String modelerFileName = tfi.getId() + ".form";
        String modelerURI = this.myPath.toURI();
        modelerURI = modelerURI.substring(0, modelerURI.lastIndexOf("/"));
        modelerURI = modelerURI + "/" + modelerFileName;
        try {
            tfi.setModelerOutput(this.formModelerService.buildFormXML(this.myPath.getFileSystem(), modelerFileName, modelerURI, this.def, tfi.getTaskId()));
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFile(String pathname) throws IOException {
        StringBuilder fileContents = new StringBuilder();
        Scanner scanner = new Scanner(new File(pathname));
        String lineSeparator = System.getProperty("line.separator");
        try {
            while (scanner.hasNextLine()) {
                fileContents.append(scanner.nextLine() + lineSeparator);
            }
            String string = fileContents.toString();
            return string;
        }
        finally {
            scanner.close();
        }
    }

    private String replaceInterpolations(String base) {
        return base.replaceAll("\\#\\{", "\\$\\{");
    }

    public List<TaskFormInfo> getTaskFormInformationList() {
        return this.taskFormInformationList;
    }

    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public void setTemplatesPath(String templatesPath) {
        this.templatesPath = templatesPath;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public void setTaskFormInformationList(List<TaskFormInfo> taskFormInformationList) {
        this.taskFormInformationList = taskFormInformationList;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
}

