/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletResponse;
import org.jbpm.designer.helper.TestServletConfig;
import org.jbpm.designer.helper.TestServletContext;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Filter;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.VFSFileSystemProducer;
import org.jbpm.designer.repository.filters.FilterByExtension;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;
import org.jbpm.designer.web.server.DictionaryServlet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DictionaryServletTest
extends RepositoryBaseTest {
    @Before
    public void setup() {
        new File(REPOSITORY_ROOT).mkdir();
        this.profile = new JbpmProfileImpl();
        this.producer = new VFSFileSystemProducer();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("repository.root", VFS_REPOSITORY_ROOT);
        env.put("repository.globaldir", "/global");
        this.descriptor = this.producer.produceFileSystem(env);
    }

    @After
    public void teardown() {
        File repo = new File(REPOSITORY_ROOT);
        if (repo.exists()) {
            this.deleteFiles(repo);
        }
        repo.delete();
    }

    @Test
    public void testStoreDictionary() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "save");
        params.put("profile", "jbpm");
        params.put("dvalue", "this is dictionary");
        DictionaryServlet dictionaryServlet = new DictionaryServlet();
        dictionaryServlet.setProfile((IDiagramProfile)this.profile);
        dictionaryServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        dictionaryServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String responseText = new String(response.getContent());
        Assert.assertNotNull((Object)responseText);
        Assert.assertEquals((Object)"saved", (Object)responseText);
        Collection dictionary = repository.listAssets("/global", (Filter)new FilterByExtension("json"));
        Assert.assertNotNull((Object)dictionary);
        Assert.assertEquals((long)1L, (long)dictionary.size());
        Asset dictionaryAsset = repository.loadAsset(((Asset)dictionary.iterator().next()).getUniqueId());
        Assert.assertNotNull((Object)dictionaryAsset);
        Assert.assertEquals((Object)"this is dictionary", (Object)dictionaryAsset.getAssetContent());
    }

    @Test
    public void testLoadDictionary() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)"test dictionary content").type("json").name("processdictionary").location("/global");
        repository.createAsset(builder.getAsset());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "load");
        params.put("profile", "jbpm");
        DictionaryServlet dictionaryServlet = new DictionaryServlet();
        dictionaryServlet.setProfile((IDiagramProfile)this.profile);
        dictionaryServlet.init((ServletConfig)new TestServletConfig(new TestServletContext((Repository)repository)));
        TestHttpServletResponse response = new TestHttpServletResponse();
        dictionaryServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        String dictionaryContent = new String(response.getContent());
        Assert.assertNotNull((Object)dictionaryContent);
        Assert.assertEquals((Object)"test dictionary content", (Object)dictionaryContent);
    }
}

