/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server.service;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.service.BPMN2DataServices;
import org.jbpm.designer.service.DesignerAssetService;
import org.jbpm.designer.util.OSProtocolSocketFactory;
import org.jbpm.designer.util.Utils;
import org.json.JSONArray;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class DefaultDesignerAssetService
implements DesignerAssetService {
    @Inject
    private Repository repository;
    @Inject
    private Instance<BPMN2DataServices> bpmn2DataServices;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    public static final String PROCESS_STUB = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<bpmn2:definitions xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.omg.org/bpmn20\" xmlns:bpmn2=\"http://www.omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" xmlns:bpsim=\"http://www.bpsim.org/schemas/1.0\" xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:drools=\"http://www.jboss.org/drools\" \nid=\"Definition\" xsi:schemaLocation=\"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd http://www.jboss.org/drools drools.xsd http://www.bpsim.org/schemas/1.0 bpsim.xsd\" expressionLanguage=\"http://www.mvel.org/2.0\" targetNamespace=\"http://www.omg.org/bpmn20\" typeLanguage=\"http://www.java.com/javaTypes\"> \n   <bpmn2:process id=\"${processid}\" drools:packageName=\"org.jbpm\" drools:version=\"1.0\" name=\"\" isExecutable=\"true\"> \n      <bpmn2:startEvent id=\"processStartEvent\" drools:bgcolor=\"#9acd32\" drools:selectable=\"true\" name=\"\"/> \n   </bpmn2:process> \n   <bpmndi:BPMNDiagram> \n      <bpmndi:BPMNPlane bpmnElement=\"${processid}\"> \n         <bpmndi:BPMNShape bpmnElement=\"processStartEvent\"> \n            <dc:Bounds height=\"30.0\" width=\"30.0\" x=\"120.0\" y=\"165.0\"/> \n         </bpmndi:BPMNShape> \n      </bpmndi:BPMNPlane> \n   </bpmndi:BPMNDiagram> \n</bpmn2:definitions>";

    @PostConstruct
    public void configure() {
        Protocol.registerProtocol((String)"http", (Protocol)new Protocol("http", (ProtocolSocketFactory)new OSProtocolSocketFactory(), 80));
    }

    public Map<String, String> getEditorParameters(org.uberfire.backend.vfs.Path path, String editorID, String hostInfo, PlaceRequest place) {
        List<Object> activeNodesList = new ArrayList();
        String activeNodesParam = place.getParameter("activeNodes", null);
        boolean readOnly = place.getParameter("readOnly", null) != null;
        String processId = place.getParameter("processId", "");
        String deploymentId = place.getParameter("deploymentId", "");
        String encodedProcessSource = "";
        try {
            encodedProcessSource = ((BPMN2DataServices)this.bpmn2DataServices.iterator().next()).getProcessSources(deploymentId, processId);
        }
        catch (Exception e) {
            encodedProcessSource = place.getParameter("encodedProcessSource", "");
        }
        if (activeNodesParam != null) {
            activeNodesList = Arrays.asList(activeNodesParam.split(","));
        }
        List<Object> completedNodesList = new ArrayList();
        String completedNodesParam = place.getParameter("completedNodes", null);
        if (completedNodesParam != null) {
            completedNodesList = Arrays.asList(completedNodesParam.split(","));
        }
        JSONArray activeNodesArray = new JSONArray(activeNodesList);
        JSONArray completedNodesArray = new JSONArray(completedNodesList);
        HashMap<String, String> editorParamsMap = new HashMap<String, String>();
        editorParamsMap.put("hostinfo", hostInfo);
        try {
            editorParamsMap.put("uuid", Base64.encodeBase64URLSafeString((byte[])UriUtils.decode(path.toURI()).getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        editorParamsMap.put("profile", "jbpm");
        editorParamsMap.put("pp", "");
        editorParamsMap.put("editorid", editorID);
        editorParamsMap.put("readonly", String.valueOf(readOnly));
        editorParamsMap.put("activenodes", activeNodesArray.toString());
        editorParamsMap.put("completednodes", completedNodesArray.toString());
        editorParamsMap.put("processsource", encodedProcessSource);
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.sessionInfo));
        return editorParamsMap;
    }

    public String getEditorID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public org.uberfire.backend.vfs.Path createProcess(org.uberfire.backend.vfs.Path context, String fileName) {
        org.uberfire.backend.vfs.Path path = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName));
        String location = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent().toString();
        String name = path.getFileName();
        String processId = this.buildProcessId(location, name);
        String processContent = PROCESS_STUB.replaceAll("\\$\\{processid\\}", processId.replaceAll("\\s", ""));
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder(name);
        builder.location(location).content(processContent).uniqueId(path.toURI());
        Asset processAsset = builder.getAsset();
        this.repository.createAsset(processAsset);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEditorResponse(String urlpath, String encProcessSrc) {
        HttpClient httpclient = new HttpClient();
        PostMethod authMethod = new PostMethod(urlpath);
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("j_username", "admin"), new NameValuePair("j_password", "admin")};
        authMethod.setRequestBody(data);
        try {
            httpclient.executeMethod((HttpMethod)authMethod);
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            authMethod.releaseConnection();
        }
        PostMethod theMethod = new PostMethod(urlpath);
        theMethod.setParameter("processsource", encProcessSrc);
        StringBuffer sb = new StringBuffer();
        try {
            httpclient.executeMethod((HttpMethod)theMethod);
            sb.append(theMethod.getResponseBodyAsString());
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            theMethod.releaseConnection();
        }
    }

    private String buildProcessId(String location, String name) {
        if (location.startsWith("/")) {
            location = location.replaceFirst("/", "");
        }
        if ((location = location.replaceAll("/", ".")).length() > 0) {
            String[] locationParts = location.split("\\.");
            location = locationParts[0];
        }
        name = name.substring(0, name.lastIndexOf("."));
        name = Utils.toBPMNIdentifier(name);
        return location + "." + name;
    }
}

