/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.impl;

import bpsim.BPSimDataType;
import bpsim.BpsimFactory;
import bpsim.BpsimPackage;
import bpsim.ControlParameters;
import bpsim.CostParameters;
import bpsim.ElementParameters;
import bpsim.FloatingParameterType;
import bpsim.NormalDistributionType;
import bpsim.Parameter;
import bpsim.PoissonDistributionType;
import bpsim.PriorityParameters;
import bpsim.ResourceParameters;
import bpsim.Scenario;
import bpsim.ScenarioParameters;
import bpsim.TimeParameters;
import bpsim.TimeUnit;
import bpsim.UniformDistributionType;
import bpsim.impl.BpsimPackageImpl;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.AdHocOrdering;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.Artifact;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.Auditing;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Category;
import org.eclipse.bpmn2.CategoryValue;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.DataStore;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Error;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.Escalation;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.EventSubprocess;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.eclipse.bpmn2.GlobalTask;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.LoopCharacteristics;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.Monitoring;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.bpmn2.PotentialOwner;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.ProcessType;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.Relationship;
import org.eclipse.bpmn2.ResourceAssignmentExpression;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.ScriptTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.Signal;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.bpmn2.util.Bpmn2Resource;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.DcFactory;
import org.eclipse.dd.dc.Point;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EAttributeImpl;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsFactory;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.GlobalType;
import org.jboss.drools.ImportType;
import org.jboss.drools.OnEntryScriptType;
import org.jboss.drools.OnExitScriptType;
import org.jboss.drools.impl.DroolsPackageImpl;
import org.jbpm.designer.bpmn2.BpmnMarshallerHelper;
import org.jbpm.designer.bpmn2.impl.Bpmn20Stencil;
import org.jbpm.designer.bpmn2.resource.JBPMBpmn2ResourceFactoryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bpmn2JsonUnmarshaller {
    public static final String defaultBgColor = "#fafad2";
    public static final String defaultBrColor = "#000000";
    public static final String defaultFontColor = "#000000";
    public static final String defaultSequenceflowColor = "#000000";
    public static final String defaultRelationshipType = "BPSimData";
    private Map<Object, String> _objMap = new HashMap<Object, String>();
    private Map<String, Object> _idMap = new HashMap<String, Object>();
    private Map<Object, List<String>> _outgoingFlows = new HashMap<Object, List<String>>();
    private Set<String> _sequenceFlowTargets = new HashSet<String>();
    private Map<String, Bounds> _bounds = new HashMap<String, Bounds>();
    private Map<String, List<Point>> _dockers = new HashMap<String, List<Point>>();
    private List<Lane> _lanes = new ArrayList<Lane>();
    private List<Artifact> _artifacts = new ArrayList<Artifact>();
    private Map<String, ItemDefinition> _subprocessItemDefs = new HashMap<String, ItemDefinition>();
    private List<Import> _wsdlImports = new ArrayList<Import>();
    private List<BpmnMarshallerHelper> _helpers;
    private String processDocs;
    private Bpmn2Resource _currentResource;
    private Map<String, Escalation> _escalations = new HashMap<String, Escalation>();
    private Map<String, Error> _errors = new HashMap<String, Error>();
    private Map<String, Message> _messages = new HashMap<String, Message>();
    private Map<String, ItemDefinition> _itemDefinitions = new HashMap<String, ItemDefinition>();
    private Map<String, List<EObject>> _simulationElementParameters = new HashMap<String, List<EObject>>();
    private ScenarioParameters _simulationScenarioParameters = BpsimFactory.eINSTANCE.createScenarioParameters();
    private static final Logger _logger = LoggerFactory.getLogger(Bpmn2JsonUnmarshaller.class);

    public Bpmn2JsonUnmarshaller() {
        this._helpers = new ArrayList<BpmnMarshallerHelper>();
        DroolsPackageImpl.init();
        BpsimPackageImpl.init();
        if (this.getClass().getClassLoader() instanceof BundleReference) {
            BundleContext context = ((BundleReference)this.getClass().getClassLoader()).getBundle().getBundleContext();
            try {
                ServiceReference[] refs;
                for (ServiceReference ref : refs = context.getAllServiceReferences(BpmnMarshallerHelper.class.getName(), null)) {
                    BpmnMarshallerHelper helper = (BpmnMarshallerHelper)context.getService(ref);
                    this._helpers.add(helper);
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
    }

    public Bpmn2Resource unmarshall(String json, String preProcessingData) throws JsonParseException, IOException {
        return this.unmarshall(new JsonFactory().createJsonParser(json), preProcessingData);
    }

    public Bpmn2Resource unmarshall(File file, String preProcessingData) throws JsonParseException, IOException {
        return this.unmarshall(new JsonFactory().createJsonParser(file), preProcessingData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bpmn2Resource unmarshall(JsonParser parser, String preProcessingData) throws JsonParseException, IOException {
        try {
            parser.nextToken();
            ResourceSetImpl rSet = new ResourceSetImpl();
            rSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpmn2", new JBPMBpmn2ResourceFactoryImpl());
            Bpmn2Resource bpmn2 = (Bpmn2Resource)rSet.createResource(URI.createURI((String)"virtual.bpmn2"));
            rSet.getResources().add((Object)bpmn2);
            this._currentResource = bpmn2;
            if (preProcessingData == null || preProcessingData.length() < 1) {
                preProcessingData = "ReadOnlyService";
            }
            Definitions def = (Definitions)this.unmarshallItem(parser, preProcessingData);
            this.revisitServiceTasks(def);
            this.revisitMessages(def);
            this.revisitCatchEvents(def);
            this.revisitThrowEvents(def);
            this.revisitLanes(def);
            this.revisitSubProcessItemDefs(def);
            this.revisitArtifacts(def);
            this.revisitGroups(def);
            this.revisitTaskAssociations(def);
            this.revisitSendReceiveTasks(def);
            this.reconnectFlows();
            this.revisitGateways(def);
            this.revisitCatchEventsConvertToBoundary(def);
            this.createDiagram(def);
            this.updateIDs(def);
            this.revisitDataObjects(def);
            this.revisitAssociationsIoSpec(def);
            this.revisitWsdlImports(def);
            this.revisitMultiInstanceTasks(def);
            this.addSimulation(def);
            this.revisitItemDefinitions(def);
            this.revisitProcessDoc(def);
            this._currentResource.getContents().add((Object)def);
            Bpmn2Resource bpmn2Resource = this._currentResource;
            return bpmn2Resource;
        }
        finally {
            parser.close();
            this._objMap.clear();
            this._idMap.clear();
            this._outgoingFlows.clear();
            this._sequenceFlowTargets.clear();
            this._bounds.clear();
            this._currentResource = null;
        }
    }

    public void revisitItemDefinitions(Definitions def) {
        ArrayList<String> itemIds = new ArrayList<String>();
        ArrayList itemsToRemove = new ArrayList();
        for (RootElement root : def.getRootElements()) {
            if (!(root instanceof ItemDefinition)) continue;
            if (!itemIds.contains(root.getId())) {
                itemIds.add(root.getId());
                continue;
            }
            ItemDefinition idef = (ItemDefinition)root;
            Random rand = new Random();
            int randomNum = rand.nextInt(991) + 10;
            idef.setId(idef.getId() + randomNum);
        }
    }

    public void revisitDI(Definitions def) {
        BPMNPlane plane = ((BPMNDiagram)def.getDiagrams().get(0)).getPlane();
        List diagramElements = plane.getPlaneElement();
        for (DiagramElement dia : diagramElements) {
            if (!(dia instanceof BPMNShape)) continue;
            BPMNShape shape = (BPMNShape)dia;
            this.updateShapeBounds(def, plane, shape.getBpmnElement());
        }
    }

    public void revisitProcessDoc(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            if (this.processDocs == null || this.processDocs.length() <= 0) continue;
            process.getDocumentation().add(this.createDocumentation(this.wrapInCDATABlock(this.processDocs)));
        }
    }

    public void updateShapeBounds(Definitions def, BPMNPlane plane, BaseElement ele) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            List flowElements = process.getFlowElements();
            boolean foundAsTopLevel = false;
            for (FlowElement fe : flowElements) {
                if (!fe.getId().equals(ele.getId())) continue;
                foundAsTopLevel = true;
                break;
            }
            if (foundAsTopLevel) continue;
            for (FlowElement fe : flowElements) {
                Bounds subprocessBounds;
                if (!(fe instanceof SubProcess) || (subprocessBounds = this.getBoundsForShape(plane, (BaseElement)fe)) == null) continue;
                this.updateShapeBoundsInSubprocess(plane, ele, (SubProcess)fe, subprocessBounds.getX(), subprocessBounds.getY());
            }
        }
    }

    public void updateShapeBoundsInSubprocess(BPMNPlane plane, BaseElement ele, SubProcess sub, float parentX, float parentY) {
        Bounds subEleBounds;
        boolean foundInSubprocess = false;
        for (FlowElement subEle : sub.getFlowElements()) {
            if (!subEle.getId().equals(ele.getId())) continue;
            foundInSubprocess = true;
            subEleBounds = this.getBoundsForShape(plane, (BaseElement)subEle);
            if (subEleBounds == null) continue;
            subEleBounds.setX(subEleBounds.getX() + parentX);
            subEleBounds.setY(subEleBounds.getY() + parentY);
        }
        if (!foundInSubprocess) {
            for (FlowElement subEle : sub.getFlowElements()) {
                if (!(subEle instanceof SubProcess)) continue;
                subEleBounds = this.getBoundsForShape(plane, (BaseElement)subEle);
                this.updateShapeBoundsInSubprocess(plane, ele, (SubProcess)subEle, subEleBounds.getX() + parentX, subEleBounds.getY() + parentY);
            }
        }
    }

    private Bounds getBoundsForShape(BPMNPlane plane, BaseElement ele) {
        List diagramElements = plane.getPlaneElement();
        for (DiagramElement dia : diagramElements) {
            BPMNShape shape;
            if (!(dia instanceof BPMNShape) || !(shape = (BPMNShape)dia).getBpmnElement().getId().equals(ele.getId())) continue;
            return shape.getBounds();
        }
        return null;
    }

    public void revisitMultiInstanceTasks(Definitions def) {
        try {
            List rootElements = def.getRootElements();
            for (RootElement root : rootElements) {
                if (!(root instanceof Process)) continue;
                Process process = (Process)root;
                List flowElements = process.getFlowElements();
                for (FlowElement fe : flowElements) {
                    if (!(fe instanceof Task)) continue;
                    Task task = (Task)fe;
                    block4: for (FeatureMap.Entry entry : task.getAnyAttribute()) {
                        InputSet inset;
                        List properties;
                        String multiValue;
                        String[] multiValueParts;
                        if (!entry.getEStructuralFeature().getName().equals("mitask") || (multiValueParts = (multiValue = (String)entry.getValue()).split("@")) == null || multiValueParts.length != 4) continue;
                        String miCollectionInput = multiValueParts[0].equals(" ") ? "" : multiValueParts[0];
                        String miCollectionOutput = multiValueParts[1].equals(" ") ? "" : multiValueParts[1];
                        String miDataInput = multiValueParts[2].equals(" ") ? "" : multiValueParts[2];
                        String miDataOutput = multiValueParts[3].equals(" ") ? "" : multiValueParts[3];
                        MultiInstanceLoopCharacteristics loopCharacteristics = Bpmn2Factory.eINSTANCE.createMultiInstanceLoopCharacteristics();
                        if (miCollectionInput != null && miCollectionInput.length() > 0) {
                            properties = process.getProperties();
                            for (Property prop : properties) {
                                if (prop.getId() == null || !prop.getId().equals(miCollectionInput)) continue;
                                DataInput miCollectionInputDI = Bpmn2Factory.eINSTANCE.createDataInput();
                                miCollectionInputDI.setName("miinputCollection");
                                ItemDefinition miCollectionInputDIItemDefinition = Bpmn2Factory.eINSTANCE.createItemDefinition();
                                miCollectionInputDIItemDefinition.setStructureRef("java.util.Collection");
                                def.getRootElements().add(miCollectionInputDIItemDefinition);
                                miCollectionInputDI.setItemSubjectRef(miCollectionInputDIItemDefinition);
                                task.getIoSpecification().getDataInputs().add(miCollectionInputDI);
                                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                                    task.getIoSpecification().getInputSets().add(inset);
                                }
                                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(miCollectionInputDI);
                                loopCharacteristics.setLoopDataInputRef((ItemAwareElement)miCollectionInputDI);
                                DataInputAssociation miCollectionInputDataInputAssociation = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                                miCollectionInputDataInputAssociation.getSourceRef().add(prop);
                                miCollectionInputDataInputAssociation.setTargetRef((ItemAwareElement)miCollectionInputDI);
                                task.getDataInputAssociations().add(miCollectionInputDataInputAssociation);
                                break;
                            }
                        }
                        if (miCollectionOutput != null && miCollectionOutput.length() > 0) {
                            properties = process.getProperties();
                            for (Property prop : properties) {
                                if (prop.getId() == null || !prop.getId().equals(miCollectionOutput)) continue;
                                DataOutput miCollectionOutputDI = Bpmn2Factory.eINSTANCE.createDataOutput();
                                miCollectionOutputDI.setName("mioutputCollection");
                                ItemDefinition miCollectionOutputDIItemDefinition = Bpmn2Factory.eINSTANCE.createItemDefinition();
                                miCollectionOutputDIItemDefinition.setStructureRef("java.util.Collection");
                                def.getRootElements().add(miCollectionOutputDIItemDefinition);
                                miCollectionOutputDI.setItemSubjectRef(miCollectionOutputDIItemDefinition);
                                task.getIoSpecification().getDataOutputs().add(miCollectionOutputDI);
                                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                                    task.getIoSpecification().getInputSets().add(inset);
                                }
                                ((OutputSet)task.getIoSpecification().getOutputSets().get(0)).getDataOutputRefs().add(miCollectionOutputDI);
                                loopCharacteristics.setLoopDataOutputRef((ItemAwareElement)miCollectionOutputDI);
                                DataOutputAssociation miCollectionInputDataOutputAssociation = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                                miCollectionInputDataOutputAssociation.setTargetRef((ItemAwareElement)prop);
                                miCollectionInputDataOutputAssociation.getSourceRef().add(miCollectionOutputDI);
                                task.getDataOutputAssociations().add(miCollectionInputDataOutputAssociation);
                                break;
                            }
                        }
                        if (miDataInput != null && miDataInput.length() > 0) {
                            List dins = task.getIoSpecification().getDataInputs();
                            for (DataInput di : dins) {
                                if (!di.getName().equals(miDataInput)) continue;
                                DataInput inputDataItemObj = Bpmn2Factory.eINSTANCE.createDataInput();
                                inputDataItemObj.setId("miDataInputX");
                                inputDataItemObj.setItemSubjectRef(di.getItemSubjectRef());
                                loopCharacteristics.setInputDataItem(inputDataItemObj);
                                break;
                            }
                        }
                        if (miDataOutput != null && miDataOutput.length() > 0) {
                            List douts = task.getIoSpecification().getDataOutputs();
                            for (DataOutput dout : douts) {
                                if (!dout.getName().equals(miDataOutput)) continue;
                                DataOutput outputDataItemObj = Bpmn2Factory.eINSTANCE.createDataOutput();
                                outputDataItemObj.setId("miDataOutputX");
                                outputDataItemObj.setItemSubjectRef(dout.getItemSubjectRef());
                                loopCharacteristics.setOutputDataItem(outputDataItemObj);
                                break;
                            }
                        }
                        task.setLoopCharacteristics((LoopCharacteristics)loopCharacteristics);
                        if (miDataInput != null && miDataInput.length() > 0 && ((MultiInstanceLoopCharacteristics)task.getLoopCharacteristics()).getInputDataItem() != null) {
                            DataInputAssociation dias = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                            dias.getSourceRef().add(((MultiInstanceLoopCharacteristics)task.getLoopCharacteristics()).getInputDataItem());
                            List dins = task.getIoSpecification().getDataInputs();
                            for (DataInput di : dins) {
                                if (!di.getName().equals(miDataInput)) continue;
                                dias.setTargetRef((ItemAwareElement)di);
                                task.getDataInputAssociations().add(dias);
                                break;
                            }
                        }
                        if (miDataOutput == null || miDataOutput.length() <= 0 || ((MultiInstanceLoopCharacteristics)task.getLoopCharacteristics()).getOutputDataItem() == null) continue;
                        DataOutputAssociation dout = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                        dout.setTargetRef((ItemAwareElement)((MultiInstanceLoopCharacteristics)task.getLoopCharacteristics()).getOutputDataItem());
                        List douts = task.getIoSpecification().getDataOutputs();
                        for (DataOutput dou : douts) {
                            if (!dou.getName().equals(miDataOutput)) continue;
                            dout.getSourceRef().add(dou);
                            task.getDataOutputAssociations().add(dout);
                            continue block4;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void revisitWsdlImports(Definitions def) {
        for (Import imp : this._wsdlImports) {
            def.getImports().add(imp);
        }
        this._wsdlImports.clear();
    }

    public void revisitSubProcessItemDefs(Definitions def) {
        for (String key : this._subprocessItemDefs.keySet()) {
            def.getRootElements().add(this._subprocessItemDefs.get(key));
        }
        this._subprocessItemDefs.clear();
    }

    public void updateIDs(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            List flowElements = process.getFlowElements();
            for (FlowElement fe : flowElements) {
                DataObject da;
                if (!(fe instanceof DataObject) || (da = (DataObject)fe).getName() == null) continue;
                String daId = da.getName().trim();
                daId = daId.replaceAll("\\W", "");
                da.setId(daId);
            }
        }
    }

    public void addSimulation(Definitions def) {
        Relationship relationship = Bpmn2Factory.eINSTANCE.createRelationship();
        relationship.getSources().add(def);
        relationship.getTargets().add(def);
        relationship.setType(defaultRelationshipType);
        BPSimDataType simDataType = BpsimFactory.eINSTANCE.createBPSimDataType();
        Scenario defaultScenario = BpsimFactory.eINSTANCE.createScenario();
        defaultScenario.setId("default");
        defaultScenario.setName("Simulationscenario");
        defaultScenario.setScenarioParameters(this._simulationScenarioParameters);
        if (this._simulationElementParameters.size() > 0) {
            for (String key : this._simulationElementParameters.keySet()) {
                ElementParameters etype = BpsimFactory.eINSTANCE.createElementParameters();
                etype.setElementRef(key);
                List<EObject> params = this._simulationElementParameters.get(key);
                for (EObject np : params) {
                    if (np instanceof ControlParameters) {
                        etype.setControlParameters((ControlParameters)np);
                        continue;
                    }
                    if (np instanceof CostParameters) {
                        etype.setCostParameters((CostParameters)np);
                        continue;
                    }
                    if (np instanceof PriorityParameters) {
                        etype.setPriorityParameters((PriorityParameters)np);
                        continue;
                    }
                    if (np instanceof ResourceParameters) {
                        etype.setResourceParameters((ResourceParameters)np);
                        continue;
                    }
                    if (!(np instanceof TimeParameters)) continue;
                    etype.setTimeParameters((TimeParameters)np);
                }
                defaultScenario.getElementParameters().add((Object)etype);
            }
        }
        simDataType.getScenario().add((Object)defaultScenario);
        ExtensionAttributeValue extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
        relationship.getExtensionValues().add(extensionElement);
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)BpsimPackage.Literals.DOCUMENT_ROOT__BP_SIM_DATA, (Object)simDataType);
        ((ExtensionAttributeValue)relationship.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
        def.getRelationships().add(relationship);
    }

    public void revisitDataObjects(Definitions def) {
        List rootElements = def.getRootElements();
        ArrayList<ItemDefinition> itemDefinitionsToAddUnfiltered = new ArrayList<ItemDefinition>();
        ArrayList<ItemDefinition> itemDefinitionsToAddFiltered = new ArrayList<ItemDefinition>();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            List flowElements = process.getFlowElements();
            for (FlowElement fe : flowElements) {
                if (!(fe instanceof DataObject)) continue;
                DataObject da = (DataObject)fe;
                ItemDefinition itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                itemdef.setId("_" + da.getId() + "Item");
                for (FeatureMap.Entry entry : da.getAnyAttribute()) {
                    String typeValue;
                    if (!entry.getEStructuralFeature().getName().equals("datype") || (typeValue = (String)entry.getValue()) == null || typeValue.equals("None")) continue;
                    itemdef.setStructureRef((String)entry.getValue());
                }
                da.setItemSubjectRef(itemdef);
                itemDefinitionsToAddUnfiltered.add(itemdef);
            }
        }
        for (ItemDefinition itemDef : itemDefinitionsToAddUnfiltered) {
            boolean foundItemDef = false;
            for (RootElement ele : rootElements) {
                ItemDefinition idef;
                if (!(ele instanceof ItemDefinition) || !(idef = (ItemDefinition)ele).getId().equals(itemDef.getId())) continue;
                foundItemDef = true;
                break;
            }
            if (foundItemDef) continue;
            itemDefinitionsToAddFiltered.add(itemDef);
        }
        for (ItemDefinition itemDefFil : itemDefinitionsToAddFiltered) {
            def.getRootElements().add(itemDefFil);
        }
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            List artifactElements = process.getArtifacts();
            for (Artifact af : artifactElements) {
                SequenceFlow sf;
                DataOutputAssociation dia;
                DataInput d;
                Task task;
                DataObject da;
                if (!(af instanceof Association)) continue;
                Association as = (Association)af;
                if (as.getSourceRef() != null && as.getSourceRef() instanceof DataObject && as.getTargetRef() != null && (as.getTargetRef() instanceof Task || as.getTargetRef() instanceof ThrowEvent)) {
                    da = (DataObject)as.getSourceRef();
                    if (as.getTargetRef() instanceof Task) {
                        task = (Task)as.getTargetRef();
                        if (task.getIoSpecification() == null) {
                            InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                            task.setIoSpecification(iospec);
                        }
                        if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                            InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
                            task.getIoSpecification().getInputSets().add(inset);
                        }
                        InputSet inSet = (InputSet)task.getIoSpecification().getInputSets().get(0);
                        boolean foundDataInput = false;
                        for (DataInput dataInput : inSet.getDataInputRefs()) {
                            if (!dataInput.getId().equals(task.getId() + "_" + da.getId() + "InputX")) continue;
                            foundDataInput = true;
                        }
                        if (!foundDataInput) {
                            d = Bpmn2Factory.eINSTANCE.createDataInput();
                            d.setId(task.getId() + "_" + da.getId() + "InputX");
                            d.setName(da.getId() + "InputX");
                            task.getIoSpecification().getDataInputs().add(d);
                            ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
                            dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                            dia.setTargetRef((ItemAwareElement)d);
                            dia.getSourceRef().add(da);
                            task.getDataInputAssociations().add(dia);
                        }
                    } else if (as.getTargetRef() instanceof ThrowEvent) {
                        ThrowEvent te = (ThrowEvent)as.getTargetRef();
                        boolean foundDataInput = false;
                        List dataInputs = te.getDataInputs();
                        for (DataInput din : dataInputs) {
                            if (!din.getId().equals(te.getId() + "_" + da.getId() + "InputX")) continue;
                            foundDataInput = true;
                        }
                        if (!foundDataInput) {
                            DataInput datain = Bpmn2Factory.eINSTANCE.createDataInput();
                            datain.setId(te.getId() + "_" + da.getId() + "InputX");
                            datain.setName(da.getId() + "InputX");
                            te.getDataInputs().add(datain);
                            if (te.getInputSet() == null) {
                                InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
                                te.setInputSet(inset);
                            }
                            te.getInputSet().getDataInputRefs().add(datain);
                            DataInputAssociation dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                            dia2.setTargetRef((ItemAwareElement)datain);
                            dia2.getSourceRef().add(da);
                            te.getDataInputAssociation().add(dia2);
                        }
                    }
                }
                if (as.getTargetRef() != null && as.getTargetRef() instanceof DataObject && as.getSourceRef() != null && (as.getSourceRef() instanceof Task || as.getSourceRef() instanceof CatchEvent)) {
                    da = (DataObject)as.getTargetRef();
                    if (as.getSourceRef() instanceof Task) {
                        task = (Task)as.getSourceRef();
                        if (task.getIoSpecification() == null) {
                            InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                            task.setIoSpecification(iospec);
                        }
                        if (task.getIoSpecification().getOutputSets() == null || task.getIoSpecification().getOutputSets().size() < 1) {
                            OutputSet outSet = Bpmn2Factory.eINSTANCE.createOutputSet();
                            task.getIoSpecification().getOutputSets().add(outSet);
                        }
                        boolean foundDataOutput = false;
                        OutputSet outSet = (OutputSet)task.getIoSpecification().getOutputSets().get(0);
                        for (DataOutput dataOut : outSet.getDataOutputRefs()) {
                            if (!dataOut.getId().equals(task.getId() + "_" + da.getId() + "OutputX")) continue;
                            foundDataOutput = true;
                        }
                        if (!foundDataOutput) {
                            d = Bpmn2Factory.eINSTANCE.createDataOutput();
                            d.setId(task.getId() + "_" + da.getId() + "OutputX");
                            d.setName(da.getId() + "OutputX");
                            task.getIoSpecification().getDataOutputs().add(d);
                            ((OutputSet)task.getIoSpecification().getOutputSets().get(0)).getDataOutputRefs().add(d);
                            DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                            doa.getSourceRef().add(d);
                            doa.setTargetRef((ItemAwareElement)da);
                            task.getDataOutputAssociations().add(doa);
                        }
                    } else if (as.getSourceRef() instanceof CatchEvent) {
                        CatchEvent ce = (CatchEvent)as.getSourceRef();
                        boolean foundDataOutput = false;
                        List dataOutputs = ce.getDataOutputs();
                        for (DataOutput dout : dataOutputs) {
                            if (!dout.getId().equals(ce.getId() + "_" + da.getId() + "OutputX")) continue;
                            foundDataOutput = true;
                        }
                        if (!foundDataOutput) {
                            DataOutput dataout = Bpmn2Factory.eINSTANCE.createDataOutput();
                            dataout.setId(ce.getId() + "_" + da.getId() + "OutputX");
                            dataout.setName(da.getId() + "OutputX");
                            ce.getDataOutputs().add(dataout);
                            if (ce.getOutputSet() == null) {
                                OutputSet outset = Bpmn2Factory.eINSTANCE.createOutputSet();
                                ce.setOutputSet(outset);
                            }
                            ce.getOutputSet().getDataOutputRefs().add(dataout);
                            dia = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                            dia.setTargetRef((ItemAwareElement)da);
                            dia.getSourceRef().add(dataout);
                            ce.getDataOutputAssociation().add(dia);
                        }
                    }
                }
                if (as.getSourceRef() == null || !(as.getSourceRef() instanceof DataObject) || as.getTargetRef() == null || !(as.getTargetRef() instanceof SequenceFlow) || (sf = (SequenceFlow)as.getTargetRef()).getSourceRef() == null || !(sf.getSourceRef() instanceof Activity) || sf.getTargetRef() == null || !(sf.getTargetRef() instanceof Activity)) continue;
                Activity sourceElement = (Activity)sf.getSourceRef();
                Activity targetElement = (Activity)sf.getTargetRef();
                DataObject da2 = (DataObject)as.getSourceRef();
                if (targetElement.getIoSpecification() == null) {
                    InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                    targetElement.setIoSpecification(iospec);
                }
                if (targetElement.getIoSpecification().getInputSets() == null || targetElement.getIoSpecification().getInputSets().size() < 1) {
                    InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    targetElement.getIoSpecification().getInputSets().add(inset);
                }
                InputSet inSet = (InputSet)targetElement.getIoSpecification().getInputSets().get(0);
                boolean foundDataInput = false;
                for (DataInput dataInput : inSet.getDataInputRefs()) {
                    if (!dataInput.getId().equals(targetElement.getId() + "_" + da2.getId() + "InputX")) continue;
                    foundDataInput = true;
                }
                if (!foundDataInput) {
                    DataInput d2 = Bpmn2Factory.eINSTANCE.createDataInput();
                    d2.setId(targetElement.getId() + "_" + da2.getId() + "InputX");
                    d2.setName(da2.getId() + "InputX");
                    targetElement.getIoSpecification().getDataInputs().add(d2);
                    ((InputSet)targetElement.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d2);
                    DataInputAssociation dia3 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                    dia3.setTargetRef((ItemAwareElement)d2);
                    dia3.getSourceRef().add(da2);
                    targetElement.getDataInputAssociations().add(dia3);
                }
                if (sourceElement.getIoSpecification() == null) {
                    InputOutputSpecification iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                    sourceElement.setIoSpecification(iospec);
                }
                if (sourceElement.getIoSpecification().getOutputSets() == null || sourceElement.getIoSpecification().getOutputSets().size() < 1) {
                    OutputSet outSet = Bpmn2Factory.eINSTANCE.createOutputSet();
                    sourceElement.getIoSpecification().getOutputSets().add(outSet);
                }
                boolean foundDataOutput = false;
                OutputSet outSet = (OutputSet)sourceElement.getIoSpecification().getOutputSets().get(0);
                for (DataOutput dataOut : outSet.getDataOutputRefs()) {
                    if (!dataOut.getId().equals(sourceElement.getId() + "_" + da2.getId() + "OutputX")) continue;
                    foundDataOutput = true;
                }
                if (foundDataOutput) continue;
                DataOutput d3 = Bpmn2Factory.eINSTANCE.createDataOutput();
                d3.setId(sourceElement.getId() + "_" + da2.getId() + "OutputX");
                d3.setName(da2.getId() + "OutputX");
                sourceElement.getIoSpecification().getDataOutputs().add(d3);
                ((OutputSet)sourceElement.getIoSpecification().getOutputSets().get(0)).getDataOutputRefs().add(d3);
                DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                doa.getSourceRef().add(d3);
                doa.setTargetRef((ItemAwareElement)da2);
                sourceElement.getDataOutputAssociations().add(doa);
            }
        }
    }

    public void revisitTaskAssociations(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            List flowElements = process.getFlowElements();
            for (FlowElement fe : flowElements) {
                List outputList;
                List inputList;
                if (!(fe instanceof Task)) continue;
                Task t = (Task)fe;
                if (t.getDataInputAssociations() != null && (inputList = t.getDataInputAssociations()) != null) {
                    for (DataInputAssociation input : inputList) {
                        List sourceRef = input.getSourceRef();
                        if (sourceRef == null) continue;
                        for (ItemAwareElement iae : sourceRef) {
                            String[] iaeParts = iae.getId().split("\\.");
                            if (iaeParts.length <= 1) continue;
                        }
                    }
                }
                if (t.getDataOutputAssociations() != null && (outputList = t.getDataOutputAssociations()) != null) {
                    for (DataOutputAssociation output : outputList) {
                        String[] targetEleParts;
                        ItemAwareElement targetEle = output.getTargetRef();
                        if (targetEle != null && (targetEleParts = targetEle.getId().split("\\.")).length <= 1) continue;
                    }
                }
                if (t.getIoSpecification() == null) continue;
                InputOutputSpecification ios = t.getIoSpecification();
                if (ios.getInputSets() == null || ios.getInputSets().size() < 1) {
                    InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    ios.getInputSets().add(inset);
                }
                if (ios.getOutputSets() != null || ios.getOutputSets() != null && ios.getOutputSets().size() >= 1) continue;
                OutputSet outset = Bpmn2Factory.eINSTANCE.createOutputSet();
                ios.getOutputSets().add(outset);
            }
        }
    }

    public void revisitSendReceiveTasks(Definitions def) {
        ArrayList<Message> toAddMessages = new ArrayList<Message>();
        ArrayList<ItemDefinition> toAddItemDefinitions = new ArrayList<ItemDefinition>();
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            this.setSendReceiveTasksInfo((FlowElementsContainer)((Process)root), def, toAddMessages, toAddItemDefinitions);
        }
        for (ItemDefinition idef : toAddItemDefinitions) {
            def.getRootElements().add(idef);
        }
        for (Message msg : toAddMessages) {
            def.getRootElements().add(msg);
        }
    }

    public void setSendReceiveTasksInfo(FlowElementsContainer container, Definitions def, List<Message> toAddMessages, List<ItemDefinition> toAddItemDefinitions) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            Message msg;
            ItemDefinition idef;
            if (fe instanceof ReceiveTask) {
                ReceiveTask rt = (ReceiveTask)fe;
                idef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                msg = Bpmn2Factory.eINSTANCE.createMessage();
                for (FeatureMap.Entry entry : rt.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("msgref")) continue;
                    msg.setId((String)entry.getValue());
                    idef.setId((String)entry.getValue() + "Type");
                }
                msg.setItemRef(idef);
                rt.setMessageRef(msg);
                toAddMessages.add(msg);
                toAddItemDefinitions.add(idef);
                continue;
            }
            if (fe instanceof SendTask) {
                SendTask st = (SendTask)fe;
                idef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                msg = Bpmn2Factory.eINSTANCE.createMessage();
                for (FeatureMap.Entry entry : st.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("msgref")) continue;
                    msg.setId((String)entry.getValue());
                    idef.setId((String)entry.getValue() + "Type");
                }
                msg.setItemRef(idef);
                st.setMessageRef(msg);
                toAddMessages.add(msg);
                toAddItemDefinitions.add(idef);
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setSendReceiveTasksInfo((FlowElementsContainer)fe, def, toAddMessages, toAddItemDefinitions);
        }
    }

    public void revisitLanes(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            Process process;
            if (!(root instanceof Process) || (process = (Process)root).getLaneSets() != null && process.getLaneSets().size() >= 1 || this._lanes.size() <= 0) continue;
            LaneSet ls = Bpmn2Factory.eINSTANCE.createLaneSet();
            for (Lane lane : this._lanes) {
                ls.getLanes().add(lane);
                List laneFlowNodes = lane.getFlowNodeRefs();
                for (FlowNode fl : laneFlowNodes) {
                    process.getFlowElements().add(fl);
                }
            }
            process.getLaneSets().add(ls);
        }
    }

    public void revisitArtifacts(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            for (Artifact a : this._artifacts) {
                process.getArtifacts().add(a);
            }
        }
    }

    public void revisitGroups(Definitions def) {
        List rootElements = def.getRootElements();
        Category defaultCat = Bpmn2Factory.eINSTANCE.createCategory();
        defaultCat.setName("default");
        for (RootElement root : rootElements) {
            Process process;
            List processArtifacts;
            if (!(root instanceof Process) || (processArtifacts = (process = (Process)root).getArtifacts()) == null) continue;
            for (Artifact ar : processArtifacts) {
                if (!(ar instanceof Group)) continue;
                Group group = (Group)ar;
                for (FeatureMap.Entry entry : group.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("categoryval")) continue;
                    CategoryValue catval = Bpmn2Factory.eINSTANCE.createCategoryValue();
                    catval.setValue((String)entry.getValue());
                    defaultCat.getCategoryValue().add(catval);
                    group.setCategoryValueRef(catval);
                }
            }
        }
        if (defaultCat.getCategoryValue() != null && defaultCat.getCategoryValue().size() > 0) {
            rootElements.add(defaultCat);
        }
    }

    public void revisitThrowEvents(Definitions def) {
        List rootElements = def.getRootElements();
        ArrayList<Signal> toAddSignals = new ArrayList<Signal>();
        HashSet<Error> toAddErrors = new HashSet<Error>();
        HashSet<Escalation> toAddEscalations = new HashSet<Escalation>();
        HashSet<Message> toAddMessages = new HashSet<Message>();
        HashSet<ItemDefinition> toAddItemDefinitions = new HashSet<ItemDefinition>();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            this.setThrowEventsInfo((FlowElementsContainer)((Process)root), def, rootElements, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
        for (Lane lane : this._lanes) {
            this.setThrowEventsInfoForLanes(lane, def, rootElements, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
        for (Signal s : toAddSignals) {
            def.getRootElements().add(s);
        }
        for (Error er : toAddErrors) {
            def.getRootElements().add(er);
        }
        for (Escalation es : toAddEscalations) {
            def.getRootElements().add(es);
        }
        for (ItemDefinition idef : toAddItemDefinitions) {
            def.getRootElements().add(idef);
        }
        for (Message msg : toAddMessages) {
            def.getRootElements().add(msg);
        }
    }

    public void setThrowEventsInfo(FlowElementsContainer container, Definitions def, List<RootElement> rootElements, List<Signal> toAddSignals, Set<Error> toAddErrors, Set<Escalation> toAddEscalations, Set<Message> toAddMessages, Set<ItemDefinition> toAddItemDefinitions) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof ThrowEvent) {
                if (((ThrowEvent)fe).getEventDefinitions().size() <= 0) continue;
                EventDefinition ed = (EventDefinition)((ThrowEvent)fe).getEventDefinitions().get(0);
                if (ed instanceof SignalEventDefinition) {
                    SignalEventDefinition sed = (SignalEventDefinition)ed;
                    if (sed.getSignalRef() == null || sed.getSignalRef().length() <= 0) continue;
                    String signalRef = sed.getSignalRef();
                    boolean shouldAddSignal = true;
                    for (RootElement re : rootElements) {
                        if (!(re instanceof Signal) || !re.getId().equals(signalRef)) continue;
                        shouldAddSignal = false;
                        break;
                    }
                    if (toAddSignals != null) {
                        for (Signal s : toAddSignals) {
                            if (!s.getId().equals(signalRef)) continue;
                            shouldAddSignal = false;
                            break;
                        }
                    }
                    if (!shouldAddSignal) continue;
                    Signal signal = Bpmn2Factory.eINSTANCE.createSignal();
                    signal.setId(signalRef);
                    signal.setName(signalRef);
                    toAddSignals.add(signal);
                    continue;
                }
                if (ed instanceof ErrorEventDefinition) {
                    String errorCode = null;
                    String errorId = null;
                    for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                        if (!entry.getEStructuralFeature().getName().equals("erefname")) continue;
                        errorId = (String)entry.getValue();
                        errorCode = (String)entry.getValue();
                    }
                    Error err = this._errors.get(errorCode);
                    if (err == null) {
                        err = Bpmn2Factory.eINSTANCE.createError();
                        err.setId(errorId);
                        err.setErrorCode(errorCode);
                        this._errors.put(errorCode, err);
                    }
                    toAddErrors.add(err);
                    ((ErrorEventDefinition)ed).setErrorRef(err);
                    continue;
                }
                if (ed instanceof EscalationEventDefinition) {
                    Escalation escalation;
                    String escalationCode = null;
                    for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                        if (!entry.getEStructuralFeature().getName().equals("esccode")) continue;
                        escalationCode = (String)entry.getValue();
                        break;
                    }
                    if ((escalation = this._escalations.get(escalationCode)) == null) {
                        escalation = Bpmn2Factory.eINSTANCE.createEscalation();
                        escalation.setEscalationCode(escalationCode);
                        this._escalations.put(escalationCode, escalation);
                    }
                    toAddEscalations.add(escalation);
                    ((EscalationEventDefinition)ed).setEscalationRef(escalation);
                    continue;
                }
                if (ed instanceof MessageEventDefinition) {
                    Message msg;
                    String idefId = null;
                    String msgId = null;
                    for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                        if (!entry.getEStructuralFeature().getName().equals("msgref")) continue;
                        msgId = (String)entry.getValue();
                        idefId = (String)entry.getValue() + "Type";
                    }
                    ItemDefinition idef = this._itemDefinitions.get(idefId);
                    if (idef == null) {
                        idef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                        idef.setId(idefId);
                        this._itemDefinitions.put(idefId, idef);
                    }
                    if ((msg = this._messages.get(msgId)) == null) {
                        msg = Bpmn2Factory.eINSTANCE.createMessage();
                        msg.setId(msgId);
                        msg.setItemRef(idef);
                        this._messages.put(msgId, msg);
                    }
                    toAddMessages.add(msg);
                    toAddItemDefinitions.add(idef);
                    ((MessageEventDefinition)ed).setMessageRef(msg);
                    continue;
                }
                if (!(ed instanceof CompensateEventDefinition)) continue;
                for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("actrefname")) continue;
                    String activityNameRef = (String)entry.getValue();
                    List re = def.getRootElements();
                    for (RootElement r : re) {
                        if (!(r instanceof Process)) continue;
                        Process p = (Process)r;
                        List fes = p.getFlowElements();
                        for (FlowElement f : fes) {
                            if (!(f instanceof Activity) || !((Activity)f).getName().equals(activityNameRef)) continue;
                            ((CompensateEventDefinition)ed).setActivityRef((Activity)f);
                            ((Activity)f).setIsForCompensation(true);
                        }
                    }
                }
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setThrowEventsInfo((FlowElementsContainer)fe, def, rootElements, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
    }

    public void setThrowEventsInfoForLanes(Lane lane, Definitions def, List<RootElement> rootElements, List<Signal> toAddSignals, Set<Error> toAddErrors, Set<Escalation> toAddEscalations, Set<Message> toAddMessages, Set<ItemDefinition> toAddItemDefinitions) {
        List laneFlowNodes = lane.getFlowNodeRefs();
        for (FlowNode fe : laneFlowNodes) {
            if (fe instanceof ThrowEvent) {
                if (((ThrowEvent)fe).getEventDefinitions().size() <= 0) continue;
                EventDefinition ed = (EventDefinition)((ThrowEvent)fe).getEventDefinitions().get(0);
                if (ed instanceof SignalEventDefinition) {
                    SignalEventDefinition sed = (SignalEventDefinition)ed;
                    if (sed.getSignalRef() == null || sed.getSignalRef().length() <= 0) continue;
                    String signalRef = sed.getSignalRef();
                    boolean shouldAddSignal = true;
                    for (RootElement re : rootElements) {
                        if (!(re instanceof Signal) || !re.getId().equals(signalRef)) continue;
                        shouldAddSignal = false;
                        break;
                    }
                    if (toAddSignals != null) {
                        for (Signal s : toAddSignals) {
                            if (!s.getId().equals(signalRef)) continue;
                            shouldAddSignal = false;
                            break;
                        }
                    }
                    if (!shouldAddSignal) continue;
                    Signal signal = Bpmn2Factory.eINSTANCE.createSignal();
                    signal.setId(signalRef);
                    signal.setName(signalRef);
                    toAddSignals.add(signal);
                    continue;
                }
                if (ed instanceof ErrorEventDefinition) {
                    String errorCode = null;
                    String errorId = null;
                    for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                        if (!entry.getEStructuralFeature().getName().equals("erefname")) continue;
                        errorId = (String)entry.getValue();
                        errorCode = (String)entry.getValue();
                    }
                    Error err = this._errors.get(errorCode);
                    if (err == null) {
                        err = Bpmn2Factory.eINSTANCE.createError();
                        err.setId(errorId);
                        err.setErrorCode(errorCode);
                        this._errors.put(errorCode, err);
                    }
                    toAddErrors.add(err);
                    ((ErrorEventDefinition)ed).setErrorRef(err);
                    continue;
                }
                if (ed instanceof EscalationEventDefinition) {
                    Escalation escalation;
                    String escalationCode = null;
                    for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                        if (!entry.getEStructuralFeature().getName().equals("esccode")) continue;
                        escalationCode = (String)entry.getValue();
                        break;
                    }
                    if ((escalation = this._escalations.get(escalationCode)) == null) {
                        escalation = Bpmn2Factory.eINSTANCE.createEscalation();
                        escalation.setEscalationCode(escalationCode);
                        this._escalations.put(escalationCode, escalation);
                    }
                    toAddEscalations.add(escalation);
                    ((EscalationEventDefinition)ed).setEscalationRef(escalation);
                    continue;
                }
                if (ed instanceof MessageEventDefinition) {
                    Message msg;
                    String idefId = null;
                    String msgId = null;
                    for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                        if (!entry.getEStructuralFeature().getName().equals("msgref")) continue;
                        msgId = (String)entry.getValue();
                        idefId = (String)entry.getValue() + "Type";
                    }
                    ItemDefinition idef = this._itemDefinitions.get(idefId);
                    if (idef == null) {
                        idef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                        idef.setId(idefId);
                        this._itemDefinitions.put(idefId, idef);
                    }
                    if ((msg = this._messages.get(msgId)) == null) {
                        msg = Bpmn2Factory.eINSTANCE.createMessage();
                        msg.setId(msgId);
                        msg.setItemRef(idef);
                        this._messages.put(msgId, msg);
                    }
                    toAddMessages.add(msg);
                    toAddItemDefinitions.add(idef);
                    ((MessageEventDefinition)ed).setMessageRef(msg);
                    continue;
                }
                if (!(ed instanceof CompensateEventDefinition)) continue;
                for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("actrefname")) continue;
                    String activityNameRef = (String)entry.getValue();
                    List re = def.getRootElements();
                    for (RootElement r : re) {
                        if (!(r instanceof Process)) continue;
                        Process p = (Process)r;
                        List fes = p.getFlowElements();
                        for (FlowElement f : fes) {
                            if (!(f instanceof Activity) || !((Activity)f).getName().equals(activityNameRef)) continue;
                            ((CompensateEventDefinition)ed).setActivityRef((Activity)f);
                            ((Activity)f).setIsForCompensation(true);
                        }
                    }
                }
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setThrowEventsInfo((FlowElementsContainer)fe, def, rootElements, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
    }

    private void revisitCatchEventsConvertToBoundary(Definitions def) {
        ArrayList<CatchEvent> catchEventsToRemove = new ArrayList<CatchEvent>();
        HashMap<BoundaryEvent, List<String>> boundaryEventsToAdd = new HashMap<BoundaryEvent, List<String>>();
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            this.revisitCatchEVentsConvertToBoundaryExecute((FlowElementsContainer)process, catchEventsToRemove, boundaryEventsToAdd);
        }
        this.reconnectFlows();
    }

    private void revisitCatchEVentsConvertToBoundaryExecute(FlowElementsContainer container, List<CatchEvent> catchEventsToRemove, Map<BoundaryEvent, List<String>> boundaryEventsToAdd) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof CatchEvent) {
                CatchEvent ce = (CatchEvent)fe;
                EventDefinition ed = null;
                if (ce.getEventDefinitions() != null && ce.getEventDefinitions().size() > 0) {
                    ed = (EventDefinition)ce.getEventDefinitions().get(0);
                }
                for (Map.Entry<Object, List<String>> entry : this._outgoingFlows.entrySet()) {
                    for (String flowId : entry.getValue()) {
                        if (!(entry.getKey() instanceof Activity) || !flowId.equals(ce.getId())) continue;
                        BoundaryEvent be = Bpmn2Factory.eINSTANCE.createBoundaryEvent();
                        if (ed != null && ed instanceof ErrorEventDefinition) {
                            be.setCancelActivity(true);
                        } else {
                            for (FeatureMap.Entry entry2 : ce.getAnyAttribute()) {
                                if (!entry2.getEStructuralFeature().getName().equals("boundaryca")) continue;
                                String boundaryceVal = (String)entry2.getValue();
                                be.setCancelActivity(Boolean.parseBoolean(boundaryceVal));
                            }
                        }
                        if (ce.getDataOutputs() != null) {
                            be.getDataOutputs().addAll(ce.getDataOutputs());
                        }
                        if (ce.getDataOutputAssociation() != null) {
                            be.getDataOutputAssociation().addAll(ce.getDataOutputAssociation());
                        }
                        if (ce.getOutputSet() != null) {
                            be.setOutputSet(ce.getOutputSet());
                        }
                        if (ce.getEventDefinitions() != null) {
                            be.getEventDefinitions().addAll(ce.getEventDefinitions());
                        }
                        if (ce.getEventDefinitionRefs() != null) {
                            be.getEventDefinitionRefs().addAll(ce.getEventDefinitionRefs());
                        }
                        if (ce.getProperties() != null) {
                            be.getProperties().addAll(ce.getProperties());
                        }
                        if (ce.getAnyAttribute() != null) {
                            be.getAnyAttribute().addAll((Collection)ce.getAnyAttribute());
                        }
                        if (ce.getOutgoing() != null) {
                            be.getOutgoing().addAll(ce.getOutgoing());
                        }
                        if (ce.getIncoming() != null) {
                            be.getIncoming().addAll(ce.getIncoming());
                        }
                        if (ce.getProperties() != null) {
                            be.getProperties().addAll(ce.getProperties());
                        }
                        be.setName(ce.getName());
                        be.setId(ce.getId());
                        be.setAttachedToRef((Activity)entry.getKey());
                        ((Activity)entry.getKey()).getBoundaryEventRefs().add(be);
                        catchEventsToRemove.add(ce);
                        boundaryEventsToAdd.put(be, this._outgoingFlows.get(ce));
                    }
                }
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.revisitCatchEVentsConvertToBoundaryExecute((FlowElementsContainer)fe, catchEventsToRemove, boundaryEventsToAdd);
        }
        if (catchEventsToRemove.size() > 0) {
            for (CatchEvent ce : catchEventsToRemove) {
                boolean removed = container.getFlowElements().remove(ce);
                this._outgoingFlows.remove(ce);
            }
        }
        if (boundaryEventsToAdd.size() > 0) {
            for (BoundaryEvent bToAdd : boundaryEventsToAdd.keySet()) {
                container.getFlowElements().add(bToAdd);
                this._outgoingFlows.put(bToAdd, boundaryEventsToAdd.get(bToAdd));
            }
        }
    }

    public void revisitAssociationsIoSpec(Definitions def) {
        List rootElements = def.getRootElements();
        ArrayList<ItemDefinition> toAddItemDefinitions = new ArrayList<ItemDefinition>();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            this.setItemDefinitionsForActivitiesIoSpec((FlowElementsContainer)((Process)root), def, toAddItemDefinitions);
        }
        for (ItemDefinition itemDef : toAddItemDefinitions) {
            def.getRootElements().add(itemDef);
        }
    }

    public void setItemDefinitionsForActivitiesIoSpec(FlowElementsContainer container, Definitions def, List<ItemDefinition> toAddItemDefinitions) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof Activity) {
                ItemDefinition itemdef;
                Activity ac = (Activity)fe;
                if (ac.getIoSpecification() == null) continue;
                if (ac.getIoSpecification().getDataInputs() != null) {
                    List dataInputs = ac.getIoSpecification().getDataInputs();
                    for (DataInput din : dataInputs) {
                        for (FeatureMap.Entry entry : din.getAnyAttribute()) {
                            String dinType;
                            if (!entry.getEStructuralFeature().getName().equals("dtype") || (dinType = (String)entry.getValue()) == null || dinType.length() <= 0) continue;
                            itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                            itemdef.setId("_" + din.getId() + "Item");
                            itemdef.setStructureRef(dinType);
                            toAddItemDefinitions.add(itemdef);
                            din.setItemSubjectRef(itemdef);
                        }
                    }
                }
                if (ac.getIoSpecification().getDataOutputs() == null) continue;
                List dataOutputs = ac.getIoSpecification().getDataOutputs();
                for (DataOutput dout : dataOutputs) {
                    for (FeatureMap.Entry entry : dout.getAnyAttribute()) {
                        String doutType;
                        if (!entry.getEStructuralFeature().getName().equals("dtype") || (doutType = (String)entry.getValue()) == null || doutType.length() <= 0) continue;
                        itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                        itemdef.setId("_" + dout.getId() + "Item");
                        itemdef.setStructureRef(doutType);
                        toAddItemDefinitions.add(itemdef);
                        dout.setItemSubjectRef(itemdef);
                    }
                }
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setItemDefinitionsForActivitiesIoSpec((FlowElementsContainer)fe, def, toAddItemDefinitions);
        }
    }

    public void revisitCatchEvents(Definitions def) {
        List rootElements = def.getRootElements();
        ArrayList<Signal> toAddSignals = new ArrayList<Signal>();
        HashSet<Error> toAddErrors = new HashSet<Error>();
        HashSet<Escalation> toAddEscalations = new HashSet<Escalation>();
        HashSet<Message> toAddMessages = new HashSet<Message>();
        HashSet<ItemDefinition> toAddItemDefinitions = new HashSet<ItemDefinition>();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            this.setCatchEventsInfo((FlowElementsContainer)((Process)root), def, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
        for (Lane lane : this._lanes) {
            this.setCatchEventsInfoForLanes(lane, def, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
        for (Signal s : toAddSignals) {
            def.getRootElements().add(s);
        }
        for (Error er : toAddErrors) {
            def.getRootElements().add(er);
        }
        for (Escalation es : toAddEscalations) {
            def.getRootElements().add(es);
        }
        for (ItemDefinition idef : toAddItemDefinitions) {
            def.getRootElements().add(idef);
        }
        for (Message msg : toAddMessages) {
            def.getRootElements().add(msg);
        }
    }

    public void setCatchEventsInfo(FlowElementsContainer container, Definitions def, List<Signal> toAddSignals, Set<Error> toAddErrors, Set<Escalation> toAddEscalations, Set<Message> toAddMessages, Set<ItemDefinition> toAddItemDefinitions) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof CatchEvent) {
                if (((CatchEvent)fe).getEventDefinitions().size() <= 0) continue;
                EventDefinition ed = (EventDefinition)((CatchEvent)fe).getEventDefinitions().get(0);
                if (ed instanceof SignalEventDefinition) {
                    SignalEventDefinition sed = (SignalEventDefinition)ed;
                    if (sed.getSignalRef() == null || sed.getSignalRef().length() <= 0) continue;
                    String signalRef = sed.getSignalRef();
                    boolean shouldAddSignal = true;
                    List rootElements = def.getRootElements();
                    for (RootElement re : rootElements) {
                        if (!(re instanceof Signal) || !re.getId().equals(signalRef)) continue;
                        shouldAddSignal = false;
                        break;
                    }
                    if (toAddSignals != null) {
                        for (Signal s : toAddSignals) {
                            if (!s.getId().equals(signalRef)) continue;
                            shouldAddSignal = false;
                            break;
                        }
                    }
                    if (!shouldAddSignal) continue;
                    Signal signal = Bpmn2Factory.eINSTANCE.createSignal();
                    signal.setId(signalRef);
                    signal.setName(signalRef);
                    toAddSignals.add(signal);
                    continue;
                }
                if (ed instanceof ErrorEventDefinition) {
                    String errorCode = null;
                    String errorId = null;
                    for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                        if (!entry.getEStructuralFeature().getName().equals("erefname")) continue;
                        errorId = (String)entry.getValue();
                        errorCode = (String)entry.getValue();
                    }
                    Error err = this._errors.get(errorCode);
                    if (err == null) {
                        err = Bpmn2Factory.eINSTANCE.createError();
                        err.setId(errorId);
                        err.setErrorCode(errorCode);
                        this._errors.put(errorCode, err);
                    }
                    toAddErrors.add(err);
                    ((ErrorEventDefinition)ed).setErrorRef(err);
                    continue;
                }
                if (ed instanceof EscalationEventDefinition) {
                    Escalation escalation;
                    String escalationCode = null;
                    for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                        if (!entry.getEStructuralFeature().getName().equals("esccode")) continue;
                        escalationCode = (String)entry.getValue();
                        break;
                    }
                    if ((escalation = this._escalations.get(escalationCode)) == null) {
                        escalation = Bpmn2Factory.eINSTANCE.createEscalation();
                        escalation.setEscalationCode(escalationCode);
                        this._escalations.put(escalationCode, escalation);
                    }
                    toAddEscalations.add(escalation);
                    ((EscalationEventDefinition)ed).setEscalationRef(escalation);
                    continue;
                }
                if (ed instanceof MessageEventDefinition) {
                    Message msg;
                    String idefId = null;
                    String msgId = null;
                    for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                        if (!entry.getEStructuralFeature().getName().equals("msgref")) continue;
                        msgId = (String)entry.getValue();
                        idefId = (String)entry.getValue() + "Type";
                    }
                    ItemDefinition idef = this._itemDefinitions.get(idefId);
                    if (idef == null) {
                        idef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                        idef.setId(idefId);
                        this._itemDefinitions.put(idefId, idef);
                    }
                    if ((msg = this._messages.get(msgId)) == null) {
                        msg = Bpmn2Factory.eINSTANCE.createMessage();
                        msg.setId(msgId);
                        msg.setItemRef(idef);
                        this._messages.put(msgId, msg);
                    }
                    toAddMessages.add(msg);
                    toAddItemDefinitions.add(idef);
                    ((MessageEventDefinition)ed).setMessageRef(msg);
                    continue;
                }
                if (!(ed instanceof CompensateEventDefinition)) continue;
                for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("actrefname")) continue;
                    String activityNameRef = (String)entry.getValue();
                    List re = def.getRootElements();
                    for (RootElement r : re) {
                        if (!(r instanceof Process)) continue;
                        Process p = (Process)r;
                        List fes = p.getFlowElements();
                        for (FlowElement f : fes) {
                            if (!(f instanceof Activity) || !((Activity)f).getName().equals(activityNameRef)) continue;
                            ((CompensateEventDefinition)ed).setActivityRef((Activity)f);
                            ((Activity)f).setIsForCompensation(true);
                        }
                    }
                }
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setCatchEventsInfo((FlowElementsContainer)fe, def, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
    }

    public void setCatchEventsInfoForLanes(Lane lane, Definitions def, List<Signal> toAddSignals, Set<Error> toAddErrors, Set<Escalation> toAddEscalations, Set<Message> toAddMessages, Set<ItemDefinition> toAddItemDefinitions) {
        List laneFlowNodes = lane.getFlowNodeRefs();
        for (FlowNode fe : laneFlowNodes) {
            if (fe instanceof CatchEvent) {
                if (((CatchEvent)fe).getEventDefinitions().size() <= 0) continue;
                EventDefinition ed = (EventDefinition)((CatchEvent)fe).getEventDefinitions().get(0);
                if (ed instanceof SignalEventDefinition) {
                    SignalEventDefinition sed = (SignalEventDefinition)ed;
                    if (sed.getSignalRef() == null || sed.getSignalRef().length() <= 0) continue;
                    String signalRef = sed.getSignalRef();
                    boolean shouldAddSignal = true;
                    List rootElements = def.getRootElements();
                    for (RootElement re : rootElements) {
                        if (!(re instanceof Signal) || !re.getId().equals(signalRef)) continue;
                        shouldAddSignal = false;
                        break;
                    }
                    if (toAddSignals != null) {
                        for (Signal s : toAddSignals) {
                            if (!s.getId().equals(signalRef)) continue;
                            shouldAddSignal = false;
                            break;
                        }
                    }
                    if (!shouldAddSignal) continue;
                    Signal signal = Bpmn2Factory.eINSTANCE.createSignal();
                    signal.setId(signalRef);
                    signal.setName(signalRef);
                    toAddSignals.add(signal);
                    continue;
                }
                if (ed instanceof ErrorEventDefinition) {
                    String errorCode = null;
                    String errorId = null;
                    for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                        if (!entry.getEStructuralFeature().getName().equals("erefname")) continue;
                        errorId = (String)entry.getValue();
                        errorCode = (String)entry.getValue();
                    }
                    Error err = this._errors.get(errorCode);
                    if (err == null) {
                        err = Bpmn2Factory.eINSTANCE.createError();
                        err.setId(errorId);
                        err.setErrorCode(errorCode);
                        this._errors.put(errorCode, err);
                    }
                    toAddErrors.add(err);
                    ((ErrorEventDefinition)ed).setErrorRef(err);
                    continue;
                }
                if (ed instanceof EscalationEventDefinition) {
                    Escalation escalation;
                    String escalationCode = null;
                    for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                        if (!entry.getEStructuralFeature().getName().equals("esccode")) continue;
                        escalationCode = (String)entry.getValue();
                        break;
                    }
                    if ((escalation = this._escalations.get(escalationCode)) == null) {
                        escalation = Bpmn2Factory.eINSTANCE.createEscalation();
                        escalation.setEscalationCode(escalationCode);
                        this._escalations.put(escalationCode, escalation);
                    }
                    toAddEscalations.add(escalation);
                    ((EscalationEventDefinition)ed).setEscalationRef(escalation);
                    continue;
                }
                if (ed instanceof MessageEventDefinition) {
                    Message msg;
                    String idefId = null;
                    String msgId = null;
                    for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                        if (!entry.getEStructuralFeature().getName().equals("msgref")) continue;
                        msgId = (String)entry.getValue();
                        idefId = (String)entry.getValue() + "Type";
                    }
                    ItemDefinition idef = this._itemDefinitions.get(idefId);
                    if (idef == null) {
                        idef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                        idef.setId(idefId);
                        this._itemDefinitions.put(idefId, idef);
                    }
                    if ((msg = this._messages.get(msgId)) == null) {
                        msg = Bpmn2Factory.eINSTANCE.createMessage();
                        msg.setId(msgId);
                        msg.setItemRef(idef);
                        this._messages.put(msgId, msg);
                    }
                    toAddMessages.add(msg);
                    toAddItemDefinitions.add(idef);
                    ((MessageEventDefinition)ed).setMessageRef(msg);
                    continue;
                }
                if (!(ed instanceof CompensateEventDefinition)) continue;
                for (FeatureMap.Entry entry : ed.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("actrefname")) continue;
                    String activityNameRef = (String)entry.getValue();
                    List re = def.getRootElements();
                    for (RootElement r : re) {
                        if (!(r instanceof Process)) continue;
                        Process p = (Process)r;
                        List fes = p.getFlowElements();
                        for (FlowElement f : fes) {
                            if (!(f instanceof Activity) || !((Activity)f).getName().equals(activityNameRef)) continue;
                            ((CompensateEventDefinition)ed).setActivityRef((Activity)f);
                            ((Activity)f).setIsForCompensation(true);
                        }
                    }
                }
                continue;
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setCatchEventsInfo((FlowElementsContainer)fe, def, toAddSignals, toAddErrors, toAddEscalations, toAddMessages, toAddItemDefinitions);
        }
    }

    private void revisitGateways(Definitions def) {
        List rootElements = def.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            this.setGatewayInfo((FlowElementsContainer)((Process)root));
        }
    }

    private void setGatewayInfo(FlowElementsContainer container) {
        List flowElements = container.getFlowElements();
        for (FlowElement fe : flowElements) {
            FormalExpression expr;
            SequenceFlow sf;
            String[] entryValueParts;
            String entryValueId;
            String entryValue;
            if (fe instanceof Gateway) {
                int outgoing;
                Gateway gateway = (Gateway)fe;
                int incoming = gateway.getIncoming() == null ? 0 : gateway.getIncoming().size();
                int n = outgoing = gateway.getOutgoing() == null ? 0 : gateway.getOutgoing().size();
                if (incoming <= 1 && outgoing > 1) {
                    gateway.setGatewayDirection(GatewayDirection.DIVERGING);
                } else if (incoming > 1 && outgoing <= 1) {
                    gateway.setGatewayDirection(GatewayDirection.CONVERGING);
                } else {
                    gateway.setGatewayDirection(GatewayDirection.UNSPECIFIED);
                }
            }
            if (fe instanceof InclusiveGateway) {
                for (FeatureMap.Entry entry : fe.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("dg")) continue;
                    for (FlowElement feg : flowElements) {
                        entryValue = (String)entry.getValue();
                        entryValueId = "";
                        entryValueParts = entryValue.split(" : ");
                        if (entryValueParts.length == 1) {
                            entryValueId = entryValueParts[0];
                        } else if (entryValueParts.length > 1) {
                            entryValueId = entryValueParts[1];
                        }
                        if (!(feg instanceof SequenceFlow) || !feg.getId().equals(entryValueId)) continue;
                        sf = (SequenceFlow)feg;
                        ((InclusiveGateway)fe).setDefault(sf);
                        if (sf.getConditionExpression() != null) continue;
                        expr = Bpmn2Factory.eINSTANCE.createFormalExpression();
                        expr.setBody("");
                        sf.setConditionExpression((Expression)expr);
                    }
                }
            }
            if (fe instanceof ExclusiveGateway) {
                for (FeatureMap.Entry entry : fe.getAnyAttribute()) {
                    if (!entry.getEStructuralFeature().getName().equals("dg")) continue;
                    for (FlowElement feg : flowElements) {
                        entryValue = (String)entry.getValue();
                        entryValueId = "";
                        entryValueParts = entryValue.split(" : ");
                        if (entryValueParts.length == 1) {
                            entryValueId = entryValueParts[0];
                        } else if (entryValueParts.length > 1) {
                            entryValueId = entryValueParts[1];
                        }
                        if (!(feg instanceof SequenceFlow) || !feg.getId().equals(entryValueId)) continue;
                        sf = (SequenceFlow)feg;
                        ((ExclusiveGateway)fe).setDefault(sf);
                        if (sf.getConditionExpression() != null) continue;
                        expr = Bpmn2Factory.eINSTANCE.createFormalExpression();
                        expr.setBody("");
                        sf.setConditionExpression((Expression)expr);
                    }
                }
            }
            if (!(fe instanceof FlowElementsContainer)) continue;
            this.setGatewayInfo((FlowElementsContainer)fe);
        }
    }

    private void revisitServiceTasks(Definitions def) {
        List rootElements = def.getRootElements();
        ArrayList<Interface> toAddInterfaces = new ArrayList<Interface>();
        ArrayList<Message> toAddMessages = new ArrayList<Message>();
        ArrayList<ItemDefinition> toAddDefinitions = new ArrayList<ItemDefinition>();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            List flowElements = process.getFlowElements();
            for (FlowElement fe : flowElements) {
                if (!(fe instanceof ServiceTask)) continue;
                Iterator iter = fe.getAnyAttribute().iterator();
                String serviceImplementation = null;
                String serviceInterface = null;
                String serviceOperation = null;
                EStructuralFeature serviceInterfaceFeature = null;
                EStructuralFeature serviceOperationFeature = null;
                while (iter.hasNext()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
                    if (entry.getEStructuralFeature().getName().equals("serviceimplementation")) {
                        serviceImplementation = (String)entry.getValue();
                    }
                    if (entry.getEStructuralFeature().getName().equals("serviceoperation")) {
                        serviceOperation = (String)entry.getValue();
                        serviceOperationFeature = entry.getEStructuralFeature();
                    }
                    if (!entry.getEStructuralFeature().getName().equals("serviceinterface")) continue;
                    serviceInterface = (String)entry.getValue();
                    serviceInterfaceFeature = entry.getEStructuralFeature();
                }
                boolean foundInterface = false;
                Interface touseInterface = null;
                if (serviceImplementation != null && serviceImplementation.equals("Java")) {
                    for (RootElement iroot : rootElements) {
                        if (!(iroot instanceof Interface) || !((Interface)iroot).getName().equals(serviceInterface)) continue;
                        foundInterface = true;
                        touseInterface = (Interface)iroot;
                        break;
                    }
                    if (!foundInterface) {
                        for (Interface toadd : toAddInterfaces) {
                            if (toadd.getName() == null || !toadd.getName().equals(serviceInterface)) continue;
                            foundInterface = true;
                            touseInterface = toadd;
                            break;
                        }
                    }
                } else if (serviceImplementation != null && serviceImplementation.equals("##WebService")) {
                    for (RootElement iroot : rootElements) {
                        if (!(iroot instanceof Interface) || !((Interface)iroot).getImplementationRef().equals(serviceInterface)) continue;
                        foundInterface = true;
                        touseInterface = (Interface)iroot;
                        break;
                    }
                    if (!foundInterface) {
                        for (Interface toadd : toAddInterfaces) {
                            if (!toadd.getImplementationRef().equals(serviceInterface)) continue;
                            foundInterface = true;
                            touseInterface = toadd;
                            break;
                        }
                    }
                }
                if (!foundInterface) {
                    touseInterface = Bpmn2Factory.eINSTANCE.createInterface();
                    if (serviceInterface == null || serviceInterface.length() == 0) {
                        serviceInterface = fe.getId() + "_ServiceInterface";
                        if (serviceInterfaceFeature != null) {
                            fe.getAnyAttribute().set(serviceInterfaceFeature, (Object)serviceInterface);
                        }
                    }
                    touseInterface.setName(serviceInterface);
                    touseInterface.setImplementationRef(serviceInterface);
                    touseInterface.setId(fe.getId() + "_ServiceInterface");
                    toAddInterfaces.add(touseInterface);
                }
                if (serviceOperation == null) continue;
                boolean foundOperation = false;
                for (Operation oper : touseInterface.getOperations()) {
                    if (serviceImplementation != null && serviceImplementation.equals("Java")) {
                        if (!oper.getName().equals(serviceOperation)) continue;
                        foundOperation = true;
                        break;
                    }
                    if (serviceImplementation == null || !serviceImplementation.equals("##WebService") || !oper.getImplementationRef().equals(serviceOperation)) continue;
                    foundOperation = true;
                    break;
                }
                if (foundOperation) continue;
                Operation touseOperation = Bpmn2Factory.eINSTANCE.createOperation();
                if (serviceOperation == null || serviceOperation.length() == 0) {
                    serviceOperation = fe.getId() + "_ServiceOperation";
                    if (serviceOperationFeature != null) {
                        fe.getAnyAttribute().set(serviceOperationFeature, (Object)serviceOperation);
                    }
                }
                touseOperation.setId(fe.getId() + "_ServiceOperation");
                touseOperation.setName(serviceOperation);
                touseOperation.setImplementationRef(serviceOperation);
                Message message = Bpmn2Factory.eINSTANCE.createMessage();
                message.setId(fe.getId() + "_InMessage");
                ItemDefinition itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                itemdef.setId(message.getId() + "Type");
                message.setItemRef(itemdef);
                toAddDefinitions.add(itemdef);
                toAddMessages.add(message);
                touseOperation.setInMessageRef(message);
                touseInterface.getOperations().add(touseOperation);
                ((ServiceTask)fe).setOperationRef(touseOperation);
            }
        }
        for (ItemDefinition id : toAddDefinitions) {
            def.getRootElements().add(id);
        }
        for (Message m : toAddMessages) {
            def.getRootElements().add(m);
        }
        for (Interface i : toAddInterfaces) {
            def.getRootElements().add(i);
        }
    }

    private void revisitMessages(Definitions def) {
        List rootElements = def.getRootElements();
        ArrayList<ItemDefinition> toAddDefinitions = new ArrayList<ItemDefinition>();
        for (RootElement root : rootElements) {
            if (!(root instanceof Message) || this.existsMessageItemDefinition(rootElements, root.getId())) continue;
            ItemDefinition itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
            itemdef.setId(root.getId() + "Type");
            toAddDefinitions.add(itemdef);
            ((Message)root).setItemRef(itemdef);
        }
        for (ItemDefinition id : toAddDefinitions) {
            def.getRootElements().add(id);
        }
    }

    private boolean existsMessageItemDefinition(List<RootElement> rootElements, String id) {
        for (RootElement root : rootElements) {
            if (!(root instanceof ItemDefinition) || !root.getId().equals(id + "Type")) continue;
            return true;
        }
        return false;
    }

    private void reconnectFlows() {
        for (Map.Entry<Object, List<String>> entry : this._outgoingFlows.entrySet()) {
            for (String flowId : entry.getValue()) {
                if (entry.getKey() instanceof SequenceFlow) {
                    if (this._idMap.get(flowId) instanceof FlowNode) {
                        ((SequenceFlow)entry.getKey()).setTargetRef((FlowNode)this._idMap.get(flowId));
                    }
                    if (!(this._idMap.get(flowId) instanceof Association)) continue;
                    ((Association)this._idMap.get(flowId)).setTargetRef((BaseElement)((SequenceFlow)entry.getKey()));
                    continue;
                }
                if (entry.getKey() instanceof Association) {
                    ((Association)entry.getKey()).setTargetRef((BaseElement)this._idMap.get(flowId));
                    continue;
                }
                if (this._idMap.get(flowId) instanceof SequenceFlow) {
                    ((FlowNode)entry.getKey()).getOutgoing().add((SequenceFlow)this._idMap.get(flowId));
                    continue;
                }
                if (!(this._idMap.get(flowId) instanceof Association)) continue;
                ((Association)this._idMap.get(flowId)).setSourceRef((BaseElement)entry.getKey());
            }
        }
    }

    private void createSubProcessDiagram(BPMNPlane plane, FlowElement flowElement, BpmnDiFactory factory) {
        SubProcess sp = (SubProcess)flowElement;
        for (FlowElement subProcessFlowElement : sp.getFlowElements()) {
            BPMNShape shape;
            Bounds spb;
            if (subProcessFlowElement instanceof SubProcess) {
                spb = this._bounds.get(subProcessFlowElement.getId());
                if (spb != null) {
                    shape = factory.createBPMNShape();
                    shape.setBpmnElement((BaseElement)subProcessFlowElement);
                    shape.setBounds(spb);
                    plane.getPlaneElement().add(shape);
                }
                this.createSubProcessDiagram(plane, subProcessFlowElement, factory);
                continue;
            }
            if (subProcessFlowElement instanceof FlowNode) {
                spb = this._bounds.get(subProcessFlowElement.getId());
                if (spb == null) continue;
                shape = factory.createBPMNShape();
                shape.setBpmnElement((BaseElement)subProcessFlowElement);
                shape.setBounds(spb);
                plane.getPlaneElement().add(shape);
                continue;
            }
            if (!(subProcessFlowElement instanceof SequenceFlow)) continue;
            SequenceFlow sequenceFlow = (SequenceFlow)subProcessFlowElement;
            BPMNEdge edge = factory.createBPMNEdge();
            edge.setBpmnElement((BaseElement)subProcessFlowElement);
            DcFactory dcFactory = DcFactory.eINSTANCE;
            Point point = dcFactory.createPoint();
            if (sequenceFlow.getSourceRef() != null) {
                Bounds sourceBounds = this._bounds.get(sequenceFlow.getSourceRef().getId());
                point.setX(sourceBounds.getX() + sourceBounds.getWidth() / 2.0f);
                point.setY(sourceBounds.getY() + sourceBounds.getHeight() / 2.0f);
            }
            edge.getWaypoint().add(point);
            List<Point> dockers = this._dockers.get(sequenceFlow.getId());
            for (int i = 1; i < dockers.size() - 1; ++i) {
                edge.getWaypoint().add(dockers.get(i));
            }
            point = dcFactory.createPoint();
            if (sequenceFlow.getTargetRef() != null) {
                Bounds targetBounds = this._bounds.get(sequenceFlow.getTargetRef().getId());
                point.setX(targetBounds.getX() + targetBounds.getWidth() / 2.0f);
                point.setY(targetBounds.getY() + targetBounds.getHeight() / 2.0f);
            }
            edge.getWaypoint().add(point);
            plane.getPlaneElement().add(edge);
        }
        if (sp.getArtifacts() != null) {
            ArrayList<Association> incompleteAssociations = new ArrayList<Association>();
            for (Artifact artifact : sp.getArtifacts()) {
                Bounds ba;
                if ((artifact instanceof TextAnnotation || artifact instanceof Group) && (ba = this._bounds.get(artifact.getId())) != null) {
                    BPMNShape shape = factory.createBPMNShape();
                    shape.setBpmnElement((BaseElement)artifact);
                    shape.setBounds(ba);
                    plane.getPlaneElement().add(shape);
                }
                if (!(artifact instanceof Association)) continue;
                Association association = (Association)artifact;
                if (association.getSourceRef() != null && association.getTargetRef() != null) {
                    BPMNEdge edge = factory.createBPMNEdge();
                    edge.setBpmnElement((BaseElement)association);
                    DcFactory dcFactory = DcFactory.eINSTANCE;
                    Point point = dcFactory.createPoint();
                    Bounds sourceBounds = this._bounds.get(association.getSourceRef().getId());
                    point.setX(sourceBounds.getX() + sourceBounds.getWidth() / 2.0f);
                    point.setY(sourceBounds.getY() + sourceBounds.getHeight() / 2.0f);
                    edge.getWaypoint().add(point);
                    List<Point> dockers = this._dockers.get(association.getId());
                    for (int i = 1; i < dockers.size() - 1; ++i) {
                        edge.getWaypoint().add(dockers.get(i));
                    }
                    point = dcFactory.createPoint();
                    Bounds targetBounds = this._bounds.get(association.getTargetRef().getId());
                    point.setX(targetBounds.getX() + targetBounds.getWidth() / 2.0f);
                    point.setY(targetBounds.getY() + targetBounds.getHeight() / 2.0f);
                    edge.getWaypoint().add(point);
                    plane.getPlaneElement().add(edge);
                    continue;
                }
                incompleteAssociations.add(association);
            }
            if (!incompleteAssociations.isEmpty()) {
                for (Association incompleteAssociation : incompleteAssociations) {
                    sp.getArtifacts().remove(incompleteAssociation);
                }
            }
        }
    }

    private void createDiagram(Definitions def) {
        for (RootElement rootElement : def.getRootElements()) {
            BPMNEdge edge;
            if (!(rootElement instanceof Process)) continue;
            Process process = (Process)rootElement;
            BpmnDiFactory factory = BpmnDiFactory.eINSTANCE;
            BPMNDiagram diagram = factory.createBPMNDiagram();
            BPMNPlane plane = factory.createBPMNPlane();
            plane.setBpmnElement((BaseElement)process);
            diagram.setPlane(plane);
            for (FlowElement flowElement : process.getFlowElements()) {
                BPMNShape shape;
                Bounds b;
                if (flowElement instanceof FlowNode) {
                    b = this._bounds.get(flowElement.getId());
                    if (b != null) {
                        shape = factory.createBPMNShape();
                        shape.setBpmnElement((BaseElement)flowElement);
                        shape.setBounds(b);
                        plane.getPlaneElement().add(shape);
                        if (flowElement instanceof BoundaryEvent) {
                            edge = factory.createBPMNEdge();
                            edge.setBpmnElement((BaseElement)flowElement);
                            List<Point> dockers = this._dockers.get(flowElement.getId());
                            DcFactory dcFactory = DcFactory.eINSTANCE;
                            Point addedDocker = dcFactory.createPoint();
                            for (int i = 0; i < dockers.size(); ++i) {
                                edge.getWaypoint().add(dockers.get(i));
                                if (i != 0) continue;
                                addedDocker.setX(dockers.get(i).getX());
                                addedDocker.setY(dockers.get(i).getY());
                            }
                            if (dockers.size() == 1) {
                                edge.getWaypoint().add(addedDocker);
                            }
                            plane.getPlaneElement().add(edge);
                        }
                    }
                    if (!(flowElement instanceof SubProcess)) continue;
                    this.createSubProcessDiagram(plane, flowElement, factory);
                    continue;
                }
                if (flowElement instanceof DataObject) {
                    b = this._bounds.get(flowElement.getId());
                    if (b == null) continue;
                    shape = factory.createBPMNShape();
                    shape.setBpmnElement((BaseElement)flowElement);
                    shape.setBounds(b);
                    plane.getPlaneElement().add(shape);
                    continue;
                }
                if (!(flowElement instanceof SequenceFlow)) continue;
                SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
                BPMNEdge edge2 = factory.createBPMNEdge();
                edge2.setBpmnElement((BaseElement)flowElement);
                DcFactory dcFactory = DcFactory.eINSTANCE;
                Point point = dcFactory.createPoint();
                if (sequenceFlow.getSourceRef() != null) {
                    Bounds sourceBounds = this._bounds.get(sequenceFlow.getSourceRef().getId());
                    point.setX(sourceBounds.getX() + sourceBounds.getWidth() / 2.0f);
                    point.setY(sourceBounds.getY() + sourceBounds.getHeight() / 2.0f);
                }
                edge2.getWaypoint().add(point);
                List<Point> dockers = this._dockers.get(sequenceFlow.getId());
                for (int i = 1; i < dockers.size() - 1; ++i) {
                    edge2.getWaypoint().add(dockers.get(i));
                }
                point = dcFactory.createPoint();
                if (sequenceFlow.getTargetRef() != null) {
                    Bounds targetBounds = this._bounds.get(sequenceFlow.getTargetRef().getId());
                    point.setX(targetBounds.getX() + targetBounds.getWidth() / 2.0f);
                    point.setY(targetBounds.getY() + targetBounds.getHeight() / 2.0f);
                }
                edge2.getWaypoint().add(point);
                plane.getPlaneElement().add(edge2);
            }
            if (process.getArtifacts() != null) {
                ArrayList<Association> incompleteAssociations = new ArrayList<Association>();
                for (Artifact artifact : process.getArtifacts()) {
                    Bounds b;
                    if ((artifact instanceof TextAnnotation || artifact instanceof Group) && (b = this._bounds.get(artifact.getId())) != null) {
                        BPMNShape shape = factory.createBPMNShape();
                        shape.setBpmnElement((BaseElement)artifact);
                        shape.setBounds(b);
                        plane.getPlaneElement().add(shape);
                    }
                    if (!(artifact instanceof Association)) continue;
                    Association association = (Association)artifact;
                    if (association.getSourceRef() != null && association.getTargetRef() != null) {
                        edge = factory.createBPMNEdge();
                        edge.setBpmnElement((BaseElement)association);
                        DcFactory dcFactory = DcFactory.eINSTANCE;
                        Point point = dcFactory.createPoint();
                        Bounds sourceBounds = this._bounds.get(association.getSourceRef().getId());
                        point.setX(sourceBounds.getX() + sourceBounds.getWidth() / 2.0f);
                        point.setY(sourceBounds.getY() + sourceBounds.getHeight() / 2.0f);
                        edge.getWaypoint().add(point);
                        List<Point> dockers = this._dockers.get(association.getId());
                        for (int i = 1; i < dockers.size() - 1; ++i) {
                            edge.getWaypoint().add(dockers.get(i));
                        }
                        point = dcFactory.createPoint();
                        Bounds targetBounds = this._bounds.get(association.getTargetRef().getId());
                        point.setX(targetBounds.getX());
                        point.setY(targetBounds.getY() + targetBounds.getHeight() / 2.0f);
                        edge.getWaypoint().add(point);
                        plane.getPlaneElement().add(edge);
                        continue;
                    }
                    incompleteAssociations.add(association);
                }
                if (!incompleteAssociations.isEmpty()) {
                    for (Association incompleteAssociation : incompleteAssociations) {
                        process.getArtifacts().remove(incompleteAssociation);
                    }
                }
            }
            if (process.getLaneSets() != null && process.getLaneSets().size() > 0) {
                for (LaneSet ls : process.getLaneSets()) {
                    for (Lane lane : ls.getLanes()) {
                        Bounds b = this._bounds.get(lane.getId());
                        if (b == null) continue;
                        BPMNShape shape = factory.createBPMNShape();
                        shape.setBpmnElement((BaseElement)lane);
                        shape.setBounds(b);
                        plane.getPlaneElement().add(shape);
                    }
                }
            }
            def.getDiagrams().add(diagram);
        }
    }

    private BaseElement unmarshallItem(JsonParser parser, String preProcessingData) throws JsonParseException, IOException {
        String resourceId = null;
        Map<String, String> properties = null;
        String stencil = null;
        ArrayList<BaseElement> childElements = new ArrayList<BaseElement>();
        ArrayList<String> outgoing = new ArrayList<String>();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = parser.getCurrentName();
            parser.nextToken();
            if ("resourceId".equals(fieldname)) {
                resourceId = parser.getText();
                continue;
            }
            if ("properties".equals(fieldname)) {
                properties = this.unmarshallProperties(parser);
                continue;
            }
            if ("stencil".equals(fieldname)) {
                parser.nextToken();
                parser.nextToken();
                stencil = parser.getText();
                parser.nextToken();
                continue;
            }
            if ("childShapes".equals(fieldname)) {
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    childElements.add(this.unmarshallItem(parser, preProcessingData));
                }
                continue;
            }
            if ("bounds".equals(fieldname)) {
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                Integer x2 = parser.getIntValue();
                parser.nextToken();
                parser.nextToken();
                Integer y2 = parser.getIntValue();
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                Integer x1 = parser.getIntValue();
                parser.nextToken();
                parser.nextToken();
                Integer y1 = parser.getIntValue();
                parser.nextToken();
                parser.nextToken();
                Bounds b = DcFactory.eINSTANCE.createBounds();
                b.setX((float)x1.intValue());
                b.setY((float)y1.intValue());
                b.setWidth((float)(x2 - x1));
                b.setHeight((float)(y2 - y1));
                this._bounds.put(resourceId, b);
                continue;
            }
            if ("dockers".equals(fieldname)) {
                ArrayList<Point> dockers = new ArrayList<Point>();
                JsonToken nextToken = parser.nextToken();
                boolean end = JsonToken.END_ARRAY.equals((Object)nextToken);
                while (!end) {
                    nextToken = parser.nextToken();
                    nextToken = parser.nextToken();
                    Integer x = parser.getIntValue();
                    parser.nextToken();
                    parser.nextToken();
                    Integer y = parser.getIntValue();
                    Point point = DcFactory.eINSTANCE.createPoint();
                    point.setX((float)x.intValue());
                    point.setY((float)y.intValue());
                    dockers.add(point);
                    parser.nextToken();
                    nextToken = parser.nextToken();
                    end = JsonToken.END_ARRAY.equals((Object)nextToken);
                }
                this._dockers.put(resourceId, dockers);
                continue;
            }
            if ("outgoing".equals(fieldname)) {
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    parser.nextToken();
                    parser.nextToken();
                    outgoing.add(parser.getText());
                    parser.nextToken();
                }
                parser.skipChildren();
                continue;
            }
            if (!"target".equals(fieldname)) continue;
            parser.skipChildren();
        }
        properties.put("resourceId", resourceId);
        boolean customElement = this.isCustomElement((String)properties.get("tasktype"), preProcessingData);
        BaseElement baseElt = this.createBaseElement(stencil, properties.get("tasktype"), customElement);
        if (baseElt instanceof SequenceFlow) {
            this._sequenceFlowTargets.addAll(outgoing);
        }
        this._outgoingFlows.put(baseElt, outgoing);
        this._objMap.put(baseElt, resourceId);
        this._idMap.put(resourceId, baseElt);
        this.applyProperties(baseElt, properties, preProcessingData);
        if (baseElt instanceof Definitions) {
            Process rootLevelProcess = null;
            if (childElements == null || childElements.size() < 1) {
                if (rootLevelProcess == null) {
                    ExtendedMetaData metadata;
                    rootLevelProcess = Bpmn2Factory.eINSTANCE.createProcess();
                    if (properties.get("vardefs") != null && properties.get("vardefs").length() > 0) {
                        String[] vardefs;
                        for (String vardef : vardefs = properties.get("vardefs").split(",\\s*")) {
                            Property prop = Bpmn2Factory.eINSTANCE.createProperty();
                            ItemDefinition itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                            if (vardef.contains(":")) {
                                String[] vardefParts = vardef.split(":\\s*");
                                prop.setId(vardefParts[0]);
                                itemdef.setId("_" + prop.getId() + "Item");
                                itemdef.setStructureRef(vardefParts[1]);
                            } else {
                                prop.setId(vardef);
                                itemdef.setId("_" + prop.getId() + "Item");
                            }
                            prop.setItemSubjectRef(itemdef);
                            rootLevelProcess.getProperties().add(prop);
                            ((Definitions)baseElt).getRootElements().add(itemdef);
                        }
                    }
                    if (properties.get("adhocprocess") != null && properties.get("adhocprocess").equals("true")) {
                        metadata = ExtendedMetaData.INSTANCE;
                        EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "adHoc", false, false);
                        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("adhocprocess"));
                        rootLevelProcess.getAnyAttribute().add((Object)extensionEntry);
                    }
                    if (properties.get("customdescription") != null && properties.get("customdescription").length() > 0) {
                        metadata = DroolsFactory.eINSTANCE.createMetaDataType();
                        metadata.setName("customDescription");
                        metadata.setMetaValue(this.wrapInCDATABlock(properties.get("customdescription")));
                        if (rootLevelProcess.getExtensionValues() == null || rootLevelProcess.getExtensionValues().size() < 1) {
                            ExtensionAttributeValue extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                            rootLevelProcess.getExtensionValues().add(extensionElement);
                        }
                        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, (Object)metadata);
                        ((ExtensionAttributeValue)rootLevelProcess.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
                    }
                    rootLevelProcess.setId(properties.get("id"));
                    this.applyProcessProperties(rootLevelProcess, properties);
                    ((Definitions)baseElt).getRootElements().add(rootLevelProcess);
                }
            } else {
                for (BaseElement child : childElements) {
                    if (child instanceof SequenceFlow) {
                        List<String> ids = this._outgoingFlows.get(child);
                        FlowElementsContainer container = null;
                        for (String id : ids) {
                            Object obj = this._idMap.get(id);
                            if (!(obj instanceof EObject) || !(((EObject)obj).eContainer() instanceof FlowElementsContainer)) continue;
                            container = (FlowElementsContainer)((EObject)obj).eContainer();
                            break;
                        }
                        if (container != null) {
                            container.getFlowElements().add((SequenceFlow)child);
                            continue;
                        }
                    }
                    if ((child instanceof Task || child instanceof SequenceFlow || child instanceof Gateway || child instanceof Event || child instanceof Artifact || child instanceof DataObject || child instanceof SubProcess || child instanceof Lane || child instanceof CallActivity) && rootLevelProcess == null) {
                        ExtendedMetaData metadata;
                        rootLevelProcess = Bpmn2Factory.eINSTANCE.createProcess();
                        if (properties.get("vardefs") != null && properties.get("vardefs").length() > 0) {
                            String[] vardefs;
                            for (String vardef : vardefs = properties.get("vardefs").split(",\\s*")) {
                                Property prop = Bpmn2Factory.eINSTANCE.createProperty();
                                ItemDefinition itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                                if (vardef.contains(":")) {
                                    String[] vardefParts = vardef.split(":\\s*");
                                    prop.setId(vardefParts[0]);
                                    itemdef.setId("_" + prop.getId() + "Item");
                                    itemdef.setStructureRef(vardefParts[1]);
                                } else {
                                    prop.setId(vardef);
                                    itemdef.setId("_" + prop.getId() + "Item");
                                }
                                prop.setItemSubjectRef(itemdef);
                                rootLevelProcess.getProperties().add(prop);
                                ((Definitions)baseElt).getRootElements().add(itemdef);
                            }
                        }
                        if (properties.get("adhocprocess") != null && properties.get("adhocprocess").equals("true")) {
                            metadata = ExtendedMetaData.INSTANCE;
                            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "adHoc", false, false);
                            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("adhocprocess"));
                            rootLevelProcess.getAnyAttribute().add((Object)extensionEntry);
                        }
                        if (properties.get("customdescription") != null && properties.get("customdescription").length() > 0) {
                            metadata = DroolsFactory.eINSTANCE.createMetaDataType();
                            metadata.setName("customDescription");
                            metadata.setMetaValue(this.wrapInCDATABlock(properties.get("customdescription")));
                            if (rootLevelProcess.getExtensionValues() == null || rootLevelProcess.getExtensionValues().size() < 1) {
                                ExtensionAttributeValue extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                                rootLevelProcess.getExtensionValues().add(extensionElement);
                            }
                            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, (Object)metadata);
                            ((ExtensionAttributeValue)rootLevelProcess.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
                        }
                        rootLevelProcess.setId(properties.get("id"));
                        this.applyProcessProperties(rootLevelProcess, properties);
                        ((Definitions)baseElt).getRootElements().add(rootLevelProcess);
                    }
                    if (child instanceof Task) {
                        rootLevelProcess.getFlowElements().add((Task)child);
                        continue;
                    }
                    if (child instanceof CallActivity) {
                        rootLevelProcess.getFlowElements().add((CallActivity)child);
                        continue;
                    }
                    if (child instanceof RootElement) {
                        ((Definitions)baseElt).getRootElements().add((RootElement)child);
                        continue;
                    }
                    if (child instanceof SequenceFlow) {
                        rootLevelProcess.getFlowElements().add((SequenceFlow)child);
                        continue;
                    }
                    if (child instanceof Gateway) {
                        rootLevelProcess.getFlowElements().add((Gateway)child);
                        continue;
                    }
                    if (child instanceof Event) {
                        rootLevelProcess.getFlowElements().add((Event)child);
                        continue;
                    }
                    if (child instanceof Artifact) {
                        rootLevelProcess.getArtifacts().add((Artifact)child);
                        continue;
                    }
                    if (child instanceof DataObject) {
                        rootLevelProcess.getFlowElements().add((DataObject)child);
                        continue;
                    }
                    if (child instanceof SubProcess) {
                        rootLevelProcess.getFlowElements().add((SubProcess)child);
                        continue;
                    }
                    if (child instanceof Lane) continue;
                    _logger.error("Don't know what to do of " + child);
                }
            }
        } else if (baseElt instanceof Process) {
            for (BaseElement child : childElements) {
                if (child instanceof Lane) {
                    if (((Process)baseElt).getLaneSets().isEmpty()) {
                        ((Process)baseElt).getLaneSets().add(Bpmn2Factory.eINSTANCE.createLaneSet());
                    }
                    ((LaneSet)((Process)baseElt).getLaneSets().get(0)).getLanes().add((Lane)child);
                    this.addLaneFlowNodes((Process)baseElt, (Lane)child);
                    continue;
                }
                if (child instanceof Artifact) {
                    ((Process)baseElt).getArtifacts().add((Artifact)child);
                    continue;
                }
                _logger.error("Don't know what to do of " + child);
            }
        } else if (baseElt instanceof SubProcess) {
            for (BaseElement child : childElements) {
                if (child instanceof FlowElement) {
                    ((SubProcess)baseElt).getFlowElements().add((FlowElement)child);
                    continue;
                }
                if (child instanceof Artifact) {
                    ((SubProcess)baseElt).getArtifacts().add((Artifact)child);
                    continue;
                }
                _logger.error("Subprocess - don't know what to do of " + child);
            }
        } else if (!(baseElt instanceof Message)) {
            if (baseElt instanceof Lane) {
                ((Lane)baseElt).setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
                for (BaseElement child : childElements) {
                    if (child instanceof FlowNode) {
                        ((Lane)baseElt).getFlowNodeRefs().add((FlowNode)child);
                        continue;
                    }
                    if (child instanceof Artifact) {
                        this._artifacts.add((Artifact)child);
                        continue;
                    }
                    _logger.error("Don't know what to do of " + childElements);
                }
                this._lanes.add((Lane)baseElt);
            } else if (!childElements.isEmpty()) {
                _logger.error("Don't know what to do of " + childElements + " with " + baseElt);
            }
        }
        return baseElt;
    }

    private void addLaneFlowNodes(Process process, Lane lane) {
        process.getFlowElements().addAll(lane.getFlowNodeRefs());
        if (lane.getChildLaneSet() != null) {
            for (Lane l : lane.getChildLaneSet().getLanes()) {
                this.addLaneFlowNodes(process, l);
            }
        }
    }

    protected void applyProperties(BaseElement baseElement, Map<String, String> properties, String preProcessingData) {
        this.applyBaseElementProperties(baseElement, properties);
        if (baseElement instanceof SubProcess) {
            this.applySubProcessProperties((SubProcess)baseElement, properties);
        }
        if (baseElement instanceof AdHocSubProcess) {
            this.applyAdHocSubProcessProperties((AdHocSubProcess)baseElement, properties);
        }
        if (baseElement instanceof CallActivity) {
            this.applyCallActivityProperties((CallActivity)baseElement, properties);
        }
        if (baseElement instanceof GlobalTask) {
            this.applyGlobalTaskProperties((GlobalTask)baseElement, properties);
        }
        if (baseElement instanceof Definitions) {
            this.applyDefinitionProperties((Definitions)baseElement, properties);
        }
        if (baseElement instanceof Process) {
            this.applyProcessProperties((Process)baseElement, properties);
        }
        if (baseElement instanceof Lane) {
            this.applyLaneProperties((Lane)baseElement, properties);
        }
        if (baseElement instanceof SequenceFlow) {
            this.applySequenceFlowProperties((SequenceFlow)baseElement, properties);
        }
        if (baseElement instanceof Task) {
            this.applyTaskProperties((Task)baseElement, properties, preProcessingData);
        }
        if (baseElement instanceof UserTask) {
            this.applyUserTaskProperties((UserTask)baseElement, properties);
        }
        if (baseElement instanceof BusinessRuleTask) {
            this.applyBusinessRuleTaskProperties((BusinessRuleTask)baseElement, properties);
        }
        if (baseElement instanceof ScriptTask) {
            this.applyScriptTaskProperties((ScriptTask)baseElement, properties);
        }
        if (baseElement instanceof ServiceTask) {
            this.applyServiceTaskProperties((ServiceTask)baseElement, properties);
        }
        if (baseElement instanceof ReceiveTask) {
            this.applyReceiveTaskProperties((ReceiveTask)baseElement, properties);
        }
        if (baseElement instanceof SendTask) {
            this.applySendTaskProperties((SendTask)baseElement, properties);
        }
        if (baseElement instanceof Gateway) {
            this.applyGatewayProperties((Gateway)baseElement, properties);
        }
        if (baseElement instanceof Event) {
            this.applyEventProperties((Event)baseElement, properties);
        }
        if (baseElement instanceof CatchEvent) {
            this.applyCatchEventProperties((CatchEvent)baseElement, properties);
        }
        if (baseElement instanceof ThrowEvent) {
            this.applyThrowEventProperties((ThrowEvent)baseElement, properties);
        }
        if (baseElement instanceof TextAnnotation) {
            this.applyTextAnnotationProperties((TextAnnotation)baseElement, properties);
        }
        if (baseElement instanceof Group) {
            this.applyGroupProperties((Group)baseElement, properties);
        }
        if (baseElement instanceof DataObject) {
            this.applyDataObjectProperties((DataObject)baseElement, properties);
        }
        if (baseElement instanceof DataStore) {
            this.applyDataStoreProperties((DataStore)baseElement, properties);
        }
        if (baseElement instanceof Message) {
            this.applyMessageProperties((Message)baseElement, properties);
        }
        if (baseElement instanceof StartEvent) {
            this.applyStartEventProperties((StartEvent)baseElement, properties);
        }
        if (baseElement instanceof EndEvent) {
            this.applyEndEventProperties((EndEvent)baseElement, properties);
        }
        if (baseElement instanceof Association) {
            this.applyAssociationProperties((Association)baseElement, properties);
        }
        for (BpmnMarshallerHelper helper : this._helpers) {
            helper.applyProperties(baseElement, properties);
        }
    }

    protected void applySubProcessProperties(SubProcess sp, Map<String, String> properties) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        InputOutputSpecification iospec;
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry;
        ExtensionAttributeValue extensionElement;
        String scriptLanguage;
        String[] allActions;
        if (properties.get("name") != null) {
            sp.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        } else {
            sp.setName("");
        }
        if (properties.get("onentryactions") != null && properties.get("onentryactions").length() > 0) {
            for (String action : allActions = properties.get("onentryactions").split("\\|\\s*")) {
                OnEntryScriptType onEntryScript = DroolsFactory.eINSTANCE.createOnEntryScriptType();
                onEntryScript.setScript(this.wrapInCDATABlock(action));
                scriptLanguage = properties.get("script_language").equals("java") ? "http://www.java.com/java" : (properties.get("script_language").equals("mvel") ? "http://www.mvel.org/2.0" : "http://www.java.com/java");
                onEntryScript.setScriptFormat(scriptLanguage);
                if (sp.getExtensionValues() == null || sp.getExtensionValues().size() < 1) {
                    extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                    sp.getExtensionValues().add(extensionElement);
                }
                extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__ON_ENTRY_SCRIPT, (Object)onEntryScript);
                ((ExtensionAttributeValue)sp.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
            }
        }
        if (properties.get("onexitactions") != null && properties.get("onexitactions").length() > 0) {
            for (String action : allActions = properties.get("onexitactions").split("\\|\\s*")) {
                OnExitScriptType onExitScript = DroolsFactory.eINSTANCE.createOnExitScriptType();
                onExitScript.setScript(this.wrapInCDATABlock(action));
                scriptLanguage = properties.get("script_language").equals("java") ? "http://www.java.com/java" : (properties.get("script_language").equals("mvel") ? "http://www.mvel.org/2.0" : "http://www.java.com/java");
                onExitScript.setScriptFormat(scriptLanguage);
                if (sp.getExtensionValues() == null || sp.getExtensionValues().size() < 1) {
                    extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                    sp.getExtensionValues().add(extensionElement);
                }
                extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__ON_EXIT_SCRIPT, (Object)onExitScript);
                ((ExtensionAttributeValue)sp.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
            }
        }
        if (properties.get("datainputset") != null && properties.get("datainputset").trim().length() > 0) {
            String[] allDataInputs = properties.get("datainputset").split(",\\s*");
            if (sp.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                sp.setIoSpecification(iospec);
            }
            InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
            for (String dataInput : allDataInputs) {
                if (dataInput.trim().length() <= 0) continue;
                DataInput nextInput = Bpmn2Factory.eINSTANCE.createDataInput();
                String[] dataInputParts = dataInput.split(":\\s*");
                if (dataInputParts.length == 2) {
                    nextInput.setId(sp.getId() + "_" + dataInputParts[0] + "InputX");
                    nextInput.setName(dataInputParts[0]);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)dataInputParts[1]);
                    nextInput.getAnyAttribute().add((Object)extensionEntry);
                } else {
                    nextInput.setId(sp.getId() + "_" + dataInput + "InputX");
                    nextInput.setName(dataInput);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)"Object");
                    nextInput.getAnyAttribute().add((Object)extensionEntry);
                }
                sp.getIoSpecification().getDataInputs().add(nextInput);
                inset.getDataInputRefs().add(nextInput);
            }
            sp.getIoSpecification().getInputSets().add(inset);
        } else if (sp.getIoSpecification() != null) {
            sp.getIoSpecification().getInputSets().add(Bpmn2Factory.eINSTANCE.createInputSet());
        }
        if (properties.get("dataoutputset") != null && properties.get("dataoutputset").trim().length() > 0) {
            String[] allDataOutputs = properties.get("dataoutputset").split(",\\s*");
            if (sp.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                sp.setIoSpecification(iospec);
            }
            OutputSet outset = Bpmn2Factory.eINSTANCE.createOutputSet();
            for (String dataOutput : allDataOutputs) {
                if (dataOutput.trim().length() <= 0) continue;
                DataOutput nextOut = Bpmn2Factory.eINSTANCE.createDataOutput();
                String[] dataOutputParts = dataOutput.split(":\\s*");
                if (dataOutputParts.length == 2) {
                    nextOut.setId(sp.getId() + "_" + dataOutputParts[0] + "OutputX");
                    nextOut.setName(dataOutputParts[0]);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)dataOutputParts[1]);
                    nextOut.getAnyAttribute().add((Object)extensionEntry);
                } else {
                    nextOut.setId(sp.getId() + "_" + dataOutput + "OutputX");
                    nextOut.setName(dataOutput);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)"Object");
                    nextOut.getAnyAttribute().add((Object)extensionEntry);
                }
                sp.getIoSpecification().getDataOutputs().add(nextOut);
                outset.getDataOutputRefs().add(nextOut);
            }
            sp.getIoSpecification().getOutputSets().add(outset);
        } else if (sp.getIoSpecification() != null) {
            sp.getIoSpecification().getOutputSets().add(Bpmn2Factory.eINSTANCE.createOutputSet());
        }
        if (properties.get("assignments") != null && properties.get("assignments").length() > 0 && sp.getIoSpecification() != null) {
            String[] allAssignments;
            for (String assignment : allAssignments = properties.get("assignments").split(",\\s*")) {
                ItemAwareElement ie;
                String[] assignmentParts;
                if (assignment.contains("=")) {
                    assignmentParts = assignment.split("=\\s*");
                    DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                    if (sp.getIoSpecification() != null && sp.getIoSpecification().getDataOutputs() != null) {
                        List dataInputs = sp.getIoSpecification().getDataInputs();
                        for (DataInput di : dataInputs) {
                            if (!di.getId().equals(sp.getId() + "_" + assignmentParts[0] + "InputX")) continue;
                            dia.setTargetRef((ItemAwareElement)di);
                            if (!di.getName().equals("TaskName")) continue;
                            break;
                        }
                    }
                    Assignment a = Bpmn2Factory.eINSTANCE.createAssignment();
                    FormalExpression fromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    if (assignmentParts.length > 1) {
                        String replacer = assignmentParts[1].replaceAll("##", ",");
                        replacer = replacer.replaceAll("\\|\\|", "=");
                        fromExpression.setBody(this.wrapInCDATABlock(replacer));
                    } else {
                        fromExpression.setBody("");
                    }
                    FormalExpression toExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    toExpression.setBody(dia.getTargetRef().getId());
                    a.setFrom((Expression)fromExpression);
                    a.setTo((Expression)toExpression);
                    dia.getAssignment().add(a);
                    sp.getDataInputAssociations().add(dia);
                    continue;
                }
                if (assignment.contains("<->")) {
                    assignmentParts = assignment.split("<->\\s*");
                    DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                    DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                    ItemAwareElement ie2 = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                    ie2.setId(assignmentParts[0]);
                    dia.getSourceRef().add(ie2);
                    doa.setTargetRef(ie2);
                    List dataInputs = sp.getIoSpecification().getDataInputs();
                    for (DataInput di : dataInputs) {
                        if (!di.getId().equals(sp.getId() + "_" + assignmentParts[1] + "InputX")) continue;
                        dia.setTargetRef((ItemAwareElement)di);
                        break;
                    }
                    List dataOutputs = sp.getIoSpecification().getDataOutputs();
                    for (DataOutput dout : dataOutputs) {
                        if (!dout.getId().equals(sp.getId() + "_" + assignmentParts[1] + "OutputX")) continue;
                        doa.getSourceRef().add(dout);
                        break;
                    }
                    sp.getDataInputAssociations().add(dia);
                    sp.getDataOutputAssociations().add(doa);
                    continue;
                }
                if (!assignment.contains("->")) continue;
                assignmentParts = assignment.split("->\\s*");
                boolean leftHandAssignMentIsDO = false;
                List dataOutputs = sp.getIoSpecification().getDataOutputs();
                for (DataOutput dout : dataOutputs) {
                    if (!dout.getId().equals(sp.getId() + "_" + assignmentParts[0] + "OutputX")) continue;
                    leftHandAssignMentIsDO = true;
                    break;
                }
                if (leftHandAssignMentIsDO) {
                    DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                    for (DataOutput dout : dataOutputs) {
                        if (!dout.getId().equals(sp.getId() + "_" + assignmentParts[0] + "OutputX")) continue;
                        doa.getSourceRef().add(dout);
                        break;
                    }
                    ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                    ie.setId(assignmentParts[1]);
                    doa.setTargetRef(ie);
                    sp.getDataOutputAssociations().add(doa);
                    continue;
                }
                DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                ie.setId(assignmentParts[0]);
                dia.getSourceRef().add(ie);
                List dataInputs = sp.getIoSpecification().getDataInputs();
                for (DataInput di : dataInputs) {
                    if (!di.getId().equals(sp.getId() + "_" + assignmentParts[1] + "InputX")) continue;
                    dia.setTargetRef((ItemAwareElement)di);
                    break;
                }
                sp.getDataInputAssociations().add(dia);
            }
        }
        if (properties.get("multipleinstancecollectioninput") != null && properties.get("multipleinstancecollectioninput").length() > 0 && properties.get("multipleinstancedatainput") != null && properties.get("multipleinstancedatainput").length() > 0) {
            if (sp.getIoSpecification() == null) {
                InputOutputSpecification iospec2 = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                sp.setIoSpecification(iospec2);
            } else {
                sp.getIoSpecification().getDataInputs().clear();
                sp.getIoSpecification().getDataOutputs().clear();
                sp.getIoSpecification().getInputSets().clear();
                sp.getIoSpecification().getOutputSets().clear();
                sp.getDataInputAssociations().clear();
                sp.getDataOutputAssociations().clear();
            }
            InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
            DataInput multiInput = Bpmn2Factory.eINSTANCE.createDataInput();
            multiInput.setId(sp.getId() + "_" + "input");
            multiInput.setName(properties.get("multipleinstancecollectioninput"));
            sp.getIoSpecification().getDataInputs().add(multiInput);
            inset.getDataInputRefs().add(multiInput);
            sp.getIoSpecification().getInputSets().add(inset);
            DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
            ItemAwareElement ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
            ie.setId(properties.get("multipleinstancecollectioninput"));
            dia.getSourceRef().add(ie);
            dia.setTargetRef((ItemAwareElement)multiInput);
            sp.getDataInputAssociations().add(dia);
            MultiInstanceLoopCharacteristics loopCharacteristics = Bpmn2Factory.eINSTANCE.createMultiInstanceLoopCharacteristics();
            loopCharacteristics.setLoopDataInputRef((ItemAwareElement)multiInput);
            DataInput din = Bpmn2Factory.eINSTANCE.createDataInput();
            din.setId(properties.get("multipleinstancedatainput"));
            ItemDefinition itemDef = Bpmn2Factory.eINSTANCE.createItemDefinition();
            itemDef.setId(sp.getId() + "_" + "multiInstanceItemType");
            din.setItemSubjectRef(itemDef);
            this._subprocessItemDefs.put(itemDef.getId(), itemDef);
            loopCharacteristics.setInputDataItem(din);
            if (properties.get("multipleinstancecollectionoutput") != null && properties.get("multipleinstancecollectionoutput").length() > 0 && properties.get("multipleinstancedataoutput") != null && properties.get("multipleinstancedataoutput").length() > 0) {
                OutputSet outset = Bpmn2Factory.eINSTANCE.createOutputSet();
                DataOutput multiOutput = Bpmn2Factory.eINSTANCE.createDataOutput();
                multiOutput.setId(sp.getId() + "_" + "output");
                multiOutput.setName(properties.get("multipleinstancecollectionoutput"));
                sp.getIoSpecification().getDataOutputs().add(multiOutput);
                outset.getDataOutputRefs().add(multiOutput);
                sp.getIoSpecification().getOutputSets().add(outset);
                DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                ItemAwareElement ie2 = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                ie2.setId(properties.get("multipleinstancecollectionoutput"));
                doa.getSourceRef().add(multiOutput);
                doa.setTargetRef(ie2);
                sp.getDataOutputAssociations().add(doa);
                loopCharacteristics.setLoopDataOutputRef((ItemAwareElement)multiOutput);
                DataOutput don = Bpmn2Factory.eINSTANCE.createDataOutput();
                don.setId(properties.get("multipleinstancedataoutput"));
                ItemDefinition itemDef2 = Bpmn2Factory.eINSTANCE.createItemDefinition();
                itemDef2.setId(sp.getId() + "_" + "multiInstanceItemType");
                don.setItemSubjectRef(itemDef2);
                this._subprocessItemDefs.put(itemDef2.getId(), itemDef2);
                loopCharacteristics.setOutputDataItem(don);
            }
            sp.setLoopCharacteristics((LoopCharacteristics)loopCharacteristics);
        }
        if (properties.get("vardefs") != null && properties.get("vardefs").length() > 0) {
            String[] vardefs;
            for (String vardef : vardefs = properties.get("vardefs").split(",\\s*")) {
                Property prop = Bpmn2Factory.eINSTANCE.createProperty();
                ItemDefinition itemdef = Bpmn2Factory.eINSTANCE.createItemDefinition();
                if (vardef.contains(":")) {
                    String[] vardefParts = vardef.split(":\\s*");
                    prop.setId(vardefParts[0]);
                    itemdef.setId("_" + prop.getId() + "Item");
                    itemdef.setStructureRef(vardefParts[1]);
                } else {
                    prop.setId(vardef);
                    itemdef.setId("_" + prop.getId() + "Item");
                }
                prop.setItemSubjectRef(itemdef);
                sp.getProperties().add(prop);
                this._subprocessItemDefs.put(itemdef.getId(), itemdef);
            }
        }
        if (sp instanceof EventSubprocess) {
            sp.setTriggeredByEvent(true);
        }
        if (properties.get("distributiontype") != null && properties.get("distributiontype").length() > 0) {
            TimeParameters timeParams = BpsimFactory.eINSTANCE.createTimeParameters();
            Parameter processingTimeParam = BpsimFactory.eINSTANCE.createParameter();
            if (properties.get("distributiontype").equals("normal")) {
                NormalDistributionType normalDistributionType = BpsimFactory.eINSTANCE.createNormalDistributionType();
                normalDistributionType.setStandardDeviation(Double.valueOf(properties.get("standarddeviation")).doubleValue());
                normalDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)normalDistributionType);
            } else if (properties.get("distributiontype").equals("uniform")) {
                UniformDistributionType uniformDistributionType = BpsimFactory.eINSTANCE.createUniformDistributionType();
                uniformDistributionType.setMax(Double.valueOf(properties.get("max")).doubleValue());
                uniformDistributionType.setMin(Double.valueOf(properties.get("min")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)uniformDistributionType);
            } else if (properties.get("distributiontype").equals("poisson")) {
                PoissonDistributionType poissonDistributionType = BpsimFactory.eINSTANCE.createPoissonDistributionType();
                poissonDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)poissonDistributionType);
            }
            if (properties.get("waittime") != null) {
                Parameter waittimeParam = BpsimFactory.eINSTANCE.createParameter();
                FloatingParameterType waittimeParamValue = BpsimFactory.eINSTANCE.createFloatingParameterType();
                DecimalFormat twoDForm = new DecimalFormat("#.##");
                waittimeParamValue.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("waittime")))).doubleValue());
                waittimeParam.getParameterValue().add((Object)waittimeParamValue);
                timeParams.setWaitTime(waittimeParam);
            }
            timeParams.setProcessingTime(processingTimeParam);
            if (this._simulationElementParameters.containsKey(sp.getId())) {
                this._simulationElementParameters.get(sp.getId()).add((EObject)timeParams);
            } else {
                ArrayList<TimeParameters> values = new ArrayList<TimeParameters>();
                values.add(timeParams);
                this._simulationElementParameters.put(sp.getId(), values);
            }
        }
        CostParameters costParameters = BpsimFactory.eINSTANCE.createCostParameters();
        if (properties.get("unitcost") != null && properties.get("unitcost").length() > 0) {
            Parameter unitcostParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType unitCostParameterValue = BpsimFactory.eINSTANCE.createFloatingParameterType();
            unitCostParameterValue.setValue(new Double(properties.get("unitcost")).doubleValue());
            unitcostParam.getParameterValue().add((Object)unitCostParameterValue);
            costParameters.setUnitCost(unitcostParam);
        }
        if (this._simulationElementParameters.containsKey(sp.getId())) {
            this._simulationElementParameters.get(sp.getId()).add((EObject)costParameters);
        } else {
            ArrayList<CostParameters> values = new ArrayList<CostParameters>();
            values.add(costParameters);
            this._simulationElementParameters.put(sp.getId(), values);
        }
    }

    protected void applyAdHocSubProcessProperties(AdHocSubProcess ahsp, Map<String, String> properties) {
        if (properties.get("adhocordering") != null) {
            if (properties.get("adhocordering").equals("Parallel")) {
                ahsp.setOrdering(AdHocOrdering.PARALLEL);
            } else {
                ahsp.setOrdering(AdHocOrdering.SEQUENTIAL);
            }
        }
        if (properties.get("adhoccompletioncondition") != null) {
            FormalExpression completionConditionExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
            completionConditionExpression.setBody(this.wrapInCDATABlock(properties.get("adhoccompletioncondition")));
            ahsp.setCompletionCondition((Expression)completionConditionExpression);
        }
    }

    protected void applyEndEventProperties(EndEvent ee, Map<String, String> properties) {
        ee.setId(properties.get("resourceId"));
        if (properties.get("name") != null) {
            ee.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        } else {
            ee.setName("");
        }
    }

    protected void applyAssociationProperties(Association association, Map<String, String> properties) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        if (properties.get("type") != null) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "type", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("type"));
            association.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("bordercolor") != null && properties.get("bordercolor").length() > 0 && !properties.get("bordercolor").equals("#000000")) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "bordercolor", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("bordercolor"));
            association.getAnyAttribute().add((Object)extensionEntry);
        }
    }

    protected void applyStartEventProperties(StartEvent se, Map<String, String> properties) {
        if (properties.get("name") != null) {
            se.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        } else {
            se.setName("");
        }
        se.setIsInterrupting(Boolean.parseBoolean(properties.get("isinterrupting")));
    }

    protected void applyMessageProperties(Message msg, Map<String, String> properties) {
        if (properties.get("name") != null) {
            msg.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
            msg.setId(properties.get("name") + "Message");
        } else {
            msg.setName("");
            msg.setId("Message");
        }
    }

    protected void applyDataStoreProperties(DataStore da, Map<String, String> properties) {
        if (properties.get("name") != null) {
            da.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        } else {
            da.setName("");
        }
    }

    protected void applyDataObjectProperties(DataObject da, Map<String, String> properties) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        if (properties.get("name") != null && properties.get("name").length() > 0) {
            da.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        } else {
            da.setName(da.getId());
        }
        boolean haveCustomType = false;
        if (properties.get("customtype") != null && properties.get("customtype").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "datype", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("customtype"));
            da.getAnyAttribute().add((Object)extensionEntry);
            haveCustomType = true;
        }
        if (properties.get("standardtype") != null && properties.get("standardtype").length() > 0 && !haveCustomType) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "datype", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("standardtype"));
            da.getAnyAttribute().add((Object)extensionEntry);
        }
    }

    protected void applyTextAnnotationProperties(TextAnnotation ta, Map<String, String> properties) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        if (properties.get("name") != null) {
            ta.setText(properties.get("name"));
        } else {
            ta.setText("");
        }
        ta.setTextFormat("text/plain");
        if (properties.get("bordercolor") != null && properties.get("bordercolor").length() > 0 && !properties.get("bordercolor").equals("#000000")) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "bordercolor", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("bordercolor"));
            ta.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("fontsize") != null && properties.get("fontsize").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "fontsize", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("fontsize"));
            ta.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("fontcolor") != null && properties.get("fontcolor").length() > 0 && !properties.get("fontcolor").equals("#000000")) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "fontcolor", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("fontcolor"));
            ta.getAnyAttribute().add((Object)extensionEntry);
        }
    }

    protected void applyGroupProperties(Group group, Map<String, String> properties) {
        if (properties.get("name") != null) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "categoryval", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("name"));
            group.getAnyAttribute().add((Object)extensionEntry);
        }
    }

    protected void applyEventProperties(Event event, Map<String, String> properties) {
        if (properties.get("name") != null) {
            event.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        } else {
            event.setName("");
        }
        if (properties.get("auditing") != null && !"".equals(properties.get("auditing"))) {
            Auditing audit = Bpmn2Factory.eINSTANCE.createAuditing();
            audit.getDocumentation().add(this.createDocumentation(properties.get("auditing")));
            event.setAuditing(audit);
        }
        if (properties.get("monitoring") != null && !"".equals(properties.get("monitoring"))) {
            Monitoring monitoring = Bpmn2Factory.eINSTANCE.createMonitoring();
            monitoring.getDocumentation().add(this.createDocumentation(properties.get("monitoring")));
            event.setMonitoring(monitoring);
        }
    }

    protected void applyCatchEventProperties(CatchEvent event, Map<String, String> properties) {
        if (properties.get("dataoutput") != null && !"".equals(properties.get("dataoutput"))) {
            String[] allDataOutputs = properties.get("dataoutput").split(",\\s*");
            OutputSet outSet = Bpmn2Factory.eINSTANCE.createOutputSet();
            for (String dataOutput : allDataOutputs) {
                String[] doutputParts = dataOutput.split(":\\s*");
                DataOutput dataout = Bpmn2Factory.eINSTANCE.createDataOutput();
                dataout.setId(event.getId() + "_" + doutputParts[0]);
                dataout.setName(doutputParts[0]);
                event.getDataOutputs().add(dataout);
                outSet.getDataOutputRefs().add(dataout);
            }
            event.setOutputSet(outSet);
        }
        if (properties.get("boundarycancelactivity") != null) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "boundaryca", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("boundarycancelactivity"));
            event.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("dataoutputassociations") != null && !"".equals(properties.get("dataoutputassociations"))) {
            String[] allAssociations;
            for (String association : allAssociations = properties.get("dataoutputassociations").split(",\\s*")) {
                String[] associationParts = association.split("->\\s*");
                DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                List dataOutputs = event.getDataOutputs();
                if (dataOutputs != null) {
                    for (DataOutput ddo : dataOutputs) {
                        if (!ddo.getId().equals(event.getId() + "_" + associationParts[0])) continue;
                        doa.getSourceRef().add(ddo);
                    }
                }
                ItemAwareElement e = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                e.setId(associationParts[1]);
                doa.setTargetRef(e);
                event.getDataOutputAssociation().add(doa);
            }
        }
        try {
            ExtendedMetaData metadata;
            EventDefinition ed = (EventDefinition)event.getEventDefinitions().get(0);
            if (ed instanceof TimerEventDefinition) {
                if (properties.get("timeduration") != null && !"".equals(properties.get("timeduration"))) {
                    FormalExpression timeDurationExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    timeDurationExpression.setBody(properties.get("timeduration"));
                    ((TimerEventDefinition)event.getEventDefinitions().get(0)).setTimeDuration((Expression)timeDurationExpression);
                }
                if (properties.get("timecycle") != null && !"".equals(properties.get("timecycle"))) {
                    FormalExpression timeCycleExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    timeCycleExpression.setBody(properties.get("timecycle"));
                    if (properties.get("timecyclelanguage") != null && properties.get("timecyclelanguage").length() > 0) {
                        timeCycleExpression.setLanguage(properties.get("timecyclelanguage"));
                    }
                    ((TimerEventDefinition)event.getEventDefinitions().get(0)).setTimeCycle((Expression)timeCycleExpression);
                }
            } else if (ed instanceof SignalEventDefinition) {
                if (properties.get("signalref") != null && !"".equals(properties.get("signalref"))) {
                    ((SignalEventDefinition)ed).setSignalRef(properties.get("signalref"));
                }
            } else if (ed instanceof ErrorEventDefinition) {
                if (properties.get("errorref") != null && !"".equals(properties.get("errorref"))) {
                    metadata = ExtendedMetaData.INSTANCE;
                    EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "erefname", false, false);
                    EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("errorref"));
                    ((ErrorEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
                }
            } else if (ed instanceof ConditionalEventDefinition) {
                FormalExpression conditionExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                if (properties.get("conditionlanguage") != null && !"".equals(properties.get("conditionlanguage"))) {
                    String languageStr = properties.get("conditionlanguage").equals("drools") ? "http://www.jboss.org/drools/rule" : (properties.get("conditionlanguage").equals("mvel") ? "http://www.mvel.org/2.0" : "http://www.jboss.org/drools/rule");
                    conditionExpression.setLanguage(languageStr);
                }
                if (properties.get("conditionexpression") != null && !"".equals(properties.get("conditionexpression"))) {
                    String scriptStr = properties.get("conditionexpression").replaceAll("\\\\n", "\n");
                    conditionExpression.setBody(this.wrapInCDATABlock(scriptStr));
                }
                ((ConditionalEventDefinition)event.getEventDefinitions().get(0)).setCondition((Expression)conditionExpression);
            } else if (ed instanceof EscalationEventDefinition) {
                if (properties.get("escalationcode") != null && !"".equals(properties.get("escalationcode"))) {
                    metadata = ExtendedMetaData.INSTANCE;
                    EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "esccode", false, false);
                    EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("escalationcode"));
                    ((EscalationEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
                }
            } else if (ed instanceof MessageEventDefinition) {
                if (properties.get("messageref") != null && !"".equals(properties.get("messageref"))) {
                    metadata = ExtendedMetaData.INSTANCE;
                    EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "msgref", false, false);
                    EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("messageref"));
                    ((MessageEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
                }
            } else if (ed instanceof CompensateEventDefinition && properties.get("activityref") != null && !"".equals(properties.get("activityref"))) {
                metadata = ExtendedMetaData.INSTANCE;
                EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "actrefname", false, false);
                EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("activityref"));
                ((CompensateEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (properties.get("distributiontype") != null && properties.get("distributiontype").length() > 0) {
            TimeParameters timeParams = BpsimFactory.eINSTANCE.createTimeParameters();
            Parameter processingTimeParam = BpsimFactory.eINSTANCE.createParameter();
            if (properties.get("distributiontype").equals("normal")) {
                NormalDistributionType normalDistributionType = BpsimFactory.eINSTANCE.createNormalDistributionType();
                normalDistributionType.setStandardDeviation(Double.valueOf(properties.get("standarddeviation")).doubleValue());
                normalDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)normalDistributionType);
            } else if (properties.get("distributiontype").equals("uniform")) {
                UniformDistributionType uniformDistributionType = BpsimFactory.eINSTANCE.createUniformDistributionType();
                uniformDistributionType.setMax(Double.valueOf(properties.get("max")).doubleValue());
                uniformDistributionType.setMin(Double.valueOf(properties.get("min")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)uniformDistributionType);
            } else if (properties.get("distributiontype").equals("poisson")) {
                PoissonDistributionType poissonDistributionType = BpsimFactory.eINSTANCE.createPoissonDistributionType();
                poissonDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)poissonDistributionType);
            }
            timeParams.setProcessingTime(processingTimeParam);
            if (this._simulationElementParameters.containsKey(event.getId())) {
                this._simulationElementParameters.get(event.getId()).add((EObject)timeParams);
            } else {
                ArrayList<TimeParameters> values = new ArrayList<TimeParameters>();
                values.add(timeParams);
                this._simulationElementParameters.put(event.getId(), values);
            }
        }
        if (properties.get("probability") != null && properties.get("probability").length() > 0) {
            ControlParameters controlParams = BpsimFactory.eINSTANCE.createControlParameters();
            Parameter probParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType probParamValueParam = BpsimFactory.eINSTANCE.createFloatingParameterType();
            DecimalFormat twoDForm = new DecimalFormat("#.##");
            probParamValueParam.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("probability")))).doubleValue());
            probParam.getParameterValue().add((Object)probParamValueParam);
            controlParams.setProbability(probParam);
            if (this._simulationElementParameters.containsKey(event.getId())) {
                this._simulationElementParameters.get(event.getId()).add((EObject)controlParams);
            } else {
                ArrayList<ControlParameters> values = new ArrayList<ControlParameters>();
                values.add(controlParams);
                this._simulationElementParameters.put(event.getId(), values);
            }
        }
    }

    protected void applyThrowEventProperties(ThrowEvent event, Map<String, String> properties) {
        if (properties.get("datainput") != null && !"".equals(properties.get("datainput"))) {
            String[] allDataInputs = properties.get("datainput").split(",\\s*");
            InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
            for (String dataInput : allDataInputs) {
                String[] dinputParts = dataInput.split(":\\s*");
                DataInput datain = Bpmn2Factory.eINSTANCE.createDataInput();
                datain.setId(event.getId() + "_" + dinputParts[0]);
                datain.setName(dinputParts[0]);
                event.getDataInputs().add(datain);
                inset.getDataInputRefs().add(datain);
            }
            event.setInputSet(inset);
        }
        if (properties.get("datainputassociations") != null && !"".equals(properties.get("datainputassociations"))) {
            String[] allAssociations;
            for (String association : allAssociations = properties.get("datainputassociations").split(",\\s*")) {
                String[] associationParts = association.split("->\\s*");
                DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                ItemAwareElement e = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                e.setId(associationParts[0]);
                dia.getSourceRef().add(e);
                List dataInputs = event.getDataInputs();
                if (dataInputs != null) {
                    for (DataInput di : dataInputs) {
                        if (!di.getId().equals(event.getId() + "_" + associationParts[1])) continue;
                        dia.setTargetRef((ItemAwareElement)di);
                        break;
                    }
                }
                event.getDataInputAssociation().add(dia);
            }
        }
        try {
            EAttributeImpl extensionAttribute;
            ExtendedMetaData metadata;
            EventDefinition ed = (EventDefinition)event.getEventDefinitions().get(0);
            if (ed instanceof TimerEventDefinition) {
                if (properties.get("timeduration") != null && !"".equals(properties.get("timeduration"))) {
                    FormalExpression timeDurationExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    timeDurationExpression.setBody(properties.get("timeduration"));
                    ((TimerEventDefinition)event.getEventDefinitions().get(0)).setTimeDuration((Expression)timeDurationExpression);
                }
                if (properties.get("timecycle") != null && !"".equals(properties.get("timecycle"))) {
                    FormalExpression timeCycleExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    timeCycleExpression.setBody(properties.get("timecycle"));
                    if (properties.get("timecyclelanguage") != null && properties.get("timecyclelanguage").length() > 0) {
                        timeCycleExpression.setLanguage(properties.get("timecyclelanguage"));
                    }
                    ((TimerEventDefinition)event.getEventDefinitions().get(0)).setTimeCycle((Expression)timeCycleExpression);
                }
            } else if (ed instanceof SignalEventDefinition) {
                if (properties.get("signalref") != null && !"".equals(properties.get("signalref"))) {
                    ((SignalEventDefinition)ed).setSignalRef(properties.get("signalref"));
                }
            } else if (ed instanceof ErrorEventDefinition) {
                if (properties.get("errorref") != null && !"".equals(properties.get("errorref"))) {
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "erefname", false, false);
                    EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("errorref"));
                    ((ErrorEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
                }
            } else if (ed instanceof ConditionalEventDefinition) {
                FormalExpression conditionExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                if (properties.get("conditionlanguage") != null && !"".equals(properties.get("conditionlanguage"))) {
                    String languageStr = properties.get("conditionlanguage").equals("drools") ? "http://www.jboss.org/drools/rule" : (properties.get("conditionlanguage").equals("mvel") ? "http://www.mvel.org/2.0" : "http://www.jboss.org/drools/rule");
                    conditionExpression.setLanguage(languageStr);
                }
                if (properties.get("conditionexpression") != null && !"".equals(properties.get("conditionexpression"))) {
                    String scriptStr = properties.get("conditionexpression").replaceAll("\\\\n", "\n");
                    conditionExpression.setBody(this.wrapInCDATABlock(scriptStr));
                }
                ((ConditionalEventDefinition)event.getEventDefinitions().get(0)).setCondition((Expression)conditionExpression);
            } else if (ed instanceof EscalationEventDefinition) {
                if (properties.get("escalationcode") != null && !"".equals(properties.get("escalationcode"))) {
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "esccode", false, false);
                    EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("escalationcode"));
                    ((EscalationEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
                }
            } else if (ed instanceof MessageEventDefinition) {
                if (properties.get("messageref") != null && !"".equals(properties.get("messageref"))) {
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "msgref", false, false);
                    EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("messageref"));
                    ((MessageEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
                }
            } else if (ed instanceof CompensateEventDefinition && properties.get("activityref") != null && !"".equals(properties.get("activityref"))) {
                metadata = ExtendedMetaData.INSTANCE;
                extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "actrefname", false, false);
                EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("activityref"));
                ((CompensateEventDefinition)event.getEventDefinitions().get(0)).getAnyAttribute().add((Object)extensionEntry);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (properties.get("distributiontype") != null && properties.get("distributiontype").length() > 0) {
            TimeParameters timeParams = BpsimFactory.eINSTANCE.createTimeParameters();
            Parameter processingTimeParam = BpsimFactory.eINSTANCE.createParameter();
            if (properties.get("distributiontype").equals("normal")) {
                NormalDistributionType normalDistributionType = BpsimFactory.eINSTANCE.createNormalDistributionType();
                normalDistributionType.setStandardDeviation(Double.valueOf(properties.get("standarddeviation")).doubleValue());
                normalDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)normalDistributionType);
            } else if (properties.get("distributiontype").equals("uniform")) {
                UniformDistributionType uniformDistributionType = BpsimFactory.eINSTANCE.createUniformDistributionType();
                uniformDistributionType.setMax(Double.valueOf(properties.get("max")).doubleValue());
                uniformDistributionType.setMin(Double.valueOf(properties.get("min")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)uniformDistributionType);
            } else if (properties.get("distributiontype").equals("poisson")) {
                PoissonDistributionType poissonDistributionType = BpsimFactory.eINSTANCE.createPoissonDistributionType();
                poissonDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)poissonDistributionType);
            }
            timeParams.setProcessingTime(processingTimeParam);
            if (this._simulationElementParameters.containsKey(event.getId())) {
                this._simulationElementParameters.get(event.getId()).add((EObject)timeParams);
            } else {
                ArrayList<TimeParameters> values = new ArrayList<TimeParameters>();
                values.add(timeParams);
                this._simulationElementParameters.put(event.getId(), values);
            }
        }
    }

    protected void applyGlobalTaskProperties(GlobalTask globalTask, Map<String, String> properties) {
        if (properties.get("name") != null) {
            globalTask.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        } else {
            globalTask.setName("");
        }
    }

    protected void applyBaseElementProperties(BaseElement baseElement, Map<String, String> properties) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        if (properties.get("documentation") != null && !"".equals(properties.get("documentation"))) {
            if (baseElement instanceof Definitions) {
                this.processDocs = properties.get("documentation");
            } else {
                baseElement.getDocumentation().add(this.createDocumentation(this.wrapInCDATABlock(properties.get("documentation"))));
            }
        }
        if (baseElement.getId() == null || baseElement.getId().length() < 1) {
            baseElement.setId(properties.get("resourceId"));
        }
        if (properties.get("bgcolor") != null && properties.get("bgcolor").length() > 0 && !properties.get("bgcolor").equals(defaultBgColor)) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "bgcolor", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("bgcolor"));
            baseElement.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("isselectable") != null && properties.get("isselectable").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "selectable", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("isselectable"));
            baseElement.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("bordercolor") != null && properties.get("bordercolor").length() > 0 && !properties.get("bordercolor").equals("#000000")) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "bordercolor", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("bordercolor"));
            baseElement.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("fontsize") != null && properties.get("fontsize").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "fontsize", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("fontsize"));
            baseElement.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("fontcolor") != null && properties.get("fontcolor").length() > 0 && !properties.get("fontcolor").equals("#000000")) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "fontcolor", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("fontcolor"));
            baseElement.getAnyAttribute().add((Object)extensionEntry);
        }
    }

    protected void applyDefinitionProperties(Definitions def, Map<String, String> properties) {
        def.setTypeLanguage(properties.get("typelanguage"));
        def.setTargetNamespace("http://www.omg.org/bpmn20");
        def.setExpressionLanguage(properties.get("expressionlanguage"));
        ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
        EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("xsi", "schemaLocation", false, false);
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd http://www.jboss.org/drools drools.xsd http://www.bpsim.org/schemas/1.0 bpsim.xsd");
        def.getAnyAttribute().add((Object)extensionEntry);
    }

    protected void applyProcessProperties(Process process, Map<String, String> properties) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry;
        ExtensionAttributeValue extensionElement;
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        if (properties.get("processn") != null) {
            process.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("processn")));
        } else {
            process.setName("");
        }
        if (properties.get("auditing") != null && !"".equals(properties.get("auditing"))) {
            Auditing audit = Bpmn2Factory.eINSTANCE.createAuditing();
            audit.getDocumentation().add(this.createDocumentation(properties.get("auditing")));
            process.setAuditing(audit);
        }
        process.setProcessType(ProcessType.getByName((String)properties.get("processtype")));
        process.setIsClosed(Boolean.parseBoolean(properties.get("isclosed")));
        process.setIsExecutable(Boolean.parseBoolean(properties.get("executable")));
        if (properties.get("package") != null && properties.get("package").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "packageName", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("package"));
            process.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("version") != null && properties.get("version").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "version", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("version"));
            process.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("monitoring") != null && !"".equals(properties.get("monitoring"))) {
            Monitoring monitoring = Bpmn2Factory.eINSTANCE.createMonitoring();
            monitoring.getDocumentation().add(this.createDocumentation(properties.get("monitoring")));
            process.setMonitoring(monitoring);
        }
        if (properties.get("imports") != null && properties.get("imports").length() > 0) {
            String[] allImports;
            for (String importStr : allImports = properties.get("imports").split(",\\s*")) {
                ImportType importType;
                String[] importParts = importStr.split("\\|\\s*");
                if (importParts.length == 2 || importParts.length == 3) {
                    if (importParts[1] != null && importParts[1].equals("default")) {
                        importType = DroolsFactory.eINSTANCE.createImportType();
                        importType.setName(importParts[0]);
                        if (process.getExtensionValues() == null || process.getExtensionValues().size() < 1) {
                            extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                            process.getExtensionValues().add(extensionElement);
                        }
                        extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__IMPORT, (Object)importType);
                        ((ExtensionAttributeValue)process.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
                        continue;
                    }
                    Import imp = Bpmn2Factory.eINSTANCE.createImport();
                    imp.setImportType("http://schemas.xmlsoap.org/wsdl/");
                    imp.setLocation(importParts[0]);
                    imp.setNamespace(importParts[1]);
                    this._wsdlImports.add(imp);
                    continue;
                }
                importType = DroolsFactory.eINSTANCE.createImportType();
                importType.setName(importStr);
                if (process.getExtensionValues() == null || process.getExtensionValues().size() < 1) {
                    extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                    process.getExtensionValues().add(extensionElement);
                }
                extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__IMPORT, (Object)importType);
                ((ExtensionAttributeValue)process.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
            }
        }
        if (properties.get("globals") != null && properties.get("globals").length() > 0) {
            String[] allGlobals;
            for (String globalStr : allGlobals = properties.get("globals").split(",\\s*")) {
                GlobalType globalType;
                String[] globalParts = globalStr.split(":\\s*");
                if (globalParts.length == 2) {
                    globalType = DroolsFactory.eINSTANCE.createGlobalType();
                    globalType.setIdentifier(globalParts[0]);
                    globalType.setType(globalParts[1]);
                    if (process.getExtensionValues() == null || process.getExtensionValues().size() < 1) {
                        extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                        process.getExtensionValues().add(extensionElement);
                    }
                    extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__GLOBAL, (Object)globalType);
                    ((ExtensionAttributeValue)process.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
                    continue;
                }
                if (globalParts.length != 1) continue;
                globalType = DroolsFactory.eINSTANCE.createGlobalType();
                globalType.setIdentifier(globalParts[0]);
                globalType.setType("Object");
                if (process.getExtensionValues() == null || process.getExtensionValues().size() < 1) {
                    extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                    process.getExtensionValues().add(extensionElement);
                }
                extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__GLOBAL, (Object)globalType);
                ((ExtensionAttributeValue)process.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
            }
        }
        if (properties.get("timeunit") != null && properties.get("timeunit").length() > 0) {
            this._simulationScenarioParameters.setBaseTimeUnit(TimeUnit.getByName((String)properties.get("timeunit")));
        }
        if (properties.get("currency") != null && properties.get("currency").length() > 0) {
            this._simulationScenarioParameters.setBaseCurrencyUnit(properties.get("currency"));
        }
    }

    protected void applyBusinessRuleTaskProperties(BusinessRuleTask task, Map<String, String> properties) {
        if (properties.get("name") != null) {
            task.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        } else {
            task.setName("");
        }
        if (properties.get("ruleflowgroup") != null && properties.get("ruleflowgroup").length() > 0) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "ruleFlowGroup", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("ruleflowgroup"));
            task.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("script_language") != null && properties.get("script_language").length() > 0) {
            String scriptLanguage = properties.get("script_language").equals("java") ? "http://www.java.com/java" : (properties.get("script_language").equals("mvel") ? "http://www.mvel.org/2.0" : "http://www.java.com/java");
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl scriptLanguageElement = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "scriptFormat", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)scriptLanguageElement, (Object)scriptLanguage);
            task.getAnyAttribute().add((Object)extensionEntry);
        }
    }

    protected void applyScriptTaskProperties(ScriptTask scriptTask, Map<String, String> properties) {
        if (properties.get("name") != null) {
            scriptTask.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        } else {
            scriptTask.setName("");
        }
        if (properties.get("script") != null && properties.get("script").length() > 0) {
            String scriptStr = properties.get("script").replaceAll("\\\\n", "\n");
            scriptTask.setScript(this.wrapInCDATABlock(scriptStr));
        }
        if (properties.get("script_language") != null && properties.get("script_language").length() > 0) {
            String scriptLanguage = properties.get("script_language").equals("java") ? "http://www.java.com/java" : (properties.get("script_language").equals("mvel") ? "http://www.mvel.org/2.0" : "http://www.java.com/java");
            scriptTask.setScriptFormat(scriptLanguage);
        }
    }

    public void applyServiceTaskProperties(ServiceTask serviceTask, Map<String, String> properties) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        if (properties.get("serviceimplementation") != null) {
            serviceTask.setImplementation(properties.get("serviceimplementation"));
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "serviceimplementation", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("serviceimplementation"));
            serviceTask.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("serviceoperation") != null) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "serviceoperation", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("serviceoperation"));
            serviceTask.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("serviceinterface") != null) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "serviceinterface", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("serviceinterface"));
            serviceTask.getAnyAttribute().add((Object)extensionEntry);
        }
    }

    public void applyReceiveTaskProperties(ReceiveTask receiveTask, Map<String, String> properties) {
        if (properties.get("messageref") != null && properties.get("messageref").length() > 0) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "msgref", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("messageref"));
            receiveTask.getAnyAttribute().add((Object)extensionEntry);
        }
        receiveTask.setImplementation("Other");
    }

    public void applySendTaskProperties(SendTask sendTask, Map<String, String> properties) {
        if (properties.get("messageref") != null && properties.get("messageref").length() > 0) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "msgref", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("messageref"));
            sendTask.getAnyAttribute().add((Object)extensionEntry);
        }
        sendTask.setImplementation("Other");
    }

    protected void applyLaneProperties(Lane lane, Map<String, String> properties) {
        if (properties.get("name") != null) {
            lane.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        } else {
            lane.setName("");
        }
    }

    protected void applyCallActivityProperties(CallActivity callActivity, Map<String, String> properties) {
        String[] allActions;
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        InputOutputSpecification iospec;
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry2;
        EAttributeImpl extensionAttribute2;
        ExtendedMetaData metadata2;
        if (properties.get("name") != null) {
            callActivity.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        } else {
            callActivity.setName("");
        }
        if (properties.get("independent") != null && properties.get("independent").length() > 0) {
            metadata2 = ExtendedMetaData.INSTANCE;
            extensionAttribute2 = (EAttributeImpl)metadata2.demandFeature("http://www.jboss.org/drools", "independent", false, false);
            extensionEntry2 = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute2, (Object)properties.get("independent"));
            callActivity.getAnyAttribute().add((Object)extensionEntry2);
        }
        if (properties.get("waitforcompletion") != null && properties.get("waitforcompletion").length() > 0) {
            metadata2 = ExtendedMetaData.INSTANCE;
            extensionAttribute2 = (EAttributeImpl)metadata2.demandFeature("http://www.jboss.org/drools", "waitForCompletion", false, false);
            extensionEntry2 = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute2, (Object)properties.get("waitforcompletion"));
            callActivity.getAnyAttribute().add((Object)extensionEntry2);
        }
        if (properties.get("calledelement") != null && properties.get("calledelement").length() > 0) {
            callActivity.setCalledElement(properties.get("calledelement"));
        }
        if (properties.get("datainputset") != null && properties.get("datainputset").trim().length() > 0) {
            String[] allDataInputs = properties.get("datainputset").split(",\\s*");
            if (callActivity.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                callActivity.setIoSpecification(iospec);
            }
            InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
            for (String dataInput : allDataInputs) {
                if (dataInput.trim().length() <= 0) continue;
                DataInput nextInput = Bpmn2Factory.eINSTANCE.createDataInput();
                String[] dataInputParts = dataInput.split(":\\s*");
                if (dataInputParts.length == 2) {
                    nextInput.setId(callActivity.getId() + "_" + dataInputParts[0] + "InputX");
                    nextInput.setName(dataInputParts[0]);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)dataInputParts[1]);
                    nextInput.getAnyAttribute().add((Object)extensionEntry);
                } else {
                    nextInput.setId(callActivity.getId() + "_" + dataInput + "InputX");
                    nextInput.setName(dataInput);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)"Object");
                    nextInput.getAnyAttribute().add((Object)extensionEntry);
                }
                callActivity.getIoSpecification().getDataInputs().add(nextInput);
                inset.getDataInputRefs().add(nextInput);
            }
            callActivity.getIoSpecification().getInputSets().add(inset);
        } else if (callActivity.getIoSpecification() != null) {
            callActivity.getIoSpecification().getInputSets().add(Bpmn2Factory.eINSTANCE.createInputSet());
        }
        if (properties.get("dataoutputset") != null && properties.get("dataoutputset").trim().length() > 0) {
            String[] allDataOutputs = properties.get("dataoutputset").split(",\\s*");
            if (callActivity.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                callActivity.setIoSpecification(iospec);
            }
            OutputSet outset = Bpmn2Factory.eINSTANCE.createOutputSet();
            for (String dataOutput : allDataOutputs) {
                if (dataOutput.trim().length() <= 0) continue;
                DataOutput nextOut = Bpmn2Factory.eINSTANCE.createDataOutput();
                String[] dataOutputParts = dataOutput.split(":\\s*");
                if (dataOutputParts.length == 2) {
                    nextOut.setId(callActivity.getId() + "_" + dataOutputParts[0] + "OutputX");
                    nextOut.setName(dataOutputParts[0]);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)dataOutputParts[1]);
                    nextOut.getAnyAttribute().add((Object)extensionEntry);
                } else {
                    nextOut.setId(callActivity.getId() + "_" + dataOutput + "OutputX");
                    nextOut.setName(dataOutput);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)"Object");
                    nextOut.getAnyAttribute().add((Object)extensionEntry);
                }
                callActivity.getIoSpecification().getDataOutputs().add(nextOut);
                outset.getDataOutputRefs().add(nextOut);
            }
            callActivity.getIoSpecification().getOutputSets().add(outset);
        } else if (callActivity.getIoSpecification() != null) {
            callActivity.getIoSpecification().getOutputSets().add(Bpmn2Factory.eINSTANCE.createOutputSet());
        }
        if (properties.get("assignments") != null && properties.get("assignments").length() > 0) {
            String[] allAssignments;
            for (String assignment : allAssignments = properties.get("assignments").split(",\\s*")) {
                ItemAwareElement ie;
                String[] assignmentParts;
                if (assignment.contains("=")) {
                    assignmentParts = assignment.split("=\\s*");
                    DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                    boolean foundTaskName = false;
                    if (callActivity.getIoSpecification() != null && callActivity.getIoSpecification().getDataOutputs() != null) {
                        List dataInputs = callActivity.getIoSpecification().getDataInputs();
                        for (DataInput di : dataInputs) {
                            if (!di.getId().equals(callActivity.getId() + "_" + assignmentParts[0] + "InputX")) continue;
                            dia.setTargetRef((ItemAwareElement)di);
                            if (!di.getName().equals("TaskName")) continue;
                            foundTaskName = true;
                            break;
                        }
                    }
                    Assignment a = Bpmn2Factory.eINSTANCE.createAssignment();
                    FormalExpression fromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    if (assignmentParts.length > 1) {
                        String replacer = assignmentParts[1].replaceAll("##", ",");
                        replacer = replacer.replaceAll("\\|\\|", "=");
                        fromExpression.setBody(this.wrapInCDATABlock(replacer));
                    } else {
                        fromExpression.setBody("");
                    }
                    FormalExpression toExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    toExpression.setBody(dia.getTargetRef().getId());
                    a.setFrom((Expression)fromExpression);
                    a.setTo((Expression)toExpression);
                    dia.getAssignment().add(a);
                    callActivity.getDataInputAssociations().add(dia);
                    continue;
                }
                if (assignment.contains("<->")) {
                    assignmentParts = assignment.split("<->\\s*");
                    DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                    DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                    ItemAwareElement ie2 = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                    ie2.setId(assignmentParts[0]);
                    dia.getSourceRef().add(ie2);
                    doa.setTargetRef(ie2);
                    List dataInputs = callActivity.getIoSpecification().getDataInputs();
                    for (DataInput di : dataInputs) {
                        if (!di.getId().equals(callActivity.getId() + "_" + assignmentParts[1] + "InputX")) continue;
                        dia.setTargetRef((ItemAwareElement)di);
                        break;
                    }
                    List dataOutputs = callActivity.getIoSpecification().getDataOutputs();
                    for (DataOutput dout : dataOutputs) {
                        if (!dout.getId().equals(callActivity.getId() + "_" + assignmentParts[1] + "OutputX")) continue;
                        doa.getSourceRef().add(dout);
                        break;
                    }
                    callActivity.getDataInputAssociations().add(dia);
                    callActivity.getDataOutputAssociations().add(doa);
                    continue;
                }
                if (!assignment.contains("->")) continue;
                assignmentParts = assignment.split("->\\s*");
                boolean leftHandAssignMentIsDO = false;
                List dataOutputs = callActivity.getIoSpecification().getDataOutputs();
                for (DataOutput dout : dataOutputs) {
                    if (!dout.getId().equals(callActivity.getId() + "_" + assignmentParts[0] + "OutputX")) continue;
                    leftHandAssignMentIsDO = true;
                    break;
                }
                if (leftHandAssignMentIsDO) {
                    DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                    for (DataOutput dout : dataOutputs) {
                        if (!dout.getId().equals(callActivity.getId() + "_" + assignmentParts[0] + "OutputX")) continue;
                        doa.getSourceRef().add(dout);
                        break;
                    }
                    ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                    ie.setId(assignmentParts[1]);
                    doa.setTargetRef(ie);
                    callActivity.getDataOutputAssociations().add(doa);
                    continue;
                }
                DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                ie.setId(assignmentParts[0]);
                dia.getSourceRef().add(ie);
                List dataInputs = callActivity.getIoSpecification().getDataInputs();
                for (DataInput di : dataInputs) {
                    if (!di.getId().equals(callActivity.getId() + "_" + assignmentParts[1] + "InputX")) continue;
                    dia.setTargetRef((ItemAwareElement)di);
                    break;
                }
                callActivity.getDataInputAssociations().add(dia);
            }
        }
        if (properties.get("onentryactions") != null && properties.get("onentryactions").length() > 0) {
            for (String action : allActions = properties.get("onentryactions").split("\\|\\s*")) {
                OnEntryScriptType onEntryScript = DroolsFactory.eINSTANCE.createOnEntryScriptType();
                onEntryScript.setScript(this.wrapInCDATABlock(action));
                String scriptLanguage = "";
                scriptLanguage = properties.get("script_language").equals("java") ? "http://www.java.com/java" : (properties.get("script_language").equals("mvel") ? "http://www.mvel.org/2.0" : "http://www.java.com/java");
                onEntryScript.setScriptFormat(scriptLanguage);
                if (callActivity.getExtensionValues() == null || callActivity.getExtensionValues().size() < 1) {
                    ExtensionAttributeValue extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                    callActivity.getExtensionValues().add(extensionElement);
                }
                EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__ON_ENTRY_SCRIPT, (Object)onEntryScript);
                ((ExtensionAttributeValue)callActivity.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
            }
        }
        if (properties.get("onexitactions") != null && properties.get("onexitactions").length() > 0) {
            for (String action : allActions = properties.get("onexitactions").split("\\|\\s*")) {
                OnExitScriptType onExitScript = DroolsFactory.eINSTANCE.createOnExitScriptType();
                onExitScript.setScript(this.wrapInCDATABlock(action));
                String scriptLanguage = "";
                scriptLanguage = properties.get("script_language").equals("java") ? "http://www.java.com/java" : (properties.get("script_language").equals("mvel") ? "http://www.mvel.org/2.0" : "http://www.java.com/java");
                onExitScript.setScriptFormat(scriptLanguage);
                if (callActivity.getExtensionValues() == null || callActivity.getExtensionValues().size() < 1) {
                    ExtensionAttributeValue extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                    callActivity.getExtensionValues().add(extensionElement);
                }
                EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__ON_EXIT_SCRIPT, (Object)onExitScript);
                ((ExtensionAttributeValue)callActivity.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
            }
        }
        if (properties.get("distributiontype") != null && properties.get("distributiontype").length() > 0) {
            TimeParameters timeParams = BpsimFactory.eINSTANCE.createTimeParameters();
            Parameter processingTimeParam = BpsimFactory.eINSTANCE.createParameter();
            if (properties.get("distributiontype").equals("normal")) {
                NormalDistributionType normalDistributionType = BpsimFactory.eINSTANCE.createNormalDistributionType();
                normalDistributionType.setStandardDeviation(Double.valueOf(properties.get("standarddeviation")).doubleValue());
                normalDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)normalDistributionType);
            } else if (properties.get("distributiontype").equals("uniform")) {
                UniformDistributionType uniformDistributionType = BpsimFactory.eINSTANCE.createUniformDistributionType();
                uniformDistributionType.setMax(Double.valueOf(properties.get("max")).doubleValue());
                uniformDistributionType.setMin(Double.valueOf(properties.get("min")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)uniformDistributionType);
            } else if (properties.get("distributiontype").equals("poisson")) {
                PoissonDistributionType poissonDistributionType = BpsimFactory.eINSTANCE.createPoissonDistributionType();
                poissonDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)poissonDistributionType);
            }
            if (properties.get("waittime") != null) {
                Parameter waittimeParam = BpsimFactory.eINSTANCE.createParameter();
                FloatingParameterType waittimeParamValue = BpsimFactory.eINSTANCE.createFloatingParameterType();
                DecimalFormat twoDForm = new DecimalFormat("#.##");
                waittimeParamValue.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("waittime")))).doubleValue());
                waittimeParam.getParameterValue().add((Object)waittimeParamValue);
                timeParams.setWaitTime(waittimeParam);
            }
            timeParams.setProcessingTime(processingTimeParam);
            if (this._simulationElementParameters.containsKey(callActivity.getId())) {
                this._simulationElementParameters.get(callActivity.getId()).add((EObject)timeParams);
            } else {
                ArrayList<TimeParameters> values = new ArrayList<TimeParameters>();
                values.add(timeParams);
                this._simulationElementParameters.put(callActivity.getId(), values);
            }
        }
        CostParameters costParameters = BpsimFactory.eINSTANCE.createCostParameters();
        if (properties.get("unitcost") != null && properties.get("unitcost").length() > 0) {
            Parameter unitcostParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType unitCostParameterValue = BpsimFactory.eINSTANCE.createFloatingParameterType();
            unitCostParameterValue.setValue(new Double(properties.get("unitcost")).doubleValue());
            unitcostParam.getParameterValue().add((Object)unitCostParameterValue);
            costParameters.setUnitCost(unitcostParam);
        }
        if (this._simulationElementParameters.containsKey(callActivity.getId())) {
            this._simulationElementParameters.get(callActivity.getId()).add((EObject)costParameters);
        } else {
            ArrayList<CostParameters> values = new ArrayList<CostParameters>();
            values.add(costParameters);
            this._simulationElementParameters.put(callActivity.getId(), values);
        }
    }

    protected void applyTaskProperties(Task task, Map<String, String> properties, String preProcessingData) {
        String[] allActions;
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        InputOutputSpecification iospec;
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry2;
        EAttributeImpl extensionAttribute2;
        ExtendedMetaData metadata2;
        if (properties.get("name") != null) {
            task.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        } else {
            task.setName("");
        }
        DataInput taskNameDataInput = null;
        if (properties.get("taskname") != null && properties.get("taskname").length() > 0) {
            if (this.isCustomElement(properties.get("tasktype"), preProcessingData)) {
                metadata2 = ExtendedMetaData.INSTANCE;
                extensionAttribute2 = (EAttributeImpl)metadata2.demandFeature("http://www.jboss.org/drools", "taskName", false, false);
                extensionEntry2 = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute2, (Object)properties.get("taskname").replaceAll("&", "").replaceAll(" ", ""));
                task.getAnyAttribute().add((Object)extensionEntry2);
            }
            taskNameDataInput = Bpmn2Factory.eINSTANCE.createDataInput();
            taskNameDataInput.setId(task.getId() + "_TaskNameInputX");
            taskNameDataInput.setName("TaskName");
            if (task.getIoSpecification() == null) {
                InputOutputSpecification iospec2 = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec2);
            }
            task.getIoSpecification().getDataInputs().add(taskNameDataInput);
            DataInputAssociation taskNameDataInputAssociation = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
            taskNameDataInputAssociation.setTargetRef((ItemAwareElement)taskNameDataInput);
            Assignment taskNameAssignment = Bpmn2Factory.eINSTANCE.createAssignment();
            FormalExpression fromExp = Bpmn2Factory.eINSTANCE.createFormalExpression();
            fromExp.setBody(properties.get("taskname").replaceAll("&", "").replaceAll(" ", ""));
            taskNameAssignment.setFrom((Expression)fromExp);
            FormalExpression toExp = Bpmn2Factory.eINSTANCE.createFormalExpression();
            toExp.setBody(task.getId() + "_TaskNameInputX");
            taskNameAssignment.setTo((Expression)toExp);
            taskNameDataInputAssociation.getAssignment().add(taskNameAssignment);
            task.getDataInputAssociations().add(taskNameDataInputAssociation);
        }
        if (properties.get("lanes") != null && properties.get("lanes").length() > 0) {
            metadata2 = ExtendedMetaData.INSTANCE;
            extensionAttribute2 = (EAttributeImpl)metadata2.demandFeature("http://www.jboss.org/drools", "lanes", false, false);
            extensionEntry2 = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute2, (Object)properties.get("lanes"));
            task.getAnyAttribute().add((Object)extensionEntry2);
        }
        if (properties.get("datainputset") != null && properties.get("datainputset").trim().length() > 0) {
            String[] allDataInputs = properties.get("datainputset").split(",\\s*");
            if (task.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            InputSet inset = Bpmn2Factory.eINSTANCE.createInputSet();
            for (String dataInput : allDataInputs) {
                if (dataInput.trim().length() <= 0) continue;
                DataInput nextInput = Bpmn2Factory.eINSTANCE.createDataInput();
                String[] dataInputParts = dataInput.split(":\\s*");
                if (dataInputParts.length == 2) {
                    nextInput.setId(task.getId() + "_" + dataInputParts[0] + (dataInputParts[0].endsWith("InputX") ? "" : "InputX"));
                    nextInput.setName(dataInputParts[0]);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)dataInputParts[1]);
                    nextInput.getAnyAttribute().add((Object)extensionEntry);
                } else {
                    nextInput.setId(task.getId() + "_" + dataInput + (dataInput.endsWith("InputX") ? "" : "InputX"));
                    nextInput.setName(dataInput);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)"Object");
                    nextInput.getAnyAttribute().add((Object)extensionEntry);
                }
                task.getIoSpecification().getDataInputs().add(nextInput);
                inset.getDataInputRefs().add(nextInput);
            }
            if (taskNameDataInput != null) {
                inset.getDataInputRefs().add(taskNameDataInput);
            }
            task.getIoSpecification().getInputSets().add(inset);
        } else if (task.getIoSpecification() != null) {
            task.getIoSpecification().getInputSets().add(Bpmn2Factory.eINSTANCE.createInputSet());
        }
        if (properties.get("dataoutputset") != null && properties.get("dataoutputset").trim().length() > 0) {
            String[] allDataOutputs = properties.get("dataoutputset").split(",\\s*");
            if (task.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            OutputSet outset = Bpmn2Factory.eINSTANCE.createOutputSet();
            for (String dataOutput : allDataOutputs) {
                if (dataOutput.trim().length() <= 0) continue;
                DataOutput nextOut = Bpmn2Factory.eINSTANCE.createDataOutput();
                String[] dataOutputParts = dataOutput.split(":\\s*");
                if (dataOutputParts.length == 2) {
                    nextOut.setId(task.getId() + "_" + dataOutputParts[0] + (dataOutputParts[0].endsWith("OutputX") ? "" : "OutputX"));
                    nextOut.setName(dataOutputParts[0]);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)dataOutputParts[1]);
                    nextOut.getAnyAttribute().add((Object)extensionEntry);
                } else {
                    nextOut.setId(task.getId() + "_" + dataOutput + (dataOutput.endsWith("OutputX") ? "" : "OutputX"));
                    nextOut.setName(dataOutput);
                    metadata = ExtendedMetaData.INSTANCE;
                    extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dtype", false, false);
                    extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)"Object");
                    nextOut.getAnyAttribute().add((Object)extensionEntry);
                }
                task.getIoSpecification().getDataOutputs().add(nextOut);
                outset.getDataOutputRefs().add(nextOut);
            }
            task.getIoSpecification().getOutputSets().add(outset);
        } else if (task.getIoSpecification() != null) {
            task.getIoSpecification().getOutputSets().add(Bpmn2Factory.eINSTANCE.createOutputSet());
        }
        if (properties.get("assignments") != null && properties.get("assignments").length() > 0) {
            String[] allAssignments;
            for (String assignment : allAssignments = properties.get("assignments").split(",\\s*")) {
                ItemAwareElement ie;
                String[] assignmentParts;
                if (assignment.contains("=")) {
                    assignmentParts = assignment.split("=\\s*");
                    DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                    boolean foundTaskName = false;
                    if (task.getIoSpecification() != null && task.getIoSpecification().getDataOutputs() != null) {
                        List dataInputs = task.getIoSpecification().getDataInputs();
                        for (DataInput di : dataInputs) {
                            if (!di.getId().equals(task.getId() + "_" + assignmentParts[0] + (assignmentParts[0].endsWith("InputX") ? "" : "InputX"))) continue;
                            dia.setTargetRef((ItemAwareElement)di);
                            if (!di.getName().equals("TaskName")) continue;
                            foundTaskName = true;
                            break;
                        }
                    }
                    if (assignmentParts[0].equals("TaskName") && !foundTaskName) {
                        DataInput assignmentTaskNameDataInput = Bpmn2Factory.eINSTANCE.createDataInput();
                        assignmentTaskNameDataInput.setId(task.getId() + "_TaskNameInputX");
                        assignmentTaskNameDataInput.setName("TaskName");
                        if (task.getIoSpecification() == null) {
                            InputOutputSpecification iospec3 = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                            task.setIoSpecification(iospec3);
                        }
                        task.getIoSpecification().getDataInputs().add(assignmentTaskNameDataInput);
                        dia.setTargetRef((ItemAwareElement)assignmentTaskNameDataInput);
                        InputSet inset = (InputSet)task.getIoSpecification().getInputSets().get(0);
                        inset.getDataInputRefs().add(assignmentTaskNameDataInput);
                    }
                    Assignment a = Bpmn2Factory.eINSTANCE.createAssignment();
                    FormalExpression fromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    if (assignmentParts.length > 1) {
                        String replacer = assignmentParts[1].replaceAll("##", ",");
                        replacer = replacer.replaceAll("\\|\\|", "=");
                        fromExpression.setBody(this.wrapInCDATABlock(replacer));
                    } else {
                        fromExpression.setBody("");
                    }
                    FormalExpression toExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                    toExpression.setBody(dia.getTargetRef().getId());
                    a.setFrom((Expression)fromExpression);
                    a.setTo((Expression)toExpression);
                    dia.getAssignment().add(a);
                    task.getDataInputAssociations().add(dia);
                    continue;
                }
                if (assignment.contains("<->")) {
                    assignmentParts = assignment.split("<->\\s*");
                    DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                    DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                    ItemAwareElement ie2 = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                    ie2.setId(assignmentParts[0]);
                    dia.getSourceRef().add(ie2);
                    doa.setTargetRef(ie2);
                    List dataInputs = task.getIoSpecification().getDataInputs();
                    for (DataInput di : dataInputs) {
                        if (!di.getId().equals(task.getId() + "_" + assignmentParts[1] + (assignmentParts[1].endsWith("InputX") ? "" : "InputX"))) continue;
                        dia.setTargetRef((ItemAwareElement)di);
                        break;
                    }
                    List dataOutputs = task.getIoSpecification().getDataOutputs();
                    for (DataOutput dout : dataOutputs) {
                        if (!dout.getId().equals(task.getId() + "_" + assignmentParts[1] + (assignmentParts[1].endsWith("OutputX") ? "" : "OutputX"))) continue;
                        doa.getSourceRef().add(dout);
                        break;
                    }
                    task.getDataInputAssociations().add(dia);
                    task.getDataOutputAssociations().add(doa);
                    continue;
                }
                if (!assignment.contains("->")) continue;
                assignmentParts = assignment.split("->\\s*");
                boolean leftHandAssignMentIsDO = false;
                List dataOutputs = task.getIoSpecification().getDataOutputs();
                for (DataOutput dout : dataOutputs) {
                    if (!dout.getId().equals(task.getId() + "_" + assignmentParts[0] + (assignmentParts[0].endsWith("OutputX") ? "" : "OutputX"))) continue;
                    leftHandAssignMentIsDO = true;
                    break;
                }
                if (leftHandAssignMentIsDO) {
                    DataOutputAssociation doa = Bpmn2Factory.eINSTANCE.createDataOutputAssociation();
                    for (DataOutput dout : dataOutputs) {
                        if (!dout.getId().equals(task.getId() + "_" + assignmentParts[0] + (assignmentParts[0].endsWith("OutputX") ? "" : "OutputX"))) continue;
                        doa.getSourceRef().add(dout);
                        break;
                    }
                    ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                    ie.setId(assignmentParts[1]);
                    doa.setTargetRef(ie);
                    task.getDataOutputAssociations().add(doa);
                    continue;
                }
                DataInputAssociation dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                ie = Bpmn2Factory.eINSTANCE.createItemAwareElement();
                ie.setId(assignmentParts[0]);
                dia.getSourceRef().add(ie);
                List dataInputs = task.getIoSpecification().getDataInputs();
                for (DataInput di : dataInputs) {
                    if (!di.getId().equals(task.getId() + "_" + assignmentParts[1] + (assignmentParts[1].endsWith("InputX") ? "" : "InputX"))) continue;
                    dia.setTargetRef((ItemAwareElement)di);
                    break;
                }
                task.getDataInputAssociations().add(dia);
            }
            List dataInputAssociations = task.getDataInputAssociations();
            boolean haveTaskNameInput = false;
            Iterator itr = dataInputAssociations.iterator();
            while (itr.hasNext()) {
                Assignment a;
                DataInputAssociation da = (DataInputAssociation)itr.next();
                if (da.getAssignment() == null || da.getAssignment().size() <= 0 || !((FormalExpression)(a = (Assignment)da.getAssignment().get(0)).getTo()).getBody().equals(task.getId() + "_TaskNameInputX")) continue;
                if (!haveTaskNameInput) {
                    haveTaskNameInput = true;
                    continue;
                }
                itr.remove();
            }
        }
        if (properties.get("onentryactions") != null && properties.get("onentryactions").length() > 0) {
            for (String action : allActions = properties.get("onentryactions").split("\\|\\s*")) {
                OnEntryScriptType onEntryScript = DroolsFactory.eINSTANCE.createOnEntryScriptType();
                onEntryScript.setScript(this.wrapInCDATABlock(action));
                String scriptLanguage = "";
                scriptLanguage = properties.get("script_language").equals("java") ? "http://www.java.com/java" : (properties.get("script_language").equals("mvel") ? "http://www.mvel.org/2.0" : "http://www.java.com/java");
                onEntryScript.setScriptFormat(scriptLanguage);
                if (task.getExtensionValues() == null || task.getExtensionValues().size() < 1) {
                    ExtensionAttributeValue extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                    task.getExtensionValues().add(extensionElement);
                }
                EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__ON_ENTRY_SCRIPT, (Object)onEntryScript);
                ((ExtensionAttributeValue)task.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
            }
        }
        if (properties.get("onexitactions") != null && properties.get("onexitactions").length() > 0) {
            for (String action : allActions = properties.get("onexitactions").split("\\|\\s*")) {
                OnExitScriptType onExitScript = DroolsFactory.eINSTANCE.createOnExitScriptType();
                onExitScript.setScript(this.wrapInCDATABlock(action));
                String scriptLanguage = properties.get("script_language").equals("java") ? "http://www.java.com/java" : (properties.get("script_language").equals("mvel") ? "http://www.mvel.org/2.0" : "http://www.java.com/java");
                onExitScript.setScriptFormat(scriptLanguage);
                if (task.getExtensionValues() == null || task.getExtensionValues().size() < 1) {
                    ExtensionAttributeValue extensionElement = Bpmn2Factory.eINSTANCE.createExtensionAttributeValue();
                    task.getExtensionValues().add(extensionElement);
                }
                EStructuralFeatureImpl.SimpleFeatureMapEntry extensionElementEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)DroolsPackage.Literals.DOCUMENT_ROOT__ON_EXIT_SCRIPT, (Object)onExitScript);
                ((ExtensionAttributeValue)task.getExtensionValues().get(0)).getValue().add((Object)extensionElementEntry);
            }
        }
        if (properties.get("multipleinstance") != null && properties.get("multipleinstance").length() > 0 && properties.get("multipleinstance").equals("true")) {
            metadata2 = ExtendedMetaData.INSTANCE;
            extensionAttribute2 = (EAttributeImpl)metadata2.demandFeature("http://www.jboss.org/drools", "mitask", false, false);
            StringBuffer buff = new StringBuffer();
            buff.append(properties.get("multipleinstancecollectioninput") != null && properties.get("multipleinstancecollectioninput").length() > 0 ? properties.get("multipleinstancecollectioninput") : " ");
            buff.append("@");
            buff.append(properties.get("multipleinstancecollectionoutput") != null && properties.get("multipleinstancecollectionoutput").length() > 0 ? properties.get("multipleinstancecollectionoutput") : " ");
            buff.append("@");
            buff.append(properties.get("multipleinstancedatainput") != null && properties.get("multipleinstancedatainput").length() > 0 ? properties.get("multipleinstancedatainput") : " ");
            buff.append("@");
            buff.append(properties.get("multipleinstancedataoutput") != null && properties.get("multipleinstancedataoutput").length() > 0 ? properties.get("multipleinstancedataoutput") : " ");
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry3 = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute2, (Object)buff.toString());
            task.getAnyAttribute().add((Object)extensionEntry3);
        }
        if (properties.get("distributiontype") != null && properties.get("distributiontype").length() > 0) {
            TimeParameters timeParams = BpsimFactory.eINSTANCE.createTimeParameters();
            Parameter processingTimeParam = BpsimFactory.eINSTANCE.createParameter();
            if (properties.get("distributiontype").equals("normal")) {
                NormalDistributionType normalDistributionType = BpsimFactory.eINSTANCE.createNormalDistributionType();
                normalDistributionType.setStandardDeviation(Double.valueOf(properties.get("standarddeviation")).doubleValue());
                normalDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)normalDistributionType);
            } else if (properties.get("distributiontype").equals("uniform")) {
                UniformDistributionType uniformDistributionType = BpsimFactory.eINSTANCE.createUniformDistributionType();
                uniformDistributionType.setMax(Double.valueOf(properties.get("max")).doubleValue());
                uniformDistributionType.setMin(Double.valueOf(properties.get("min")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)uniformDistributionType);
            } else if (properties.get("distributiontype").equals("poisson")) {
                PoissonDistributionType poissonDistributionType = BpsimFactory.eINSTANCE.createPoissonDistributionType();
                poissonDistributionType.setMean(Double.valueOf(properties.get("mean")).doubleValue());
                processingTimeParam.getParameterValue().add((Object)poissonDistributionType);
            }
            if (properties.get("waittime") != null) {
                Parameter waittimeParam = BpsimFactory.eINSTANCE.createParameter();
                FloatingParameterType waittimeParamValue = BpsimFactory.eINSTANCE.createFloatingParameterType();
                DecimalFormat twoDForm = new DecimalFormat("#.##");
                waittimeParamValue.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("waittime")))).doubleValue());
                waittimeParam.getParameterValue().add((Object)waittimeParamValue);
                timeParams.setWaitTime(waittimeParam);
            }
            timeParams.setProcessingTime(processingTimeParam);
            if (this._simulationElementParameters.containsKey(task.getId())) {
                this._simulationElementParameters.get(task.getId()).add((EObject)timeParams);
            } else {
                ArrayList<TimeParameters> values = new ArrayList<TimeParameters>();
                values.add(timeParams);
                this._simulationElementParameters.put(task.getId(), values);
            }
        }
        CostParameters costParameters = BpsimFactory.eINSTANCE.createCostParameters();
        if (properties.get("unitcost") != null && properties.get("unitcost").length() > 0) {
            Parameter unitcostParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType unitCostParameterValue = BpsimFactory.eINSTANCE.createFloatingParameterType();
            unitCostParameterValue.setValue(new Double(properties.get("unitcost")).doubleValue());
            unitcostParam.getParameterValue().add((Object)unitCostParameterValue);
            costParameters.setUnitCost(unitcostParam);
        }
        if (this._simulationElementParameters.containsKey(task.getId())) {
            this._simulationElementParameters.get(task.getId()).add((EObject)costParameters);
        } else {
            ArrayList<CostParameters> values = new ArrayList<CostParameters>();
            values.add(costParameters);
            this._simulationElementParameters.put(task.getId(), values);
        }
    }

    protected void applyUserTaskProperties(UserTask task, Map<String, String> properties) {
        DecimalFormat twoDForm;
        FormalExpression notStartedToExpression;
        FormalExpression notStartedFromExpression;
        FormalExpression notCompletedToExpression;
        FormalExpression notCompletedFromExpression;
        Assignment a;
        DataInputAssociation dia;
        List inputAssociations;
        DataInput foundNotStartedDataInput;
        Assignment a2;
        DataInputAssociation dia2;
        List inputAssociations2;
        InputSet inset;
        List dataInputs;
        InputOutputSpecification iospec;
        if (properties.get("actors") != null && properties.get("actors").length() > 0) {
            String[] allActors;
            for (String actor : allActors = properties.get("actors").split(",\\s*")) {
                PotentialOwner po = Bpmn2Factory.eINSTANCE.createPotentialOwner();
                ResourceAssignmentExpression rae = Bpmn2Factory.eINSTANCE.createResourceAssignmentExpression();
                FormalExpression fe = Bpmn2Factory.eINSTANCE.createFormalExpression();
                fe.setBody(actor);
                rae.setExpression((Expression)fe);
                po.setResourceAssignmentExpression(rae);
                task.getResources().add(po);
            }
        }
        if (properties.get("script_language") != null && properties.get("script_language").length() > 0) {
            String scriptLanguage = properties.get("script_language").equals("java") ? "http://www.java.com/java" : (properties.get("script_language").equals("mvel") ? "http://www.mvel.org/2.0" : "http://www.java.com/java");
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl scriptLanguageElement = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "scriptFormat", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)scriptLanguageElement, (Object)scriptLanguage);
            task.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("groupid") != null && properties.get("groupid").length() > 0) {
            if (task.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundGroupIdInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("GroupId")) continue;
                foundGroupIdInput = true;
                foundInput = din;
                break;
            }
            if (!foundGroupIdInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_" + "GroupId" + "InputX");
                d.setName("GroupId");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundGroupIdAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (!da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundGroupIdAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.wrapInCDATABlock(properties.get("groupid")));
            }
            if (!foundGroupIdAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression groupFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                groupFromExpression.setBody(this.wrapInCDATABlock(properties.get("groupid")));
                FormalExpression groupToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                groupToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)groupFromExpression);
                a2.setTo((Expression)groupToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("skippable") != null && properties.get("skippable").length() > 0) {
            if (task.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundSkippableInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("Skippable")) continue;
                foundSkippableInput = true;
                foundInput = din;
                break;
            }
            if (!foundSkippableInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_" + "Skippable" + "InputX");
                d.setName("Skippable");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundSkippableAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (!da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundSkippableAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(properties.get("skippable"));
            }
            if (!foundSkippableAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression skippableFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                skippableFromExpression.setBody(properties.get("skippable"));
                FormalExpression skippableToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                skippableToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)skippableFromExpression);
                a2.setTo((Expression)skippableToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("comment") != null && properties.get("comment").length() > 0) {
            if (task.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundCommentInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("Comment")) continue;
                foundCommentInput = true;
                foundInput = din;
                break;
            }
            if (!foundCommentInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_" + "Comment" + "InputX");
                d.setName("Comment");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundCommentAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (!da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundCommentAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.wrapInCDATABlock(properties.get("comment")));
            }
            if (!foundCommentAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression commentFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                commentFromExpression.setBody(this.wrapInCDATABlock(properties.get("comment")));
                FormalExpression commentToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                commentToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)commentFromExpression);
                a2.setTo((Expression)commentToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("priority") != null && properties.get("priority").length() > 0) {
            if (task.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundPriorityInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("Priority")) continue;
                foundPriorityInput = true;
                foundInput = din;
                break;
            }
            if (!foundPriorityInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_" + "Priority" + "InputX");
                d.setName("Priority");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundPriorityAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (!da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundPriorityAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(properties.get("priority"));
            }
            if (!foundPriorityAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression priorityFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                priorityFromExpression.setBody(properties.get("priority"));
                FormalExpression priorityToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                priorityToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)priorityFromExpression);
                a2.setTo((Expression)priorityToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("content") != null && properties.get("content").length() > 0) {
            if (task.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                OutputSet outSet = Bpmn2Factory.eINSTANCE.createOutputSet();
                iospec.getOutputSets().add(outSet);
                task.setIoSpecification(iospec);
            }
            dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundContentInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("Content")) continue;
                foundContentInput = true;
                foundInput = din;
                break;
            }
            if (!foundContentInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_" + "Content" + "InputX");
                d.setName("Content");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundContentAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (!da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundContentAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.wrapInCDATABlock(properties.get("content")));
            }
            if (!foundContentAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression contentFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                contentFromExpression.setBody(this.wrapInCDATABlock(properties.get("content")));
                FormalExpression contentToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                contentToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)contentFromExpression);
                a2.setTo((Expression)contentToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("locale") != null && properties.get("locale").length() > 0) {
            if (task.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundLocaleInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("Locale")) continue;
                foundLocaleInput = true;
                foundInput = din;
                break;
            }
            if (!foundLocaleInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_" + "Locale" + "InputX");
                d.setName("Locale");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundLocaleAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (!da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundLocaleAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.wrapInCDATABlock(properties.get("locale")));
            }
            if (!foundLocaleAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression localeFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                localeFromExpression.setBody(this.wrapInCDATABlock(properties.get("locale")));
                FormalExpression localeToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                localeToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)localeFromExpression);
                a2.setTo((Expression)localeToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("createdby") != null && properties.get("createdby").length() > 0) {
            if (task.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundCreatedByInput = false;
            DataInput foundInput = null;
            for (DataInput din : dataInputs) {
                if (!din.getName().equals("CreatedBy")) continue;
                foundCreatedByInput = true;
                foundInput = din;
                break;
            }
            if (!foundCreatedByInput) {
                DataInput d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_" + "CreatedBy" + "InputX");
                d.setName("CreatedBy");
                task.getIoSpecification().getDataInputs().add(d);
                foundInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundCreatedByAssociation = false;
            inputAssociations2 = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations2) {
                if (!da.getTargetRef().getId().equals(foundInput.getId())) continue;
                foundCreatedByAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.wrapInCDATABlock(properties.get("createdby")));
            }
            if (!foundCreatedByAssociation) {
                dia2 = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia2.setTargetRef((ItemAwareElement)foundInput);
                a2 = Bpmn2Factory.eINSTANCE.createAssignment();
                FormalExpression createdByFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                createdByFromExpression.setBody(this.wrapInCDATABlock(properties.get("createdby")));
                FormalExpression createdByToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                createdByToExpression.setBody(foundInput.getId());
                a2.setFrom((Expression)createdByFromExpression);
                a2.setTo((Expression)createdByToExpression);
                dia2.getAssignment().add(a2);
                task.getDataInputAssociations().add(dia2);
            }
        }
        if (properties.get("reassignment") != null && properties.get("reassignment").length() > 0) {
            InputSet inset2;
            DataInput d;
            if (task.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundNotCompletedReassignmentsInput = false;
            boolean foundNotStartedReassignmentsInput = false;
            DataInput foundNotCompletedDataInput = null;
            foundNotStartedDataInput = null;
            for (DataInput din : dataInputs) {
                if (din.getName().equals("NotCompletedReassign")) {
                    foundNotCompletedReassignmentsInput = true;
                    foundNotCompletedDataInput = din;
                }
                if (!din.getName().equals("NotStartedReassign")) continue;
                foundNotStartedReassignmentsInput = true;
                foundNotStartedDataInput = din;
            }
            if (!foundNotCompletedReassignmentsInput) {
                d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_" + "NotCompletedReassign" + "InputX");
                d.setName("NotCompletedReassign");
                task.getIoSpecification().getDataInputs().add(d);
                foundNotCompletedDataInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset2 = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset2);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            if (!foundNotStartedReassignmentsInput) {
                d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_" + "NotStartedReassign" + "InputX");
                d.setName("NotStartedReassign");
                task.getIoSpecification().getDataInputs().add(d);
                foundNotStartedDataInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    inset2 = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset2);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundNotCompletedReassignmentAssociation = false;
            boolean foundNotStartedReassignmentAssociation = false;
            inputAssociations = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations) {
                if (da.getTargetRef().getId().equals(foundNotCompletedDataInput.getId())) {
                    foundNotCompletedReassignmentAssociation = true;
                    ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.getReassignmentsAndNotificationsForType(properties.get("reassignment"), "not-completed"));
                }
                if (!da.getTargetRef().getId().equals(foundNotStartedDataInput.getId())) continue;
                foundNotStartedReassignmentAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.getReassignmentsAndNotificationsForType(properties.get("reassignment"), "not-started"));
            }
            if (!foundNotCompletedReassignmentAssociation) {
                dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia.setTargetRef((ItemAwareElement)foundNotCompletedDataInput);
                a = Bpmn2Factory.eINSTANCE.createAssignment();
                notCompletedFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notCompletedFromExpression.setBody(this.getReassignmentsAndNotificationsForType(properties.get("reassignment"), "not-completed"));
                notCompletedToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notCompletedToExpression.setBody(foundNotCompletedDataInput.getId());
                a.setFrom((Expression)notCompletedFromExpression);
                a.setTo((Expression)notCompletedToExpression);
                dia.getAssignment().add(a);
                task.getDataInputAssociations().add(dia);
            }
            if (!foundNotStartedReassignmentAssociation) {
                dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia.setTargetRef((ItemAwareElement)foundNotStartedDataInput);
                a = Bpmn2Factory.eINSTANCE.createAssignment();
                notStartedFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notStartedFromExpression.setBody(this.getReassignmentsAndNotificationsForType(properties.get("reassignment"), "not-started"));
                notStartedToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notStartedToExpression.setBody(foundNotStartedDataInput.getId());
                a.setFrom((Expression)notStartedFromExpression);
                a.setTo((Expression)notStartedToExpression);
                dia.getAssignment().add(a);
                task.getDataInputAssociations().add(dia);
            }
        }
        if (properties.get("notifications") != null && properties.get("notifications").length() > 0) {
            DataInput d;
            if (task.getIoSpecification() == null) {
                iospec = Bpmn2Factory.eINSTANCE.createInputOutputSpecification();
                task.setIoSpecification(iospec);
            }
            dataInputs = task.getIoSpecification().getDataInputs();
            boolean foundNotCompletedNotificationsInput = false;
            boolean foundNotStartedNotificationsInput = false;
            DataInput foundNotCompletedDataInput = null;
            foundNotStartedDataInput = null;
            for (DataInput din : dataInputs) {
                if (din.getName().equals("NotCompletedNotify")) {
                    foundNotCompletedNotificationsInput = true;
                    foundNotCompletedDataInput = din;
                }
                if (!din.getName().equals("NotStartedNotify")) continue;
                foundNotStartedNotificationsInput = true;
                foundNotStartedDataInput = din;
            }
            if (!foundNotCompletedNotificationsInput) {
                d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_" + "NotCompletedNotify" + "InputX");
                d.setName("NotCompletedNotify");
                task.getIoSpecification().getDataInputs().add(d);
                foundNotCompletedDataInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    InputSet inset3 = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset3);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            if (!foundNotStartedNotificationsInput) {
                d = Bpmn2Factory.eINSTANCE.createDataInput();
                d.setId(task.getId() + "_" + "NotStartedNotify" + "InputX");
                d.setName("NotStartedNotify");
                task.getIoSpecification().getDataInputs().add(d);
                foundNotStartedDataInput = d;
                if (task.getIoSpecification().getInputSets() == null || task.getIoSpecification().getInputSets().size() < 1) {
                    InputSet inset4 = Bpmn2Factory.eINSTANCE.createInputSet();
                    task.getIoSpecification().getInputSets().add(inset4);
                }
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().add(d);
            }
            boolean foundNotCompletedNotificationAssociation = false;
            boolean foundNotStartedNotificationAssociation = false;
            inputAssociations = task.getDataInputAssociations();
            for (DataInputAssociation da : inputAssociations) {
                if (da.getTargetRef().getId().equals(foundNotCompletedDataInput.getId())) {
                    foundNotCompletedNotificationAssociation = true;
                    ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.getReassignmentsAndNotificationsForType(properties.get("notifications"), "not-completed"));
                }
                if (!da.getTargetRef().getId().equals(foundNotStartedDataInput.getId())) continue;
                foundNotStartedNotificationAssociation = true;
                ((FormalExpression)((Assignment)da.getAssignment().get(0)).getFrom()).setBody(this.getReassignmentsAndNotificationsForType(properties.get("notifications"), "not-started"));
            }
            if (!foundNotCompletedNotificationAssociation) {
                dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia.setTargetRef((ItemAwareElement)foundNotCompletedDataInput);
                a = Bpmn2Factory.eINSTANCE.createAssignment();
                notCompletedFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notCompletedFromExpression.setBody(this.getReassignmentsAndNotificationsForType(properties.get("notifications"), "not-completed"));
                notCompletedToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notCompletedToExpression.setBody(foundNotCompletedDataInput.getId());
                a.setFrom((Expression)notCompletedFromExpression);
                a.setTo((Expression)notCompletedToExpression);
                dia.getAssignment().add(a);
                task.getDataInputAssociations().add(dia);
            }
            if (!foundNotStartedNotificationAssociation) {
                dia = Bpmn2Factory.eINSTANCE.createDataInputAssociation();
                dia.setTargetRef((ItemAwareElement)foundNotStartedDataInput);
                a = Bpmn2Factory.eINSTANCE.createAssignment();
                notStartedFromExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notStartedFromExpression.setBody(this.getReassignmentsAndNotificationsForType(properties.get("notifications"), "not-started"));
                notStartedToExpression = Bpmn2Factory.eINSTANCE.createFormalExpression();
                notStartedToExpression.setBody(foundNotStartedDataInput.getId());
                a.setFrom((Expression)notStartedFromExpression);
                a.setTo((Expression)notStartedToExpression);
                dia.getAssignment().add(a);
                task.getDataInputAssociations().add(dia);
            }
        }
        if (task.getDataInputAssociations() != null) {
            List dataInputAssociations = task.getDataInputAssociations();
            ArrayList<DataInputAssociation> incompleteAssociations = new ArrayList<DataInputAssociation>();
            for (DataInputAssociation dia3 : dataInputAssociations) {
                DataInput targetInput = (DataInput)dia3.getTargetRef();
                if (targetInput == null || targetInput.getName() == null) continue;
                if (targetInput.getName().equals("GroupId") && (properties.get("groupid") == null || properties.get("groupid").length() == 0)) {
                    incompleteAssociations.add(dia3);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("Skippable") && (properties.get("skippable") == null || properties.get("skippable").length() == 0)) {
                    incompleteAssociations.add(dia3);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("Comment") && (properties.get("comment") == null || properties.get("comment").length() == 0)) {
                    incompleteAssociations.add(dia3);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("Priority") && (properties.get("priority") == null || properties.get("priority").length() == 0)) {
                    incompleteAssociations.add(dia3);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("Content") && (properties.get("content") == null || properties.get("content").length() == 0)) {
                    incompleteAssociations.add(dia3);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("Locale") && (properties.get("locale") == null || properties.get("locale").length() == 0)) {
                    incompleteAssociations.add(dia3);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("CreatedBy") && (properties.get("createdby") == null || properties.get("createdby").length() == 0)) {
                    incompleteAssociations.add(dia3);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("NotCompletedReassign") && (properties.get("reassignment") == null || properties.get("reassignment").length() == 0)) {
                    incompleteAssociations.add(dia3);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("NotStartedReassign") && (properties.get("reassignment") == null || properties.get("reassignment").length() == 0)) {
                    incompleteAssociations.add(dia3);
                    continue;
                }
                if (targetInput.getName().equalsIgnoreCase("NotCompletedNotify") && (properties.get("notifications") == null || properties.get("notifications").length() == 0)) {
                    incompleteAssociations.add(dia3);
                    continue;
                }
                if (!targetInput.getName().equalsIgnoreCase("NotStartedNotify") || properties.get("notifications") != null && properties.get("notifications").length() != 0) continue;
                incompleteAssociations.add(dia3);
            }
            for (DataInputAssociation tr : incompleteAssociations) {
                if (task.getDataInputAssociations() == null) continue;
                task.getDataInputAssociations().remove(tr);
            }
        }
        ArrayList<DataInput> toRemoveDataInputs = new ArrayList<DataInput>();
        if (task.getIoSpecification() != null && task.getIoSpecification().getDataInputs() != null) {
            List taskDataInputs = task.getIoSpecification().getDataInputs();
            for (DataInput din : taskDataInputs) {
                if (din.getName().equals("GroupId") && (properties.get("groupid") == null || properties.get("groupid").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("Skippable") && (properties.get("skippable") == null || properties.get("skippable").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("Comment") && (properties.get("comment") == null || properties.get("comment").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("Priority") && (properties.get("priority") == null || properties.get("priority").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("Content") && (properties.get("content") == null || properties.get("content").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("Locale") && (properties.get("locale") == null || properties.get("locale").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("CreatedBy") && (properties.get("createdby") == null || properties.get("createdby").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("NotCompletedReassign") && (properties.get("reassignment") == null || properties.get("reassignment").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("NotStartedReassign") && (properties.get("reassignment") == null || properties.get("reassignment").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (din.getName().equalsIgnoreCase("NotCompletedNotify") && (properties.get("notifications") == null || properties.get("notifications").length() == 0)) {
                    toRemoveDataInputs.add(din);
                    continue;
                }
                if (!din.getName().equalsIgnoreCase("NotStartedNotify") || properties.get("notifications") != null && properties.get("notifications").length() != 0) continue;
                toRemoveDataInputs.add(din);
            }
        }
        for (DataInput trdin : toRemoveDataInputs) {
            if (task.getIoSpecification() != null && task.getIoSpecification().getDataInputs() != null && task.getIoSpecification().getInputSets().size() > 0) {
                ((InputSet)task.getIoSpecification().getInputSets().get(0)).getDataInputRefs().remove(trdin);
            }
            task.getIoSpecification().getDataInputs().remove(trdin);
        }
        ResourceParameters resourceParameters = BpsimFactory.eINSTANCE.createResourceParameters();
        if (properties.get("quantity") != null && properties.get("quantity").length() > 0) {
            Parameter quantityParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType quantityValueParam = BpsimFactory.eINSTANCE.createFloatingParameterType();
            twoDForm = new DecimalFormat("#.##");
            quantityValueParam.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("quantity")))).doubleValue());
            quantityParam.getParameterValue().add((Object)quantityValueParam);
            resourceParameters.setQuantity(quantityParam);
        }
        if (properties.get("workinghours") != null && properties.get("workinghours").length() > 0) {
            Parameter workingHoursParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType workingHoursValueParam = BpsimFactory.eINSTANCE.createFloatingParameterType();
            twoDForm = new DecimalFormat("#.##");
            workingHoursValueParam.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("workinghours")))).doubleValue());
            workingHoursParam.getParameterValue().add((Object)workingHoursValueParam);
            resourceParameters.setAvailability(workingHoursParam);
        }
        if (this._simulationElementParameters.containsKey(task.getId())) {
            this._simulationElementParameters.get(task.getId()).add((EObject)resourceParameters);
        } else {
            ArrayList<ResourceParameters> values = new ArrayList<ResourceParameters>();
            values.add(resourceParameters);
            this._simulationElementParameters.put(task.getId(), values);
        }
    }

    protected void applyGatewayProperties(Gateway gateway, Map<String, String> properties) {
        if (properties.get("name") != null && properties.get("name").length() > 0) {
            gateway.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        } else {
            gateway.setName("");
        }
        if (properties.get("defaultgate") != null && (gateway instanceof InclusiveGateway || gateway instanceof ExclusiveGateway)) {
            ExtendedMetaData metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "dg", false, false);
            EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("defaultgate"));
            gateway.getAnyAttribute().add((Object)extensionEntry);
        }
    }

    protected void applySequenceFlowProperties(SequenceFlow sequenceFlow, Map<String, String> properties) {
        EStructuralFeatureImpl.SimpleFeatureMapEntry extensionEntry;
        EAttributeImpl extensionAttribute;
        ExtendedMetaData metadata;
        if (properties.get("name") != null && !"".equals(properties.get("name"))) {
            sequenceFlow.setName(Bpmn2JsonUnmarshaller.escapeXmlString(properties.get("name")));
        }
        if (properties.get("bgcolor") != null && properties.get("bgcolor").length() > 0 && !properties.get("bgcolor").equals("#000000")) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "bgcolor", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("bgcolor"));
            sequenceFlow.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("bordercolor") != null && properties.get("bordercolor").length() > 0 && !properties.get("bordercolor").equals("#000000")) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "bordercolor", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("bordercolor"));
            sequenceFlow.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("fontsize") != null && properties.get("fontsize").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "fontsize", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("fontsize"));
            sequenceFlow.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("fontcolor") != null && properties.get("fontcolor").length() > 0 && !properties.get("fontcolor").equals("#000000")) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "fontcolor", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("fontcolor"));
            sequenceFlow.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("isselectable") != null && properties.get("isselectable").length() > 0) {
            metadata = ExtendedMetaData.INSTANCE;
            extensionAttribute = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "selectable", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)extensionAttribute, (Object)properties.get("isselectable"));
            sequenceFlow.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("auditing") != null && !"".equals(properties.get("auditing"))) {
            Auditing audit = Bpmn2Factory.eINSTANCE.createAuditing();
            audit.getDocumentation().add(this.createDocumentation(properties.get("auditing")));
            sequenceFlow.setAuditing(audit);
        }
        if (properties.get("conditionexpression") != null && !"".equals(properties.get("conditionexpression"))) {
            FormalExpression expr = Bpmn2Factory.eINSTANCE.createFormalExpression();
            String scriptStr = properties.get("conditionexpression").replaceAll("\\\\n", "\n");
            expr.setBody(this.wrapInCDATABlock(scriptStr));
            if (properties.get("conditionexpressionlanguage") != null && !"".equals(properties.get("conditionexpressionlanguage"))) {
                String languageStr = properties.get("conditionexpressionlanguage").equals("drools") ? "http://www.jboss.org/drools/rule" : (properties.get("conditionexpressionlanguage").equals("mvel") ? "http://www.mvel.org/2.0" : (properties.get("conditionexpressionlanguage").equals("java") ? "http://www.java.com/java" : "http://www.mvel.org/2.0"));
                expr.setLanguage(languageStr);
            }
            sequenceFlow.setConditionExpression((Expression)expr);
        }
        if (properties.get("priority") != null && !"".equals(properties.get("priority"))) {
            metadata = ExtendedMetaData.INSTANCE;
            EAttributeImpl priorityElement = (EAttributeImpl)metadata.demandFeature("http://www.jboss.org/drools", "priority", false, false);
            extensionEntry = new EStructuralFeatureImpl.SimpleFeatureMapEntry((EStructuralFeature.Internal)priorityElement, (Object)properties.get("priority"));
            sequenceFlow.getAnyAttribute().add((Object)extensionEntry);
        }
        if (properties.get("monitoring") != null && !"".equals(properties.get("monitoring"))) {
            Monitoring monitoring = Bpmn2Factory.eINSTANCE.createMonitoring();
            monitoring.getDocumentation().add(this.createDocumentation(properties.get("monitoring")));
            sequenceFlow.setMonitoring(monitoring);
        }
        sequenceFlow.setIsImmediate(Boolean.parseBoolean(properties.get("isimmediate")));
        if (properties.get("probability") != null && properties.get("probability").length() > 0) {
            ControlParameters controlParams = BpsimFactory.eINSTANCE.createControlParameters();
            Parameter probParam = BpsimFactory.eINSTANCE.createParameter();
            FloatingParameterType probParamValueParam = BpsimFactory.eINSTANCE.createFloatingParameterType();
            DecimalFormat twoDForm = new DecimalFormat("#.##");
            probParamValueParam.setValue(Double.valueOf(twoDForm.format(Double.valueOf(properties.get("probability")))).doubleValue());
            probParam.getParameterValue().add((Object)probParamValueParam);
            controlParams.setProbability(probParam);
            if (this._simulationElementParameters.containsKey(sequenceFlow.getId())) {
                this._simulationElementParameters.get(sequenceFlow.getId()).add((EObject)controlParams);
            } else {
                ArrayList<ControlParameters> values = new ArrayList<ControlParameters>();
                values.add(controlParams);
                this._simulationElementParameters.put(sequenceFlow.getId(), values);
            }
        }
    }

    private Map<String, String> unmarshallProperties(JsonParser parser) throws JsonParseException, IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = parser.getCurrentName();
            parser.nextToken();
            properties.put(fieldname, parser.getText());
        }
        return properties;
    }

    private Documentation createDocumentation(String text) {
        Documentation doc = Bpmn2Factory.eINSTANCE.createDocumentation();
        doc.setText(text);
        return doc;
    }

    private boolean isCustomElement(String taskType, String preProcessingData) {
        if (taskType != null && taskType.length() > 0 && preProcessingData != null && preProcessingData.length() > 0) {
            String[] preProcessingDataElements;
            for (String preProcessingDataElement : preProcessingDataElements = preProcessingData.split(",\\s*")) {
                if (!taskType.equals(preProcessingDataElement)) continue;
                return true;
            }
        }
        return false;
    }

    protected BaseElement createBaseElement(String stencil, String taskType, boolean customElement) {
        return Bpmn20Stencil.createElement(stencil, taskType, customElement);
    }

    protected String wrapInCDATABlock(String value) {
        return "<![CDATA[" + value + "]]>";
    }

    private static String escapeXmlString(String string) {
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                sb.append(' ');
                continue;
            }
            lastWasBlankChar = false;
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            int ci = 0xFFFF & c;
            if (ci < 160) {
                sb.append(c);
                continue;
            }
            sb.append("&#");
            sb.append(Integer.toString(ci));
            sb.append(';');
        }
        return sb.toString();
    }

    private String getReassignmentsAndNotificationsForType(String inputStr, String type) {
        String[] parts = inputStr.split("\\^\\s*");
        String ret = "";
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].endsWith("^")) {
                parts[i] = parts[i].substring(0, parts[i].length() - 1);
            }
            if (!parts[i].endsWith("@" + type)) continue;
            ret = ret + parts[i].substring(0, parts[i].length() - ("@" + type).length());
            ret = ret + "^";
        }
        if (ret.endsWith("^")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return this.wrapInCDATABlock(ret);
    }
}

