/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.filter;

import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jbpm.designer.filter.InjectionRule;
import org.jbpm.designer.filter.InjectionRules;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InjectionConfig {
    private static final String DEFAULT_INJECTION_CONF_FILE = "/injection/designerinjection.xml";
    private static ServletContext context;
    private InjectionRules rules;

    public InjectionConfig(ServletContext sc) {
        context = sc;
        this.load(sc.getContextPath());
    }

    public synchronized void load(String contextPath) {
        DocumentBuilder parser;
        InputStream is = null;
        is = this.getClass().getResourceAsStream(DEFAULT_INJECTION_CONF_FILE);
        if (is == null) {
            System.out.println("unable to find designer injection conf file /injection/designerinjection.xml");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        try {
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return;
        }
        try {
            Document doc = parser.parse(is);
            NodeList rulesConf = doc.getElementsByTagName("rule");
            this.rules = new InjectionRules();
            for (int i = 0; i < rulesConf.getLength(); ++i) {
                Node ruleNode = rulesConf.item(i);
                InjectionRule rule = new InjectionRule(ruleNode, contextPath);
                if (!rule.isEnabled()) continue;
                this.rules.add(rule);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InjectionRules getRules() {
        return this.rules;
    }
}

