/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.lucene.search.Query;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.QueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.TypeIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringStringPageRow;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.io.IOService;
import org.uberfire.paging.PageResponse;

@ApplicationScoped
public class FindDataTypesQuery
implements NamedQuery {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    private DataTypesResponseBuilder responseBuilder = new DataTypesResponseBuilder();

    public String getName() {
        return "DesignerFindTypesQuery";
    }

    public Set<IndexTerm> getTerms() {
        return new HashSet<IndexTerm>(){
            {
                this.add(new TypeIndexTerm());
            }
        };
    }

    public Query toQuery(Set<ValueIndexTerm> terms, boolean useWildcards) {
        if (terms.size() != 1) {
            throw new IllegalArgumentException("Required term has not been provided. Require 'type_name'.");
        }
        Map<String, ValueIndexTerm> normalizedTerms = this.normalizeTerms(terms);
        ValueIndexTerm typeTerm = normalizedTerms.get("type_name");
        if (typeTerm == null) {
            throw new IllegalArgumentException("Required term has not been provided. Require 'type_name'.");
        }
        QueryBuilder builder = new QueryBuilder();
        if (useWildcards) {
            builder.useWildcards();
        }
        builder.addTerm(typeTerm);
        return builder.build();
    }

    private Map<String, ValueIndexTerm> normalizeTerms(Set<ValueIndexTerm> terms) {
        HashMap<String, ValueIndexTerm> normalizedTerms = new HashMap<String, ValueIndexTerm>();
        for (ValueIndexTerm term : terms) {
            normalizedTerms.put(term.getTerm(), term);
        }
        return normalizedTerms;
    }

    public ResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    private static class DataTypesResponseBuilder
    implements ResponseBuilder {
        private IOService ioService;

        private DataTypesResponseBuilder() {
        }

        public void setIOService(IOService ioService) {
            this.ioService = ioService;
        }

        public PageResponse<RefactoringPageRow> buildResponse(int pageSize, int startRow, List<KObject> kObjects) {
            int hits = kObjects.size();
            PageResponse response = new PageResponse();
            List<RefactoringPageRow> result = this.buildResponse(kObjects);
            response.setTotalRowSize(hits);
            response.setPageRowList(result);
            response.setTotalRowSizeExact(true);
            response.setStartRowIndex(startRow);
            response.setLastPage(pageSize * startRow + 2 >= hits);
            return response;
        }

        public List<RefactoringPageRow> buildResponse(List<KObject> kObjects) {
            ArrayList<RefactoringPageRow> result = new ArrayList<RefactoringPageRow>(kObjects.size());
            HashMap<String, String> uniqueDataTypeNames = new HashMap<String, String>();
            for (KObject kObject : kObjects) {
                Map<String, String> dataTypeNames = this.getDataTypeNamesFromKObject(kObject);
                uniqueDataTypeNames.putAll(dataTypeNames);
            }
            for (Map.Entry entry : uniqueDataTypeNames.entrySet()) {
                RefactoringStringPageRow row = new RefactoringStringPageRow();
                row.setValue(entry.getKey());
                result.add((RefactoringPageRow)row);
            }
            return result;
        }

        private Map<String, String> getDataTypeNamesFromKObject(KObject kObject) {
            HashMap<String, String> dataTypeNames = new HashMap<String, String>();
            if (kObject == null) {
                return dataTypeNames;
            }
            for (KProperty property : kObject.getProperties()) {
                if (!property.getName().equals("java_type_name") || dataTypeNames.containsKey(property.getValue())) continue;
                dataTypeNames.put(property.getValue().toString(), property.getValue().toString());
            }
            return dataTypeNames;
        }
    }
}

