/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.filter.DesignerResponseWrapper;
import org.jbpm.designer.filter.InjectionConfig;
import org.jbpm.designer.filter.InjectionRule;
import org.jbpm.designer.filter.InjectionRules;

public class DesignerInjectionFilter
implements Filter {
    private FilterConfig fc = null;
    private ServletContext sc = null;
    private InjectionConfig cf;
    private InjectionRules rules;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.fc = filterConfig;
        this.sc = this.fc.getServletContext();
        this.cf = new InjectionConfig(this.sc);
        this.rules = this.cf.getRules();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            DesignerResponseWrapper wrapper = new DesignerResponseWrapper((HttpServletResponse)response);
            chain.doFilter(request, (ServletResponse)wrapper);
            if (!((HttpServletResponse)response).containsHeader("Content-Encoding") && response.getContentType() != null && response.getContentType().indexOf("text/html") >= 0) {
                StringBuffer buff = wrapper.getBuffer();
                PrintWriter out = response.getWriter();
                if (!((HttpServletRequest)request).getRequestURI().endsWith("hosted.html")) {
                    String modifiedResponse = this.processContent(buff, this.rules);
                    out.write(modifiedResponse);
                } else {
                    out.write(buff.toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
        this.fc = null;
    }

    private String processContent(StringBuffer buffer, InjectionRules rulesToApply) {
        String strResponse = buffer.toString();
        String tagsToInsert = "";
        String modResponse = strResponse;
        String headBeginMarker = "<!-- mg#head#begin#marker -->";
        String bodyBeginMarker = "<!-- mg#body#begin#marker -->";
        boolean headBeginInserted = false;
        boolean bodyBeginInserted = false;
        for (InjectionRule ruleToApply : rulesToApply) {
            tagsToInsert = ruleToApply.toString();
            switch (ruleToApply.getInsertAt()) {
                case 0: {
                    if (!headBeginInserted) {
                        if (tagsToInsert == "") break;
                        tagsToInsert = "<head>\n" + tagsToInsert + headBeginMarker;
                        modResponse = this.findAndReplace(tagsToInsert, modResponse, "<head>");
                        headBeginInserted = true;
                        break;
                    }
                    if (tagsToInsert == "") break;
                    tagsToInsert = tagsToInsert + headBeginMarker;
                    modResponse = this.findAndReplace(tagsToInsert, modResponse, headBeginMarker);
                    break;
                }
                case 1: {
                    if (tagsToInsert == "") break;
                    tagsToInsert = tagsToInsert + "</head>";
                    modResponse = this.findAndReplace(tagsToInsert, modResponse, "</head>");
                    break;
                }
                case 2: {
                    if (!bodyBeginInserted) {
                        if (tagsToInsert == "") break;
                        Pattern p = Pattern.compile("<body[^>]*>", 42);
                        Matcher m = p.matcher(modResponse);
                        StringBuffer sb = new StringBuffer();
                        while (m.find()) {
                            String origBody = m.group();
                            if (origBody == null) continue;
                            m.appendReplacement(sb, origBody.replaceAll("\\$", "\\\\\\$") + "\n" + tagsToInsert + bodyBeginMarker);
                            break;
                        }
                        m.appendTail(sb);
                        modResponse = sb.toString();
                        bodyBeginInserted = true;
                        break;
                    }
                    if (tagsToInsert == "") break;
                    tagsToInsert = tagsToInsert + bodyBeginMarker;
                    modResponse = this.findAndReplace(tagsToInsert, modResponse, bodyBeginMarker);
                    break;
                }
                case 3: {
                    if (tagsToInsert == "") break;
                    tagsToInsert = tagsToInsert + "\n</body>";
                    modResponse = this.findAndReplace(tagsToInsert, modResponse, "</body>");
                }
            }
        }
        return modResponse;
    }

    private String findAndReplace(String tagsToInsert, String modResponse, String strPattern) {
        Pattern p = Pattern.compile(strPattern, 2);
        Matcher m = p.matcher(modResponse);
        modResponse = m.replaceFirst(tagsToInsert);
        return modResponse;
    }
}

