/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server.menu.connector.commands;

import bpsim.impl.BpsimFactoryImpl;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItemStream;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.AssetTypeMapper;
import org.jbpm.designer.repository.Directory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.NoSuchFileException;

public abstract class AbstractCommand {
    private static Logger logger = LoggerFactory.getLogger(AbstractCommand.class);

    public JSONObject listContent(IDiagramProfile profile, String target, String current, boolean tree) throws Exception {
        try {
            if (target == null || target.length() < 1) {
                target = "/";
            } else if (!target.startsWith("/")) {
                target = "/" + target;
            }
            JSONObject retObj = new JSONObject();
            retObj.put("cwd", this.getCwd(profile, target, tree));
            retObj.put("cdc", this.getCdc(profile, target, tree));
            if (target == "/") {
                retObj.put("tree", this.getTree(profile, target, tree));
            }
            this.addParams(retObj);
            return retObj;
        }
        catch (JSONException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            return new JSONObject();
        }
    }

    public JSONObject pasteDirectoriesOrAssets(IDiagramProfile profile, String current, List<String> targets, String cut, String dst, String src, boolean tree) throws Exception {
        if (current == null || current.length() < 1) {
            current = "/";
        } else if (!current.startsWith("/")) {
            current = "/" + current;
        }
        if (current.startsWith("//")) {
            current = current.substring(1, current.length());
        }
        if (targets != null) {
            for (String target : targets) {
                if (target.startsWith("//")) {
                    target = target.substring(1, target.length());
                }
                if (profile.getRepository().directoryExists(target)) {
                    boolean deleted;
                    boolean copied = profile.getRepository().copyDirectory(target, dst);
                    if (!copied) {
                        logger.error("Unable to copy directory: " + target + " to " + dst);
                        continue;
                    }
                    if (cut == null || !cut.equals("1") || (deleted = profile.getRepository().deleteDirectory(target, false))) continue;
                    logger.error("Unable to delete directory: " + target);
                    continue;
                }
                Asset toPasteAsset = null;
                try {
                    boolean deleted;
                    toPasteAsset = profile.getRepository().loadAssetFromPath(target);
                    boolean copied = profile.getRepository().copyAsset(toPasteAsset.getUniqueId(), dst);
                    if (!copied) {
                        logger.error("Unable to copy asset: " + toPasteAsset.getUniqueId() + " to " + dst);
                        continue;
                    }
                    if (cut == null || !cut.equals("1") || (deleted = profile.getRepository().deleteAsset(toPasteAsset.getUniqueId()))) continue;
                    logger.error("Unable to delete asset: " + toPasteAsset.getUniqueId());
                }
                catch (NoSuchFileException e) {
                    logger.error("Unable to retrieve asset: " + target);
                }
            }
        }
        JSONObject retObj = new JSONObject();
        retObj.put("cwd", this.getCwd(profile, current, tree));
        retObj.put("cdc", this.getCdc(profile, current, tree));
        retObj.put("tree", this.getTree(profile, "/", tree));
        retObj.put("select", (Object)current);
        return retObj;
    }

    public JSONObject moveDirectoryOrAsset(IDiagramProfile profile, String name, String target, String current, boolean tree) throws Exception {
        Repository repository;
        if (current == null || current.length() < 1) {
            current = "/";
        } else if (!current.startsWith("/")) {
            current = "/" + current;
        }
        if (current.startsWith("//")) {
            current = current.substring(1, current.length());
        }
        if (target.startsWith("//")) {
            target = target.substring(1, target.length());
        }
        if ((repository = profile.getRepository()).directoryExists(target)) {
            boolean moved = repository.moveDirectory(target, current, name);
            if (!moved) {
                logger.error("Unable to move directory: " + target);
            }
        } else {
            Asset tobeRenamedAsset = null;
            try {
                tobeRenamedAsset = repository.loadAssetFromPath(target);
            }
            catch (NoSuchFileException e) {
                logger.error("Unable to retrieve asset: " + target);
            }
            if (tobeRenamedAsset != null) {
                boolean moved;
                if (name.indexOf(".") < 0) {
                    name = name + "." + tobeRenamedAsset.getAssetType();
                }
                if (!(moved = repository.moveAsset(tobeRenamedAsset.getUniqueId(), current, name))) {
                    logger.error("Unable to move asset: " + target);
                }
            }
        }
        JSONObject retObj = new JSONObject();
        retObj.put("cwd", this.getCwd(profile, current, tree));
        retObj.put("cdc", this.getCdc(profile, current, tree));
        retObj.put("tree", this.getTree(profile, "/", tree));
        retObj.put("select", (Object)current);
        return retObj;
    }

    public JSONObject removeAssets(IDiagramProfile profile, String current, List<String> targets, boolean tree) throws Exception {
        if (current == null || current.length() < 1) {
            current = "/";
        } else if (!current.startsWith("/")) {
            current = "/" + current;
        }
        if (current.startsWith("//")) {
            current = current.substring(1, current.length());
        }
        if (profile.getRepository().directoryExists(current)) {
            for (String target : targets) {
                boolean deleted;
                if (target.startsWith("//")) {
                    target = target.substring(1, target.length());
                }
                if (deleted = profile.getRepository().directoryExists(target) ? profile.getRepository().deleteDirectory(target, false) : profile.getRepository().deleteAssetFromPath(target)) continue;
                logger.error("Unable to delete asset: " + target);
            }
        }
        JSONObject retObj = new JSONObject();
        retObj.put("cwd", this.getCwd(profile, current, tree));
        retObj.put("cdc", this.getCdc(profile, current, tree));
        retObj.put("tree", this.getTree(profile, "/", tree));
        retObj.put("select", (Object)"");
        return retObj;
    }

    public JSONObject uploadFiles(IDiagramProfile profile, String current, List<FileItemStream> listFiles, List<ByteArrayOutputStream> listFileStreams, boolean tree) throws Exception {
        if (current == null || current.length() < 1) {
            current = "/";
        } else if (!current.startsWith("/")) {
            current = "/" + current;
        }
        if (current.startsWith("//")) {
            current = current.substring(1, current.length());
        }
        if (profile.getRepository().directoryExists(current)) {
            try {
                int i = 0;
                for (FileItemStream uplFile : listFiles) {
                    String fileName = uplFile.getName();
                    String fileContentType = uplFile.getContentType();
                    ByteArrayOutputStream os = listFileStreams.get(i);
                    this.checkUploadFile(fileName, os);
                    this.checkAlreadyExists(profile, fileName, current);
                    String[] fileParts = fileName.split("\\.");
                    String fileType = fileParts[fileParts.length - 1];
                    String fileNameOnly = fileName.substring(0, fileName.length() - (fileType.length() + 1));
                    AssetBuilder assetBuilder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte);
                    assetBuilder.content(os.toByteArray()).location(current).name(fileNameOnly).type(fileType).version("1.0");
                    Asset newAsset = assetBuilder.getAsset();
                    profile.getRepository().createAsset(newAsset);
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error("Unable to upload file: " + e.getMessage());
            }
        } else {
            logger.error("Directory does not exist: " + current);
        }
        JSONObject retObj = new JSONObject();
        retObj.put("cwd", this.getCwd(profile, current, tree));
        retObj.put("cdc", this.getCdc(profile, current, tree));
        retObj.put("tree", this.getTree(profile, current, tree));
        retObj.put("select", (Object)current);
        this.addParams(retObj);
        return retObj;
    }

    public JSONObject makeDirectory(IDiagramProfile profile, String current, String name, boolean tree) throws Exception {
        if (current == null || current.length() < 1) {
            current = "/";
        } else if (!current.startsWith("/")) {
            current = "/" + current;
        }
        Directory newDir = null;
        try {
            newDir = profile.getRepository().createDirectory(current + "/" + name);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        JSONObject retObj = new JSONObject();
        retObj.put("cwd", this.getCwd(profile, current, tree));
        retObj.put("cdc", this.getCdc(profile, current, tree));
        retObj.put("tree", this.getTree(profile, "/", tree));
        retObj.put("select", (Object)(newDir == null ? "" : newDir.getName()));
        return retObj;
    }

    public JSONObject makeFile(IDiagramProfile profile, String current, String name, boolean tree) throws Exception {
        if (current == null || current.length() < 1) {
            current = "/";
        } else if (!current.startsWith("/")) {
            current = "/" + current;
        }
        if (name.endsWith(".bpmn2")) {
            name = name.substring(0, name.length() - 6);
        } else if (name.endsWith("bpmn")) {
            name = name.substring(0, name.length() - 5);
        }
        String fullName = name + ".bpmn2";
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Text);
        builder.content("").type("bpmn2").name(name).location(current);
        String newFileId = profile.getRepository().createAsset(builder.getAsset());
        if (newFileId == null) {
            logger.error("Unable to create asset: " + current + "/" + fullName);
        }
        JSONObject retObj = new JSONObject();
        retObj.put("cwd", this.getCwd(profile, current, tree));
        retObj.put("cdc", this.getCdc(profile, current, tree));
        retObj.put("tree", this.getTree(profile, "/", tree));
        retObj.put("select", (Object)(newFileId == null ? "" : current + "/" + fullName));
        return retObj;
    }

    public Map<String, Object> getTree(IDiagramProfile profile, String path, boolean tree) throws Exception {
        String qname = "";
        if (path != "/") {
            String[] pathParts = path.split("/");
            qname = pathParts[pathParts.length - 1];
        } else {
            qname = path;
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("hash", path);
        info.put("name", qname);
        info.put("read", "true");
        info.put("write", "true");
        Collection<Directory> subdirs = profile.getRepository().listDirectories(path);
        ArrayList<Map<String, Object>> dirs = new ArrayList<Map<String, Object>>();
        if (subdirs != null) {
            for (Directory sub : subdirs) {
                dirs.add(this.getTree(profile, path.endsWith("/") ? path + sub.getName() : path + "/" + sub.getName(), tree));
            }
        }
        info.put("dirs", dirs);
        return info;
    }

    public List<Map<String, Object>> getCdc(IDiagramProfile profile, String path, boolean tree) throws Exception {
        ArrayList<Map<String, Object>> cdcinfo = new ArrayList<Map<String, Object>>();
        Collection<Asset> assets = profile.getRepository().listAssets(path);
        Collection<Directory> dirs = profile.getRepository().listDirectories(path);
        if (assets != null) {
            for (Asset asset : assets) {
                cdcinfo.add(this.getAssetInfo(profile, asset));
            }
        }
        if (dirs != null) {
            for (Directory dir : dirs) {
                cdcinfo.add(this.getDirectoryInfo(profile, dir));
            }
        }
        return cdcinfo;
    }

    public Map<String, Object> getCwd(IDiagramProfile profile, String path, boolean tree) throws Exception {
        HashMap<String, Object> cwdinfo = new HashMap<String, Object>();
        cwdinfo.put("hash", path);
        cwdinfo.put("name", path);
        cwdinfo.put("mime", "directory");
        cwdinfo.put("rel", path);
        cwdinfo.put("size", "0");
        cwdinfo.put("date", "");
        cwdinfo.put("read", true);
        cwdinfo.put("write", true);
        cwdinfo.put("rm", false);
        return cwdinfo;
    }

    public void addParams(JSONObject retObj) throws Exception {
        JSONObject paramsObj = new JSONObject();
        paramsObj.put("dotFiles", (Object)"true");
        paramsObj.put("archives", (Object)new JSONArray());
        paramsObj.put("uplMaxSize", (Object)"100M");
        paramsObj.put("url", (Object)"");
        paramsObj.put("extract", (Object)new JSONArray());
        retObj.put("params", (Object)paramsObj);
        retObj.put("disabled", (Object)new JSONArray());
    }

    protected Map<String, Object> getDirectoryInfo(IDiagramProfile profile, Directory dir) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("name", dir.getName());
        info.put("hash", dir.getLocation() + "/" + dir.getName());
        info.put("mime", "directory");
        info.put("date", "");
        info.put("size", "");
        info.put("read", true);
        info.put("write", true);
        info.put("rm", true);
        info.put("url", "");
        info.put("tmb", "");
        return info;
    }

    protected Map<String, Object> getAssetInfo(IDiagramProfile profile, Asset asset) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("name", asset.getFullName());
        info.put("hash", asset.getAssetLocation() + "/" + asset.getFullName());
        info.put("mime", AssetTypeMapper.findMimeType(asset));
        info.put("date", "");
        info.put("size", "");
        info.put("read", true);
        info.put("write", true);
        info.put("rm", true);
        info.put("url", asset.getAssetType() + "|" + asset.getUniqueId());
        if (asset.getAssetType().equals("bpmn") | asset.getAssetType().equals("bpmn2")) {
            try {
                info.put("processlocation", asset.getAssetLocation());
                Asset ab = profile.getRepository().loadAssetFromPath(asset.getAssetLocation() + "/" + asset.getFullName());
                DroolsFactoryImpl.init();
                BpsimFactoryImpl.init();
                Definitions def = ((JbpmProfileImpl)profile).getDefinitions((String)ab.getAssetContent());
                List rootElements = def.getRootElements();
                for (RootElement root : rootElements) {
                    if (!(root instanceof Process)) continue;
                    Process process = (Process)root;
                    info.put("processid", process.getId());
                    boolean foundVersion = false;
                    for (FeatureMap.Entry entry : process.getAnyAttribute()) {
                        if (!entry.getEStructuralFeature().getName().equals("version")) continue;
                        info.put("assetversion", entry.getValue());
                        foundVersion = true;
                    }
                    if (foundVersion) continue;
                    info.put("assetversion", "");
                }
            }
            catch (Exception e) {
                logger.warn("Unable to extract process id and version from: " + asset.getFullName());
                info.put("processid", "");
                info.put("assetversion", "");
            }
        } else {
            info.put("assetversion", "");
        }
        return info;
    }

    protected void checkUploadFile(String fileName, ByteArrayOutputStream os) throws Exception {
        if (!this._checkName(fileName)) {
            throw new Exception("Invalid upload file name: " + fileName);
        }
        int uploadSizeOctets = os.size();
        this.checkUploadSizes(uploadSizeOctets);
    }

    protected void checkAlreadyExists(IDiagramProfile profile, String fileName, String current) throws Exception {
        Collection<Asset> assets = profile.getRepository().listAssets(current);
        for (Asset asset : assets) {
            String assetFull = asset.getName() + "." + asset.getAssetType();
            if (!assetFull.equals(fileName)) continue;
            throw new Exception("File name " + fileName + " already exists in directory " + current);
        }
    }

    protected void checkUploadSizes(int uploadSizeOctets) throws Exception {
        if (uploadSizeOctets > 0x6400000) {
            throw new Exception("File exceeds the maximum allowed filesize.");
        }
    }

    public boolean _checkName(String n) {
        if (n == null) {
            return false;
        }
        if ("".equals(n = n.trim())) {
            return false;
        }
        return n.matches("|^[^\\\\/\\<\\>:]+$|");
    }
}

