/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.editorhandler;

import java.io.File;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import junit.framework.Assert;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.repository.VFSFileSystemProducer;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.server.EditorHandler;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class EditorHandlerBaseTest
extends RepositoryBaseTest {
    @Override
    @Before
    public void setup() {
        new File(REPOSITORY_ROOT).mkdir();
        this.profile = new JbpmProfileImpl();
        this.producer = new VFSFileSystemProducer();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("repository.root", VFS_REPOSITORY_ROOT);
        env.put("repository.globaldir", "/global");
        this.descriptor = this.producer.produceFileSystem(env);
    }

    @Override
    @After
    public void teardown() {
        File repo = new File(REPOSITORY_ROOT);
        if (repo.exists()) {
            this.deleteFiles(repo);
        }
        repo.delete();
    }

    @Test
    public void testGetInstanceViewMode() throws Exception {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceviewmode", "false");
        EditorHandler editorHandler = new EditorHandler();
        Assert.assertEquals((String)editorHandler.getInstanceViewMode((HttpServletRequest)new TestHttpServletRequest(params)), (String)"false");
        params.put("instanceviewmode", "true");
        Assert.assertEquals((String)editorHandler.getInstanceViewMode((HttpServletRequest)new TestHttpServletRequest(params)), (String)"true");
        params.remove("instanceviewmode");
        Assert.assertEquals((String)editorHandler.getInstanceViewMode((HttpServletRequest)new TestHttpServletRequest(params)), (String)"false");
    }
}

