/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository;

import java.io.File;
import java.util.HashMap;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.VFSFileSystemProducer;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.jbpm.designer.repository.vfs.VFSRepository;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;

public class RepositoryBaseTest {
    protected static final String REPOSITORY_ROOT = (System.getProperty("java.io.tmpdir").endsWith(File.separator) ? System.getProperty("java.io.tmpdir") : System.getProperty("java.io.tmpdir") + File.separator) + "designer-repo";
    protected static final String VFS_REPOSITORY_ROOT = "default://" + REPOSITORY_ROOT;
    protected JbpmProfileImpl profile;
    protected RepositoryDescriptor descriptor;
    protected VFSFileSystemProducer producer;

    protected void deleteFiles(File directory) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.deleteFiles(file);
            }
            file.delete();
        }
    }

    public void setup() {
        new File(REPOSITORY_ROOT).mkdir();
        this.profile = new JbpmProfileImpl();
        this.producer = new VFSFileSystemProducer();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("repository.root", VFS_REPOSITORY_ROOT);
        env.put("repository.globaldir", "/global");
        this.descriptor = this.producer.produceFileSystem(env);
    }

    public void teardown() {
        File repo = new File(REPOSITORY_ROOT);
        if (repo.exists()) {
            this.deleteFiles(repo);
        }
        repo.delete();
    }

    public Repository createRepository() {
        VFSRepository repository = new VFSRepository(this.producer.getIoService());
        repository.setDescriptor(this.descriptor);
        this.profile.setRepository((Repository)repository);
        return repository;
    }

    public String createAsset(Repository repository, String location, String name, String fileType, String bpContent) {
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder((Asset.AssetType)Asset.AssetType.Text);
        builder.content((Object)bpContent).type(fileType).name(name).location(location);
        return repository.createAsset(builder.getAsset());
    }
}

