/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class RdfJsonTransformation {
    private static final String[] reservedNodeNames = new String[]{"rdf:type", "type", "mode", "stencilset", "render", "bounds", "dockers", "outgoing", "target", "parent", "ssextension", "ssnamespace"};
    private static JSONObject canvas;
    private static Map<String, JSONObject> objects;
    private static Map<String, String> parents;
    private static String hostUrl;
    private static Logger log;

    public static JSONObject toJson(Document rdfDoc, String requestUrl) {
        canvas = new JSONObject();
        objects = new HashMap<String, JSONObject>();
        parents = new HashMap<String, String>();
        hostUrl = requestUrl;
        Node root = RdfJsonTransformation.getRootNode(rdfDoc);
        if (root == null) {
            return canvas;
        }
        if (root.hasChildNodes()) {
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                String rdfType;
                if (node instanceof Text) continue;
                Node rdfTypeNode = RdfJsonTransformation.getChild(node, "rdf:type");
                if (rdfTypeNode != null && (rdfType = RdfJsonTransformation.getAttributeValue(rdfTypeNode, "rdf:resource")) != null && rdfType.equals("http://oryx-editor.org/canvas")) {
                    RdfJsonTransformation.handleCanvas(node);
                    continue;
                }
                RdfJsonTransformation.handleShape(node);
            }
        }
        RdfJsonTransformation.setupParentRelationships();
        return canvas;
    }

    private static void handleCanvas(Node n) {
        try {
            canvas.put("resourceId", (Object)RdfJsonTransformation.getResourceId(n));
            canvas.put("childShapes", (Object)new JSONArray());
            RdfJsonTransformation.handleProperties(n, canvas);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static void handleShape(Node n) {
        try {
            if (!RdfJsonTransformation.isValidShapeNode(n)) {
                return;
            }
            String resourceId = RdfJsonTransformation.getResourceId(n);
            JSONObject shape = new JSONObject();
            shape.put("resourceId", (Object)resourceId);
            objects.put(resourceId, shape);
            parents.put(resourceId, RdfJsonTransformation.getParentResourceId(n));
            shape.put("outgoing", (Object)new JSONArray());
            shape.put("childShapes", (Object)new JSONArray());
            RdfJsonTransformation.handleProperties(n, shape);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static boolean isValidShapeNode(Node n) {
        if (RdfJsonTransformation.getResourceId(n).length() == 0) {
            return false;
        }
        if (n.hasChildNodes()) {
            return n.getFirstChild().getLocalName() == null || !n.getFirstChild().getLocalName().equals("generatorAgent");
        }
        return false;
    }

    private static void setupParentRelationships() {
        for (String resourceId : parents.keySet()) {
            JSONObject child = objects.get(resourceId);
            JSONObject parent = objects.get(parents.get(resourceId));
            if (parent == null) {
                parent = canvas;
            }
            try {
                parent.getJSONArray("childShapes").put((Object)child);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private static void handleProperties(Node n, JSONObject object) throws JSONException {
        JSONObject properties = new JSONObject();
        object.put("properties", (Object)properties);
        if (n.hasChildNodes()) {
            for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!RdfJsonTransformation.isReservedNodeName(child.getNodeName())) {
                    String content = RdfJsonTransformation.getContent(child);
                    if (content == null) {
                        properties.put(child.getNodeName(), (Object)content);
                        continue;
                    }
                    try {
                        JSONObject jsonObj = new JSONObject(content);
                        properties.put(child.getNodeName(), (Object)jsonObj);
                    }
                    catch (JSONException e) {
                        log.info("conversion error");
                        log.info(content);
                        log.info(e.toString());
                        properties.put(child.getNodeName(), (Object)content);
                    }
                    continue;
                }
                RdfJsonTransformation.handleReservedNodeName(child, object);
            }
        }
    }

    private static void handleReservedNodeName(Node n, JSONObject object) throws JSONException {
        if (n.getNodeName().equals("bounds")) {
            object.put("bounds", (Object)RdfJsonTransformation.getBounds(n));
        } else if (n.getNodeName().equals("dockers")) {
            object.put("dockers", (Object)RdfJsonTransformation.getDockers(n));
        } else if (n.getNodeName().equals("ssextension")) {
            if (!object.has("ssextensions")) {
                object.put("ssextensions", (Object)new JSONArray());
            }
            JSONArray extensions = (JSONArray)object.get("ssextensions");
            extensions.put((Object)RdfJsonTransformation.getContent(n));
        } else if (n.getNodeName().equals("type")) {
            object.put("stencil", (Object)new JSONObject().put("id", (Object)RdfJsonTransformation.getType(n)));
        } else if (n.getNodeName().equals("outgoing")) {
            JSONObject outgoingObject = new JSONObject();
            outgoingObject.put("resourceId", (Object)RdfJsonTransformation.getResourceId(RdfJsonTransformation.getAttributeValue(n, "rdf:resource")));
            object.getJSONArray("outgoing").put((Object)outgoingObject);
        } else if (n.getNodeName().equals("target")) {
            JSONObject target = new JSONObject();
            target.put("resourceId", (Object)RdfJsonTransformation.getResourceId(RdfJsonTransformation.getAttributeValue(n, "rdf:resource")));
            object.put("target", (Object)target);
        } else if (n.getNodeName().equals("stencilset")) {
            JSONObject stencilset;
            if (object.has("stencilset")) {
                stencilset = object.getJSONObject("stencilset");
            } else {
                stencilset = new JSONObject();
                object.put("stencilset", (Object)stencilset);
            }
            String stencilsetUrl = RdfJsonTransformation.getAttributeValue(n, "rdf:resource");
            if (!stencilsetUrl.startsWith(hostUrl)) {
                stencilsetUrl = hostUrl + stencilsetUrl;
            }
            if (stencilsetUrl.lastIndexOf("http://") > 0) {
                stencilsetUrl = stencilsetUrl.substring(stencilsetUrl.lastIndexOf("http://"));
            }
            stencilset.put("url", (Object)stencilsetUrl);
        } else if (n.getNodeName().equals("ssnamespace")) {
            JSONObject stencilset;
            if (object.has("stencilset")) {
                stencilset = object.getJSONObject("stencilset");
            } else {
                stencilset = new JSONObject();
                object.put("stencilset", (Object)stencilset);
            }
            String namespace = RdfJsonTransformation.getAttributeValue(n, "rdf:resource");
            stencilset.put("namespace", (Object)namespace);
        }
    }

    private static JSONObject getBounds(Node n) throws JSONException {
        String boundsString = RdfJsonTransformation.getContent(n);
        if (boundsString == null) {
            return null;
        }
        String[] boundStringArr = boundsString.split(",");
        JSONObject upperLeft = new JSONObject();
        upperLeft.put("x", Double.parseDouble(boundStringArr[0]));
        upperLeft.put("y", Double.parseDouble(boundStringArr[1]));
        JSONObject lowerRight = new JSONObject();
        lowerRight.put("x", Double.parseDouble(boundStringArr[2]));
        lowerRight.put("y", Double.parseDouble(boundStringArr[3]));
        JSONObject bounds = new JSONObject();
        bounds.put("upperLeft", (Object)upperLeft);
        bounds.put("lowerRight", (Object)lowerRight);
        return bounds;
    }

    private static JSONArray getDockers(Node n) throws JSONException {
        String dockersString = RdfJsonTransformation.getContent(n);
        if (dockersString == null) {
            return null;
        }
        String[] dockerPoints = dockersString.replaceAll("#|\\s+", " ").trim().split(" ");
        JSONArray dockers = new JSONArray();
        JSONObject currentDocker = null;
        for (int i = 0; i < dockerPoints.length; ++i) {
            Double point = Double.parseDouble(dockerPoints[i]);
            if (i % 2 == 0) {
                currentDocker = new JSONObject();
                currentDocker.put("x", (Object)point);
                continue;
            }
            currentDocker.put("y", (Object)point);
            dockers.put((Object)currentDocker);
        }
        return dockers;
    }

    private static String getParentResourceId(Node n) {
        Node parentNode = RdfJsonTransformation.getChild(n, "parent");
        if (parentNode == null) {
            return null;
        }
        String parentResourceId = RdfJsonTransformation.getResourceId(RdfJsonTransformation.getAttributeValue(parentNode, "rdf:resource"));
        if (parentResourceId != null) {
            return RdfJsonTransformation.getResourceId(parentResourceId);
        }
        return null;
    }

    private static String getContent(Node node) {
        if (node != null && node.hasChildNodes()) {
            return node.getFirstChild().getNodeValue();
        }
        return null;
    }

    private static String getAttributeValue(Node node, String attribute) {
        Node item = node.getAttributes().getNamedItem(attribute);
        if (item != null) {
            return item.getNodeValue();
        }
        return null;
    }

    private static String getType(Node node) {
        String type = RdfJsonTransformation.getContent(node);
        if (type != null) {
            return type.substring(type.indexOf(35) + 1);
        }
        return null;
    }

    private static String getResourceId(Node node) {
        String attributeValue = RdfJsonTransformation.getAttributeValue(node, "rdf:about");
        if (attributeValue != null) {
            return RdfJsonTransformation.getResourceId(attributeValue);
        }
        return null;
    }

    private static String getResourceId(String id) {
        if (id == null) {
            return null;
        }
        return id.substring(id.indexOf(35) + 1);
    }

    private static Node getChild(Node n, String name) {
        if (n == null) {
            return null;
        }
        for (Node node = n.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.getNodeName().equals(name)) continue;
            return node;
        }
        return null;
    }

    private static Node getRootNode(Document doc) {
        Element node = doc.getDocumentElement();
        if (node == null || !node.getNodeName().equals("rdf:RDF")) {
            return null;
        }
        return node;
    }

    private static boolean isReservedNodeName(String nodeName) {
        for (String n : reservedNodeNames) {
            if (!n.equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    static {
        log = LoggerFactory.getLogger((String)"org.jbpm.designer.server.RdfJsonTransformation");
    }
}

