/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.impl;

import org.jbpm.designer.bpmn2.utils.Bpmn2Loader;
import org.jbpm.designer.bpmn2.validation.BPMN2SyntaxCheckerTest;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.impl.DefaultProfileImpl;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class Bpmn2JsonMarshallerTest {
    DefaultProfileImpl profile = new DefaultProfileImpl();
    IDiagramProfile.IDiagramUnmarshaller marshaller = this.profile.createUnmarshaller();
    public static final String COST_PER_TIME_UNIT = "unitcost";
    public static final String PROCESSING_TIME_MAX = "max";
    public static final String PROCESSING_TIME_MIN = "min";
    public static final String PROCESSING_TIME_MEAN = "mean";
    public static final String PROBABILITY = "probability";
    public static final String WORKING_HOURS = "workinghours";
    public static final String QUANTITY = "quantity";
    public static final String STANDARD_DEVIATION = "standarddeviation";
    public static final String DISTRIBUTION_TYPE = "distributiontype";
    private Bpmn2Loader loader = new Bpmn2Loader(Bpmn2JsonMarshallerTest.class);

    @Test
    public void testGroupMarshalling() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("group.bpmn2");
        JSONObject group = Bpmn2Loader.getChildByName(process, "group");
        Assert.assertNotNull((String)"Group with name 'group' not found in process.", (Object)group);
        Assert.assertEquals((String)"Group has wrong documentation.", (Object)"group documentation", (Object)Bpmn2Loader.getDocumentationFor(group));
    }

    @Test
    public void testBoundaryEventDocumentation() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("boundaryEventsDocumentation.bpmn2");
        JSONObject boundaryEvent = Bpmn2Loader.getChildByName(process, "CancelOnTimer");
        Assert.assertNotNull((String)"BoundaryEvent with name 'CancelOnTimer' not found in process.", (Object)boundaryEvent);
        Assert.assertEquals((String)"BoundaryEvent has wrong documentation.", (Object)"Cancel task on timeout.", (Object)Bpmn2Loader.getDocumentationFor(boundaryEvent));
    }

    @Test
    public void testSwimlaneDocumentation() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("swimlane.bpmn2");
        JSONObject swimlane = Bpmn2Loader.getChildByName(process, "Documented Swimlane");
        Assert.assertNotNull((String)"Swimlane with name 'Documented Swimlane' not found in process.", (Object)swimlane);
        Assert.assertEquals((String)"Swimlane has wrong documentation.", (Object)"Some documentation for swimlane.", (Object)Bpmn2Loader.getDocumentationFor(swimlane));
    }

    @Test
    public void testConstraint() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("constraint.bpmn2");
        JSONObject condition1 = Bpmn2Loader.getChildByName(process, "Condition1");
        JSONObject condition2 = Bpmn2Loader.getChildByName(process, "Condition2");
        JSONObject condition1Properties = condition1.getJSONObject("properties");
        JSONObject condition2Properties = condition2.getJSONObject("properties");
        Assert.assertEquals((Object)"return  KieFunctions.endsWith(customVar, \"sample\");", (Object)condition1Properties.getString("conditionexpression"));
        Assert.assertEquals((Object)"return  !KieFunctions.isNull(intVar);", (Object)condition2Properties.getString("conditionexpression"));
    }

    @Test
    public void testSendTaskDataInputs() throws Exception {
        String[] variableNames = new String[]{"Comment", "Content", "CreatedBy", "GroupId", "Locale", "NotCompletedNotify", "NotCompletedReassign", "NotStartedNotify", "NotStartedReassign", "Priority", "Skippable", "TaskName", "MyDataInput1", "MyDataInput2"};
        JSONObject process = this.loader.loadProcessFromXml("nonusertaskdatainputs.bpmn2");
        JSONObject sendtask = Bpmn2Loader.getChildByName(process, "MySendTask");
        JSONObject properties = sendtask.getJSONObject("properties");
        String datainputset = properties.getString("datainputset");
        for (String variableName : variableNames) {
            String dataInput = variableName + ":String";
            Assert.assertTrue((String)("Variable \"" + variableName + "\" not found in datainputset"), (boolean)datainputset.contains(dataInput));
        }
        String assignments = properties.getString("assignments");
        for (String variableName : variableNames) {
            String assignment = "[din]" + variableName + "=a" + variableName;
            Assert.assertTrue((String)("Assignment \"" + assignment + "\" not found in assignments"), (boolean)assignments.contains(assignment));
        }
    }

    @Test
    public void testCustomTaskTaskName() throws Exception {
        String assignment;
        String dataInput;
        String[] existingVariableNames = new String[]{"Message", "DataInput1"};
        String[] nonExistingVariableNames = new String[]{"TaskName"};
        JSONObject process = this.loader.loadProcessFromXml("customtasktaskname.bpmn2");
        JSONObject logtask = Bpmn2Loader.getChildByName(process, "Log");
        JSONObject properties = logtask.getJSONObject("properties");
        String datainputset = properties.getString("datainputset");
        String assignments = properties.getString("assignments");
        for (String variableName : existingVariableNames) {
            dataInput = variableName + ":String";
            Assert.assertTrue((String)("Variable \"" + variableName + "\" not found in datainputset"), (boolean)datainputset.contains(dataInput));
        }
        for (String variableName : existingVariableNames) {
            assignment = "[din]" + variableName + "=";
            Assert.assertTrue((String)("Assignment \"" + assignment + "\" not found in assignments"), (boolean)assignments.contains(assignment));
        }
        for (String variableName : nonExistingVariableNames) {
            dataInput = variableName + ":String";
            Assert.assertFalse((String)("Variable \"" + variableName + "\" found in datainputset"), (boolean)datainputset.contains(dataInput));
        }
        for (String variableName : nonExistingVariableNames) {
            assignment = "[din]" + variableName + "=";
            Assert.assertFalse((String)("Assignment \"" + assignment + "\" found in assignments"), (boolean)assignments.contains(assignment));
        }
    }

    @Test
    public void testSimulationStartEvent() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject startEvent = Bpmn2Loader.getChildByName(process, "StartEvent");
        JSONObject properties = startEvent.getJSONObject("properties");
        Assert.assertEquals((long)99L, (long)properties.getInt(PROBABILITY));
        Assert.assertEquals((long)5L, (long)properties.getInt(PROCESSING_TIME_MAX));
        Assert.assertEquals((long)4L, (long)properties.getInt(PROCESSING_TIME_MIN));
        Assert.assertEquals((Object)"uniform", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationUserTask() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject userTask = Bpmn2Loader.getChildByName(process, "UserTask");
        JSONObject properties = userTask.getJSONObject("properties");
        Assert.assertEquals((long)8L, (long)properties.getInt(COST_PER_TIME_UNIT));
        Assert.assertEquals((long)7L, (long)properties.getInt(PROCESSING_TIME_MAX));
        Assert.assertEquals((long)3L, (long)properties.getInt(PROCESSING_TIME_MIN));
        Assert.assertEquals((long)5L, (long)properties.getInt(WORKING_HOURS));
        Assert.assertEquals((long)2L, (long)properties.getInt(QUANTITY));
        Assert.assertEquals((Object)"uniform", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationGatewayProbability() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject lowSequence = Bpmn2Loader.getChildByName(process, "LowProbability");
        JSONObject highSequence = Bpmn2Loader.getChildByName(process, "HighProbability");
        JSONObject lowProperties = lowSequence.getJSONObject("properties");
        Assert.assertEquals((long)30L, (long)lowProperties.getInt(PROBABILITY));
        JSONObject highProperties = highSequence.getJSONObject("properties");
        Assert.assertEquals((long)70L, (long)highProperties.getInt(PROBABILITY));
    }

    @Test
    public void testSimulationThrowEvent() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject throwEvent = Bpmn2Loader.getChildByName(process, "ThrowEvent");
        JSONObject properties = throwEvent.getJSONObject("properties");
        Assert.assertEquals((long)3L, (long)properties.getInt(PROCESSING_TIME_MEAN));
        Assert.assertEquals((Object)"poisson", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationCallActivity() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject callActivity = Bpmn2Loader.getChildByName(process, "CallActivity");
        JSONObject properties = callActivity.getJSONObject("properties");
        Assert.assertEquals((long)3L, (long)properties.getInt(COST_PER_TIME_UNIT));
        Assert.assertEquals((long)2L, (long)properties.getInt(PROCESSING_TIME_MEAN));
        Assert.assertEquals((long)1L, (long)properties.getInt(STANDARD_DEVIATION));
        Assert.assertEquals((Object)"normal", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationEndEvent() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject endEvent = Bpmn2Loader.getChildByName(process, "EndEvent");
        JSONObject properties = endEvent.getJSONObject("properties");
        Assert.assertEquals((long)9L, (long)properties.getInt(PROCESSING_TIME_MAX));
        Assert.assertEquals((long)8L, (long)properties.getInt(PROCESSING_TIME_MIN));
        Assert.assertEquals((Object)"uniform", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationSubProcess() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject subProcess = Bpmn2Loader.getChildByName(process, "SubProcess");
        JSONObject properties = subProcess.getJSONObject("properties");
        Assert.assertEquals((long)12L, (long)properties.getInt(COST_PER_TIME_UNIT));
        Assert.assertEquals((long)6L, (long)properties.getInt(PROCESSING_TIME_MAX));
        Assert.assertEquals((long)2L, (long)properties.getInt(PROCESSING_TIME_MIN));
        Assert.assertEquals((Object)"uniform", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationSubService() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject serviceTask = Bpmn2Loader.getChildByName(Bpmn2Loader.getChildByName(process, "SubProcess"), "SubService");
        JSONObject properties = serviceTask.getJSONObject("properties");
        Assert.assertEquals((long)14L, (long)properties.getInt(COST_PER_TIME_UNIT));
        Assert.assertEquals((long)7L, (long)properties.getInt(PROCESSING_TIME_MEAN));
        Assert.assertEquals((Object)"poisson", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationBoundaryEvent() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject boundaryEvent = Bpmn2Loader.getChildByName(process, "BoundaryEvent");
        JSONObject properties = boundaryEvent.getJSONObject("properties");
        Assert.assertEquals((long)13L, (long)properties.getInt(PROCESSING_TIME_MAX));
        Assert.assertEquals((long)4L, (long)properties.getInt(PROCESSING_TIME_MIN));
        Assert.assertEquals((long)85L, (long)properties.getInt(PROBABILITY));
        Assert.assertEquals((Object)"uniform", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testSimulationCancelEvent() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("simulationProcess.bpmn2");
        JSONObject cancelEvent = Bpmn2Loader.getChildByName(process, "CancelEvent");
        JSONObject properties = cancelEvent.getJSONObject("properties");
        Assert.assertEquals((long)15L, (long)properties.getInt(PROCESSING_TIME_MAX));
        Assert.assertEquals((long)6L, (long)properties.getInt(PROCESSING_TIME_MIN));
        Assert.assertEquals((Object)"uniform", (Object)properties.getString(DISTRIBUTION_TYPE));
    }

    @Test
    public void testUserTaskAndTaskName() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("userTaskWithTaskName.bpmn2", BPMN2SyntaxCheckerTest.class);
        JSONObject userTask = Bpmn2Loader.getChildByName(process, "User Task");
        JSONObject properties = userTask.getJSONObject("properties");
        Assert.assertEquals((Object)"taskForSomebody", (Object)properties.getString("taskname"));
        Assert.assertEquals((Object)true, (Object)properties.getBoolean("isasync"));
    }

    @Test
    public void testCallActivityAssignments() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("callActivityInSubprocess.bpmn2");
        JSONObject subProcess = Bpmn2Loader.getChildByName(process, "SubProcess");
        JSONObject callActivity = Bpmn2Loader.getChildByName(subProcess, "callActivity");
        JSONObject properties = callActivity.getJSONObject("properties");
        String datainputset = properties.getString("datainputset");
        String dataoutputset = properties.getString("dataoutputset");
        String assignments = properties.getString("assignments");
        Assert.assertTrue((boolean)assignments.contains("[dout]innerOutput->intVariable"));
        Assert.assertTrue((boolean)assignments.contains("[din]intVariable->innerInput"));
        Assert.assertTrue((boolean)assignments.contains("[din]innerConstant=stringConstant"));
        Assert.assertTrue((boolean)datainputset.contains("innerInput:Integer"));
        Assert.assertTrue((boolean)datainputset.contains("innerConstant:String"));
        Assert.assertTrue((boolean)dataoutputset.contains("innerOutput:Integer"));
    }

    @Test
    public void testCallActivity() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("callActivity.bpmn2", BPMN2SyntaxCheckerTest.class);
        JSONObject callActivity = Bpmn2Loader.getChildByName(process, "callActivity");
        JSONObject properties = callActivity.getJSONObject("properties");
        Assert.assertEquals((Object)"abc.noCalledElementCallActivity", (Object)properties.getString("calledelement"));
    }

    @Test
    public void testNoCalledElementCallActivity() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("noCalledElementCallActivity.bpmn2", BPMN2SyntaxCheckerTest.class);
        JSONObject callActivity = Bpmn2Loader.getChildByName(process, "callActivity");
        JSONObject properties = callActivity.getJSONObject("properties");
        Assert.assertFalse((boolean)properties.has("calledelement"));
    }

    @Test
    public void testErrorBoundaryEvent() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("errorBoundaryEvent.bpmn2", BPMN2SyntaxCheckerTest.class);
        JSONObject lane = Bpmn2Loader.getChildByName(process, "myLane");
        JSONObject error = Bpmn2Loader.getChildByName(lane, "MyError");
        JSONObject properties = error.getJSONObject("properties");
        Assert.assertEquals((Object)"errorReference", (Object)properties.getString("errorref"));
    }

    @Test
    public void testErrorBoundaryEventMissingDefinition() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("errorBoundaryEventMissingDefinition.bpmn2", BPMN2SyntaxCheckerTest.class);
        JSONObject lane = Bpmn2Loader.getChildByName(process, "myLane");
        JSONObject error = Bpmn2Loader.getChildByName(lane, "MyError");
        JSONObject properties = error.getJSONObject("properties");
        Assert.assertEquals((Object)"", (Object)properties.getString("errorref"));
    }

    @Test
    public void testServiceTaskInterfaceAndOperation() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("serviceTaskInterfaceAndOperation.bpmn2");
        JSONObject serviceTask = Bpmn2Loader.getChildByName(process, "Send PO");
        JSONObject properties = serviceTask.getJSONObject("properties");
        Assert.assertEquals((Object)"Java", (Object)properties.getString("serviceimplementation"));
        Assert.assertEquals((Object)"sendInterface", (Object)properties.getString("serviceinterface"));
        Assert.assertEquals((Object)"sendOperation", (Object)properties.getString("serviceoperation"));
        Assert.assertEquals((Object)true, (Object)properties.getBoolean("isasync"));
    }

    @Test
    public void testServiceTaskNoInterfaceNoOperation() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("serviceTaskNoInterfaceNoOperation.bpmn2");
        JSONObject serviceTask = Bpmn2Loader.getChildByName(process, "Send PO");
        JSONObject properties = serviceTask.getJSONObject("properties");
        Assert.assertEquals((Object)"Java", (Object)properties.getString("serviceimplementation"));
        Assert.assertEquals((Object)"", (Object)properties.getString("serviceinterface"));
        Assert.assertEquals((Object)"", (Object)properties.getString("serviceoperation"));
    }

    @Test
    public void testSubprocessTaskAssignments() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("subprocessTaskAssignments.bpmn2");
        JSONObject subprocess = Bpmn2Loader.getChildByName(process, "Embedded subprocess");
        JSONObject userTask = Bpmn2Loader.getChildByName(subprocess, "UserTask");
        JSONObject properties = userTask.getJSONObject("properties");
        Assert.assertTrue((boolean)properties.getString("datainputset").contains("sInput:String"));
        Assert.assertTrue((boolean)properties.getString("dataoutputset").contains("iOutput:Integer"));
        JSONObject subprocessProperties = subprocess.getJSONObject("properties");
        Assert.assertEquals((Object)true, (Object)subprocessProperties.getBoolean("isasync"));
    }

    @Test
    public void testEndEventsAssignments() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("subprocessTaskAssignments.bpmn2");
        JSONObject subprocess = Bpmn2Loader.getChildByName(process, "Embedded subprocess");
        JSONObject subEnd = Bpmn2Loader.getChildByName(subprocess, "SubEnd");
        JSONObject subProperties = subEnd.getJSONObject("properties");
        Assert.assertEquals((Object)"intSubInput:Integer", (Object)subProperties.getString("datainput"));
        Assert.assertEquals((Object)"[din]intVar->intSubInput", (Object)subProperties.getString("datainputassociations"));
        JSONObject endEvent = Bpmn2Loader.getChildByName(process, "End Event");
        JSONObject properties = endEvent.getJSONObject("properties");
        Assert.assertEquals((Object)"intInput:Integer", (Object)properties.getString("datainput"));
        Assert.assertEquals((Object)"[din]intVar->intInput", (Object)properties.getString("datainputassociations"));
    }

    @Test
    public void testBusinessRuleTask() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("businessRule.bpmn2", BPMN2SyntaxCheckerTest.class);
        JSONObject ruleTask = Bpmn2Loader.getChildByName(process, "businessRuleTask");
        JSONObject properties = ruleTask.getJSONObject("properties");
        Assert.assertEquals((Object)"simpleGroup", (Object)properties.getString("ruleflowgroup"));
        Assert.assertEquals((Object)true, (Object)properties.getBoolean("isasync"));
    }

    @Test
    public void testReceiveTask() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("receiveTask.bpmn2");
        JSONObject receiveTask = Bpmn2Loader.getChildByName(process, "receiveTask");
        JSONObject properties = receiveTask.getJSONObject("properties");
        Assert.assertEquals((Object)"parcel", (Object)properties.getString("messageref"));
        Assert.assertEquals((Object)true, (Object)properties.getBoolean("isasync"));
    }

    @Test
    public void testSendTask() throws Exception {
        JSONObject process = this.loader.loadProcessFromXml("sendTask.bpmn2");
        JSONObject sendTask = Bpmn2Loader.getChildByName(process, "sendTask");
        JSONObject properties = sendTask.getJSONObject("properties");
        Assert.assertEquals((Object)"parcel", (Object)properties.getString("messageref"));
        Assert.assertEquals((Object)true, (Object)properties.getBoolean("isasync"));
    }

    @Test
    public void testRestTaskAssignments() throws Exception {
        String[] existingVariableNames = new String[]{"Content", "ContentType", "ResultClass", "Method", "Username", "Password", "ReadTimeout", "ConnectTimeout", "Url"};
        JSONObject process = this.loader.loadProcessFromXml("restTask.bpmn2");
        JSONObject restTask = Bpmn2Loader.getChildByName(process, "REST");
        JSONObject properties = restTask.getJSONObject("properties");
        String datainputset = properties.getString("datainputset");
        String dataoutputset = properties.getString("dataoutputset");
        String assignments = properties.getString("assignments");
        for (String variableName : existingVariableNames) {
            String dataInput = variableName + ":String";
            Assert.assertTrue((String)("Variable \"" + variableName + "\" not found in datainputset"), (boolean)datainputset.contains(dataInput));
        }
        for (String variableName : existingVariableNames) {
            String assignment = "[din]" + variableName + "=";
            Assert.assertTrue((String)("Assignment \"" + assignment + "\" not found in assignments"), (boolean)assignments.contains(assignment));
        }
        Assert.assertTrue((boolean)assignments.contains("[dout]Result->processVariable"));
        Assert.assertTrue((boolean)dataoutputset.contains("Result:java.lang.Object"));
    }
}

