/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.bpmn2.validation;

import bpsim.BPSimDataType;
import bpsim.BpsimPackage;
import bpsim.CostParameters;
import bpsim.ElementParameters;
import bpsim.FloatingParameterType;
import bpsim.ResourceParameters;
import bpsim.Scenario;
import bpsim.impl.BpsimFactoryImpl;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.Artifact;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ComplexGateway;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.EventSubprocess;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.Relationship;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.ScriptTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.UserTask;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.designer.bpmn2.validation.SyntaxChecker;
import org.jbpm.designer.bpmn2.validation.SyntaxCheckerErrors;
import org.jbpm.designer.bpmn2.validation.SyntaxCheckerUtils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.validation.RuleFlowProcessValidator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPMN2SyntaxChecker
implements SyntaxChecker {
    public static final String BPMN2_TYPE = "BPMN2";
    public static final String SIMULATION_TYPE = "Simulation";
    public static final String PROCESS_TYPE = "Process";
    private static final Logger _logger = LoggerFactory.getLogger(BPMN2SyntaxChecker.class);
    protected Map<String, List<ValidationSyntaxError>> errors = new HashMap<String, List<ValidationSyntaxError>>();
    private String json;
    private String preprocessingData;
    private IDiagramProfile profile;
    private String defaultResourceId = "processerrors";

    public BPMN2SyntaxChecker(String json, String preprocessingData, IDiagramProfile profile) {
        this.json = json;
        this.preprocessingData = preprocessingData;
        this.profile = profile;
    }

    @Override
    public void checkSyntax() {
        DroolsFactoryImpl.init();
        BpsimFactoryImpl.init();
        Process process = null;
        try {
            Definitions def = this.profile.createMarshaller().getDefinitions(this.json, this.preprocessingData);
            List rootElements = def.getRootElements();
            Scenario defaultScenario = this.getDefaultScenario(def);
            for (RootElement root : rootElements) {
                List processProperties;
                if (!(root instanceof Process)) continue;
                process = (Process)root;
                if (BPMN2SyntaxChecker.isEmpty(process.getId())) {
                    this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Process has no id."));
                } else if (!SyntaxCheckerUtils.isNCName(process.getId())) {
                    this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Invalid process id. See http://www.w3.org/TR/REC-xml-names/#NT-NCName for more info."));
                } else {
                    this.defaultResourceId = process.getId();
                }
                Iterator iter = process.getAnyAttribute().iterator();
                boolean foundPackageName = false;
                while (iter.hasNext()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
                    if (!entry.getEStructuralFeature().getName().equals("packageName")) continue;
                    foundPackageName = true;
                    String pname = (String)entry.getValue();
                    if (BPMN2SyntaxChecker.isEmpty(pname)) {
                        this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Process has no package name."));
                    }
                    if (this.isValidPackageName(pname)) continue;
                    this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Package name contains invalid characters."));
                }
                if (!foundPackageName) {
                    this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Process has no package name."));
                }
                if (BPMN2SyntaxChecker.isEmpty(process.getName())) {
                    this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Process has no name."));
                }
                if ((processProperties = process.getProperties()) != null && processProperties.size() > 0) {
                    for (Property prop : processProperties) {
                        String propId = prop.getId();
                        Pattern pattern = Pattern.compile("\\s");
                        Matcher matcher = pattern.matcher(propId);
                        if (!matcher.find()) continue;
                        this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, SyntaxCheckerErrors.processVariableContainsWhiteSpaces(propId)));
                    }
                }
                boolean foundStartEvent = false;
                boolean foundEndEvent = false;
                List flowElements = process.getFlowElements();
                for (FlowElement fe : flowElements) {
                    if (fe instanceof StartEvent) {
                        foundStartEvent = true;
                    }
                    if (!(fe instanceof EndEvent)) continue;
                    foundEndEvent = true;
                }
                if (!foundStartEvent && !this.isAdHocProcess(process)) {
                    this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Process has no start node."));
                }
                if (!foundEndEvent && !this.isAdHocProcess(process)) {
                    this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, BPMN2_TYPE, "Process has no end node."));
                }
                this.checkFlowElements((FlowElementsContainer)process, process, defaultScenario);
            }
        }
        catch (Exception e) {
            this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, PROCESS_TYPE, "Could not parse BPMN2 process."));
        }
        if (this.errors.size() < 1) {
            try {
                SemanticModules modules = new SemanticModules();
                modules.addSemanticModule((SemanticModule)new BPMNSemanticModule());
                modules.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
                XmlProcessReader xmlReader = new XmlProcessReader(modules, this.getClass().getClassLoader());
                List processes = xmlReader.read((Reader)new StringReader(this.profile.createMarshaller().parseModel(this.json, this.preprocessingData)));
                if (processes != null) {
                    ProcessValidationError[] errors;
                    for (ProcessValidationError er : errors = RuleFlowProcessValidator.getInstance().validateProcess((RuleFlowProcess)processes.get(0))) {
                        this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, PROCESS_TYPE, er.getMessage()));
                    }
                }
            }
            catch (Exception e) {
                _logger.warn("Could not parse to RuleFlowProcess.");
                this.addError(this.defaultResourceId, new ValidationSyntaxError((BaseElement)process, PROCESS_TYPE, "Could not parse BPMN2 to RuleFlowProcess."));
            }
        }
    }

    private void checkFlowElements(FlowElementsContainer container, Process process, Scenario defaultScenario) {
        for (FlowElement fe : container.getFlowElements()) {
            if (fe instanceof StartEvent) {
                this.checkStartEvent((StartEvent)fe, container, process);
            } else if (fe instanceof EndEvent) {
                this.checkEndEvent((EndEvent)fe, container, process);
            } else if (fe instanceof FlowNode) {
                this.checkFlowNode((FlowNode)fe, container, process);
            }
            if (fe instanceof BusinessRuleTask) {
                this.checkBusinessRuleTask((BusinessRuleTask)fe);
            }
            if (fe instanceof ScriptTask) {
                this.checkScriptTask((ScriptTask)fe);
            }
            if (fe instanceof ReceiveTask) {
                this.checkReceiveTask((ReceiveTask)fe);
            }
            if (fe instanceof SendTask) {
                this.checkSendTask((SendTask)fe);
            }
            if (fe instanceof ServiceTask) {
                this.checkServiceTask((ServiceTask)fe);
            }
            if (fe instanceof UserTask) {
                this.checkUserTask((UserTask)fe, defaultScenario);
            }
            if (fe instanceof Task) {
                this.checkTask((Task)fe, defaultScenario);
            }
            if (fe instanceof CatchEvent) {
                this.checkCatchEvent((CatchEvent)fe);
            }
            if (fe instanceof ThrowEvent) {
                this.checkThrowEvent((ThrowEvent)fe);
            }
            if (fe instanceof SequenceFlow) {
                this.checkSequenceFlow((SequenceFlow)fe);
            }
            if (fe instanceof Gateway) {
                this.checkGateway((Gateway)fe, defaultScenario);
            }
            if (fe instanceof CallActivity) {
                this.checkCallActivity((CallActivity)fe);
            }
            if (fe instanceof DataObject) {
                this.checkDataObject((DataObject)fe);
            }
            if (!(fe instanceof SubProcess)) continue;
            this.checkFlowElements((FlowElementsContainer)((SubProcess)fe), process, defaultScenario);
        }
    }

    private void checkStartEvent(StartEvent startEvent, FlowElementsContainer container, Process process) {
        if (startEvent.getOutgoing() == null || startEvent.getOutgoing().isEmpty()) {
            if (container instanceof Process) {
                if (!this.isAdHocProcess(process)) {
                    this.addError((BaseElement)startEvent, new ValidationSyntaxError((BaseElement)startEvent, BPMN2_TYPE, "Start node has no outgoing connections"));
                }
            } else if (container instanceof SubProcess) {
                if (!(container instanceof AdHocSubProcess)) {
                    this.addError((BaseElement)startEvent, new ValidationSyntaxError((BaseElement)startEvent, BPMN2_TYPE, "Start node has no outgoing connections"));
                }
            } else {
                this.addError((BaseElement)startEvent, new ValidationSyntaxError((BaseElement)startEvent, BPMN2_TYPE, "Start node has no outgoing connections"));
            }
        }
    }

    private void checkEndEvent(EndEvent endEvent, FlowElementsContainer container, Process process) {
        if (endEvent.getIncoming() == null || endEvent.getIncoming().isEmpty()) {
            if (container instanceof Process) {
                if (!this.isAdHocProcess(process)) {
                    this.addError((BaseElement)endEvent, new ValidationSyntaxError((BaseElement)endEvent, BPMN2_TYPE, "End node has no incoming connections"));
                }
            } else if (container instanceof SubProcess) {
                if (!(container instanceof AdHocSubProcess)) {
                    this.addError((BaseElement)endEvent, new ValidationSyntaxError((BaseElement)endEvent, BPMN2_TYPE, "End node has no incoming connections"));
                }
            } else {
                this.addError((BaseElement)endEvent, new ValidationSyntaxError((BaseElement)endEvent, BPMN2_TYPE, "End node has no incoming connections"));
            }
        }
    }

    private void checkFlowNode(FlowNode flowNode, FlowElementsContainer container, Process process) {
        if (!(flowNode.getOutgoing() != null && !flowNode.getOutgoing().isEmpty() || this.isAdHocProcess(process) || flowNode instanceof BoundaryEvent || flowNode instanceof EventSubprocess)) {
            if (container instanceof Process) {
                if (!this.isAdHocProcess(process) && !this.isCompensatingFlowNodeInProcess(flowNode, (Process)container)) {
                    this.addError((BaseElement)flowNode, new ValidationSyntaxError((BaseElement)flowNode, BPMN2_TYPE, "Node has no outgoing connections"));
                }
            } else if (container instanceof SubProcess) {
                if (!(container instanceof AdHocSubProcess) && !this.isCompensatingFlowNodeInSubprocess(flowNode, (SubProcess)container)) {
                    this.addError((BaseElement)flowNode, new ValidationSyntaxError((BaseElement)flowNode, BPMN2_TYPE, "Node has no outgoing connections"));
                }
            } else {
                this.addError((BaseElement)flowNode, new ValidationSyntaxError((BaseElement)flowNode, BPMN2_TYPE, "Node has no outgoing connections"));
            }
        }
        if (!(flowNode instanceof BoundaryEvent || flowNode.getIncoming() != null && !flowNode.getIncoming().isEmpty() || this.isAdHocProcess(process))) {
            if (container instanceof Process) {
                if (!(this.isAdHocProcess(process) || flowNode instanceof EventSubprocess || this.isCompensatingFlowNodeInProcess(flowNode, (Process)container))) {
                    this.addError((BaseElement)flowNode, new ValidationSyntaxError((BaseElement)flowNode, BPMN2_TYPE, "Node has no incoming connections"));
                }
            } else if (container instanceof SubProcess) {
                if (!(container instanceof AdHocSubProcess) && !this.isCompensatingFlowNodeInSubprocess(flowNode, (SubProcess)container)) {
                    this.addError((BaseElement)flowNode, new ValidationSyntaxError((BaseElement)flowNode, BPMN2_TYPE, "Node has no incoming connections"));
                }
            } else {
                this.addError((BaseElement)flowNode, new ValidationSyntaxError((BaseElement)flowNode, BPMN2_TYPE, "Node has no incoming connections"));
            }
        }
    }

    private void checkBusinessRuleTask(BusinessRuleTask businessRuleTask) {
        Iterator biter = businessRuleTask.getAnyAttribute().iterator();
        boolean foundRuleflowGroup = false;
        while (biter.hasNext()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)biter.next();
            if (!entry.getEStructuralFeature().getName().equals("ruleFlowGroup")) continue;
            foundRuleflowGroup = true;
            String ruleflowGroup = (String)entry.getValue();
            if (!BPMN2SyntaxChecker.isEmpty(ruleflowGroup)) continue;
            this.addError((BaseElement)businessRuleTask, new ValidationSyntaxError((BaseElement)businessRuleTask, BPMN2_TYPE, "Business Rule Task has no ruleflow-group."));
        }
        if (!foundRuleflowGroup) {
            this.addError((BaseElement)businessRuleTask, new ValidationSyntaxError((BaseElement)businessRuleTask, BPMN2_TYPE, "Business Rule Task has no ruleflow-group."));
        }
    }

    private void checkScriptTask(ScriptTask scriptTask) {
        if (BPMN2SyntaxChecker.isEmpty(scriptTask.getScript())) {
            this.addError((BaseElement)scriptTask, new ValidationSyntaxError((BaseElement)scriptTask, BPMN2_TYPE, "Script Task has no script."));
        }
        if (BPMN2SyntaxChecker.isEmpty(scriptTask.getScriptFormat())) {
            this.addError((BaseElement)scriptTask, new ValidationSyntaxError((BaseElement)scriptTask, BPMN2_TYPE, "Script Task has no script format."));
        }
    }

    private void checkReceiveTask(ReceiveTask receiveTask) {
        this.checkMessageRefOfTask((Task)receiveTask, receiveTask.getMessageRef());
    }

    private void checkSendTask(SendTask sendTask) {
        this.checkMessageRefOfTask((Task)sendTask, sendTask.getMessageRef());
    }

    private void checkMessageRefOfTask(Task task, Message message) {
        if (message == null) {
            this.addError((BaseElement)task, new ValidationSyntaxError((BaseElement)task, BPMN2_TYPE, "Task has no message."));
        }
    }

    private void checkServiceTask(ServiceTask serviceTask) {
        if (serviceTask.getOperationRef() == null) {
            this.addError((BaseElement)serviceTask, new ValidationSyntaxError((BaseElement)serviceTask, BPMN2_TYPE, "Service Task has no operation."));
        }
    }

    private void checkUserTask(UserTask userTask, Scenario defaultScenario) {
        String taskName = null;
        boolean foundTaskName = false;
        if (userTask.getIoSpecification() != null && userTask.getIoSpecification().getDataInputs() != null) {
            List taskDataInputs = userTask.getIoSpecification().getDataInputs();
            for (DataInput din : taskDataInputs) {
                if (din.getName() == null || !din.getName().equals("TaskName")) continue;
                List taskDataInputAssociations = userTask.getDataInputAssociations();
                for (DataInputAssociation dia : taskDataInputAssociations) {
                    if (dia.getTargetRef().getId() == null || !dia.getTargetRef().getId().equals(din.getId())) continue;
                    foundTaskName = true;
                    taskName = ((FormalExpression)((Assignment)dia.getAssignment().get(0)).getFrom()).getBody();
                    if (!BPMN2SyntaxChecker.isEmpty(taskName)) continue;
                    this.addError((BaseElement)userTask, new ValidationSyntaxError((BaseElement)userTask, BPMN2_TYPE, "User Task has no task name."));
                }
            }
        }
        if (!foundTaskName) {
            this.addError((BaseElement)userTask, new ValidationSyntaxError((BaseElement)userTask, BPMN2_TYPE, "User Task has no task name."));
        }
        for (ElementParameters eleType : this.getElementParameters(defaultScenario, (BaseElement)userTask)) {
            FloatingParameterType quantityVal;
            double val;
            ResourceParameters resourceParams;
            if (eleType.getResourceParameters() == null || (resourceParams = eleType.getResourceParameters()).getQuantity() == null || !((val = (quantityVal = (FloatingParameterType)resourceParams.getQuantity().getParameterValue().get(0)).getValue()) < 0.0)) continue;
            this.addError((BaseElement)userTask, new ValidationSyntaxError((BaseElement)userTask, SIMULATION_TYPE, "Staff Availability value must be positive."));
        }
    }

    private void checkTask(Task task, Scenario defaultScenario) {
        for (ElementParameters eleType : this.getElementParameters(defaultScenario, (BaseElement)task)) {
            FloatingParameterType workingHoursVal;
            ResourceParameters resourceParams;
            FloatingParameterType unitCostVal;
            Double val;
            CostParameters costParams;
            if (eleType.getCostParameters() != null && (costParams = eleType.getCostParameters()).getUnitCost() != null && (val = Double.valueOf((unitCostVal = (FloatingParameterType)costParams.getUnitCost().getParameterValue().get(0)).getValue())) < 0.0) {
                this.addError((BaseElement)task, new ValidationSyntaxError((BaseElement)task, SIMULATION_TYPE, "Cost per Time Unit value must be positive."));
            }
            if (eleType.getResourceParameters() == null || (resourceParams = eleType.getResourceParameters()).getQuantity() == null || !((workingHoursVal = (FloatingParameterType)resourceParams.getQuantity().getParameterValue().get(0)).getValue() < 0.0)) continue;
            this.addError((BaseElement)task, new ValidationSyntaxError((BaseElement)task, SIMULATION_TYPE, "Working Hours value must be positive."));
        }
    }

    private void checkCatchEvent(CatchEvent catchEvent) {
        List eventdefs = catchEvent.getEventDefinitions();
        for (EventDefinition ed : eventdefs) {
            this.checkEventDefinition((Event)catchEvent, ed, false);
        }
    }

    private void checkThrowEvent(ThrowEvent throwEvent) {
        List eventdefs = throwEvent.getEventDefinitions();
        for (EventDefinition ed : eventdefs) {
            this.checkEventDefinition((Event)throwEvent, ed, true);
        }
    }

    private void checkGateway(Gateway gateway, Scenario defaultScenario) {
        List outgoingGwSequenceFlows;
        List outgoingFlows;
        if (gateway.getGatewayDirection() == null || gateway.getGatewayDirection().getValue() == GatewayDirection.UNSPECIFIED.getValue()) {
            this.addError((BaseElement)gateway, new ValidationSyntaxError((BaseElement)gateway, BPMN2_TYPE, "Gateway does not specify a valid direction."));
        }
        if (gateway instanceof ExclusiveGateway) {
            if (gateway.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue() && gateway.getGatewayDirection().getValue() != GatewayDirection.CONVERGING.getValue()) {
                this.addError((BaseElement)gateway, new ValidationSyntaxError((BaseElement)gateway, BPMN2_TYPE, "Invalid Gateway direction for Exclusing Gateway. It should be 'Converging' or 'Diverging'."));
            }
            this.checkDefaultGate(gateway, ((ExclusiveGateway)gateway).getDefault());
        }
        if (gateway instanceof EventBasedGateway && gateway.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue()) {
            this.addError((BaseElement)gateway, new ValidationSyntaxError((BaseElement)gateway, BPMN2_TYPE, "Invalid Gateway direction for EventBased Gateway. It should be 'Diverging'."));
        }
        if (gateway instanceof ParallelGateway && gateway.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue() && gateway.getGatewayDirection().getValue() != GatewayDirection.CONVERGING.getValue()) {
            this.addError((BaseElement)gateway, new ValidationSyntaxError((BaseElement)gateway, BPMN2_TYPE, "Invalid Gateway direction for Parallel Gateway. It should be 'Converging' or 'Diverging'."));
        }
        if (gateway instanceof InclusiveGateway) {
            if (gateway.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue()) {
                this.addError((BaseElement)gateway, new ValidationSyntaxError((BaseElement)gateway, BPMN2_TYPE, "Invalid Gateway direction for Inclusive Gateway. It should be 'Diverging'."));
            }
            this.checkDefaultGate(gateway, ((InclusiveGateway)gateway).getDefault());
        }
        if (gateway instanceof ComplexGateway && gateway.getGatewayDirection().getValue() != GatewayDirection.DIVERGING.getValue() && gateway.getGatewayDirection().getValue() != GatewayDirection.CONVERGING.getValue()) {
            this.addError((BaseElement)gateway, new ValidationSyntaxError((BaseElement)gateway, BPMN2_TYPE, "Invalid Gateway direction for Complex Gateway. It should be 'Converging' or 'Diverging'."));
        }
        if ((gateway instanceof ExclusiveGateway || gateway instanceof InclusiveGateway) && gateway.getGatewayDirection().getValue() == GatewayDirection.DIVERGING.getValue() && (outgoingFlows = gateway.getOutgoing()) != null && outgoingFlows.size() > 0) {
            for (SequenceFlow flow : outgoingFlows) {
                if (flow.getConditionExpression() == null) {
                    this.addError((BaseElement)flow, new ValidationSyntaxError((BaseElement)flow, BPMN2_TYPE, "Sequence flow has no condition expression defined."));
                    continue;
                }
                if (flow.getConditionExpression() instanceof FormalExpression) {
                    FormalExpression formalExp = (FormalExpression)flow.getConditionExpression();
                    if (formalExp.getBody() != null || !formalExp.getBody().isEmpty()) continue;
                    this.addError((BaseElement)flow, new ValidationSyntaxError((BaseElement)flow, BPMN2_TYPE, "Sequence flow has no condition expression defined."));
                    continue;
                }
                this.addError((BaseElement)flow, new ValidationSyntaxError((BaseElement)flow, BPMN2_TYPE, "Invalid condition expression on sequence flow."));
            }
        }
        if ((outgoingGwSequenceFlows = gateway.getOutgoing()) != null && outgoingGwSequenceFlows.size() > 0) {
            double probabilitySum = 0.0;
            boolean defaultSimulationOutgoingFlow = false;
            for (SequenceFlow sf : outgoingGwSequenceFlows) {
                for (ElementParameters eleType : this.getElementParameters(defaultScenario, (BaseElement)sf)) {
                    if (eleType.getControlParameters() != null && eleType.getControlParameters().getProbability() != null) {
                        FloatingParameterType valType = (FloatingParameterType)eleType.getControlParameters().getProbability().getParameterValue().get(0);
                        if (valType.getValue() < 0.0) {
                            this.addError((BaseElement)sf, new ValidationSyntaxError((BaseElement)sf, SIMULATION_TYPE, "Probability value must be positive."));
                            continue;
                        }
                        if (valType.getValue() == 100.0) {
                            defaultSimulationOutgoingFlow = true;
                        }
                        probabilitySum += valType.getValue();
                        continue;
                    }
                    this.addError((BaseElement)sf, new ValidationSyntaxError((BaseElement)sf, SIMULATION_TYPE, "Sequence Flow has no probability defined."));
                }
            }
            if (!(gateway instanceof ParallelGateway)) {
                if (gateway instanceof InclusiveGateway) {
                    if (!defaultSimulationOutgoingFlow) {
                        this.addError((BaseElement)gateway, new ValidationSyntaxError((BaseElement)gateway, SIMULATION_TYPE, "At least one outgoing connection should have probability equal to 100."));
                    }
                } else if (probabilitySum != 100.0) {
                    this.addError((BaseElement)gateway, new ValidationSyntaxError((BaseElement)gateway, SIMULATION_TYPE, "The sum of probability values of all outgoing Sequence Flows must be equal 100."));
                }
            }
        }
    }

    private void checkSequenceFlow(SequenceFlow sequenceFlow) {
        if (sequenceFlow.getSourceRef() == null) {
            this.addError((BaseElement)sequenceFlow, new ValidationSyntaxError((BaseElement)sequenceFlow, BPMN2_TYPE, "An Edge must have a source node."));
        }
        if (sequenceFlow.getTargetRef() == null) {
            this.addError((BaseElement)sequenceFlow, new ValidationSyntaxError((BaseElement)sequenceFlow, BPMN2_TYPE, "An Edge must have a target node."));
        }
    }

    private void checkCallActivity(CallActivity callActivity) {
        if (callActivity.getCalledElement() == null || callActivity.getCalledElement().isEmpty()) {
            this.addError((BaseElement)callActivity, new ValidationSyntaxError((BaseElement)callActivity, BPMN2_TYPE, "Reusable Subprocess has no called element specified."));
        }
    }

    private void checkDataObject(DataObject dataObject) {
        if (dataObject.getName() == null || dataObject.getName().isEmpty()) {
            this.addError((BaseElement)dataObject, new ValidationSyntaxError((BaseElement)dataObject, BPMN2_TYPE, "Data Object has no name defined."));
        } else if (this.containsWhiteSpace(dataObject.getName())) {
            this.addError((BaseElement)dataObject, new ValidationSyntaxError((BaseElement)dataObject, BPMN2_TYPE, "Data Object name contains white spaces."));
        }
    }

    private void checkEventDefinition(Event event, EventDefinition ed, boolean isThrowingEvent) {
        String prefix;
        String string = prefix = isThrowingEvent ? "Throw Event " : "Catch Event ";
        if (ed instanceof TimerEventDefinition) {
            TimerEventDefinition ted = (TimerEventDefinition)ed;
            if (ted.getTimeDate() != null && ted.getTimeDuration() != null && ted.getTimeCycle() != null) {
                this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, prefix + " has timeDate and timeDuration and timeCycle defined."));
            } else if (ted.getTimeDate() != null && ted.getTimeDuration() != null) {
                this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, prefix + " has both timeDate and timeDuration defined."));
            } else if (ted.getTimeDate() != null && ted.getTimeCycle() != null) {
                this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, prefix + " has both timeDate and timeCycle defined."));
            } else if (ted.getTimeDuration() != null && ted.getTimeCycle() != null) {
                this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, prefix + " has both timeduration and timecycle defined."));
            }
            if (ted.getTimeDate() == null && ted.getTimeDuration() == null && ted.getTimeCycle() == null) {
                this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, prefix + " has no timeDate or timeDuration or timeCycle defined."));
            }
        } else if (ed instanceof SignalEventDefinition) {
            if (((SignalEventDefinition)ed).getSignalRef() == null) {
                this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, prefix + " has no signalref."));
            }
        } else if (ed instanceof ErrorEventDefinition) {
            if (((ErrorEventDefinition)ed).getErrorRef() == null || ((ErrorEventDefinition)ed).getErrorRef().getErrorCode() == null) {
                this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, prefix + " has no errorref."));
            }
        } else if (ed instanceof ConditionalEventDefinition) {
            FormalExpression conditionalExp = (FormalExpression)((ConditionalEventDefinition)ed).getCondition();
            if (conditionalExp.getBody() == null) {
                this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, prefix + " has no conditional expression."));
            }
        } else if (ed instanceof EscalationEventDefinition) {
            if (((EscalationEventDefinition)ed).getEscalationRef() == null) {
                this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, prefix + " has no escalationref."));
            }
        } else if (ed instanceof MessageEventDefinition) {
            if (((MessageEventDefinition)ed).getMessageRef() == null) {
                this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, prefix + " has no messageref."));
            }
        } else if (ed instanceof CompensateEventDefinition && ((CompensateEventDefinition)ed).getActivityRef() == null) {
            this.addError((BaseElement)event, new ValidationSyntaxError((BaseElement)event, BPMN2_TYPE, prefix + " has no activityref."));
        }
    }

    private void checkDefaultGate(Gateway gateway, SequenceFlow defaultSequenceFlow) {
        if (defaultSequenceFlow != null && gateway.getOutgoing() != null && !gateway.getOutgoing().contains(defaultSequenceFlow)) {
            this.addError((BaseElement)gateway, new ValidationSyntaxError((BaseElement)gateway, BPMN2_TYPE, "Default gate must be one of outgoing flows."));
        }
    }

    @Override
    public Map<String, List<ValidationSyntaxError>> getErrors() {
        return this.errors;
    }

    @Override
    public JSONObject getErrorsAsJson() {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, List<ValidationSyntaxError>> error : this.getErrors().entrySet()) {
            try {
                JSONArray errorsArray = new JSONArray();
                for (ValidationSyntaxError se : error.getValue()) {
                    errorsArray.put((Object)se.toJSON());
                }
                jsonObject.put(error.getKey(), (Object)errorsArray);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    @Override
    public boolean errorsFound() {
        return this.errors.size() > 0;
    }

    @Override
    public void clearErrors() {
        this.errors.clear();
    }

    private void addError(BaseElement element, ValidationSyntaxError error) {
        this.addError(element.getId(), error);
    }

    private void addError(String resourceId, ValidationSyntaxError error) {
        if (this.errors.containsKey(resourceId) && this.errors.get(resourceId) != null) {
            this.errors.get(resourceId).add(error);
        } else {
            ArrayList<ValidationSyntaxError> value = new ArrayList<ValidationSyntaxError>();
            value.add(error);
            this.errors.put(resourceId, value);
        }
    }

    private static boolean isEmpty(CharSequence str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    private boolean isAdHocProcess(Process process) {
        for (FeatureMap.Entry entry : process.getAnyAttribute()) {
            if (!entry.getEStructuralFeature().getName().equals("adHoc")) continue;
            return Boolean.parseBoolean(((String)entry.getValue()).trim());
        }
        return false;
    }

    public boolean isCompensatingFlowNodeInSubprocess(FlowNode node, SubProcess subProcess) {
        if (node instanceof TextAnnotation) {
            return true;
        }
        for (Artifact artifact : subProcess.getArtifacts()) {
            Association association;
            if (!(artifact instanceof Association) || !(association = (Association)artifact).getTargetRef().getId().equals(node.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean isCompensatingFlowNodeInProcess(FlowNode node, Process process) {
        for (Artifact artifact : process.getArtifacts()) {
            Association association;
            if (!(artifact instanceof Association) || !(association = (Association)artifact).getTargetRef().getId().equals(node.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean containsWhiteSpace(String testString) {
        if (testString != null) {
            for (int i = 0; i < testString.length(); ++i) {
                if (!Character.isWhitespace(testString.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidPackageName(String pkg) {
        Pattern p = Pattern.compile("^[a-zA-Z_\\$][\\w\\$]*(?:\\.[a-zA-Z_\\$][\\w\\$]*)*$");
        return p.matcher(pkg).matches();
    }

    private Scenario getDefaultScenario(Definitions def) {
        if (def.getRelationships() != null && def.getRelationships().size() > 0) {
            Relationship relationship = (Relationship)def.getRelationships().get(0);
            for (ExtensionAttributeValue extattrval : relationship.getExtensionValues()) {
                BPSimDataType processAnalysis;
                FeatureMap extensionElements = extattrval.getValue();
                List bpsimExtensions = (List)extensionElements.get((EStructuralFeature)BpsimPackage.Literals.DOCUMENT_ROOT__BP_SIM_DATA, true);
                if (bpsimExtensions == null || bpsimExtensions.size() <= 0 || (processAnalysis = (BPSimDataType)bpsimExtensions.get(0)).getScenario() == null || processAnalysis.getScenario().size() <= 0) continue;
                return (Scenario)processAnalysis.getScenario().get(0);
            }
        }
        return null;
    }

    private List<ElementParameters> getElementParameters(Scenario scenario, BaseElement element) {
        ArrayList<ElementParameters> elementParameters = new ArrayList<ElementParameters>();
        if (scenario != null && scenario.getElementParameters() != null) {
            for (ElementParameters eleType : scenario.getElementParameters()) {
                if (!eleType.getElementRef().equals(element.getId())) continue;
                elementParameters.add(eleType);
            }
        }
        return elementParameters;
    }

    public class ValidationSyntaxError {
        private BaseElement element;
        private String error;
        private String type;

        public ValidationSyntaxError(BaseElement element, String type, String error) {
            this.element = element;
            this.error = error;
            this.type = type;
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject errorJSON = new JSONObject();
            errorJSON.put("id", (Object)(this.element == null ? "" : this.element.getId()));
            errorJSON.put("type", (Object)this.type);
            errorJSON.put("error", (Object)this.error);
            return errorJSON;
        }

        public BaseElement getElement() {
            return this.element;
        }

        public String getError() {
            return this.error;
        }
    }
}

