/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import bpsim.BPSimDataType;
import bpsim.BpsimPackage;
import bpsim.Scenario;
import bpsim.impl.BpsimFactoryImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.drools.core.command.runtime.rule.InsertElementsCommand;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Relationship;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.bpmn2.impl.Bpmn2JsonUnmarshaller;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.simulation.AggregatedSimulationEvent;
import org.jbpm.simulation.PathFinder;
import org.jbpm.simulation.PathFinderFactory;
import org.jbpm.simulation.PathFormatConverter;
import org.jbpm.simulation.SimulationEvent;
import org.jbpm.simulation.SimulationInfo;
import org.jbpm.simulation.SimulationRepository;
import org.jbpm.simulation.SimulationRunner;
import org.jbpm.simulation.converter.JSONPathFormatConverter;
import org.jbpm.simulation.impl.WorkingMemorySimulationRepository;
import org.jbpm.simulation.impl.events.ActivitySimulationEvent;
import org.jbpm.simulation.impl.events.AggregatedActivitySimulationEvent;
import org.jbpm.simulation.impl.events.AggregatedProcessSimulationEvent;
import org.jbpm.simulation.impl.events.EndSimulationEvent;
import org.jbpm.simulation.impl.events.GatewaySimulationEvent;
import org.jbpm.simulation.impl.events.GenericSimulationEvent;
import org.jbpm.simulation.impl.events.HTAggregatedSimulationEvent;
import org.jbpm.simulation.impl.events.HumanTaskActivitySimulationEvent;
import org.jbpm.simulation.impl.events.StartSimulationEvent;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kie.api.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = LoggerFactory.getLogger(SimulationServlet.class);
    protected static final String ACTION_GETPATHINFO = "getpathinfo";
    protected static final String ACTION_RUNSIMULATION = "runsimulation";
    private ServletConfig config;
    private List<SimulationEvent> eventAggregations = new ArrayList<SimulationEvent>();
    private List<Long> eventAggregationsTimes = new ArrayList<Long>();
    private Map<String, Integer> pathInfoMap = null;
    private DateTime simTime = null;
    private static final String MAX = "Max";
    private static final String MIN = "Min";
    private static final String AVERAGE = "Average";
    private static final String MAX_EXECUTION_TIME = "Max Execution Time";
    private static final String MIN_EXECUTION_TIME = "Min Execution Time";
    private static final String AVG_EXECUTION_TIME = "Avg Execution Time";
    private static final String ACTIVITY_INSTANCES = "Activity Instances";
    private static final String PROCESS_AVERAGES = "Process Averages";
    private static final String EXECUTION_TIMES = "Execution Times";
    private static final String WAIT_TIMES = "Wait Times";
    private static final String RESOURCE_ALLOCATIONS = "Resource Allocations";
    private static final String RESOURCE_COST = "Resource Cost";
    private static final String HUMAN_TASK_AVERAGES = "Human Task Averages";
    private static final String TASK_AVERAGES = "Task Averages";
    private static final String SIMULATION_EVENTS = "Simulation Events";
    @Inject
    private IDiagramProfileService _profileService = null;
    private IDiagramProfile profile;

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String profileName = Utils.getDefaultProfileName(req.getParameter("profile"));
        String json = UriUtils.decode(Utils.getEncodedParam(req, "json"));
        String action = req.getParameter("action");
        String preprocessingData = req.getParameter("ppdata");
        String selectionId = req.getParameter("sel");
        String numInstances = req.getParameter("numinstances");
        String interval = req.getParameter("interval");
        String intervalUnit = req.getParameter("intervalunit");
        String language = req.getParameter("language");
        String simTestStartTime = req.getParameter("simteststarttime");
        String simTestEndTime = req.getParameter("simtestendtime");
        if (this.profile == null) {
            this.profile = this._profileService.findProfile(req, profileName);
        }
        if (action != null && action.equals(ACTION_GETPATHINFO)) {
            try {
                DroolsFactoryImpl.init();
                BpsimFactoryImpl.init();
                Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
                Definitions def = (Definitions)unmarshaller.unmarshall(json, preprocessingData).getContents().get(0);
                PathFinder pfinder = null;
                if (selectionId != null && selectionId.length() > 0) {
                    SubProcess selectedContainer = null;
                    List rootElements = def.getRootElements();
                    for (RootElement root : rootElements) {
                        if (!(root instanceof Process)) continue;
                        Process process = (Process)root;
                        selectedContainer = this.findSelectedContainer(selectionId, (FlowElementsContainer)process);
                        if (selectedContainer != null) {
                            pfinder = PathFinderFactory.getInstance((FlowElementsContainer)selectedContainer);
                            continue;
                        }
                        _logger.error("Could not find selected contaner with id: " + selectionId);
                    }
                }
                if (pfinder == null) {
                    pfinder = PathFinderFactory.getInstance((Definitions)def);
                }
                JSONObject pathjson = (JSONObject)pfinder.findPaths((PathFormatConverter)new JSONPathFormatConverter());
                PrintWriter pw = resp.getWriter();
                resp.setContentType("text/plain");
                resp.setCharacterEncoding("UTF-8");
                pw.write(pathjson.toString());
            }
            catch (Exception e) {
                _logger.error("Error during path finding", (Throwable)e);
                resp.setStatus(500);
                PrintWriter pw = resp.getWriter();
                pw.write(e.getMessage());
            }
        } else if (action != null && action.equals(ACTION_RUNSIMULATION)) {
            try {
                DroolsFactoryImpl.init();
                BpsimFactoryImpl.init();
                Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
                Definitions def = (Definitions)unmarshaller.unmarshall(json, preprocessingData).getContents().get(0);
                String processXML = this.profile.createMarshaller().parseModel(json, preprocessingData);
                List rootElements = def.getRootElements();
                String processId = "";
                for (RootElement root : rootElements) {
                    if (!(root instanceof Process)) continue;
                    processId = ((Process)root).getId();
                }
                int baseTimeUnit = 2;
                if (def.getRelationships() != null && def.getRelationships().size() > 0) {
                    Relationship relationship = (Relationship)def.getRelationships().get(0);
                    for (ExtensionAttributeValue extattrval : relationship.getExtensionValues()) {
                        BPSimDataType processAnalysis;
                        FeatureMap extensionElements = extattrval.getValue();
                        List bpsimExtensions = (List)extensionElements.get((EStructuralFeature)BpsimPackage.Literals.DOCUMENT_ROOT__BP_SIM_DATA, true);
                        if (bpsimExtensions == null || bpsimExtensions.size() <= 0 || (processAnalysis = (BPSimDataType)bpsimExtensions.get(0)).getScenario() == null || processAnalysis.getScenario().size() <= 0) continue;
                        Scenario simulationScenario = (Scenario)processAnalysis.getScenario().get(0);
                        baseTimeUnit = simulationScenario.getScenarioParameters().getBaseTimeUnit().getValue();
                    }
                }
                if (numInstances == null || numInstances.length() < 1) {
                    numInstances = "1";
                }
                if (interval == null || interval.length() < 1) {
                    interval = "1";
                }
                if (intervalUnit == null || intervalUnit.length() < 1) {
                    intervalUnit = "seconds";
                }
                int intervalInt = Integer.parseInt(interval);
                if (intervalUnit.equals("seconds")) {
                    intervalInt *= 1000;
                } else if (intervalUnit.equals("minutes")) {
                    intervalInt = intervalInt * 1000 * 60;
                } else if (intervalUnit.equals("hours")) {
                    intervalInt = intervalInt * 1000 * 60 * 60;
                } else if (intervalUnit.equals("days")) {
                    intervalInt = intervalInt * 1000 * 60 * 60 * 24;
                }
                this.eventAggregations = new ArrayList<SimulationEvent>();
                this.simTime = new DateTime();
                SimulationRepository repo = SimulationRunner.runSimulation((String)processId, (String)processXML, (int)Integer.parseInt(numInstances), (long)intervalInt, (boolean)true, (String[])new String[]{"onevent.simulation.rules.drl"});
                WorkingMemorySimulationRepository wmRepo = (WorkingMemorySimulationRepository)repo;
                ArrayList<SimulationEvent> allEvents = new ArrayList<SimulationEvent>(wmRepo.getEvents());
                wmRepo.getSession().execute((Command)new InsertElementsCommand((Collection)wmRepo.getAggregatedEvents()));
                wmRepo.fireAllRules();
                List aggEvents = (List)wmRepo.getGlobal("summary");
                SimulationInfo simInfo = wmRepo.getSimulationInfo();
                wmRepo.close();
                HashMap<String, Double> numInstanceData = new HashMap<String, Double>();
                JSONObject parentJSON = new JSONObject();
                JSONArray simInfoJSONArray = new JSONArray();
                JSONArray aggProcessSimulationJSONArray = new JSONArray();
                JSONArray aggNumActivityInstancesJSONArray = new JSONArray();
                JSONArray aggHTSimulationJSONArray = new JSONArray();
                JSONArray aggTaskSimulationJSONArray = new JSONArray();
                JSONObject simInfoKeys = new JSONObject();
                simInfoKeys.put("id", (Object)(simInfo.getProcessId() == null ? "" : simInfo.getProcessId()));
                simInfoKeys.put("name", (Object)(simInfo.getProcessName() == null ? "" : simInfo.getProcessName()));
                simInfoKeys.put("executions", simInfo.getNumberOfExecutions());
                SimpleDateFormat infoDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", this.getLocale(language));
                long startTime = simInfo.getStartTime();
                if (simTestStartTime != null && simTestStartTime.length() > 0) {
                    startTime = Long.parseLong(simTestStartTime);
                }
                long endTime = simInfo.getEndTime();
                if (simTestEndTime != null && simTestEndTime.length() > 0) {
                    endTime = Long.parseLong(simTestEndTime);
                }
                String simStartStr = infoDateFormat.format(new Date(startTime));
                String simEndStr = infoDateFormat.format(new Date(endTime));
                simInfoKeys.put("starttime", (Object)simStartStr);
                simInfoKeys.put("endtime", (Object)simEndStr);
                simInfoKeys.put("version", (Object)(simInfo.getProcessVersion() == null ? "" : simInfo.getProcessVersion()));
                simInfoKeys.put("interval", (Object)this.presentInterval((int)simInfo.getInterval(), intervalUnit));
                simInfoJSONArray.put((Object)simInfoKeys);
                for (AggregatedSimulationEvent aggEvent : aggEvents) {
                    JSONObject obj3;
                    JSONObject obj2;
                    JSONObject obj1;
                    AggregatedProcessSimulationEvent event;
                    if (aggEvent instanceof AggregatedProcessSimulationEvent) {
                        event = (AggregatedProcessSimulationEvent)aggEvent;
                        JSONObject processSimKeys = new JSONObject();
                        processSimKeys.put("key", (Object)PROCESS_AVERAGES);
                        processSimKeys.put("id", (Object)event.getProcessId());
                        processSimKeys.put("name", (Object)event.getProcessName());
                        JSONArray processSimValues = new JSONArray();
                        obj1 = new JSONObject();
                        obj1.put("label", (Object)MAX_EXECUTION_TIME);
                        obj1.put("value", this.adjustToBaseTimeUnit(event.getMaxExecutionTime(), baseTimeUnit));
                        obj2 = new JSONObject();
                        obj2.put("label", (Object)MIN_EXECUTION_TIME);
                        obj2.put("value", this.adjustToBaseTimeUnit(event.getMinExecutionTime(), baseTimeUnit));
                        obj3 = new JSONObject();
                        obj3.put("label", (Object)AVG_EXECUTION_TIME);
                        obj3.put("value", this.adjustToBaseTimeUnit(event.getAvgExecutionTime(), baseTimeUnit));
                        processSimValues.put((Object)obj1);
                        processSimValues.put((Object)obj2);
                        processSimValues.put((Object)obj3);
                        processSimKeys.put("values", (Object)processSimValues);
                        aggProcessSimulationJSONArray.put((Object)processSimKeys);
                        this.pathInfoMap = event.getPathNumberOfInstances();
                        continue;
                    }
                    if (aggEvent instanceof HTAggregatedSimulationEvent) {
                        event = (HTAggregatedSimulationEvent)aggEvent;
                        numInstanceData.put(event.getActivityName(), Double.valueOf(event.getNumberOfInstances()));
                        JSONObject allValues = new JSONObject();
                        JSONObject resourceValues = new JSONObject();
                        JSONObject costValues = new JSONObject();
                        allValues.put("key", (Object)HUMAN_TASK_AVERAGES);
                        allValues.put("id", (Object)event.getActivityId());
                        allValues.put("name", (Object)event.getActivityName());
                        JSONArray innerExecutionValues = new JSONArray();
                        JSONObject obj12 = new JSONObject();
                        obj12.put("label", (Object)MAX);
                        obj12.put("value", this.adjustToBaseTimeUnit(event.getMaxExecutionTime(), baseTimeUnit));
                        JSONObject obj22 = new JSONObject();
                        obj22.put("label", (Object)MIN);
                        obj22.put("value", this.adjustToBaseTimeUnit(event.getMinExecutionTime(), baseTimeUnit));
                        JSONObject obj32 = new JSONObject();
                        obj32.put("label", (Object)AVERAGE);
                        obj32.put("value", this.adjustToBaseTimeUnit(event.getAvgExecutionTime(), baseTimeUnit));
                        innerExecutionValues.put((Object)obj12);
                        innerExecutionValues.put((Object)obj22);
                        innerExecutionValues.put((Object)obj32);
                        JSONObject valuesObj = new JSONObject();
                        valuesObj.put("key", (Object)EXECUTION_TIMES);
                        valuesObj.put("color", (Object)"#1f77b4");
                        valuesObj.put("values", (Object)innerExecutionValues);
                        JSONArray innerExecutionValues2 = new JSONArray();
                        JSONObject obj4 = new JSONObject();
                        obj4.put("label", (Object)MAX);
                        obj4.put("value", this.adjustToBaseTimeUnit(event.getMaxWaitTime(), baseTimeUnit));
                        JSONObject obj5 = new JSONObject();
                        obj5.put("label", (Object)MIN);
                        obj5.put("value", this.adjustToBaseTimeUnit(event.getMinWaitTime(), baseTimeUnit));
                        JSONObject obj6 = new JSONObject();
                        obj6.put("label", (Object)AVERAGE);
                        obj6.put("value", this.adjustToBaseTimeUnit(event.getAvgWaitTime(), baseTimeUnit));
                        innerExecutionValues2.put((Object)obj4);
                        innerExecutionValues2.put((Object)obj5);
                        innerExecutionValues2.put((Object)obj6);
                        JSONObject valuesObj2 = new JSONObject();
                        valuesObj2.put("key", (Object)WAIT_TIMES);
                        valuesObj2.put("color", (Object)"#d62728");
                        valuesObj2.put("values", (Object)innerExecutionValues2);
                        JSONArray timeValuesInner = new JSONArray();
                        timeValuesInner.put((Object)valuesObj);
                        timeValuesInner.put((Object)valuesObj2);
                        allValues.put("timevalues", (Object)timeValuesInner);
                        resourceValues.put("key", (Object)RESOURCE_ALLOCATIONS);
                        resourceValues.put("id", (Object)event.getActivityId());
                        resourceValues.put("name", (Object)event.getActivityName());
                        JSONArray htSimValues2 = new JSONArray();
                        JSONObject obj7 = new JSONObject();
                        obj7.put("label", (Object)MAX);
                        obj7.put("value", this.adjustDouble(event.getMaxResourceUtilization()));
                        JSONObject obj8 = new JSONObject();
                        obj8.put("label", (Object)MIN);
                        obj8.put("value", this.adjustDouble(event.getMinResourceUtilization()));
                        JSONObject obj9 = new JSONObject();
                        obj9.put("label", (Object)AVERAGE);
                        obj9.put("value", this.adjustDouble(event.getAvgResourceUtilization()));
                        htSimValues2.put((Object)obj7);
                        htSimValues2.put((Object)obj8);
                        htSimValues2.put((Object)obj9);
                        resourceValues.put("values", (Object)htSimValues2);
                        allValues.put("resourcevalues", (Object)resourceValues);
                        costValues.put("key", (Object)RESOURCE_COST);
                        costValues.put("id", (Object)event.getActivityId());
                        costValues.put("name", (Object)event.getActivityName());
                        JSONArray htSimValues3 = new JSONArray();
                        JSONObject obj10 = new JSONObject();
                        obj10.put("label", (Object)MAX);
                        obj10.put("value", this.adjustDouble(event.getMaxResourceCost()));
                        JSONObject obj11 = new JSONObject();
                        obj11.put("label", (Object)MIN);
                        obj11.put("value", this.adjustDouble(event.getMinResourceCost()));
                        JSONObject obj122 = new JSONObject();
                        obj122.put("label", (Object)AVERAGE);
                        obj122.put("value", this.adjustDouble(event.getAvgResourceCost()));
                        htSimValues3.put((Object)obj10);
                        htSimValues3.put((Object)obj11);
                        htSimValues3.put((Object)obj122);
                        costValues.put("values", (Object)htSimValues3);
                        allValues.put("costvalues", (Object)costValues);
                        aggHTSimulationJSONArray.put((Object)allValues);
                        continue;
                    }
                    if (!(aggEvent instanceof AggregatedActivitySimulationEvent)) continue;
                    event = (AggregatedActivitySimulationEvent)aggEvent;
                    numInstanceData.put(event.getActivityName(), new Long(event.getNumberOfInstances()).doubleValue());
                    JSONObject taskSimKeys = new JSONObject();
                    taskSimKeys.put("key", (Object)TASK_AVERAGES);
                    taskSimKeys.put("id", (Object)event.getActivityId());
                    taskSimKeys.put("name", (Object)event.getActivityName());
                    JSONArray taskSimValues = new JSONArray();
                    obj1 = new JSONObject();
                    obj1.put("label", (Object)MAX_EXECUTION_TIME);
                    obj1.put("value", this.adjustToBaseTimeUnit(event.getMaxExecutionTime(), baseTimeUnit));
                    obj2 = new JSONObject();
                    obj2.put("label", (Object)MIN_EXECUTION_TIME);
                    obj2.put("value", this.adjustToBaseTimeUnit(event.getMinExecutionTime(), baseTimeUnit));
                    obj3 = new JSONObject();
                    obj3.put("label", (Object)AVG_EXECUTION_TIME);
                    obj3.put("value", this.adjustToBaseTimeUnit(event.getAvgExecutionTime(), baseTimeUnit));
                    taskSimValues.put((Object)obj1);
                    taskSimValues.put((Object)obj2);
                    taskSimValues.put((Object)obj3);
                    taskSimKeys.put("values", (Object)taskSimValues);
                    aggTaskSimulationJSONArray.put((Object)taskSimKeys);
                }
                JSONObject numInstancesSimKeys = new JSONObject();
                numInstancesSimKeys.put("key", (Object)ACTIVITY_INSTANCES);
                numInstancesSimKeys.put("id", (Object)ACTIVITY_INSTANCES);
                numInstancesSimKeys.put("name", (Object)ACTIVITY_INSTANCES);
                JSONArray numInstancesValues = new JSONArray();
                for (String key : numInstanceData.keySet()) {
                    Double value = (Double)numInstanceData.get(key);
                    JSONObject entryObject = new JSONObject();
                    entryObject.put("label", (Object)key);
                    entryObject.put("value", (Object)value);
                    numInstancesValues.put((Object)entryObject);
                }
                numInstancesSimKeys.put("values", (Object)numInstancesValues);
                aggNumActivityInstancesJSONArray.put((Object)numInstancesSimKeys);
                parentJSON.put("siminfo", (Object)simInfoJSONArray);
                parentJSON.put("processsim", (Object)aggProcessSimulationJSONArray);
                parentJSON.put("activityinstances", (Object)aggNumActivityInstancesJSONArray);
                parentJSON.put("htsim", (Object)aggHTSimulationJSONArray);
                parentJSON.put("tasksim", (Object)aggTaskSimulationJSONArray);
                parentJSON.put("timeline", (Object)this.getTaskEventsFromAllEvents(null, allEvents, intervalUnit, req.getContextPath()));
                JSONArray aggEventProcessSimulationJSONArray = new JSONArray();
                int c = 0;
                for (SimulationEvent simEve : this.eventAggregations) {
                    AggregatedProcessSimulationEvent aggProcessEve = (AggregatedProcessSimulationEvent)((GenericSimulationEvent)simEve).getAggregatedEvent();
                    if (aggProcessEve == null) continue;
                    JSONObject eventProcessSimKeys = new JSONObject();
                    eventProcessSimKeys.put("key", (Object)PROCESS_AVERAGES);
                    eventProcessSimKeys.put("id", (Object)aggProcessEve.getProcessId());
                    eventProcessSimKeys.put("name", (Object)aggProcessEve.getProcessName());
                    eventProcessSimKeys.put("timesincestart", (Object)this.eventAggregationsTimes.get(c));
                    eventProcessSimKeys.put("timeunit", (Object)intervalUnit);
                    JSONArray eventProcessSimValues = new JSONArray();
                    JSONObject obj1 = new JSONObject();
                    obj1.put("label", (Object)MAX_EXECUTION_TIME);
                    obj1.put("value", this.adjustToBaseTimeUnit(aggProcessEve.getMaxExecutionTime(), baseTimeUnit));
                    JSONObject obj2 = new JSONObject();
                    obj2.put("label", (Object)MIN_EXECUTION_TIME);
                    obj2.put("value", this.adjustToBaseTimeUnit(aggProcessEve.getMinExecutionTime(), baseTimeUnit));
                    JSONObject obj3 = new JSONObject();
                    obj3.put("label", (Object)AVG_EXECUTION_TIME);
                    obj3.put("value", this.adjustToBaseTimeUnit(aggProcessEve.getAvgExecutionTime(), baseTimeUnit));
                    eventProcessSimValues.put((Object)obj1);
                    eventProcessSimValues.put((Object)obj2);
                    eventProcessSimValues.put((Object)obj3);
                    eventProcessSimKeys.put("values", (Object)eventProcessSimValues);
                    aggEventProcessSimulationJSONArray.put((Object)eventProcessSimKeys);
                    ++c;
                }
                parentJSON.put("eventaggregations", (Object)aggEventProcessSimulationJSONArray);
                JSONArray processPathsJSONArray = new JSONArray();
                if (this.pathInfoMap != null) {
                    Iterator<String> pathKeys = this.pathInfoMap.keySet().iterator();
                    while (pathKeys.hasNext()) {
                        JSONObject pathsSimKeys = new JSONObject();
                        String pkey = pathKeys.next();
                        Integer pvalue = this.pathInfoMap.get(pkey);
                        pathsSimKeys.put("id", (Object)pkey);
                        pathsSimKeys.put("numinstances", (Object)pvalue);
                        pathsSimKeys.put("totalinstances", Integer.parseInt(numInstances));
                        processPathsJSONArray.put((Object)pathsSimKeys);
                    }
                    parentJSON.put("pathsim", (Object)processPathsJSONArray);
                }
                PrintWriter pw = resp.getWriter();
                resp.setContentType("text/json");
                resp.setCharacterEncoding("UTF-8");
                pw.write(Base64.encodeBase64String((byte[])UriUtils.encode(parentJSON.toString()).getBytes("UTF-8")));
            }
            catch (Exception e) {
                _logger.error("Error during simulation", (Throwable)e);
                resp.setStatus(500);
                PrintWriter pw = resp.getWriter();
                pw.write(e.getMessage());
            }
        }
    }

    private double adjustToSecs(double in) throws ParseException {
        if (in > 0.0) {
            in /= 1000.0;
        }
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        String formattedValue = twoDForm.format(in);
        return twoDForm.parse(formattedValue).doubleValue();
    }

    private double adjustToBaseTimeUnit(double in, int baseTime) throws ParseException {
        if (in > 0.0) {
            if (baseTime == 1) {
                in /= 1000.0;
            } else if (baseTime == 2) {
                in /= 60000.0;
            } else if (baseTime == 3) {
                in /= 3600000.0;
            } else if (baseTime == 4) {
                in /= 8.64E7;
            } else if (baseTime == 5) {
                in /= 1.471228928E9;
            }
        }
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        String formattedValue = twoDForm.format(in);
        return twoDForm.parse(formattedValue).doubleValue();
    }

    private double adjustDouble(double in) throws ParseException {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        String formattedValue = twoDForm.format(in);
        return twoDForm.parse(formattedValue).doubleValue();
    }

    private SubProcess findSelectedContainer(String id, FlowElementsContainer container) {
        if (container instanceof SubProcess && container.getId().equals(id)) {
            return (SubProcess)container;
        }
        for (FlowElement fe : container.getFlowElements()) {
            if (!(fe instanceof SubProcess)) continue;
            if (fe.getId().equals(id)) {
                return (SubProcess)fe;
            }
            return this.findSelectedContainer(id, (FlowElementsContainer)fe);
        }
        return null;
    }

    private String getEventName(SimulationEvent se) {
        if (se != null) {
            if (se instanceof ActivitySimulationEvent) {
                return "Activity";
            }
            if (se instanceof EndSimulationEvent) {
                return "End Event";
            }
            if (se instanceof GatewaySimulationEvent) {
                return "Gateway";
            }
            if (se instanceof HumanTaskActivitySimulationEvent) {
                return "Human Task";
            }
            if (se instanceof StartSimulationEvent) {
                return "Start Event";
            }
            return "Event";
        }
        return "Event";
    }

    private String getDateString(long seDate) {
        Date d = new Date(seDate);
        DateTime dt = new DateTime(seDate);
        StringBuffer retBuf = new StringBuffer();
        retBuf.append(dt.getYear()).append(",");
        retBuf.append(dt.getMonthOfYear()).append(",");
        retBuf.append(dt.getDayOfMonth()).append(",");
        retBuf.append(dt.getHourOfDay()).append(",");
        retBuf.append(dt.getMinuteOfHour()).append(",");
        retBuf.append(dt.getSecondOfMinute()).append(",");
        retBuf.append(dt.getMillisOfSecond());
        return retBuf.toString();
    }

    private String getIcon(SimulationEvent se, String contextPath) {
        if (se != null) {
            if (se instanceof ActivitySimulationEvent) {
                return contextPath + "/org.jbpm.designer.jBPMDesigner/images/simulation/timeline/activity.png";
            }
            if (se instanceof EndSimulationEvent) {
                return contextPath + "/org.jbpm.designer.jBPMDesigner/images/simulation/timeline/endevent.png";
            }
            if (se instanceof GatewaySimulationEvent) {
                return contextPath + "/org.jbpm.designer.jBPMDesigner/images/simulation/timeline/gateway.png";
            }
            if (se instanceof HumanTaskActivitySimulationEvent) {
                return contextPath + "/org.jbpm.designer.jBPMDesigner/images/simulation/timeline/humantask.png";
            }
            if (se instanceof StartSimulationEvent) {
                return contextPath + "/org.jbpm.designer.jBPMDesigner/images/simulation/timeline/startevent.png";
            }
            return "";
        }
        return "";
    }

    private JSONObject getTaskEventsFromAllEvents(AggregatedSimulationEvent event, List<SimulationEvent> allEvents, String intervalUnit, String contextPath) throws Exception {
        JSONObject allEventsObject = new JSONObject();
        allEventsObject.put("headline", (Object)SIMULATION_EVENTS);
        allEventsObject.put("type", (Object)"default");
        allEventsObject.put("text", (Object)SIMULATION_EVENTS);
        JSONArray allEventsDataArray = new JSONArray();
        for (SimulationEvent se : allEvents) {
            if (!(se instanceof EndSimulationEvent) && !(se instanceof ActivitySimulationEvent) && !(se instanceof HumanTaskActivitySimulationEvent)) continue;
            if (event != null) {
                String seActivityId = this.getSingleEventActivityId(se);
                String eventActivitytId = this.getAggregatedEventActivityId(event);
                if (!eventActivitytId.equals(seActivityId)) continue;
                allEventsDataArray.put((Object)this.getTimelineEventObject(se, intervalUnit, contextPath));
                continue;
            }
            allEventsDataArray.put((Object)this.getTimelineEventObject(se, intervalUnit, contextPath));
        }
        allEventsObject.put("date", (Object)allEventsDataArray);
        Collections.sort(this.eventAggregationsTimes);
        return allEventsObject;
    }

    private JSONObject getTimelineEventObject(SimulationEvent se, String intervalUnit, String contextPath) throws Exception {
        JSONObject seObject = new JSONObject();
        seObject.put("id", (Object)se.getUUID().toString());
        seObject.put("startDate", (Object)this.getDateString(se.getStartTime()));
        seObject.put("endDate", (Object)this.getDateString(se.getEndTime()));
        if (se instanceof EndSimulationEvent) {
            seObject.put("headline", (Object)((EndSimulationEvent)se).getActivityName());
            seObject.put("activityid", (Object)((EndSimulationEvent)se).getActivityId());
        } else if (se instanceof ActivitySimulationEvent) {
            seObject.put("headline", (Object)((ActivitySimulationEvent)se).getActivityName());
            seObject.put("activityid", (Object)((ActivitySimulationEvent)se).getActivityId());
        } else if (se instanceof HumanTaskActivitySimulationEvent) {
            seObject.put("headline", (Object)((HumanTaskActivitySimulationEvent)se).getActivityName());
            seObject.put("activityid", (Object)((HumanTaskActivitySimulationEvent)se).getActivityId());
        }
        seObject.put("text", (Object)"");
        seObject.put("tag", (Object)"");
        JSONObject seAsset = new JSONObject();
        seAsset.put("media", (Object)"");
        seAsset.put("thumbnail", (Object)this.getIcon(se, contextPath));
        seAsset.put("credit", (Object)"");
        seAsset.put("caption", (Object)"");
        seObject.put("asset", (Object)seAsset);
        this.eventAggregations.add(se);
        Interval eventinterval = new Interval(this.simTime.getMillis(), se.getEndTime());
        long durationvalue = eventinterval.toDurationMillis();
        if (intervalUnit.equals("seconds")) {
            durationvalue /= 1000L;
        } else if (intervalUnit.equals("minutes")) {
            durationvalue /= 60000L;
        } else if (intervalUnit.equals("hours")) {
            durationvalue /= 3600000L;
        } else if (intervalUnit.equals("days")) {
            durationvalue /= 86400000L;
        }
        this.eventAggregationsTimes.add(durationvalue);
        return seObject;
    }

    private String getSingleEventActivityId(SimulationEvent event) {
        if (event != null) {
            if (event instanceof ActivitySimulationEvent) {
                return ((ActivitySimulationEvent)event).getActivityId();
            }
            if (event instanceof EndSimulationEvent) {
                return ((EndSimulationEvent)event).getActivityId();
            }
            if (event instanceof GatewaySimulationEvent) {
                return ((GatewaySimulationEvent)event).getActivityId();
            }
            if (event instanceof HumanTaskActivitySimulationEvent) {
                return ((HumanTaskActivitySimulationEvent)event).getActivityId();
            }
            if (event instanceof StartSimulationEvent) {
                return ((StartSimulationEvent)event).getActivityId();
            }
            return "";
        }
        return "";
    }

    private String getAggregatedEventActivityId(AggregatedSimulationEvent event) {
        if (event instanceof AggregatedProcessSimulationEvent) {
            return ((AggregatedProcessSimulationEvent)event).getProcessId();
        }
        if (event instanceof HTAggregatedSimulationEvent) {
            return ((HTAggregatedSimulationEvent)event).getActivityId();
        }
        if (event instanceof AggregatedActivitySimulationEvent) {
            return ((AggregatedActivitySimulationEvent)event).getActivityId();
        }
        return "";
    }

    private String presentInterval(int interval, String intervalUnit) {
        String retVal = intervalUnit.equals("seconds") ? (interval /= 1000) + " seconds" : (intervalUnit.equals("minutes") ? (interval /= 60000) + " minutes" : (intervalUnit.equals("hours") ? (interval /= 3600000) + " hours" : (intervalUnit.equals("days") ? (interval /= 86400000) + " days" : interval + " milliseconds")));
        return retVal;
    }

    private Locale getLocale(String language) {
        if (language != null && language.length() > 0) {
            int iUnderscore = language.indexOf(95);
            if (iUnderscore > 0) {
                String lang = language.substring(0, iUnderscore);
                String region = language.substring(iUnderscore + 1).toUpperCase();
                return new Locale(lang, region);
            }
            return new Locale(language);
        }
        return Locale.getDefault();
    }
}

