/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.expressioneditor.marshalling;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.jbpm.designer.expressioneditor.model.Condition;
import org.jbpm.designer.expressioneditor.model.ConditionExpression;
import org.jbpm.designer.expressioneditor.model.ExpressionEditorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionEditorMessageJSONUnmarshaller {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionEditorMessageJSONUnmarshaller.class);

    public ExpressionEditorMessage unmarshall(String jsonMessage) throws Exception {
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser parser = null;
        try {
            parser = jsonFactory.createJsonParser(jsonMessage);
        }
        catch (Exception e) {
            logger.error("It was not possible to create a json parser for the jsonMessage: " + jsonMessage, (Throwable)e);
            throw e;
        }
        return this.unmarshall(parser);
    }

    public ExpressionEditorMessage unmarshall(InputStream inputStream) throws Exception {
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser parser = null;
        try {
            parser = jsonFactory.createJsonParser(inputStream);
        }
        catch (Exception e) {
            logger.error("It was not possible to create the a json parser for the inputStream: " + inputStream, (Throwable)e);
            throw e;
        }
        return this.unmarshall(parser);
    }

    private ExpressionEditorMessage unmarshall(JsonParser parser) throws Exception {
        ExpressionEditorMessage message = new ExpressionEditorMessage();
        ConditionExpression expression = new ConditionExpression();
        try {
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String currentField = parser.getCurrentName();
                if ("operator".equals(currentField)) {
                    parser.nextToken();
                    expression.setOperator(this.parseText(parser));
                    message.setExpression(expression);
                    continue;
                }
                if ("conditions".equals(currentField)) {
                    List<Condition> conditions = this.parseConditions(parser);
                    if (conditions.size() <= 0) continue;
                    expression.setConditions(conditions);
                    message.setExpression(expression);
                    continue;
                }
                if ("script".equals(currentField)) {
                    parser.nextToken();
                    message.setScript(this.parseText(parser));
                    continue;
                }
                if ("errorCode".equals(currentField)) {
                    parser.nextToken();
                    message.setErrorCode(this.parseText(parser));
                    continue;
                }
                if (!"errorMessage".equals(currentField)) continue;
                parser.nextToken();
                message.setErrorMessage(this.parseText(parser));
            }
        }
        catch (IOException e) {
            logger.error("An error was produced during json message parsing. " + e);
            throw e;
        }
        return message;
    }

    private String parseText(JsonParser parser) throws IOException, JsonParseException {
        return parser.getText();
    }

    private List<Condition> parseConditions(JsonParser parser) throws IOException, JsonParseException {
        ArrayList<Condition> result = new ArrayList<Condition>();
        if (parser.nextToken() == JsonToken.START_ARRAY) {
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                Condition condition = this.parseCondition(parser);
                if (condition == null) continue;
                result.add(condition);
            }
        }
        return result;
    }

    private Condition parseCondition(JsonParser parser) throws IOException, JsonParseException {
        Condition condition = null;
        if (parser.getCurrentToken() == JsonToken.START_OBJECT && parser.nextToken() != JsonToken.END_OBJECT) {
            condition = new Condition();
            if ("condition".equals(parser.getCurrentName())) {
                parser.nextToken();
                condition.setFunction(this.parseText(parser));
            }
            if (parser.nextToken() != JsonToken.END_OBJECT && "parameters".equals(parser.getCurrentName()) && parser.nextToken() == JsonToken.START_ARRAY) {
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    condition.addParam(this.parseText(parser));
                }
            }
        }
        return condition;
    }
}

