/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.taskforms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.bpmn2.Definitions;
import org.kie.workbench.common.forms.bpmn.BPMNFormBuilderService;

@Dependent
public class BPMNFormBuilderManager {
    private List<BPMNFormBuilderService<Definitions>> formBuilders = new ArrayList<BPMNFormBuilderService<Definitions>>();

    @Inject
    public BPMNFormBuilderManager(Instance<BPMNFormBuilderService<Definitions>> installedFormBuilders) {
        installedFormBuilders.iterator().forEachRemaining(formBuilder -> this.formBuilders.add((BPMNFormBuilderService<Definitions>)formBuilder));
    }

    public List<BPMNFormBuilderService<Definitions>> getFormBuilders() {
        return Collections.unmodifiableList(this.formBuilders);
    }

    public BPMNFormBuilderService<Definitions> getBuilderByFormType(String extension) {
        Optional<BPMNFormBuilderService> optional = this.formBuilders.stream().filter(builderService -> builderService.getFormExtension().equals(extension)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }
}

