/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.jbpm.designer.query.DesignerFindDataTypesQuery;
import org.jbpm.designer.query.DesignerFindRuleFlowNamesQuery;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.server.ServletUtil;
import org.json.JSONObject;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueBranchNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueProjectNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.java.nio.base.SegmentedPath;

public class CalledElementServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(CalledElementServlet.class);
    protected IDiagramProfile profile;
    @Inject
    private IDiagramProfileService _profileService = null;
    @Inject
    protected RefactoringQueryService queryService;
    @Inject
    protected VFSService vfsServices;
    @Inject
    protected KieProjectService projectService;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String profileName = Utils.getDefaultProfileName(req.getParameter("profile"));
        String processPackage = req.getParameter("ppackage");
        String processId = req.getParameter("pid");
        String action = req.getParameter("action");
        if (this.profile == null) {
            this.profile = this._profileService.findProfile(req, profileName);
        }
        if (action != null && action.equals("openprocessintab")) {
            String retValue = "";
            List<String> allPackageNames = ServletUtil.getPackageNamesFromRepository(this.profile);
            if (allPackageNames != null && allPackageNames.size() > 0) {
                block2: for (String packageName : allPackageNames) {
                    List<String> allProcessesInPackage = ServletUtil.getAllProcessesInPackage(packageName, this.profile);
                    if (allProcessesInPackage == null || allProcessesInPackage.size() <= 0) continue;
                    for (String p : allProcessesInPackage) {
                        Asset processContent = ServletUtil.getProcessSourceContent(p, this.profile);
                        Pattern idPattern = Pattern.compile("<\\S*process[^\"]+id=\"([^\"]+)\"", 8);
                        Matcher idMatcher = idPattern.matcher((CharSequence)processContent.getAssetContent());
                        if (!idMatcher.find()) continue;
                        String pid = idMatcher.group(1);
                        String pidcontent = ServletUtil.getProcessImageContent(packageName, pid, this.profile);
                        if (pid == null || !pid.equals(processId)) continue;
                        String uniqueId = processContent.getUniqueId();
                        if (Base64.isBase64((String)uniqueId)) {
                            byte[] decoded = Base64.decodeBase64((String)uniqueId);
                            try {
                                uniqueId = new String(decoded, "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                        }
                        retValue = processContent.getName() + "." + processContent.getAssetType() + "|" + uniqueId;
                        continue block2;
                    }
                }
            }
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("text/plain");
            resp.getWriter().write(retValue);
        } else if (action != null && action.equals("showruleflowgroups")) {
            List<String> ruleFlowGroupNames = this.getRuleFlowNames(req);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            resp.getWriter().write(this.getRuleFlowGroupsInfoAsJSON(ruleFlowGroupNames).toString());
        } else if (action != null && action.equals("showdatatypes")) {
            List<String> dataTypeNames = this.getJavaTypeNames(req);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            resp.getWriter().write(this.getDataTypesInfoAsJSON(dataTypeNames).toString());
        } else {
            String retValue = "false";
            List<String> allPackageNames = ServletUtil.getPackageNamesFromRepository(this.profile);
            HashMap<String, String> processInfo = new HashMap<String, String>();
            if (allPackageNames != null && allPackageNames.size() > 0) {
                for (String packageName : allPackageNames) {
                    List<String> allProcessesInPackage = ServletUtil.getAllProcessesInPackage(packageName, this.profile);
                    if (allProcessesInPackage == null || allProcessesInPackage.size() <= 0) continue;
                    for (String p : allProcessesInPackage) {
                        Asset processContent = ServletUtil.getProcessSourceContent(p, this.profile);
                        Pattern idPattern = Pattern.compile("<\\S*process[^\"]+id=\"([^\"]+)\"", 8);
                        Matcher idMatcher = idPattern.matcher((CharSequence)processContent.getAssetContent());
                        if (!idMatcher.find()) continue;
                        String pid = idMatcher.group(1);
                        String pidcontent = ServletUtil.getProcessImageContent(processContent.getAssetLocation(), pid, this.profile);
                        if (pid == null || packageName.equals(processPackage) && pid.equals(processId)) continue;
                        processInfo.put(pid + "|" + processContent.getAssetLocation(), pidcontent != null ? pidcontent : "");
                    }
                }
            }
            retValue = this.getProcessInfoAsJSON(processInfo).toString();
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            resp.getWriter().write(retValue);
        }
    }

    List<String> getRuleFlowNames(HttpServletRequest req) {
        final String[] projectAndBranch = this.getProjectAndBranchNames(req);
        List results = this.queryService.query(DesignerFindRuleFlowNamesQuery.NAME, (Set)new HashSet<ValueIndexTerm>(){
            {
                this.add(new ValueSharedPartIndexTerm("*", PartType.RULEFLOW_GROUP, ValueIndexTerm.TermSearchType.WILDCARD));
                this.add(new ValueProjectNameIndexTerm(projectAndBranch[0]));
                if (projectAndBranch[1] != null) {
                    this.add(new ValueBranchNameIndexTerm(projectAndBranch[1]));
                }
            }
        });
        ArrayList<String> ruleFlowGroupNames = new ArrayList<String>();
        for (RefactoringPageRow row : results) {
            ruleFlowGroupNames.add((String)row.getValue());
        }
        Collections.sort(ruleFlowGroupNames);
        results = this.queryService.query(DesignerFindRuleFlowNamesQuery.NAME, (Set)new HashSet<ValueIndexTerm>(){
            {
                this.add(new ValueSharedPartIndexTerm("*", PartType.RULEFLOW_GROUP, ValueIndexTerm.TermSearchType.WILDCARD));
            }
        });
        LinkedList<String> otherRuleFlowGroupNames = new LinkedList<String>();
        for (RefactoringPageRow row : results) {
            String ruleFlowGroupName = (String)row.getValue();
            if (ruleFlowGroupNames.contains(ruleFlowGroupName)) continue;
            otherRuleFlowGroupNames.add(ruleFlowGroupName);
        }
        Collections.sort(otherRuleFlowGroupNames);
        ruleFlowGroupNames.add("********");
        ruleFlowGroupNames.addAll(otherRuleFlowGroupNames);
        return ruleFlowGroupNames;
    }

    List<String> getJavaTypeNames(HttpServletRequest req) {
        final String[] projectAndBranch = this.getProjectAndBranchNames(req);
        List results = this.queryService.query(DesignerFindDataTypesQuery.NAME, (Set)new HashSet<ValueIndexTerm>(){
            {
                this.add(new ValueResourceIndexTerm("*", ResourceType.JAVA, ValueIndexTerm.TermSearchType.WILDCARD));
                this.add(new ValueProjectNameIndexTerm(projectAndBranch[0]));
                if (projectAndBranch[1] != null) {
                    this.add(new ValueBranchNameIndexTerm(projectAndBranch[1]));
                }
            }
        });
        ArrayList<String> dataTypeNames = new ArrayList<String>();
        for (RefactoringPageRow row : results) {
            dataTypeNames.add((String)row.getValue());
        }
        Collections.sort(dataTypeNames);
        results = this.queryService.query(DesignerFindDataTypesQuery.NAME, (Set)new HashSet<ValueIndexTerm>(){
            {
                this.add(new ValueResourceIndexTerm("*", ResourceType.JAVA, ValueIndexTerm.TermSearchType.WILDCARD));
            }
        });
        LinkedList<String> otherDataTypeNames = new LinkedList<String>();
        for (RefactoringPageRow row : results) {
            String ruleFlowGroupName = (String)row.getValue();
            if (dataTypeNames.contains(ruleFlowGroupName)) continue;
            otherDataTypeNames.add(ruleFlowGroupName);
        }
        Collections.sort(otherDataTypeNames);
        dataTypeNames.add("********");
        dataTypeNames.addAll(otherDataTypeNames);
        return dataTypeNames;
    }

    private String[] getProjectAndBranchNames(HttpServletRequest req) {
        String uuid = Utils.getUUID(req);
        Path myPath = this.vfsServices.get(uuid);
        KieProject project = (KieProject)this.projectService.resolveProject(myPath);
        String projectName = project.getProjectName();
        String branchName = null;
        if (myPath instanceof SegmentedPath) {
            branchName = ((SegmentedPath)myPath).getSegmentId();
        }
        return new String[]{projectName, branchName};
    }

    public JSONObject getRuleFlowGroupsInfoAsJSON(List<String> ruleFlowGroupsInfo) {
        JSONObject jsonObject = new JSONObject();
        for (String infoEntry : ruleFlowGroupsInfo) {
            try {
                jsonObject.put(infoEntry, (Object)infoEntry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    public JSONObject getDataTypesInfoAsJSON(List<String> ruleFlowGroupsInfo) {
        JSONObject jsonObject = new JSONObject();
        for (String infoEntry : ruleFlowGroupsInfo) {
            try {
                jsonObject.put(infoEntry, (Object)infoEntry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    public JSONObject getProcessInfoAsJSON(Map<String, String> processInfo) {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, String> error : processInfo.entrySet()) {
            try {
                jsonObject.put(error.getKey(), (Object)error.getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }
}

