/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.expressioneditor.marshalling;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.jbpm.designer.expressioneditor.model.Condition;
import org.jbpm.designer.expressioneditor.model.ConditionExpression;
import org.jbpm.designer.expressioneditor.model.ExpressionEditorMessage;

public class ExpressionEditorMessageJSONMarshaller {
    public String marshall(ExpressionEditorMessage message) throws Exception {
        if (message == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JsonFactory jsonFactory = new JsonFactory();
        JsonGenerator generator = jsonFactory.createJsonGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
        generator.writeStartObject();
        if (message.getExpression() == null) {
            message.setExpression(new ConditionExpression());
        }
        if (message.getExpression() != null) {
            generator.writeFieldName("operator");
            if (message.getExpression().getOperator() != null) {
                generator.writeString(message.getExpression().getOperator());
            } else {
                generator.writeNull();
            }
            generator.writeArrayFieldStart("conditions");
            if (message.getExpression().getConditions().size() > 0) {
                for (Condition condition : message.getExpression().getConditions()) {
                    generator.writeStartObject();
                    generator.writeFieldName("condition");
                    generator.writeString(condition.getFunction());
                    if (condition.getParameters().size() > 0) {
                        generator.writeArrayFieldStart("parameters");
                        for (String param : condition.getParameters()) {
                            generator.writeString(param);
                        }
                        generator.writeEndArray();
                    }
                    generator.writeEndObject();
                }
            }
            generator.writeEndArray();
        }
        generator.writeFieldName("script");
        if (message.getScript() != null) {
            generator.writeString(message.getScript());
        } else {
            generator.writeNull();
        }
        generator.writeFieldName("errorCode");
        if (message.getErrorCode() != null) {
            generator.writeString(message.getErrorCode());
        } else {
            generator.writeNull();
        }
        generator.writeFieldName("errorMessage");
        if (message.getErrorMessage() != null) {
            generator.writeString(message.getErrorMessage());
        } else {
            generator.writeNull();
        }
        generator.writeEndObject();
        generator.close();
        return outputStream.toString();
    }
}

