/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.expressioneditor.parser;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbpm.designer.expressioneditor.model.Condition;
import org.jbpm.designer.expressioneditor.model.ConditionExpression;
import org.jbpm.designer.expressioneditor.parser.FunctionDef;
import org.jbpm.designer.expressioneditor.parser.ParamDef;

public class ExpressionParser {
    private static final String VARIABLE_NAME_PARAM_REGEX = "[$_a-zA-Z][$_a-zA-Z0-9]*";
    public static final String KIE_FUNCTIONS = "KieFunctions.";
    private static Map<String, FunctionDef> functionsRegistry = new TreeMap<String, FunctionDef>();
    private int parseIndex = 0;
    private String expression;
    private String functionName = null;
    public static final String FUNCTION_NAME_NOT_RECOGNIZED_ERROR = "The function name \"{0}\" is not recognized by system.";
    public static final String FUNCTION_CALL_NOT_FOUND_ERROR = "Function call was not found, a token like \"KieFunctions.functionName(variable, params)\" is expected.";
    public static final String VALID_FUNCTION_CALL_NOT_FOUND_ERROR = "The \"KieFunctions.\" keyword must be followed by one of the following function names: \"{0}\"";
    public static final String FUNCTION_CALL_NOT_CLOSED_PROPERLY_ERROR = "Function call \"{0}\" is not closed properly, character \")\" is expected.";
    public static final String SENTENCE_NOT_CLOSED_PROPERLY_ERROR = "Script not closed properly, character \";\" is expected.";
    public static final String VARIABLE_NAME_EXPECTED_ERROR = "Variable name not found, a valid process variable name is expected.";
    public static final String PARAMETER_DELIMITER_EXPECTED_ERROR = "Parameter delimiter \",\" is expected.";
    public static final String STRING_PARAMETER_EXPECTED_ERROR = "String parameter value like \"some value\" is expected.";
    public static final String RETURN_SENTENCE_EXPECTED_ERROR = "Sentence \"{0}\" is expected.";
    public static final String BLANK_AFTER_RETURN_EXPECTED_ERROR = "Sentence \"{0}\" must be followed by a blank space or a line break.";
    private static String functionNames = null;

    public ExpressionParser(String expression) {
        this.expression = expression;
        this.parseIndex = expression != null ? 0 : -1;
    }

    public ConditionExpression parse() throws ParseException {
        ConditionExpression conditionExpression = new ConditionExpression();
        Condition condition = null;
        FunctionDef functionDef = null;
        this.parseReturnSentence();
        this.functionName = this.parseFunctionName();
        this.functionName = this.functionName.substring(KIE_FUNCTIONS.length(), this.functionName.length());
        functionDef = functionsRegistry.get(this.functionName);
        if (functionDef == null) {
            throw new ParseException(this.errorMessage(FUNCTION_NAME_NOT_RECOGNIZED_ERROR, this.functionName), this.parseIndex);
        }
        conditionExpression.setOperator("AND");
        condition = new Condition(this.functionName);
        conditionExpression.getConditions().add(condition);
        String param = null;
        boolean first = true;
        for (ParamDef paramDef : functionDef.getParams()) {
            if (first) {
                first = false;
            } else {
                this.parseParamDelimiter();
            }
            param = Object.class.getName().equals(paramDef.getType().getName()) ? this.parseVariableName() : this.parseStringParameter();
            condition.addParam(param);
        }
        this.parseFunctionClose();
        this.parseSentenceClose();
        return conditionExpression;
    }

    private String parseReturnSentence() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0) {
            throw new ParseException(this.errorMessage(RETURN_SENTENCE_EXPECTED_ERROR, "return"), this.parseIndex);
        }
        if (!this.expression.startsWith("return", index)) {
            throw new ParseException(this.errorMessage(RETURN_SENTENCE_EXPECTED_ERROR, "return"), this.parseIndex);
        }
        this.parseIndex = index + "return".length();
        if (!this.isBlank(Character.valueOf(this.expression.charAt(this.parseIndex)))) {
            throw new ParseException(this.errorMessage(BLANK_AFTER_RETURN_EXPECTED_ERROR, "return"), this.parseIndex);
        }
        return "return";
    }

    private String parseFunctionName() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0) {
            throw new ParseException(this.errorMessage(FUNCTION_CALL_NOT_FOUND_ERROR, new Object[0]), this.parseIndex);
        }
        String functionName = null;
        if (!this.expression.startsWith(KIE_FUNCTIONS, index)) {
            throw new ParseException(this.errorMessage(FUNCTION_CALL_NOT_FOUND_ERROR, new Object[0]), this.parseIndex);
        }
        for (FunctionDef functionDef : functionsRegistry.values()) {
            if (!this.expression.startsWith(KIE_FUNCTIONS + functionDef.getName() + "(", index)) continue;
            functionName = KIE_FUNCTIONS + functionDef.getName();
            break;
        }
        if (functionName == null) {
            throw new ParseException(this.errorMessage(VALID_FUNCTION_CALL_NOT_FOUND_ERROR, this.functionNames()), this.parseIndex);
        }
        this.parseIndex = index + functionName.length() + 1;
        return functionName;
    }

    private String parseFunctionClose() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0) {
            throw new ParseException(this.errorMessage(FUNCTION_CALL_NOT_CLOSED_PROPERLY_ERROR, this.functionName), this.parseIndex);
        }
        if (this.expression.charAt(index) != ')') {
            throw new ParseException(this.errorMessage(FUNCTION_CALL_NOT_CLOSED_PROPERLY_ERROR, this.functionName), this.parseIndex);
        }
        this.parseIndex = index + 1;
        return ")";
    }

    private String parseSentenceClose() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0) {
            throw new ParseException(this.errorMessage(SENTENCE_NOT_CLOSED_PROPERLY_ERROR, new Object[0]), this.parseIndex);
        }
        if (this.expression.charAt(index) != ';') {
            throw new ParseException(this.errorMessage(SENTENCE_NOT_CLOSED_PROPERLY_ERROR, new Object[0]), this.parseIndex);
        }
        this.parseIndex = index + 1;
        while (this.parseIndex < this.expression.length()) {
            if (!this.isBlank(Character.valueOf(this.expression.charAt(this.parseIndex)))) {
                throw new ParseException(this.errorMessage(SENTENCE_NOT_CLOSED_PROPERLY_ERROR, new Object[0]), this.parseIndex);
            }
            ++this.parseIndex;
        }
        return ";";
    }

    private String parseVariableName() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0) {
            throw new ParseException(this.errorMessage(VARIABLE_NAME_EXPECTED_ERROR, new Object[0]), this.parseIndex);
        }
        Pattern variableNameParam = Pattern.compile(VARIABLE_NAME_PARAM_REGEX);
        Matcher variableMatcher = variableNameParam.matcher(this.expression.substring(index, this.expression.length()));
        if (!Pattern.matches(VARIABLE_NAME_PARAM_REGEX, String.valueOf(this.expression.charAt(index)))) {
            throw new ParseException(this.errorMessage(VARIABLE_NAME_EXPECTED_ERROR, new Object[0]), this.parseIndex);
        }
        String variableName = null;
        if (!variableMatcher.find()) {
            throw new ParseException(this.errorMessage(VARIABLE_NAME_EXPECTED_ERROR, new Object[0]), this.parseIndex);
        }
        variableName = variableMatcher.group();
        this.parseIndex = index + variableName.length();
        return variableName;
    }

    private String parseParamDelimiter() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0) {
            throw new ParseException(this.errorMessage(PARAMETER_DELIMITER_EXPECTED_ERROR, new Object[0]), this.parseIndex);
        }
        if (this.expression.charAt(index) != ',') {
            throw new ParseException(this.errorMessage(PARAMETER_DELIMITER_EXPECTED_ERROR, new Object[0]), this.parseIndex);
        }
        this.parseIndex = index + 1;
        return ",";
    }

    private String parseStringParameter() throws ParseException {
        int index = this.nextNonBlank();
        if (index < 0) {
            throw new ParseException(STRING_PARAMETER_EXPECTED_ERROR, this.parseIndex);
        }
        if (this.expression.charAt(index) != '\"') {
            throw new ParseException(STRING_PARAMETER_EXPECTED_ERROR, this.parseIndex);
        }
        int shift = 1;
        Character scapeChar = Character.valueOf('\\');
        Character last = null;
        boolean strReaded = false;
        StringBuilder param = new StringBuilder();
        for (int i = index + 1; i < this.expression.length(); ++i) {
            if (this.expression.charAt(i) == '\\') {
                if (scapeChar.equals(last)) {
                    shift += 2;
                    param.append('\\');
                    last = null;
                    continue;
                }
                last = Character.valueOf(this.expression.charAt(i));
                continue;
            }
            if (this.expression.charAt(i) == '\"') {
                if (scapeChar.equals(last)) {
                    shift += 2;
                    param.append('\"');
                    last = null;
                    continue;
                }
                ++shift;
                strReaded = true;
                break;
            }
            if (this.expression.charAt(i) == 'n') {
                if (scapeChar.equals(last)) {
                    shift += 2;
                    param.append('\n');
                } else {
                    ++shift;
                    param.append(this.expression.charAt(i));
                }
                last = null;
                continue;
            }
            if (last != null) {
                ++shift;
                param.append(last);
            }
            last = null;
            ++shift;
            param.append(this.expression.charAt(i));
        }
        if (!strReaded) {
            throw new ParseException(STRING_PARAMETER_EXPECTED_ERROR, this.parseIndex);
        }
        this.parseIndex = index + shift;
        return param.toString();
    }

    private int nextNonBlank() {
        if (this.parseIndex < 0) {
            return -1;
        }
        for (int i = this.parseIndex; i < this.expression.length(); ++i) {
            if (this.isBlank(Character.valueOf(this.expression.charAt(i)))) continue;
            return i;
        }
        return -1;
    }

    private int nextBlank() {
        if (this.parseIndex < 0) {
            return -1;
        }
        for (int i = this.parseIndex; i < this.expression.length(); ++i) {
            if (!this.isBlank(Character.valueOf(this.expression.charAt(i)))) continue;
            return i;
        }
        return -1;
    }

    private boolean isBlank(Character character) {
        return character != null && (character.equals(Character.valueOf('\n')) || character.equals(Character.valueOf(' ')));
    }

    private String errorMessage(String message, Object ... params) {
        return MessageFormat.format(message, params);
    }

    private String functionNames() {
        return functionNames;
    }

    static {
        FunctionDef isNull = new FunctionDef("isNull");
        isNull.addParam("param1", Object.class);
        functionsRegistry.put(isNull.getName(), isNull);
        FunctionDef equalsTo = new FunctionDef("equalsTo");
        equalsTo.addParam("param1", Object.class);
        equalsTo.addParam("param2", String.class);
        functionsRegistry.put(equalsTo.getName(), equalsTo);
        FunctionDef isEmpty = new FunctionDef("isEmpty");
        isEmpty.addParam("param1", Object.class);
        functionsRegistry.put(isEmpty.getName(), isEmpty);
        FunctionDef contains = new FunctionDef("contains");
        contains.addParam("param1", Object.class);
        contains.addParam("param2", String.class);
        functionsRegistry.put(contains.getName(), contains);
        FunctionDef startsWith = new FunctionDef("startsWith");
        startsWith.addParam("param1", Object.class);
        startsWith.addParam("param2", String.class);
        functionsRegistry.put(startsWith.getName(), startsWith);
        FunctionDef endsWith = new FunctionDef("endsWith");
        endsWith.addParam("param1", Object.class);
        endsWith.addParam("param2", String.class);
        functionsRegistry.put(endsWith.getName(), endsWith);
        FunctionDef greaterThan = new FunctionDef("greaterThan");
        greaterThan.addParam("param1", Object.class);
        greaterThan.addParam("param2", String.class);
        functionsRegistry.put(greaterThan.getName(), greaterThan);
        FunctionDef greaterOrEqualThan = new FunctionDef("greaterOrEqualThan");
        greaterOrEqualThan.addParam("param1", Object.class);
        greaterOrEqualThan.addParam("param2", String.class);
        functionsRegistry.put(greaterOrEqualThan.getName(), greaterOrEqualThan);
        FunctionDef lessThan = new FunctionDef("lessThan");
        lessThan.addParam("param1", Object.class);
        lessThan.addParam("param2", String.class);
        functionsRegistry.put(lessThan.getName(), lessThan);
        FunctionDef lessOrEqualThan = new FunctionDef("lessOrEqualThan");
        lessOrEqualThan.addParam("param1", Object.class);
        lessOrEqualThan.addParam("param2", String.class);
        functionsRegistry.put(lessOrEqualThan.getName(), lessOrEqualThan);
        FunctionDef between = new FunctionDef("between");
        between.addParam("param1", Object.class);
        between.addParam("param2", String.class);
        between.addParam("param3", String.class);
        functionsRegistry.put(between.getName(), between);
        FunctionDef isTrue = new FunctionDef("isTrue");
        isTrue.addParam("param1", Object.class);
        functionsRegistry.put(isTrue.getName(), isTrue);
        FunctionDef isFalse = new FunctionDef("isFalse");
        isFalse.addParam("param1", Object.class);
        functionsRegistry.put(isFalse.getName(), isFalse);
        StringBuilder functionNamesBuilder = new StringBuilder();
        functionNamesBuilder.append("{");
        boolean first = true;
        for (String functionName : functionsRegistry.keySet()) {
            if (!first) {
                functionNamesBuilder.append(", ");
            }
            functionNamesBuilder.append(functionName);
            first = false;
        }
        functionNamesBuilder.append("}");
        functionNames = functionNamesBuilder.toString();
    }
}

