/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server;

import bpsim.impl.BpsimFactoryImpl;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.bpmn2.resource.JBPMBpmn2ResourceFactoryImpl;
import org.jbpm.designer.bpmn2.resource.JBPMBpmn2ResourceImpl;
import org.jbpm.designer.type.Bpmn2TypeDefinition;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.helper.CopyHelper;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class BusinessProcessCopyHelper
implements CopyHelper {
    private IOService ioService;
    private CommentedOptionFactory commentedOptionFactory;
    private Bpmn2TypeDefinition bpmn2ResourceType;
    private static Logger logger = LoggerFactory.getLogger(BusinessProcessCopyHelper.class);

    public BusinessProcessCopyHelper() {
    }

    @Inject
    public BusinessProcessCopyHelper(@Named(value="ioStrategy") IOService ioService, Bpmn2TypeDefinition bpmn2ResourceType, CommentedOptionFactory commentedOptionFactory) {
        this.ioService = ioService;
        this.bpmn2ResourceType = bpmn2ResourceType;
        this.commentedOptionFactory = commentedOptionFactory;
    }

    public boolean supports(org.uberfire.backend.vfs.Path destination) {
        return this.bpmn2ResourceType.accept(destination);
    }

    public void postProcess(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path destination) {
        Path _destination = Paths.convert((org.uberfire.backend.vfs.Path)destination);
        String processSource = this.ioService.readAllString(_destination);
        DroolsFactoryImpl.init();
        BpsimFactoryImpl.init();
        try {
            Definitions def = new JbpmProfileImpl().getDefinitions(processSource);
            Process process = this.getRootProcess(def);
            String destinationPkg = "";
            if (!"/".equals(_destination.getParent().toString())) {
                String[] pathParts = _destination.getParent().toString().split("/");
                destinationPkg = pathParts[1];
            }
            String destinationID = destinationPkg + "." + destination.getFileName().toString().substring(0, destination.getFileName().length() - 6);
            process.setId(Utils.toBPMNIdentifier(destinationID));
            ResourceSetImpl rSet = new ResourceSetImpl();
            rSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpmn2", new JBPMBpmn2ResourceFactoryImpl());
            JBPMBpmn2ResourceImpl bpmn2resource = (JBPMBpmn2ResourceImpl)rSet.createResource(URI.createURI((String)"virtual.bpmn2"));
            rSet.getResources().add((Object)bpmn2resource);
            bpmn2resource.getContents().add((Object)def);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            bpmn2resource.save(outputStream, new HashMap());
            String destinationBpmn2 = outputStream.toString();
            if (destinationBpmn2 != null) {
                this.ioService.write(_destination, destinationBpmn2, new OpenOption[]{this.commentedOptionFactory.makeCommentedOption("File [" + source.toURI() + "] copied to [" + destination.toURI() + "].")});
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public Process getRootProcess(Definitions def) {
        for (RootElement nextRootElement : def.getRootElements()) {
            if (!(nextRootElement instanceof Process)) continue;
            return (Process)nextRootElement;
        }
        return null;
    }
}

