/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.filter;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.CDATASection;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InjectionRule {
    private String name;
    private Pattern pattern;
    private boolean enabled;
    private String elements = "";
    private int insertAt;
    private String strInsertAt;

    public InjectionRule(Node ruleNode, String contextPath) throws TransformerFactoryConfigurationError, TransformerException {
        this.name = InjectionRule.getAttrValue(ruleNode, "name");
        this.setPattern(InjectionRule.getAttrValue(ruleNode, "url-pattern"));
        this.enabled = InjectionRule.getAttrValue(ruleNode, "enabled").equals("true");
        this.strInsertAt = InjectionRule.getAttrValue(ruleNode, "insert-at");
        this.setInsertAt(this.strInsertAt);
        if (this.enabled) {
            NodeList items = ruleNode.getChildNodes();
            for (int i = 0; i < items.getLength(); ++i) {
                Node item = items.item(i);
                if (item.getNodeType() != 4) continue;
                CDATASection cdata = (CDATASection)item;
                this.elements = this.elements + cdata.getNodeValue().trim() + "\n";
            }
            this.elements = this.elements.replaceAll("@contextpath@", contextPath);
        }
    }

    private static String getAttrValue(Node n, String attrName) {
        if (n == null) {
            return null;
        }
        NamedNodeMap attrs = n.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node attr = attrs.getNamedItem(attrName);
        if (attr == null) {
            return null;
        }
        String val = attr.getNodeValue();
        if (val == null) {
            return null;
        }
        return val.trim();
    }

    public String toString() {
        return this.elements;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(String p) throws PatternSyntaxException {
        try {
            this.pattern = Pattern.compile(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getInsertAt() {
        return this.insertAt;
    }

    public void setInsertAt(String strInsertAt) {
        if (strInsertAt.equals("head-begin".toLowerCase())) {
            this.insertAt = 0;
        }
        if (strInsertAt.equals("head-end".toLowerCase())) {
            this.insertAt = 1;
        }
        if (strInsertAt.equals("body-begin".toLowerCase())) {
            this.insertAt = 2;
        }
        if (strInsertAt.equals("body-end".toLowerCase())) {
            this.insertAt = 3;
        }
    }
}

