/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server;

import bpsim.impl.BpsimFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.WeakHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.jbpm.designer.util.ConfigurationProvider;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.plugin.IDiagramPlugin;
import org.jbpm.designer.web.plugin.IDiagramPluginService;
import org.jbpm.designer.web.plugin.impl.PluginServiceImpl;
import org.jbpm.designer.web.preprocessing.IDiagramPreprocessingService;
import org.jbpm.designer.web.preprocessing.IDiagramPreprocessingUnit;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.profile.impl.RepositoryInfo;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.io.IOService;

public class EditorHandler
extends HttpServlet {
    private static final long serialVersionUID = -7439613152623067053L;
    private static final Logger _logger = LoggerFactory.getLogger(EditorHandler.class);
    public static final String designer_path = ConfigurationProvider.getInstance().getDesignerContext();
    public static final String DEV = "designer.dev";
    public static final String USEOLDDATAASSIGNMENTS = "designer.useolddataassignments";
    public static final String SHOW_PDF_DOC = "designer.showpdfdoc";
    public static final String PRESET_PERSPECTIVE = "org.jbpm.designer.perspective";
    public static final String BPSIM_DISPLAY = "org.jbpm.designer.bpsimdisplay";
    public static final String FORMS_TYPE = "org.jbpm.designer.formstype";
    public static final String PREPROCESS = "designer.preprocess";
    public static final String SKIN = "designer.skin";
    public static final String SERVICE_REPO = "org.jbpm.service.repository";
    public static final String SERVICE_REPO_TASKS = "org.jbpm.service.servicetasknames";
    public static final String BUNDLE_VERSION = "Bundle-Version";
    private boolean _devMode;
    private boolean _useOldDataAssignments;
    private boolean showPDFDoc;
    private boolean _preProcess;
    private String _skin;
    private String _designerVersion;
    private String _doc;
    private IDiagramProfile profile;
    private String serviceRepo;
    private String serviceRepoTasks;
    @Inject
    private IDiagramProfileService _profileService = null;
    @Inject
    private VFSService vfsServices;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private RepositoryDescriptor descriptor;
    @Inject
    private IDiagramPreprocessingService _preProcessingService;
    private IDiagramPluginService _pluginService = null;
    private List<String> _envFiles = new ArrayList<String>();
    private Map<String, List<IDiagramPlugin>> _pluginfiles = new HashMap<String, List<IDiagramPlugin>>();
    private Map<String, List<IDiagramPlugin>> _uncompressedPlugins = new WeakHashMap<String, List<IDiagramPlugin>>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        DroolsFactoryImpl.init();
        BpsimFactoryImpl.init();
        this._profileService.init(config.getServletContext());
        this._pluginService = PluginServiceImpl.getInstance(config.getServletContext());
        this._preProcessingService.init(config.getServletContext(), this.vfsServices);
        this._devMode = Boolean.parseBoolean(System.getProperty(DEV) == null ? config.getInitParameter(DEV) : System.getProperty(DEV));
        this._useOldDataAssignments = Boolean.parseBoolean(System.getProperty(USEOLDDATAASSIGNMENTS) == null ? config.getInitParameter(USEOLDDATAASSIGNMENTS) : System.getProperty(USEOLDDATAASSIGNMENTS));
        this._preProcess = Boolean.parseBoolean(System.getProperty(PREPROCESS) == null ? config.getInitParameter(PREPROCESS) : System.getProperty(PREPROCESS));
        this._skin = System.getProperty(SKIN) == null ? config.getInitParameter(SKIN) : System.getProperty(SKIN);
        this._designerVersion = EditorHandler.readDesignerVersion(config.getServletContext());
        this.showPDFDoc = this.doShowPDFDoc(config);
        this.serviceRepo = System.getProperty(SERVICE_REPO) == null ? config.getInitParameter(SERVICE_REPO) : System.getProperty(SERVICE_REPO);
        this.serviceRepoTasks = System.getProperty(SERVICE_REPO_TASKS) == null ? config.getInitParameter(SERVICE_REPO_TASKS) : System.getProperty(SERVICE_REPO_TASKS);
        String editor_file = config.getServletContext().getRealPath(designer_path + "editor.st");
        try {
            this._doc = this.readFile(editor_file);
        }
        catch (Exception e) {
            throw new ServletException("Error while parsing editor.st", (Throwable)e);
        }
        if (this._doc == null) {
            _logger.error("Invalid editor.st, could not be read as a document.");
            throw new ServletException("Invalid editor.st, could not be read as a document.");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONArray scriptsArray;
        String profileName = Utils.getDefaultProfileName(request.getParameter("profile"));
        String uuid = Utils.getUUID(request);
        String editorID = request.getParameter("editorid");
        String readOnly = request.getParameter("readonly");
        String viewLocked = request.getParameter("viewlocked");
        String sessionId = request.getParameter("sessionId");
        if (viewLocked == null || viewLocked.length() < 1) {
            viewLocked = "false";
        }
        if (this.profile == null) {
            this.profile = this._profileService.findProfile(request, profileName);
        }
        if (this.profile == null) {
            _logger.error("No profile with the name " + profileName + " was registered");
            throw new IllegalArgumentException("No profile with the name " + profileName + " was registered");
        }
        IDiagramPreprocessingUnit preprocessingUnit = null;
        if (this._preProcess) {
            if (_logger.isInfoEnabled()) {
                _logger.info("Performing diagram information pre-processing steps. ");
            }
            preprocessingUnit = this._preProcessingService.findPreprocessingUnit(request, this.profile);
            preprocessingUnit.preprocess(request, response, this.profile, this.getServletContext(), Boolean.parseBoolean(readOnly), Boolean.parseBoolean(viewLocked), this.ioService, this.descriptor);
        }
        if (this._devMode) {
            scriptsArray = new JSONArray();
            for (String nextScript : this._envFiles) {
                scriptsArray.put((Object)(designer_path + nextScript));
            }
        } else {
            scriptsArray = new JSONArray();
            scriptsArray.put((Object)(designer_path + "jsc/env_combined.js"));
        }
        if (this._pluginfiles.get(profileName) == null) {
            ArrayList<IDiagramPlugin> compressed = new ArrayList<IDiagramPlugin>();
            Iterator<IDiagramPlugin> uncompressed = new ArrayList();
            this._pluginfiles.put(profileName, compressed);
            this._uncompressedPlugins.put(profileName, (List<IDiagramPlugin>)((Object)uncompressed));
            for (String pluginName : this.profile.getPlugins()) {
                IDiagramPlugin plugin = this._pluginService.findPlugin(request, pluginName);
                if (plugin == null) {
                    _logger.warn("Could not find the plugin " + pluginName + " requested by the profile " + this.profile.getName());
                    continue;
                }
                if (plugin.isCompressable()) {
                    compressed.add(plugin);
                    continue;
                }
                uncompressed.add(plugin);
            }
        }
        JSONArray pluginsArray = new JSONArray();
        if (this._devMode) {
            for (IDiagramPlugin jsFile : this._pluginfiles.get(profileName)) {
                pluginsArray.put((Object)("/plugin/" + jsFile.getName() + ".js"));
            }
        } else {
            pluginsArray.put((Object)(designer_path + "jsc/plugins_" + profileName + ".js"));
        }
        for (IDiagramPlugin uncompressed : this._uncompressedPlugins.get(profileName)) {
            pluginsArray.put((Object)(designer_path + "plugin/" + uncompressed.getName() + ".js"));
        }
        ST editorTemplate = new ST(this._doc, '$', '$');
        editorTemplate.add("bopen", (Object)"{");
        editorTemplate.add("bclose", (Object)"}");
        editorTemplate.add("editorprofile", (Object)profileName);
        editorTemplate.add("editoruuid", (Object)uuid);
        editorTemplate.add("editorid", (Object)editorID);
        editorTemplate.add("sessionid", (Object)sessionId);
        editorTemplate.add("instanceviewmode", (Object)this.getInstanceViewMode(request));
        editorTemplate.add("readonly", (Object)readOnly);
        editorTemplate.add("viewlocked", (Object)viewLocked);
        editorTemplate.add("allscripts", (Object)scriptsArray.toString());
        editorTemplate.add("allplugins", (Object)pluginsArray.toString());
        editorTemplate.add("title", (Object)this.profile.getTitle());
        editorTemplate.add("stencilset", (Object)this.profile.getStencilSet());
        editorTemplate.add("debug", (Object)this._devMode);
        editorTemplate.add("useolddataassignments", (Object)this._useOldDataAssignments);
        editorTemplate.add("preprocessing", (Object)(preprocessingUnit == null ? "" : preprocessingUnit.getOutData()));
        editorTemplate.add("externalprotocol", (Object)(RepositoryInfo.getRepositoryProtocol(this.profile) == null ? "" : RepositoryInfo.getRepositoryProtocol(this.profile)));
        editorTemplate.add("externalhost", (Object)RepositoryInfo.getRepositoryHost(this.profile));
        editorTemplate.add("externalsubdomain", (Object)(RepositoryInfo.getRepositorySubdomain(this.profile) != null ? RepositoryInfo.getRepositorySubdomain(this.profile).substring(0, RepositoryInfo.getRepositorySubdomain(this.profile).indexOf("/")) : ""));
        editorTemplate.add("repositoryid", (Object)"designer");
        editorTemplate.add("localhistoryenabled", (Object)this.profile.getLocalHistoryEnabled());
        editorTemplate.add("localhistorytimeout", (Object)this.profile.getLocalHistoryTimeout());
        editorTemplate.add("designerversion", (Object)this._designerVersion);
        editorTemplate.add("showpdfdoc", (Object)this.showPDFDoc);
        editorTemplate.add("storesvgonsave", (Object)this.profile.getStoreSVGonSaveOption());
        editorTemplate.add("defaultSkin", (Object)(designer_path + "css/theme-default.css"));
        editorTemplate.add("presetperspective", (Object)(System.getProperty(PRESET_PERSPECTIVE) == null ? "" : System.getProperty(PRESET_PERSPECTIVE)));
        editorTemplate.add("bpsimdisplay", (Object)this.profile.getBpsimDisplay());
        editorTemplate.add("formstype", (Object)this.profile.getFormsType());
        String overlaySkin = "";
        if (this._skin != null && !this._skin.equals("default")) {
            overlaySkin = designer_path + "css/theme-" + this._skin + ".css";
        }
        editorTemplate.add("overlaySkin", (Object)overlaySkin);
        StringBuilder plugins = new StringBuilder();
        boolean commaNeeded = false;
        for (String ext : this.profile.getPlugins()) {
            if (commaNeeded) {
                plugins.append(",");
            } else {
                commaNeeded = true;
            }
            plugins.append("\"").append(ext).append("\"");
        }
        editorTemplate.add("profileplugins", (Object)plugins.toString());
        StringBuilder ssexts = new StringBuilder();
        commaNeeded = false;
        for (String ext : this.profile.getStencilSetExtensions()) {
            if (commaNeeded) {
                ssexts.append(",");
            } else {
                commaNeeded = true;
            }
            ssexts.append("\"").append(ext).append("\"");
        }
        editorTemplate.add("ssextensions", (Object)ssexts.toString());
        editorTemplate.add("contextroot", (Object)request.getContextPath());
        editorTemplate.add("servicerepo", (Object)(this.serviceRepo == null ? "" : this.serviceRepo));
        editorTemplate.add("servicerepotasks", this.serviceRepoTasks == null ? "" : Arrays.asList(this.serviceRepoTasks.split(",")));
        response.setContentType("text/javascript; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(editorTemplate.render());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readDesignerVersion(ServletContext context) {
        String retStr = "";
        BufferedReader br = null;
        try {
            String line;
            InputStream inputStream = context.getResourceAsStream("/META-INF/MANIFEST.MF");
            br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith(BUNDLE_VERSION)) continue;
                retStr = line.substring(BUNDLE_VERSION.length() + 1);
                retStr = retStr.trim();
            }
            inputStream.close();
            if (br == null) return retStr;
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            return retStr;
        }
        finally {
            if (br != null) {
                IOUtils.closeQuietly(br);
            }
        }
        IOUtils.closeQuietly((Reader)br);
        return retStr;
    }

    public String getInstanceViewMode(HttpServletRequest request) {
        String instanceViewMode = request.getParameter("instanceviewmode");
        return instanceViewMode != null && instanceViewMode.equals("true") ? "true" : "false";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String pathname) throws IOException {
        StringBuilder fileContents = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        try (Scanner scanner = new Scanner(new File(pathname), "UTF-8");){
            while (scanner.hasNextLine()) {
                fileContents.append(scanner.nextLine() + lineSeparator);
            }
            String string = fileContents.toString();
            return string;
        }
    }

    public boolean doShowPDFDoc(ServletConfig config) {
        return Boolean.parseBoolean(System.getProperty(SHOW_PDF_DOC) == null ? config.getInitParameter(SHOW_PDF_DOC) : System.getProperty(SHOW_PDF_DOC));
    }

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public IDiagramProfile getProfile() {
        return this.profile;
    }
}

