/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import bpsim.impl.BpsimFactoryImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.bpmn2.Definitions;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.bpmn2.impl.Bpmn2JsonUnmarshaller;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.taskforms.BPMNFormBuilderManager;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.json.JSONObject;
import org.kie.workbench.common.forms.bpmn.BPMNFormBuilderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

public class TaskFormsEditorServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = LoggerFactory.getLogger(TaskFormsEditorServlet.class);
    private static final String FORMMODELER_FILE_EXTENSION = "form";
    private static final String FORMMODELER_PREVIEW_FILE_EXTENSION = "frm";
    private static final String TASKFORM_NAME_EXTENSION = "-taskform";
    protected static final String ACTION_LOAD = "load";
    protected static final String ACTION_SAVE = "save";
    private IDiagramProfile profile;
    BPMNFormBuilderService<Definitions> formBuilder;
    @Inject
    private IDiagramProfileService _profileService = null;
    @Inject
    private VFSService vfsServices;
    @Inject
    private BPMNFormBuilderManager formBuilderManager;
    @Inject
    private SessionInfo sessionInfo;

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter("action");
        String uuid = Utils.getUUID(req);
        String profileName = Utils.getDefaultProfileName(req.getParameter("profile"));
        String taskName = UriUtils.decode(Utils.getEncodedParam(req, "taskname"));
        String taskFormValue = req.getParameter("tfvalue");
        String formType = req.getParameter("formtype");
        String json = req.getParameter("json");
        String preprocessingData = req.getParameter("ppdata");
        String taskId = req.getParameter("taskid");
        if (this.profile == null) {
            this.profile = this._profileService.findProfile(req, profileName);
        }
        Repository repository = this.profile.getRepository();
        Asset processAsset = null;
        try {
            processAsset = repository.loadAsset(uuid);
            if (action != null && action.equals(ACTION_LOAD)) {
                resp.setContentType("text/html");
                resp.setCharacterEncoding("UTF-8");
                PrintWriter pw = resp.getWriter();
                String taskResponse = this.getTaskFormFromRepository(formType, taskName, processAsset.getAssetLocation(), repository, json, preprocessingData, uuid, taskId);
                pw.write(taskResponse);
            } else if (action != null && action.equals(ACTION_SAVE)) {
                resp.setContentType("application/json");
                resp.setCharacterEncoding("UTF-8");
                PrintWriter pw = resp.getWriter();
                try {
                    pw.write(this.storeTaskFormInRepository(formType, taskName, processAsset.getAssetLocation(), taskFormValue, repository).toString());
                }
                catch (Exception e) {
                    _logger.error("Exception during saving form: " + e.getMessage());
                    pw.write(new JSONObject().toString());
                }
            }
        }
        catch (Exception e) {
            PrintWriter pw = resp.getWriter();
            pw.write("error: " + e.getMessage());
        }
    }

    private JSONObject storeTaskFormInRepository(String formType, String taskName, String packageName, String formValue, Repository repository) throws Exception {
        if (formType.equals(FORMMODELER_FILE_EXTENSION) || formType.equals(FORMMODELER_PREVIEW_FILE_EXTENSION)) {
            repository.deleteAssetFromPath(packageName + "/" + taskName + TASKFORM_NAME_EXTENSION + "." + formType);
            AssetBuilder builder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte);
            builder.location(packageName).name(taskName + TASKFORM_NAME_EXTENSION).type(formType).content(formValue.getBytes("UTF-8"));
            repository.createAsset(builder.getAsset());
            Asset newFormAsset = repository.loadAssetFromPath(packageName + "/" + taskName + TASKFORM_NAME_EXTENSION + "." + formType);
            JSONObject retObj = new JSONObject();
            try {
                retObj.put("formid", (Object)this.getDecodedId(newFormAsset.getUniqueId()));
            }
            catch (UnsupportedEncodingException e) {
                retObj.put("formid", (Object)"false");
            }
            return retObj;
        }
        return new JSONObject();
    }

    private String getTaskFormFromRepository(String formType, String taskName, String packageName, Repository repository, String json, String preprocessingData, String uuid, String taskId) {
        try {
            Asset formAsset = repository.loadAssetFromPath(packageName + "/" + taskName + TASKFORM_NAME_EXTENSION + "." + formType);
            if (formType.equals(FORMMODELER_FILE_EXTENSION) || formType.equals(FORMMODELER_PREVIEW_FILE_EXTENSION)) {
                try {
                    return this.getAssetInfo(formAsset);
                }
                catch (UnsupportedEncodingException e) {
                    _logger.error("Error loading form: " + e.getMessage());
                }
            } else {
                _logger.error("Cannot load existing form for invalid form type: " + formType);
            }
        }
        catch (NoSuchFileException anfe) {
            try {
                String formValue = "";
                if (formType.equals(FORMMODELER_FILE_EXTENSION) || formType.equals(FORMMODELER_PREVIEW_FILE_EXTENSION)) {
                    this.formBuilder = this.getFormBuilder(formType);
                    if (this.formBuilder != null) {
                        DroolsFactoryImpl.init();
                        BpsimFactoryImpl.init();
                        Bpmn2JsonUnmarshaller unmarshaller = new Bpmn2JsonUnmarshaller();
                        Definitions def = (Definitions)unmarshaller.unmarshall(json, preprocessingData).getContents().get(0);
                        org.uberfire.backend.vfs.Path myPath = this.vfsServices.get(uuid);
                        Path kiePath = Paths.convert((org.uberfire.backend.vfs.Path)myPath);
                        org.uberfire.backend.vfs.Path formPath = Paths.convert((Path)kiePath.getParent().resolve(taskName + TASKFORM_NAME_EXTENSION + "." + formType));
                        formValue = this.formBuilder.buildFormContent(formPath, (Object)def, taskId);
                    } else {
                        _logger.warn("Unable to find form builder for form type: " + formType);
                    }
                    AssetBuilder assetBuilder = AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte);
                    assetBuilder.location(packageName).name(taskName + TASKFORM_NAME_EXTENSION).type(formType).content(formValue.getBytes("UTF-8"));
                    repository.createAsset(assetBuilder.getAsset());
                    Asset newFormAsset = repository.loadAssetFromPath(packageName + "/" + taskName + TASKFORM_NAME_EXTENSION + "." + formType);
                    return this.getAssetInfo(newFormAsset);
                }
                _logger.error("Cannot create new form for invalid form type: " + formType);
            }
            catch (Exception e) {
                _logger.error(e.getMessage());
            }
        }
        return "false";
    }

    public BPMNFormBuilderService<Definitions> getFormBuilder() {
        return this.formBuilder;
    }

    public BPMNFormBuilderService<Definitions> getFormBuilder(String formType) {
        return this.formBuilderManager.getBuilderByFormType(formType);
    }

    private String getAssetInfo(Asset<String> asset) throws UnsupportedEncodingException {
        return asset.getName() + "." + asset.getAssetType() + "|" + this.getDecodedId(asset.getUniqueId());
    }

    private String getDecodedId(String id) throws UnsupportedEncodingException {
        if (Base64.isBase64((String)id)) {
            byte[] decodedId = Base64.decodeBase64((String)id);
            return new String(decodedId, "UTF-8");
        }
        return id;
    }

    public void setFormBuilder(BPMNFormBuilderService<Definitions> formBuilder) {
        this.formBuilder = formBuilder;
    }
}

