/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.bpmn2.validation.BPMN2SyntaxChecker;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;

@WebServlet(displayName="SyntaxChecker", name="SyntaxCheckerServlet", urlPatterns={"/syntaxcheck"})
public class SyntaxCheckerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected IDiagramProfile profile;
    @Inject
    private IDiagramProfileService _profileService = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String json = req.getParameter("data");
        String profileName = Utils.getDefaultProfileName(req.getParameter("profile"));
        String preprocessingData = req.getParameter("pp");
        if (this.profile == null) {
            this.profile = this._profileService.findProfile(req, profileName);
        }
        BPMN2SyntaxChecker checker = new BPMN2SyntaxChecker(json, preprocessingData, this.profile);
        checker.checkSyntax();
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("application/json");
        if (checker.errorsFound()) {
            resp.getWriter().write(checker.getErrorsAsJson().toString());
        }
    }
}

