/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server.service;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.codec.binary.Base64;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.AssetBuilderFactory;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.jbpm.designer.service.BPMN2DataServices;
import org.jbpm.designer.service.DesignerAssetService;
import org.jbpm.designer.service.DesignerContent;
import org.jbpm.designer.util.Utils;
import org.json.JSONArray;
import org.kie.workbench.common.services.backend.service.KieService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class DefaultDesignerAssetService
extends KieService<DesignerContent>
implements DesignerAssetService {
    private static Logger logger = LoggerFactory.getLogger(DefaultDesignerAssetService.class);
    private static final String DEFAULT_CASE_ID_PREFIX = "CASE";
    private static final String CASE_PROJECT_DOT_FILE = ".caseproject";
    @Inject
    private Repository repository;
    @Inject
    private Instance<BPMN2DataServices> bpmn2DataServices;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private RepositoryDescriptor descriptor;
    private static final int socketBufferSize = 8192;
    private static final Logger _logger = LoggerFactory.getLogger(DefaultDesignerAssetService.class);
    public static final String PROCESS_STUB = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<bpmn2:definitions xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.omg.org/bpmn20\" xmlns:bpmn2=\"http://www.omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" xmlns:bpsim=\"http://www.bpsim.org/schemas/1.0\" xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:drools=\"http://www.jboss.org/drools\" \nid=\"Definition\" xsi:schemaLocation=\"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd http://www.jboss.org/drools drools.xsd http://www.bpsim.org/schemas/1.0 bpsim.xsd\" expressionLanguage=\"http://www.mvel.org/2.0\" targetNamespace=\"http://www.omg.org/bpmn20\" typeLanguage=\"http://www.java.com/javaTypes\"> \n   <bpmn2:process id=\"${processid}\" drools:packageName=\"${packageName}\" drools:version=\"1.0\" name=\"\" isExecutable=\"true\"> \n      <bpmn2:startEvent id=\"processStartEvent\" drools:bgcolor=\"#9acd32\" drools:selectable=\"true\" name=\"\"/> \n   </bpmn2:process> \n   <bpmndi:BPMNDiagram> \n      <bpmndi:BPMNPlane bpmnElement=\"${processid}\"> \n         <bpmndi:BPMNShape bpmnElement=\"processStartEvent\"> \n            <dc:Bounds height=\"30.0\" width=\"30.0\" x=\"120.0\" y=\"165.0\"/> \n         </bpmndi:BPMNShape> \n      </bpmndi:BPMNPlane> \n   </bpmndi:BPMNDiagram> \n</bpmn2:definitions>";
    public static final String CASE_DEF_STUB_MILESTONE = "<bpmn2:task id=\"_milestoneTask\" drools:selectable=\"true\" drools:taskName=\"Milestone\" color:background-color=\"#fafad2\" color:border-color=\"#000000\" color:color=\"#000000\" name=\"Milestone\">\n      <bpmn2:extensionElements>\n        <drools:metaData name=\"elementname\">\n          <drools:metaValue><![CDATA[Milestone]]></drools:metaValue>\n        </drools:metaData>\n        <drools:metaData name=\"customAutoStart\">\n          <drools:metaValue><![CDATA[true]]></drools:metaValue>\n        </drools:metaData>\n      </bpmn2:extensionElements>\n      <bpmn2:ioSpecification id=\"_milestoneIoSpecification\">\n        <bpmn2:dataInput id=\"_milestone_TaskNameInputX\" drools:dtype=\"String\" itemSubjectRef=\"_milestone_TaskNameInputXItem\" name=\"TaskName\"/>\n        <bpmn2:dataInput id=\"_milestone_ConditionInputX\" drools:dtype=\"String\" itemSubjectRef=\"_milestone_ConditionInputXItem\" name=\"Condition\"/>\n        <bpmn2:inputSet id=\"_milestoneInputSet\">\n          <bpmn2:dataInputRefs>_milestone_ConditionInputX</bpmn2:dataInputRefs>\n          <bpmn2:dataInputRefs>_milestone_TaskNameInputX</bpmn2:dataInputRefs>\n        </bpmn2:inputSet>\n        <bpmn2:outputSet id=\"_milestoneOutputSet\"/>\n      </bpmn2:ioSpecification>\n      <bpmn2:dataInputAssociation id=\"_milestoneDataInputAssociation\">\n        <bpmn2:targetRef>_milestone_TaskNameInputX</bpmn2:targetRef>\n        <bpmn2:assignment id=\"_milestoneAssignment\">\n          <bpmn2:from xsi:type=\"bpmn2:tFormalExpression\" id=\"_milestoneExpressionFrom\"><![CDATA[Milestone]]></bpmn2:from>\n          <bpmn2:to xsi:type=\"bpmn2:tFormalExpression\" id=\"_milestoneExpressionTo\">_milestone_TaskNameInputX</bpmn2:to>\n        </bpmn2:assignment>\n      </bpmn2:dataInputAssociation>\n      <bpmn2:dataInputAssociation id=\"_milestoneDataInputAssociation2\">\n        <bpmn2:targetRef>_milestone_ConditionInputX</bpmn2:targetRef>\n        <bpmn2:assignment id=\"_milestoneAssignment2\">\n          <bpmn2:from xsi:type=\"bpmn2:tFormalExpression\" id=\"_milestoneExpressionFrom2\"><![CDATA[]]></bpmn2:from>\n          <bpmn2:to xsi:type=\"bpmn2:tFormalExpression\" id=\"_milestoneExpressionTo2\">_milestone_ConditionInputX</bpmn2:to>\n        </bpmn2:assignment>\n      </bpmn2:dataInputAssociation>\n    </bpmn2:task>\n";
    public static final String CASE_DEF_STUB = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<bpmn2:definitions xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.omg.org/bpmn20\" xmlns:bpmn2=\"http://www.omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" xmlns:bpsim=\"http://www.bpsim.org/schemas/1.0\" xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:drools=\"http://www.jboss.org/drools\" xmlns:color=\"http://www.omg.org/spec/BPMN/non-normative/color\"  \nid=\"Definition\" xsi:schemaLocation=\"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd http://www.jboss.org/drools drools.xsd http://www.bpsim.org/schemas/1.0 bpsim.xsd\" expressionLanguage=\"http://www.mvel.org/2.0\" targetNamespace=\"http://www.omg.org/bpmn20\" typeLanguage=\"http://www.java.com/javaTypes\"> \n   <bpmn2:itemDefinition id=\"_milestone_TaskNameInputXItem\" structureRef=\"String\"/>\n   <bpmn2:itemDefinition id=\"_milestone_ConditionInputXItem\" structureRef=\"Object\"/>\n   <bpmn2:process id=\"${processid}\" drools:packageName=\"${packageName}\" drools:version=\"1.0\" drools:adHoc=\"true\" name=\"\" isExecutable=\"true\"> \n     <bpmn2:extensionElements>\n       <drools:metaData name=\"customCaseIdPrefix\">\n         <drools:metaValue>${caseidprefix}</drools:metaValue>\n      </drools:metaData>\n     </bpmn2:extensionElements><bpmn2:task id=\"_milestoneTask\" drools:selectable=\"true\" drools:taskName=\"Milestone\" color:background-color=\"#fafad2\" color:border-color=\"#000000\" color:color=\"#000000\" name=\"Milestone\">\n      <bpmn2:extensionElements>\n        <drools:metaData name=\"elementname\">\n          <drools:metaValue><![CDATA[Milestone]]></drools:metaValue>\n        </drools:metaData>\n        <drools:metaData name=\"customAutoStart\">\n          <drools:metaValue><![CDATA[true]]></drools:metaValue>\n        </drools:metaData>\n      </bpmn2:extensionElements>\n      <bpmn2:ioSpecification id=\"_milestoneIoSpecification\">\n        <bpmn2:dataInput id=\"_milestone_TaskNameInputX\" drools:dtype=\"String\" itemSubjectRef=\"_milestone_TaskNameInputXItem\" name=\"TaskName\"/>\n        <bpmn2:dataInput id=\"_milestone_ConditionInputX\" drools:dtype=\"String\" itemSubjectRef=\"_milestone_ConditionInputXItem\" name=\"Condition\"/>\n        <bpmn2:inputSet id=\"_milestoneInputSet\">\n          <bpmn2:dataInputRefs>_milestone_ConditionInputX</bpmn2:dataInputRefs>\n          <bpmn2:dataInputRefs>_milestone_TaskNameInputX</bpmn2:dataInputRefs>\n        </bpmn2:inputSet>\n        <bpmn2:outputSet id=\"_milestoneOutputSet\"/>\n      </bpmn2:ioSpecification>\n      <bpmn2:dataInputAssociation id=\"_milestoneDataInputAssociation\">\n        <bpmn2:targetRef>_milestone_TaskNameInputX</bpmn2:targetRef>\n        <bpmn2:assignment id=\"_milestoneAssignment\">\n          <bpmn2:from xsi:type=\"bpmn2:tFormalExpression\" id=\"_milestoneExpressionFrom\"><![CDATA[Milestone]]></bpmn2:from>\n          <bpmn2:to xsi:type=\"bpmn2:tFormalExpression\" id=\"_milestoneExpressionTo\">_milestone_TaskNameInputX</bpmn2:to>\n        </bpmn2:assignment>\n      </bpmn2:dataInputAssociation>\n      <bpmn2:dataInputAssociation id=\"_milestoneDataInputAssociation2\">\n        <bpmn2:targetRef>_milestone_ConditionInputX</bpmn2:targetRef>\n        <bpmn2:assignment id=\"_milestoneAssignment2\">\n          <bpmn2:from xsi:type=\"bpmn2:tFormalExpression\" id=\"_milestoneExpressionFrom2\"><![CDATA[]]></bpmn2:from>\n          <bpmn2:to xsi:type=\"bpmn2:tFormalExpression\" id=\"_milestoneExpressionTo2\">_milestone_ConditionInputX</bpmn2:to>\n        </bpmn2:assignment>\n      </bpmn2:dataInputAssociation>\n    </bpmn2:task>\n   </bpmn2:process> \n   <bpmndi:BPMNDiagram> \n      <bpmndi:BPMNPlane bpmnElement=\"${processid}\"> \n         <bpmndi:BPMNShape bpmnElement=\"_milestoneTask\"> \n            <dc:Bounds height=\"80.0\" width=\"100.0\" x=\"90.0\" y=\"90.0\"/> \n         </bpmndi:BPMNShape> \n      </bpmndi:BPMNPlane> \n   </bpmndi:BPMNDiagram> \n</bpmn2:definitions>";

    public DesignerContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (DesignerContent)super.loadContent(path);
    }

    public Map<String, String> getEditorParameters(org.uberfire.backend.vfs.Path path, String editorID, String hostInfo, PlaceRequest place) {
        boolean readOnly;
        List<Object> activeNodesList = new ArrayList();
        String activeNodesParam = place.getParameter("activeNodes", null);
        boolean bl = readOnly = place.getParameter("readOnly", null) != null;
        if (!readOnly) {
            try {
                this.ioService.getFileSystem(URI.create(path.toURI()));
            }
            catch (Exception e) {
                logger.error("Unable to create file system: " + e.getMessage());
                throw new FileSystemNotFoundException(e.getMessage());
            }
        }
        String processId = place.getParameter("processId", "");
        String deploymentId = place.getParameter("deploymentId", "");
        String encodedProcessSource = "";
        try {
            encodedProcessSource = ((BPMN2DataServices)this.bpmn2DataServices.iterator().next()).getProcessSources(deploymentId, processId);
        }
        catch (Exception e) {
            encodedProcessSource = place.getParameter("encodedProcessSource", "");
        }
        if (activeNodesParam != null) {
            activeNodesList = Arrays.asList(activeNodesParam.split(","));
        }
        List<Object> completedNodesList = new ArrayList();
        String completedNodesParam = place.getParameter("completedNodes", null);
        if (completedNodesParam != null) {
            completedNodesList = Arrays.asList(completedNodesParam.split(","));
        }
        JSONArray activeNodesArray = new JSONArray(activeNodesList);
        JSONArray completedNodesArray = new JSONArray(completedNodesList);
        HashMap<String, String> editorParamsMap = new HashMap<String, String>();
        editorParamsMap.put("hostinfo", hostInfo);
        try {
            editorParamsMap.put("uuid", Base64.encodeBase64URLSafeString((byte[])UriUtils.decode(path.toURI()).getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        editorParamsMap.put("profile", "jbpm");
        editorParamsMap.put("pp", "");
        editorParamsMap.put("editorid", editorID);
        editorParamsMap.put("readonly", String.valueOf(readOnly));
        editorParamsMap.put("activenodes", activeNodesArray.toString());
        editorParamsMap.put("completednodes", completedNodesArray.toString());
        editorParamsMap.put("processsource", encodedProcessSource);
        if (!readOnly) {
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.sessionInfo));
        }
        return editorParamsMap;
    }

    public String getEditorID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public org.uberfire.backend.vfs.Path createProcess(org.uberfire.backend.vfs.Path context, String fileName) {
        org.uberfire.backend.vfs.Path path = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName));
        String location = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent().toString();
        String name = path.getFileName();
        String processId = this.buildProcessId(location, name);
        String packageName = this.buildPackageName(location, name);
        String processContent = PROCESS_STUB.replaceAll("\\$\\{processid\\}", processId.replaceAll("\\s", "")).replaceAll("\\$\\{packageName\\}", packageName.replaceAll("\\s", ""));
        return this.create(path, name, location, processContent);
    }

    public org.uberfire.backend.vfs.Path createCaseDefinition(org.uberfire.backend.vfs.Path context, String fileName, String caseIdPrefix) {
        org.uberfire.backend.vfs.Path path = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName));
        String location = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent().toString();
        String name = path.getFileName();
        String processId = this.buildProcessId(location, name);
        String packageName = this.buildPackageName(location, name);
        if (caseIdPrefix == null || caseIdPrefix.trim().isEmpty()) {
            caseIdPrefix = DEFAULT_CASE_ID_PREFIX;
        }
        String processContent = CASE_DEF_STUB.replaceAll("\\$\\{processid\\}", processId.replaceAll("\\s", "")).replaceAll("\\$\\{packageName\\}", packageName.replaceAll("\\s", "")).replaceAll("\\$\\{caseidprefix\\}", caseIdPrefix.replaceAll("\\s", ""));
        return this.create(path, name, location, processContent);
    }

    protected org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path path, String name, String location, String processContent) {
        AssetBuilder builder = AssetBuilderFactory.getAssetBuilder(name);
        builder.location(location).content(processContent).uniqueId(path.toURI());
        Asset processAsset = builder.getAsset();
        this.repository.createAsset(processAsset);
        return path;
    }

    private String buildProcessId(String location, String name) {
        if (location.startsWith("/")) {
            location = location.replaceFirst("/", "");
        }
        if ((location = location.replaceAll("/", ".")).length() > 0) {
            String[] locationParts = location.split("\\.");
            location = locationParts[0];
        }
        name = name.substring(0, name.lastIndexOf("."));
        name = Utils.toBPMNIdentifier(name);
        return location + "." + name;
    }

    private String buildPackageName(String location, String name) {
        String packageName = location.replaceFirst("/" + name, "").replaceFirst(".*/src/main/resources", "").replaceAll("/", ".");
        if (packageName.startsWith(".")) {
            packageName = packageName.substring(1);
        }
        return packageName;
    }

    public void updateMetadata(org.uberfire.backend.vfs.Path resource, Metadata metadata) {
        this.ioService.setAttributes(Paths.convert((org.uberfire.backend.vfs.Path)resource), this.metadataService.setUpAttributes(resource, metadata));
    }

    protected DesignerContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        return new DesignerContent(overview);
    }

    public boolean isCaseProject(org.uberfire.backend.vfs.Path rootProjectPath) {
        DirectoryStream found = this.ioService.newDirectoryStream(Paths.convert((org.uberfire.backend.vfs.Path)rootProjectPath), f -> f.endsWith(CASE_PROJECT_DOT_FILE));
        return found.iterator().hasNext();
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setIoService(IOService ioService) {
        this.ioService = ioService;
    }
}

