/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server.indexing;

import java.util.HashSet;
import org.jbpm.designer.query.FindBpmn2ProcessIdsQuery;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.ResourceType;

public class FindBpmn2ProcessIdsQueryTest {
    private static final String ERROR_MSG = ResourceType.JAVA.toString() + "' can not be used";

    @Test
    public void findBpmnProcessIdsQueryTermsTest() {
        FindBpmn2ProcessIdsQuery query = new FindBpmn2ProcessIdsQuery();
        HashSet<ValueResourceIndexTerm> queryTerms = new HashSet<ValueResourceIndexTerm>();
        try {
            query.validateTerms(queryTerms);
            Assert.fail((String)"The required resources term is missing, but no exception was thrown.");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)("Incorrect error message: " + iae.getMessage()), (boolean)iae.getMessage().contains("Expected 'ValueResourceIndexTerm' term was not found."));
        }
        queryTerms = new HashSet();
        queryTerms.add(new ValueResourceIndexTerm("not-bpmn2-resources", ResourceType.JAVA));
        try {
            query.validateTerms(queryTerms);
            Assert.fail((String)"The required resources term is missing, but no exception was thrown.");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)("Incorrect error message: " + iae.getMessage()), (boolean)iae.getMessage().contains(ERROR_MSG));
        }
        queryTerms = new HashSet();
        queryTerms.add(new ValueResourceIndexTerm("*", ResourceType.BPMN2, ValueIndexTerm.TermSearchType.WILDCARD));
        try {
            query.validateTerms(queryTerms);
        }
        catch (IllegalArgumentException iae) {
            Assert.fail((String)"The activation term is acceptable here, but an exception was thrown.");
        }
    }
}

