/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.expressioneditor;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.designer.expressioneditor.model.Condition;
import org.jbpm.designer.expressioneditor.model.ConditionExpression;
import org.jbpm.designer.expressioneditor.parser.ExpressionScriptGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpressionScriptGeneratorTest {
    private ExpressionScriptGenerator generator = new ExpressionScriptGenerator();
    private ConditionExpression expression;
    private List<String> errors;
    private Condition condition;
    private List<String> parameters;

    @Before
    public void setUp() throws Exception {
        this.expression = new ConditionExpression();
        this.errors = new ArrayList<String>();
        this.expression.setOperator("AND");
        this.expression.setConditions(new ArrayList());
        this.condition = new Condition();
        this.parameters = new ArrayList<String>();
    }

    @Test
    public void testEqual() throws Exception {
        this.condition.setFunction("equalsTo");
        this.parameters.add("variable");
        this.parameters.add("value");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.equalsTo(variable, \"value\");", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testEqualEmptyValue() throws Exception {
        this.condition.setFunction("equalsTo");
        this.parameters.add("variable");
        this.parameters.add("");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertNull((Object)script);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Parameter can not be null nor empty", (Object)this.errors.get(0));
    }

    @Test
    public void testContains() throws Exception {
        this.condition.setFunction("contains");
        this.parameters.add("variable");
        this.parameters.add("value");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.contains(variable, \"value\");", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testContainsEmptyValue() throws Exception {
        this.condition.setFunction("contains");
        this.parameters.add("variable");
        this.parameters.add("");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertNull((Object)script);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Parameter can not be null nor empty", (Object)this.errors.get(0));
    }

    @Test
    public void testIsNull() throws Exception {
        this.condition.setFunction("isNull");
        this.parameters.add("variable");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.isNull(variable);", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testIsEmpty() throws Exception {
        this.condition.setFunction("isEmpty");
        this.parameters.add("variable");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.isEmpty(variable);", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testStartsWith() throws Exception {
        this.condition.setFunction("startsWith");
        this.parameters.add("variable");
        this.parameters.add("value");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.startsWith(variable, \"value\");", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testStartsWithEmptyValue() throws Exception {
        this.condition.setFunction("startsWith");
        this.parameters.add("variable");
        this.parameters.add("");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertNull((Object)script);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Parameter can not be null nor empty", (Object)this.errors.get(0));
    }

    @Test
    public void testEndsWith() throws Exception {
        this.condition.setFunction("endsWith");
        this.parameters.add("variable");
        this.parameters.add("value");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.endsWith(variable, \"value\");", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testEndsWithEmptyValue() throws Exception {
        this.condition.setFunction("endsWith");
        this.parameters.add("variable");
        this.parameters.add("");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertNull((Object)script);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Parameter can not be null nor empty", (Object)this.errors.get(0));
    }

    @Test
    public void testIsTrue() throws Exception {
        this.condition.setFunction("isTrue");
        this.parameters.add("variable");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.isTrue(variable);", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testIsFalse() throws Exception {
        this.condition.setFunction("isFalse");
        this.parameters.add("variable");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.isFalse(variable);", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testBetween() throws Exception {
        this.condition.setFunction("between");
        this.parameters.add("variable");
        this.parameters.add("value");
        this.parameters.add("secondValue");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.between(variable, \"value\", \"secondValue\");", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testBetweenEmptyValue() throws Exception {
        this.condition.setFunction("between");
        this.parameters.add("variable");
        this.parameters.add("");
        this.parameters.add("secondValue");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertNull((Object)script);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Parameter can not be null nor empty", (Object)this.errors.get(0));
    }

    @Test
    public void testBetweenEmptySecondValue() throws Exception {
        this.condition.setFunction("between");
        this.parameters.add("variable");
        this.parameters.add("value");
        this.parameters.add("");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertNull((Object)script);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Parameter can not be null nor empty", (Object)this.errors.get(0));
    }

    @Test
    public void testGreaterThan() throws Exception {
        this.condition.setFunction("greaterThan");
        this.parameters.add("variable");
        this.parameters.add("value");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.greaterThan(variable, \"value\");", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testGreaterThanEmptyValue() throws Exception {
        this.condition.setFunction("greaterThan");
        this.parameters.add("variable");
        this.parameters.add("");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertNull((Object)script);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Parameter can not be null nor empty", (Object)this.errors.get(0));
    }

    @Test
    public void testLessThan() throws Exception {
        this.condition.setFunction("lessThan");
        this.parameters.add("variable");
        this.parameters.add("value");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.lessThan(variable, \"value\");", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testLessThanEmptyValue() throws Exception {
        this.condition.setFunction("lessThan");
        this.parameters.add("variable");
        this.parameters.add("");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertNull((Object)script);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Parameter can not be null nor empty", (Object)this.errors.get(0));
    }

    @Test
    public void testGreaterOrEqualThan() throws Exception {
        this.condition.setFunction("greaterOrEqualThan");
        this.parameters.add("variable");
        this.parameters.add("value");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.greaterOrEqualThan(variable, \"value\");", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testGreaterOrEqualThanEmptyValue() throws Exception {
        this.condition.setFunction("greaterOrEqualThan");
        this.parameters.add("variable");
        this.parameters.add("");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertNull((Object)script);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Parameter can not be null nor empty", (Object)this.errors.get(0));
    }

    @Test
    public void testLessOrEqualThan() throws Exception {
        this.condition.setFunction("lessOrEqualThan");
        this.parameters.add("variable");
        this.parameters.add("value");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.lessOrEqualThan(variable, \"value\");", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testLessOrEqualThanEmptyValue() throws Exception {
        this.condition.setFunction("lessOrEqualThan");
        this.parameters.add("variable");
        this.parameters.add("");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertNull((Object)script);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Parameter can not be null nor empty", (Object)this.errors.get(0));
    }

    @Test
    public void testAnd() throws Exception {
        this.condition.setFunction("greaterThan");
        this.parameters.add("variable");
        this.parameters.add("value");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertEquals((Object)"return  KieFunctions.greaterThan(variable, \"value\") && KieFunctions.greaterThan(variable, \"value\");", (Object)script);
        Assert.assertEquals((long)0L, (long)this.errors.size());
    }

    @Test
    public void testInvalidFunction() throws Exception {
        this.condition.setFunction("invalidFunction");
        this.parameters.add("variable");
        this.parameters.add("value");
        this.condition.setParameters(this.parameters);
        this.expression.getConditions().add(this.condition);
        String script = this.generator.generateScript(this.expression, this.errors);
        Assert.assertNull((Object)script);
        Assert.assertEquals((long)1L, (long)this.errors.size());
        Assert.assertEquals((Object)"Invalid function: invalidFunction", (Object)this.errors.get(0));
    }
}

