/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server;

import bpsim.impl.BpsimFactoryImpl;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Process;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.drools.impl.DroolsFactoryImpl;
import org.jbpm.designer.server.BusinessProcessCopyHelper;
import org.jbpm.designer.type.Bpmn2TypeDefinition;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class BusinessProcessCopyHelperTest {
    @Mock
    private IOService ioService;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    private BusinessProcessCopyHelper helper;
    private Bpmn2TypeDefinition bpmn2ResourceType = new Bpmn2TypeDefinition();
    private org.uberfire.backend.vfs.Path pathSource;
    private org.uberfire.backend.vfs.Path pathDestination;
    public static final String DEFAULT_PROCESS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<bpmn2:definitions xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.omg.org/bpmn20\" xmlns:bpmn2=\"http://www.omg.org/spec/BPMN/20100524/MODEL\" xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\" xmlns:bpsim=\"http://www.bpsim.org/schemas/1.0\" xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\" xmlns:drools=\"http://www.jboss.org/drools\" \nid=\"Definition\" xsi:schemaLocation=\"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd http://www.jboss.org/drools drools.xsd http://www.bpsim.org/schemas/1.0 bpsim.xsd\" expressionLanguage=\"http://www.mvel.org/2.0\" targetNamespace=\"http://www.omg.org/bpmn20\" typeLanguage=\"http://www.java.com/javaTypes\"> \n   <bpmn2:process id=\"testdir.myprocess\" drools:packageName=\"org.jbpm\" drools:version=\"1.0\" name=\"\" isExecutable=\"true\"> \n      <bpmn2:startEvent id=\"processStartEvent\" drools:bgcolor=\"#9acd32\" drools:selectable=\"true\" name=\"\"/> \n   </bpmn2:process> \n   <bpmndi:BPMNDiagram> \n      <bpmndi:BPMNPlane bpmnElement=\"testdir.myprocess\"> \n         <bpmndi:BPMNShape bpmnElement=\"processStartEvent\"> \n            <dc:Bounds height=\"30.0\" width=\"30.0\" x=\"120.0\" y=\"165.0\"/> \n         </bpmndi:BPMNShape> \n      </bpmndi:BPMNPlane> \n   </bpmndi:BPMNDiagram> \n</bpmn2:definitions>";

    @Before
    public void setup() {
        this.pathSource = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        this.pathDestination = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        this.helper = new BusinessProcessCopyHelper(this.ioService, this.bpmn2ResourceType, this.commentedOptionFactory);
    }

    @Test
    public void testCopy() {
        Mockito.when((Object)this.pathSource.toURI()).thenReturn((Object)"file://p0/Evaluation/src/main/resources/MyProcess.bpmn2");
        Mockito.when((Object)this.pathDestination.toURI()).thenReturn((Object)"file://p0/Evaluation/src/main/resources/MyNewProcess.bpmn2");
        Mockito.when((Object)this.pathDestination.getFileName()).thenReturn((Object)"MyNewProcess.bpmn2");
        Mockito.when((Object)this.ioService.readAllString((Path)Matchers.any(Path.class))).thenReturn((Object)DEFAULT_PROCESS);
        this.helper.postProcess(this.pathSource, this.pathDestination);
        ArgumentCaptor bpmn2ArgumentCaptor = ArgumentCaptor.forClass(String.class);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Matchers.any(Path.class), (String)bpmn2ArgumentCaptor.capture(), new OpenOption[]{(OpenOption)Matchers.any(CommentedOption.class)});
        String newBPMN2 = (String)bpmn2ArgumentCaptor.getValue();
        Assert.assertNotNull((Object)newBPMN2);
        Assert.assertTrue((newBPMN2.indexOf("schemaLocation") >= 0 ? 1 : 0) != 0);
        DroolsFactoryImpl.init();
        BpsimFactoryImpl.init();
        try {
            Definitions def = new JbpmProfileImpl().getDefinitions(newBPMN2);
            Process process = this.helper.getRootProcess(def);
            Assert.assertNotNull((Object)process);
            Assert.assertNotNull((Object)process.getId());
            Assert.assertThat((Object)process.getId(), (Matcher)CoreMatchers.containsString((String)"MyNewProcess"));
        }
        catch (Exception e) {
            Assert.fail((String)("Cannot parse new process: " + e.getMessage()));
        }
    }

    @Test
    public void testCopyIDWithMultibyteCharsAndSpaces() {
        Mockito.when((Object)this.pathSource.toURI()).thenReturn((Object)"file://p0/Evaluation/src/main/resources/MyProcess.bpmn2");
        Mockito.when((Object)this.pathDestination.toURI()).thenReturn((Object)"file://p0/Evaluation/src/main/resources/MyNewProcess.bpmn2");
        Mockito.when((Object)this.pathDestination.getFileName()).thenReturn((Object)"\u042d\u043e\u0436 \u0442\u044b \u0434\u043e\u043b\u044c\u043e\u0440\u044d     My New Process  \uc5b4\ub514\uc57c.bpmn2");
        Mockito.when((Object)this.ioService.readAllString((Path)Matchers.any(Path.class))).thenReturn((Object)DEFAULT_PROCESS);
        this.helper.postProcess(this.pathSource, this.pathDestination);
        ArgumentCaptor bpmn2ArgumentCaptor = ArgumentCaptor.forClass(String.class);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Matchers.any(Path.class), (String)bpmn2ArgumentCaptor.capture(), new OpenOption[]{(OpenOption)Matchers.any(CommentedOption.class)});
        String newBPMN2 = (String)bpmn2ArgumentCaptor.getValue();
        Assert.assertNotNull((Object)newBPMN2);
        Assert.assertTrue((newBPMN2.indexOf("schemaLocation") >= 0 ? 1 : 0) != 0);
        DroolsFactoryImpl.init();
        BpsimFactoryImpl.init();
        try {
            Definitions def = new JbpmProfileImpl().getDefinitions(newBPMN2);
            Process process = this.helper.getRootProcess(def);
            Assert.assertNotNull((Object)process);
            Assert.assertNotNull((Object)process.getId());
            Assert.assertThat((Object)process.getId(), (Matcher)CoreMatchers.containsString((String)"MyNewProcessEC96B4EB9494EC95BC"));
        }
        catch (Exception e) {
            Assert.fail((String)("Cannot parse new process: " + e.getMessage()));
        }
    }

    @Test
    public void testCopyIDWithInvalidID() {
        Mockito.when((Object)this.pathSource.toURI()).thenReturn((Object)"file://p0/Evaluation/src/main/resources/MyProcess.bpmn2");
        Mockito.when((Object)this.pathDestination.toURI()).thenReturn((Object)"file://p0/Evaluation/src/main/resources/MyNewProcess.bpmn2");
        Mockito.when((Object)this.pathDestination.getFileName()).thenReturn((Object)"  << my process    >>");
        Mockito.when((Object)this.ioService.readAllString((Path)Matchers.any(Path.class))).thenReturn((Object)DEFAULT_PROCESS);
        this.helper.postProcess(this.pathSource, this.pathDestination);
        ArgumentCaptor bpmn2ArgumentCaptor = ArgumentCaptor.forClass(String.class);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Matchers.any(Path.class), (String)bpmn2ArgumentCaptor.capture(), new OpenOption[]{(OpenOption)Matchers.any(CommentedOption.class)});
        String newBPMN2 = (String)bpmn2ArgumentCaptor.getValue();
        Assert.assertNotNull((Object)newBPMN2);
        Assert.assertTrue((newBPMN2.indexOf("schemaLocation") >= 0 ? 1 : 0) != 0);
        DroolsFactoryImpl.init();
        BpsimFactoryImpl.init();
        try {
            Definitions def = new JbpmProfileImpl().getDefinitions(newBPMN2);
            Process process = this.helper.getRootProcess(def);
            Assert.assertNotNull((Object)process);
            Assert.assertNotNull((Object)process.getId());
            Assert.assertThat((Object)process.getId(), (Matcher)CoreMatchers.containsString((String)"3C3Cmyprocess"));
        }
        catch (Exception e) {
            Assert.fail((String)("Cannot parse new process: " + e.getMessage()));
        }
    }
}

