/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.jbpm.designer.helper.TestHttpServletRequest;
import org.jbpm.designer.helper.TestHttpServletResponse;
import org.jbpm.designer.repository.UriUtils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.impl.JbpmProfileImpl;
import org.jbpm.designer.web.server.ProcessInfoServlet;
import org.junit.Assert;
import org.junit.Test;

public class ProcessInfoServletTest {
    @Test
    public void testDefaultGatewayConnection() throws Exception {
        ProcessInfoServlet processInfoServlet = new ProcessInfoServlet();
        processInfoServlet.setProfile((IDiagramProfile)new JbpmProfileImpl());
        String rawJson = this.readFile("defaultgateforgateway.json");
        String encodedJson = Base64.encodeBase64String((byte[])UriUtils.encode((String)rawJson.toString()).getBytes("UTF-8"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("json", encodedJson);
        params.put("profile", "jbpm");
        params.put("ppdata", "Email,Log,Rest,WebService");
        params.put("gatewayid", "_FD098FB2-3615-4C26-A5F6-06D4B453E234");
        TestHttpServletResponse response = new TestHttpServletResponse();
        processInfoServlet.doPost((HttpServletRequest)new TestHttpServletRequest(params), (HttpServletResponse)response);
        int responseStatus = response.getStatus();
        Assert.assertEquals((long)0L, (long)responseStatus);
        String responseText = new String(response.getContent());
        Assert.assertNotNull((Object)responseText);
        Assert.assertTrue((boolean)responseText.contains("_460FCE64-6E4C-4BB6-8E1F-8817D01CA8C5"));
        Assert.assertTrue((boolean)responseText.contains("_385AB844-FFE1-4DCA-9A59-E15CC280F288"));
    }

    private String readFile(String fileName) throws Exception {
        URL fileURL = ProcessInfoServletTest.class.getResource(fileName);
        return FileUtils.readFileToString((File)new File(fileURL.toURI()));
    }
}

