/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server.menu.connector;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.repository.RepositoryBaseTest;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.server.menu.connector.AbstractConnectorServlet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractConnectorServletTest
extends RepositoryBaseTest {
    @Mock
    IDiagramProfileService profileService;
    @Spy
    @InjectMocks
    private AbstractConnectorServlet servlet = new AbstractConnectorServlet(){

        protected void initializeDefaultRepo(IDiagramProfile profile, Repository repository, HttpServletRequest request) throws Exception {
        }
    };
    private static final String FILE_NAME = "src/test/resources/designer.configuration";
    private static final String FILE_CONTENT = "application.context=/";

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.profileService.findProfile((HttpServletRequest)Matchers.any(HttpServletRequest.class), Matchers.anyString())).thenReturn((Object)this.profile);
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
    }

    @Test
    public void testGetBytesFromFileNullParameter() throws IOException {
        byte[] result = AbstractConnectorServlet.getBytesFromFile(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetBytesFromFile() throws IOException {
        byte[] result = AbstractConnectorServlet.getBytesFromFile((File)new File(FILE_NAME));
        Assert.assertEquals((Object)FILE_CONTENT, (Object)new String(result));
    }

    @Test
    public void testDoPostFindProfile() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        try {
            this.servlet.doPost(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((IDiagramProfileService)Mockito.verify((Object)this.profileService, (VerificationMode)Mockito.times((int)1))).findProfile(request, "jbpm");
    }

    @Test
    public void testDoPostProfileAlreadySet() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.servlet.profile = this.profile;
        try {
            this.servlet.doPost(request, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((IDiagramProfileService)Mockito.verify((Object)this.profileService, (VerificationMode)Mockito.never())).findProfile((HttpServletRequest)Matchers.any(HttpServletRequest.class), Matchers.anyString());
    }
}

