/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.expressioneditor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import junit.framework.Assert;
import org.jbpm.designer.expressioneditor.ExpressionEditorMessageMarshallingTest;
import org.jbpm.designer.expressioneditor.model.Condition;
import org.jbpm.designer.expressioneditor.model.ConditionExpression;
import org.jbpm.designer.expressioneditor.parser.ExpressionParser;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionParserTest {
    Logger logger = LoggerFactory.getLogger(ExpressionParserTest.class);
    private ConditionExpression expectedExpression;
    private Condition expectedCondition;

    @Before
    public void setUp() throws Exception {
        this.expectedExpression = new ConditionExpression("AND");
        this.expectedCondition = new Condition();
        this.expectedCondition.addParam("variable");
        this.expectedCondition.addParam("value");
        this.expectedExpression.getConditions().add(this.expectedCondition);
    }

    @Test
    public void testOneScriptPerLine() throws Exception {
        LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(ExpressionEditorMessageMarshallingTest.class.getResourceAsStream("OneScriptPerLine.txt")));
        String line = null;
        ArrayList<ConditionExpression> expectedExpressions = new ArrayList<ConditionExpression>();
        ConditionExpression expression = new ConditionExpression("AND");
        Condition condition = new Condition("between");
        condition.addParam("a");
        condition.addParam("o\"ne");
        condition.addParam("two");
        expression.getConditions().add(condition);
        expectedExpressions.add(expression);
        expression = new ConditionExpression("AND");
        condition = new Condition("isNull");
        condition.addParam("variable1");
        expression.getConditions().add(condition);
        expectedExpressions.add(expression);
        expression = new ConditionExpression("AND");
        condition = new Condition("greaterThan");
        condition.addParam("variable2");
        condition.addParam(" the value ");
        expression.getConditions().add(condition);
        expectedExpressions.add(expression);
        expression = new ConditionExpression("AND");
        condition = new Condition("isNull");
        condition.addParam("a");
        expression.getConditions().add(condition);
        expectedExpressions.add(expression);
        expression = new ConditionExpression("AND");
        condition = new Condition("greaterOrEqualThan");
        condition.addParam("v");
        condition.addParam("one");
        expression.getConditions().add(condition);
        expectedExpressions.add(expression);
        while ((line = lineReader.readLine()) != null) {
            this.logger.debug("line(" + lineReader.getLineNumber() + "): " + line);
            ExpressionParser parser = new ExpressionParser(line);
            ConditionExpression conditionExpression = parser.parse();
            this.assertEqualsExpression((ConditionExpression)expectedExpressions.get(lineReader.getLineNumber() - 1), conditionExpression);
        }
    }

    private String readFile(String fileName) throws IOException {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(ExpressionEditorMessageMarshallingTest.class.getResourceAsStream(fileName)));
        StringBuilder result = new StringBuilder();
        String line = null;
        while ((line = ((BufferedReader)reader).readLine()) != null) {
            result.append(line);
            result.append("\n");
        }
        return result.toString();
    }

    @Test
    public void testScript1() throws Exception {
        String script = this.readFile("Script1.txt");
        ConditionExpression expectedExpression = new ConditionExpression("AND");
        Condition expectedCondition = new Condition("greaterOrEqualThan");
        expectedCondition.addParam("variable");
        expectedCondition.addParam("o\\n\u00e1\u00e9\u00f6 great! \"\n   \u00e1\u00e9\u00ed\u00f3\u00fa\u00f1\u00d1 @|#~!\u00b7$%&/()=?\u00bf");
        expectedExpression.getConditions().add(expectedCondition);
        ExpressionParser parser = new ExpressionParser(script);
        ConditionExpression actualExpression = parser.parse();
        this.logger.debug(actualExpression.getOperator());
        for (Condition condition : actualExpression.getConditions()) {
            this.logger.debug("condition: " + condition.getFunction());
            for (String param : condition.getParameters()) {
                this.logger.debug("\"" + param + "\"");
            }
        }
        this.assertEqualsExpression(expectedExpression, actualExpression);
    }

    @Test
    public void testBetween() throws Exception {
        String script = this.readFile("between.txt");
        this.expectedCondition.setFunction("between");
        this.expectedCondition.addParam("secondValue");
        ExpressionParser parser = new ExpressionParser(script);
        ConditionExpression actualExpression = parser.parse();
        this.assertEqualsExpression(this.expectedExpression, actualExpression);
    }

    @Test
    public void testEqualsTo() throws Exception {
        String script = this.readFile("equalsTo.txt");
        ExpressionParser parser = new ExpressionParser(script);
        ConditionExpression actualExpression = parser.parse();
        this.expectedCondition.setFunction("equalsTo");
        this.assertEqualsExpression(this.expectedExpression, actualExpression);
    }

    @Test
    public void testGreaterThan() throws Exception {
        String script = this.readFile("greaterThan.txt");
        ExpressionParser parser = new ExpressionParser(script);
        ConditionExpression actualExpression = parser.parse();
        this.expectedCondition.setFunction("greaterThan");
        this.assertEqualsExpression(this.expectedExpression, actualExpression);
    }

    @Test
    public void testLessThan() throws Exception {
        String script = this.readFile("lessThan.txt");
        ExpressionParser parser = new ExpressionParser(script);
        ConditionExpression actualExpression = parser.parse();
        this.expectedCondition.setFunction("lessThan");
        this.assertEqualsExpression(this.expectedExpression, actualExpression);
    }

    @Test
    public void testIsNull() throws Exception {
        String script = this.readFile("isNull.txt");
        ExpressionParser parser = new ExpressionParser(script);
        ConditionExpression actualExpression = parser.parse();
        this.expectedCondition.setFunction("isNull");
        this.expectedCondition.getParameters().remove(1);
        this.assertEqualsExpression(this.expectedExpression, actualExpression);
    }

    @Test
    public void testMissingBracket() throws Exception {
        String script = this.readFile("missingBracket.txt");
        ExpressionParser parser = new ExpressionParser(script);
        boolean exceptionCaught = false;
        try {
            parser.parse();
        }
        catch (ParseException e) {
            Assert.assertEquals((String)e.getMessage(), (String)MessageFormat.format("Function call \"{0}\" is not closed properly, character \")\" is expected.", "between"));
            exceptionCaught = true;
        }
        Assert.assertTrue((boolean)exceptionCaught);
    }

    @Test
    public void testMissingReturn() throws Exception {
        String script = this.readFile("missingReturn.txt");
        ExpressionParser parser = new ExpressionParser(script);
        boolean exceptionCaught = false;
        try {
            parser.parse();
        }
        catch (ParseException e) {
            Assert.assertEquals((String)e.getMessage(), (String)MessageFormat.format("Sentence \"{0}\" is expected.", "return"));
            exceptionCaught = true;
        }
        Assert.assertTrue((boolean)exceptionCaught);
    }

    @Test
    public void testMissingDelimiter() throws Exception {
        String script = this.readFile("missingDelimiter.txt");
        ExpressionParser parser = new ExpressionParser(script);
        boolean exceptionCaught = false;
        try {
            parser.parse();
        }
        catch (ParseException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Parameter delimiter \",\" is expected.");
            exceptionCaught = true;
        }
        Assert.assertTrue((boolean)exceptionCaught);
    }

    @Test
    public void testStringExpected() throws Exception {
        String script = this.readFile("stringExpected.txt");
        ExpressionParser parser = new ExpressionParser(script);
        boolean exceptionCaught = false;
        try {
            parser.parse();
        }
        catch (ParseException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"String parameter value like \"some value\" is expected.");
            exceptionCaught = true;
        }
        Assert.assertTrue((boolean)exceptionCaught);
    }

    @Test
    public void testUnknownFunction() throws Exception {
        String script = this.readFile("unknownFunction.txt");
        ExpressionParser parser = new ExpressionParser(script);
        boolean exceptionCaught = false;
        try {
            parser.parse();
        }
        catch (ParseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("must be followed"));
            exceptionCaught = true;
        }
        Assert.assertTrue((boolean)exceptionCaught);
    }

    @Test
    public void testMissingVariable() throws Exception {
        String script = this.readFile("missingVariable.txt");
        ExpressionParser parser = new ExpressionParser(script);
        boolean exceptionCaught = false;
        try {
            parser.parse();
        }
        catch (ParseException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Variable name not found, a valid process variable name is expected.");
            exceptionCaught = true;
        }
        Assert.assertTrue((boolean)exceptionCaught);
    }

    @Test
    @Ignore
    public void testAnd() throws Exception {
        String script = this.readFile("and.txt");
        ExpressionParser parser = new ExpressionParser(script);
        ConditionExpression actualExpression = parser.parse();
        this.expectedCondition.setFunction("equalsTo");
        this.expectedExpression.getConditions().add(this.expectedCondition);
        this.assertEqualsExpression(this.expectedExpression, actualExpression);
    }

    public void assertEqualsExpression(ConditionExpression expected, ConditionExpression actual) {
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((String)expected.getOperator(), (String)actual.getOperator());
        Assert.assertEquals((int)expected.getConditions().size(), (int)actual.getConditions().size());
        for (int i = 0; i < expected.getConditions().size(); ++i) {
            this.assertEqualsCondition((Condition)expected.getConditions().get(i), (Condition)actual.getConditions().get(i));
        }
    }

    public void assertEqualsCondition(Condition expected, Condition actual) {
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((String)expected.getFunction(), (String)actual.getFunction());
        Assert.assertEquals((int)expected.getParameters().size(), (int)actual.getParameters().size());
        for (int i = 0; i < expected.getParameters().size(); ++i) {
            Assert.assertEquals((String)((String)expected.getParameters().get(i)), (String)((String)actual.getParameters().get(i)));
        }
    }
}

