/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository;

import java.util.HashSet;
import java.util.Set;
import org.jbpm.designer.repository.Asset;
import org.jbpm.designer.repository.impl.AssetBuilder;
import org.jbpm.designer.repository.impl.BinaryAsset;
import org.jbpm.designer.repository.impl.TextAsset;

public class AssetBuilderFactory {
    private static Set<String> binaryFormats = new HashSet<String>();

    public static AssetBuilder getAssetBuilder(Asset.AssetType type) {
        if (type == Asset.AssetType.Text) {
            return new AssetBuilder(new TextAsset());
        }
        if (type == Asset.AssetType.Byte) {
            return new AssetBuilder(new BinaryAsset());
        }
        throw new IllegalArgumentException("Unknown asset type " + (Object)((Object)type));
    }

    public static AssetBuilder getAssetBuilder(String fileName) {
        String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
        String nameOnly = fileName.substring(0, fileName.lastIndexOf("."));
        if (binaryFormats.contains(extension)) {
            return AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte).type(extension).name(nameOnly);
        }
        return AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Text).type(extension).name(nameOnly);
    }

    public static AssetBuilder getAssetBuilder(Asset asset) {
        AssetBuilder builder = null;
        builder = binaryFormats.contains(asset.getAssetType()) ? AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Byte) : AssetBuilderFactory.getAssetBuilder(Asset.AssetType.Text);
        builder.type(asset.getAssetType()).name(asset.getName()).version(asset.getVersion()).location(asset.getAssetLocation()).uniqueId(asset.getUniqueId()).creationDate(asset.getCreationDate()).lastModificationDate(asset.getLastModificationDate()).description(asset.getDescription()).owner(asset.getOwner());
        return builder;
    }

    static {
        binaryFormats.add("png");
        binaryFormats.add("gif");
        binaryFormats.add("jpeg");
        binaryFormats.add("jpg");
        binaryFormats.add("pdf");
        binaryFormats.add("binary");
    }
}

