/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.plugin.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.designer.web.plugin.IDiagramPlugin;
import org.jbpm.designer.web.plugin.IDiagramPluginService;
import org.jbpm.designer.web.plugin.impl.PluginServiceImpl;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(displayName="Plugin Service Servlet", name="PluginServiceServlet", urlPatterns={"/plugins", "/plugin", "/plugin/*"}, initParams={@WebInitParam(name="factoryName", value="jbpm")})
public class PluginServiceServlet
extends HttpServlet {
    private static final Logger _logger = LoggerFactory.getLogger(PluginServiceServlet.class);
    private static final long serialVersionUID = -2024110864538877629L;
    private IDiagramPluginService _pluginService;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._pluginService = PluginServiceImpl.getInstance(config.getServletContext());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if ("/plugins".equals(req.getServletPath())) {
                this.listAllPlugins(req, resp);
            } else {
                this.retrievePluginContents(req, resp);
            }
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrievePluginContents(HttpServletRequest req, HttpServletResponse resp) {
        String name = req.getParameter("name");
        if (name == null && (name = req.getRequestURI().substring(req.getRequestURI().lastIndexOf("/") + 1)).endsWith(".js")) {
            name = name.substring(0, name.length() - ".js".length());
        }
        if (name == null) {
            throw new IllegalArgumentException("No name provided");
        }
        IDiagramPlugin plugin = this._pluginService.findPlugin(req, name);
        if (plugin == null) {
            throw new IllegalArgumentException("No plugin by the name of " + name);
        }
        InputStream input = plugin.getContents();
        if (input == null) {
            throw new IllegalArgumentException("Plugin contents could not be found");
        }
        try {
            int read;
            byte[] buffer = new byte[4096];
            while ((read = input.read(buffer)) != -1) {
                resp.getOutputStream().write(buffer, 0, read);
            }
            resp.setContentType("application/x-javascript");
        }
        catch (IOException e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void listAllPlugins(HttpServletRequest req, HttpServletResponse resp) throws IOException, JSONException {
        JSONArray plugins = new JSONArray();
        for (IDiagramPlugin p : this._pluginService.getRegisteredPlugins(req)) {
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)p.getName());
            obj.put("core", p.isCore());
            JSONArray properties = new JSONArray();
            if (p.getProperties() != null) {
                for (Map.Entry<String, Object> entry : p.getProperties().entrySet()) {
                    JSONObject propObj = new JSONObject();
                    propObj.put(entry.getKey(), entry.getValue());
                    properties.put((Object)propObj);
                }
            }
            obj.put("properties", (Object)properties);
            plugins.put((Object)obj);
        }
        resp.setContentType("application/json");
        resp.getWriter().append(plugins.toString());
    }
}

