/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.jbpm.designer.notification.DesignerWorkitemInstalledEvent;
import org.jbpm.designer.repository.Repository;
import org.jbpm.designer.util.ConfigurationProvider;
import org.jbpm.designer.util.Utils;
import org.jbpm.designer.web.profile.IDiagramProfile;
import org.jbpm.designer.web.profile.IDiagramProfileService;
import org.jbpm.designer.web.server.ServiceRepoUtils;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.jbpm.process.workitem.WorkItemRepository;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.workbench.events.NotificationEvent;

@WebServlet(displayName="JbpmServiceRepository", name="JbpmServiceRepositoryServlet", urlPatterns={"/jbpmservicerepo"})
public class JbpmServiceRepositoryServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = LoggerFactory.getLogger(JbpmServiceRepositoryServlet.class);
    private static final String displayRepoContent = "display";
    private static final String installRepoContent = "install";
    private IDiagramProfile profile;
    @Inject
    private IDiagramProfileService _profileService = null;
    @Inject
    private Event<DesignerWorkitemInstalledEvent> workitemInstalledEventEvent;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private VFSService vfsServices;
    @Inject
    private POMService pomService;
    @Inject
    private ProjectService<? extends Project> projectService;
    @Inject
    private MetadataService metadataService;

    public void setProfile(IDiagramProfile profile) {
        this.profile = profile;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map workitemsFromRepo;
        Repository repository;
        String categoryToInstall;
        String assetsToInstall;
        String uuid;
        block29: {
            Object key;
            Iterator iterator;
            HashMap retMap;
            String repoURL;
            block27: {
                uuid = Utils.getUUID(req);
                String profileName = Utils.getDefaultProfileName(req.getParameter("profile"));
                String action = req.getParameter("action");
                assetsToInstall = req.getParameter("asset");
                categoryToInstall = req.getParameter("category");
                repoURL = req.getParameter("repourl");
                if (repoURL == null || repoURL.length() < 1) {
                    resp.setCharacterEncoding("UTF-8");
                    resp.setContentType("application/json");
                    resp.getWriter().write("false");
                    return;
                }
                try {
                    URL url = new URL(repoURL);
                    if (!repoURL.startsWith("file:")) {
                        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                        conn.setReadTimeout(5000);
                        conn.setConnectTimeout(5000);
                        conn.connect();
                        if (conn.getResponseCode() != 200) {
                            resp.setCharacterEncoding("UTF-8");
                            resp.setContentType("application/json");
                            resp.getWriter().write("false");
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    resp.setCharacterEncoding("UTF-8");
                    resp.setContentType("application/json");
                    resp.getWriter().write("false||" + e.getMessage());
                    return;
                }
                if (repoURL.endsWith("/")) {
                    repoURL = repoURL.substring(0, repoURL.length() - 1);
                }
                if (this.profile == null) {
                    this.profile = this._profileService.findProfile(req, profileName);
                }
                repository = this.profile.getRepository();
                workitemsFromRepo = WorkItemRepository.getWorkDefinitions((String)repoURL);
                if (action != null && action.equalsIgnoreCase(displayRepoContent)) {
                    if (workitemsFromRepo != null && workitemsFromRepo.size() > 0) {
                        retMap = new HashMap();
                        iterator = workitemsFromRepo.keySet().iterator();
                        break block27;
                    } else {
                        resp.setCharacterEncoding("UTF-8");
                        resp.setContentType("application/json");
                        resp.getWriter().write("false");
                        return;
                    }
                }
                if (action == null) return;
                if (!action.equalsIgnoreCase(installRepoContent)) return;
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("application/json");
                if (workitemsFromRepo == null || workitemsFromRepo.size() <= 0) {
                    _logger.error("Invalid or empty service repository.");
                    resp.setCharacterEncoding("UTF-8");
                    resp.setContentType("application/json");
                    resp.getWriter().write("false");
                    return;
                }
                break block29;
            }
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                WorkDefinitionImpl workDefinitionImpl = (WorkDefinitionImpl)workitemsFromRepo.get(key);
                ArrayList<String> keyList = new ArrayList<String>();
                keyList.add(workDefinitionImpl.getName() == null ? "" : workDefinitionImpl.getName());
                keyList.add(workDefinitionImpl.getDisplayName() == null ? "" : workDefinitionImpl.getDisplayName());
                if (workDefinitionImpl.getIcon() != null && workDefinitionImpl.getIcon().trim().length() > 0) {
                    if (repoURL.startsWith("file:")) {
                        keyList.add(this.getFileIconEncoded(repoURL + "/" + workDefinitionImpl.getName() + "/" + workDefinitionImpl.getIcon()));
                    } else {
                        keyList.add(repoURL + "/" + workDefinitionImpl.getName() + "/" + workDefinitionImpl.getIcon());
                    }
                } else {
                    _logger.warn("No icon specified. Showing default");
                    keyList.add(this.getFileIconEncoded(""));
                }
                keyList.add(workDefinitionImpl.getCategory() == null ? "" : workDefinitionImpl.getCategory());
                keyList.add(workDefinitionImpl.getExplanationText() == null ? "" : workDefinitionImpl.getExplanationText());
                keyList.add(repoURL + "/" + workDefinitionImpl.getName() + "/" + workDefinitionImpl.getDocumentation());
                StringBuffer bn = new StringBuffer();
                if (workDefinitionImpl.getParameterNames() != null) {
                    String delim = "";
                    for (String name : workDefinitionImpl.getParameterNames()) {
                        bn.append(delim).append(name);
                        delim = ",";
                    }
                }
                keyList.add(bn.toString());
                StringBuffer br = new StringBuffer();
                if (workDefinitionImpl.getResultNames() != null) {
                    String delim = "";
                    for (String resName : workDefinitionImpl.getResultNames()) {
                        br.append(delim).append(resName);
                        delim = ",";
                    }
                }
                keyList.add(br.toString());
                keyList.add(workDefinitionImpl.getDefaultHandler() == null ? "" : workDefinitionImpl.getDefaultHandler());
                retMap.put(key, keyList);
            }
            JSONObject jsonObject = new JSONObject();
            key = retMap.entrySet().iterator();
            while (true) {
                if (!key.hasNext()) {
                    resp.setCharacterEncoding("UTF-8");
                    resp.setContentType("application/json");
                    resp.getWriter().write(jsonObject.toString());
                    return;
                }
                Map.Entry entry = (Map.Entry)key.next();
                try {
                    if (entry == null || entry.getKey() == null) continue;
                    jsonObject.put((String)entry.getKey(), (Collection)entry.getValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Iterator iterator = workitemsFromRepo.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key == null || !key.equals(assetsToInstall) || !categoryToInstall.equals(((WorkDefinitionImpl)workitemsFromRepo.get(key)).getCategory())) continue;
            try {
                ServiceRepoUtils.installWorkItem(workitemsFromRepo, key, uuid, repository, this.vfsServices, this.workitemInstalledEventEvent, this.notification, this.pomService, this.projectService, this.metadataService);
            }
            catch (FileAlreadyExistsException e) {
                _logger.warn("Workitem already installed.");
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("application/json");
                resp.getWriter().write("alreadyinstalled");
                return;
            }
        }
    }

    private String getFileIconEncoded(String fileIconPath) {
        try {
            return DatatypeConverter.printBase64Binary((byte[])IOUtils.toByteArray((InputStream)new FileInputStream(new File(fileIconPath.substring(5)))));
        }
        catch (Exception e) {
            try {
                String defaultServiceNodeIcon = this.getServletContext().getRealPath(ConfigurationProvider.getInstance().getDesignerContext() + "/defaults/defaultservicenodeicon.png");
                return DatatypeConverter.printBase64Binary((byte[])IOUtils.toByteArray((InputStream)new FileInputStream(new File(defaultServiceNodeIcon))));
            }
            catch (Exception ee) {
                _logger.error("Unable to load workitem icon: " + ee.getMessage());
                return "";
            }
        }
    }
}

