/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.query;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.lucene.search.Query;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.AbstractFindQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueBranchNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueModuleNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringStringPageRow;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.paging.PageResponse;

@ApplicationScoped
public class DesignerFindRuleFlowNamesQuery
extends AbstractFindQuery
implements NamedQuery {
    public static final String NAME = DesignerFindRuleFlowNamesQuery.class.getSimpleName();
    private static final Logger logger = LoggerFactory.getLogger(DesignerFindRuleFlowNamesQuery.class);
    private static final ValueSharedPartIndexTerm ruleFlowTerm = new ValueSharedPartIndexTerm("not-used", PartType.RULEFLOW_GROUP);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    private RuleFlowNamesResponseBuilder responseBuilder = new RuleFlowNamesResponseBuilder();

    public String getName() {
        return NAME;
    }

    public ResponseBuilder getResponseBuilder() {
        this.responseBuilder.setIOService(this.ioService);
        return this.responseBuilder;
    }

    public Query toQuery(Set<ValueIndexTerm> terms) {
        return this.buildFromSingleTerm(terms);
    }

    public void validateTerms(Set<ValueIndexTerm> queryTerms) throws IllegalArgumentException {
        this.checkNotNullAndNotEmpty(queryTerms);
        this.checkInvalidAndRequiredTerms(queryTerms, NAME, new String[]{null, null, ruleFlowTerm.getTerm()}, new Predicate[]{t -> t instanceof ValueModuleNameIndexTerm, t -> t instanceof ValueBranchNameIndexTerm, t -> t.getTerm().equals(ruleFlowTerm.getTerm())});
    }

    private static class RuleFlowNamesResponseBuilder
    implements ResponseBuilder {
        private IOService ioService;

        private RuleFlowNamesResponseBuilder() {
        }

        public void setIOService(IOService ioService) {
            this.ioService = ioService;
        }

        public PageResponse<RefactoringPageRow> buildResponse(int pageSize, int startRow, List<KObject> kObjects) {
            int hits = kObjects.size();
            PageResponse response = new PageResponse();
            List<RefactoringPageRow> result = this.buildResponse(kObjects);
            response.setTotalRowSize(hits);
            response.setPageRowList(result);
            response.setTotalRowSizeExact(true);
            response.setStartRowIndex(startRow);
            response.setLastPage(pageSize * startRow + 2 >= hits);
            return response;
        }

        public List<RefactoringPageRow> buildResponse(List<KObject> kObjects) {
            ArrayList<RefactoringPageRow> result = new ArrayList<RefactoringPageRow>(kObjects.size());
            HashMap<String, List<String>> uniqueRuleFlowNames = new HashMap<String, List<String>>();
            for (KObject kObject : kObjects) {
                Map<String, List<String>> ruleFlowGroupNames = this.getRuleFlowGroupNamesNamesFromKObject(kObject);
                for (String string : ruleFlowGroupNames.keySet()) {
                    if (uniqueRuleFlowNames.containsKey(string)) {
                        List<String> rvalList = ruleFlowGroupNames.get(string);
                        for (String rvalKey : rvalList) {
                            ((List)uniqueRuleFlowNames.get(string)).add(rvalKey);
                        }
                        continue;
                    }
                    uniqueRuleFlowNames.put(string, ruleFlowGroupNames.get(string));
                }
            }
            for (String uniqueKey : uniqueRuleFlowNames.keySet()) {
                List uniqueValueList = (List)uniqueRuleFlowNames.get(uniqueKey);
                String fstr = "";
                for (String val : uniqueValueList) {
                    fstr = fstr + val + "<<";
                }
                fstr = fstr.substring(0, fstr.length() - 2);
                RefactoringStringPageRow refactoringStringPageRow = new RefactoringStringPageRow();
                refactoringStringPageRow.setValue((Object)(uniqueKey + "||" + fstr));
                result.add((RefactoringPageRow)refactoringStringPageRow);
            }
            return result;
        }

        private Map<String, List<String>> getRuleFlowGroupNamesNamesFromKObject(KObject kObject) {
            HashMap<String, List<String>> ruleFlowGroupNames = new HashMap<String, List<String>>();
            if (kObject == null) {
                return ruleFlowGroupNames;
            }
            for (KProperty property : kObject.getProperties()) {
                org.uberfire.backend.vfs.Path path;
                if (!property.getName().equals("shared:" + PartType.RULEFLOW_GROUP.toString())) continue;
                if (ruleFlowGroupNames.containsKey(property.getValue().toString())) {
                    path = Paths.convert((Path)this.ioService.get(URI.create(kObject.getKey())));
                    ((List)ruleFlowGroupNames.get(property.getValue().toString())).add(path.getFileName() + "^^" + path.toURI());
                    continue;
                }
                path = Paths.convert((Path)this.ioService.get(URI.create(kObject.getKey())));
                ArrayList<String> pathsList = new ArrayList<String>();
                pathsList.add(path.getFileName() + "^^" + path.toURI());
                ruleFlowGroupNames.put(property.getValue().toString(), pathsList);
            }
            return ruleFlowGroupNames;
        }
    }
}

