/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.web.filter.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jbpm.designer.web.filter.ConfigurableFilterConfig;
import org.jbpm.designer.web.filter.IFilterFactory;
import org.jbpm.designer.web.filter.impl.FilterChainImpl;

public class PluggableFilter
implements Filter {
    private static List<IFilterFactory> _registeredFilters = new ArrayList<IFilterFactory>();
    private List<Filter> _filters = new ArrayList<Filter>();
    private FilterConfig _filterConfig;

    public static void registerFilter(IFilterFactory filter) {
        _registeredFilters.add(filter);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this._filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this._filters.size() != _registeredFilters.size()) {
            for (Filter filter : this._filters) {
                filter.destroy();
            }
            this._filters.clear();
            for (IFilterFactory iFilterFactory : _registeredFilters) {
                Filter filter = iFilterFactory.createFilter();
                ConfigurableFilterConfig config = new ConfigurableFilterConfig(this._filterConfig);
                iFilterFactory.configureFilterConfig(config);
                filter.init((FilterConfig)config);
                this._filters.add(filter);
            }
        }
        new FilterChainImpl(this._filters, chain).doFilter(request, response);
        if (!response.isCommitted()) {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        for (Filter filter : this._filters) {
            filter.destroy();
        }
        this._filters.clear();
    }
}

