/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.designer.client.DesignerWidgetPresenter;
import org.jbpm.designer.service.DesignerAssetService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchPopup;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@Dependent
@WorkbenchPopup(identifier="jbpm.designer.popup")
public class DesignerPopUpPresenter
extends Composite
implements RequiresResize {
    @Inject
    private DesignerWidgetPresenter designerWidget;
    @Inject
    private Caller<DesignerAssetService> assetService;
    protected boolean isReadOnly;
    private FlowPanel container = new FlowPanel();

    @PostConstruct
    public void init() {
        this.container.clear();
        this.container.setSize("1000px", "549px");
        this.container.add(this.designerWidget.getView());
    }

    @OnOpen
    public void onOpen() {
        this.designerWidget.setSize(1000, 600);
    }

    @OnStartup
    public void onStartup(final PlaceRequest place) {
        this.isReadOnly = true;
        if (place instanceof PathPlaceRequest) {
            ((DesignerAssetService)this.assetService.call((RemoteCallback)new RemoteCallback<String>(){

                public void callback(final String editorID) {
                    String url = GWT.getHostPageBaseURL().replaceFirst("/" + GWT.getModuleName() + "/", "");
                    ((DesignerAssetService)DesignerPopUpPresenter.this.assetService.call((RemoteCallback)new RemoteCallback<Map<String, String>>(){

                        public void callback(Map<String, String> editorParameters) {
                            if (editorParameters != null) {
                                String activeNodes;
                                if (editorParameters.containsKey("readonly")) {
                                    DesignerPopUpPresenter.this.isReadOnly = Boolean.valueOf(editorParameters.get("readonly"));
                                }
                                if (editorParameters.containsKey("processsource")) {
                                    String processSources = editorParameters.get("processsource");
                                    if (processSources != null && processSources.length() > 0) {
                                        DesignerPopUpPresenter.this.publishProcessSourcesInfo(editorParameters.get("processsource"));
                                    }
                                    editorParameters.remove("processsource");
                                }
                                if (editorParameters.containsKey("activenodes")) {
                                    activeNodes = editorParameters.get("activenodes");
                                    if (activeNodes != null && activeNodes.length() > 0) {
                                        DesignerPopUpPresenter.this.publishActiveNodesInfo(editorParameters.get("activenodes"));
                                    }
                                    editorParameters.remove("activenodes");
                                }
                                if (editorParameters.containsKey("completednodes")) {
                                    activeNodes = editorParameters.get("completednodes");
                                    if (activeNodes != null && activeNodes.length() > 0) {
                                        DesignerPopUpPresenter.this.publishCompletedNodesInfo(editorParameters.get("completednodes"));
                                    }
                                    editorParameters.remove("completednodes");
                                }
                                editorParameters.put("ts", Long.toString(System.currentTimeMillis()));
                                DesignerPopUpPresenter.this.designerWidget.setup(editorID, editorParameters);
                            }
                        }
                    })).getEditorParameters((Path)((PathPlaceRequest)place).getPath(), editorID, url, place);
                }
            })).getEditorID();
        }
    }

    @WorkbenchPartTitle
    public String getName() {
        return "Process Model";
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.container;
    }

    private native void publishProcessSourcesInfo(String var1);

    private native void publishActiveNodesInfo(String var1);

    private native void publishCompletedNodesInfo(String var1);

    public void onResize() {
        Widget parent = this.container.getParent();
        int width = parent.getOffsetWidth();
        int height = parent.getOffsetHeight();
        this.container.setWidth(width + "px");
        this.container.setHeight(height + "px");
    }
}

