/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client;

import com.github.gwtbootstrap.client.ui.Modal;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.jbpm.designer.client.DesignerWidgetPresenter;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

public class DesignerWidgetView
extends Composite
implements DesignerWidgetPresenter.View,
RequiresResize {
    private Frame inlineFrame = new Frame();
    private String editorID = "";
    private Map<String, String> editorParameters;

    public DesignerWidgetView() {
        this.setupInlineFrame();
        this.initWidget((Widget)this.inlineFrame);
    }

    private void setupInlineFrame() {
        this.inlineFrame.setWidth("85%");
        this.inlineFrame.setHeight("600");
        this.inlineFrame.getElement().setPropertyBoolean("webkitallowfullscreen", true);
        this.inlineFrame.getElement().setPropertyBoolean("mozallowfullscreen", true);
        this.inlineFrame.getElement().setPropertyBoolean("allowfullscreen", true);
        this.inlineFrame.getElement().getStyle().setBorderWidth(0.0, Style.Unit.PX);
        this.inlineFrame.getElement().getStyle().setOverflowX(Style.Overflow.AUTO);
        this.inlineFrame.getElement().getStyle().setOverflowY(Style.Overflow.AUTO);
        this.inlineFrame.getElement().getStyle().setOverflow(Style.Overflow.AUTO);
        this.inlineFrame.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        this.inlineFrame.getElement().getStyle().setHeight(680.0, Style.Unit.PX);
    }

    @Override
    public void setEditorID(String editorID) {
        this.editorID = editorID;
        this.inlineFrame.getElement().setId(editorID);
        this.inlineFrame.getElement().setAttribute("name", editorID);
    }

    @Override
    public void setEditorParamters(Map<String, String> editorParameters) {
        this.editorParameters = editorParameters;
        String locale = LocaleInfo.getCurrentLocale().getLocaleName();
        String paramsStr = "";
        for (String paramsKey : this.editorParameters.keySet()) {
            paramsStr = paramsStr + "&" + paramsKey + "=" + editorParameters.get(paramsKey);
        }
        paramsStr = paramsStr + "&ms=" + System.currentTimeMillis();
        this.inlineFrame.getElement().setAttribute("src", GWT.getModuleBaseURL() + "inlineeditor.jsp?locale=" + locale + paramsStr);
    }

    @Override
    public String getEditorID() {
        return this.editorID;
    }

    @Override
    public boolean confirmClose() {
        return Window.confirm((String)"Business Process may contain unsaved changes. Are you sure you would like to close the editor?");
    }

    public native void setProcessSaved(String var1);

    public native boolean getIsReadOnly(String var1);

    public native boolean getIsViewLocked(String var1);

    public native void setProcessUnSaved(String var1);

    public native boolean canSaveDesignerModel(String var1);

    public native void raiseEventSave(String var1);

    public native void raiseEventSaveCancel(String var1);

    public native void raiseEventReload(String var1);

    public void onResize() {
        Widget w = this.getParent();
        int width = w.getOffsetWidth();
        int height = w.getOffsetHeight();
        this.inlineFrame.setWidth(width + "px");
        this.inlineFrame.setHeight(height + "px");
    }

    public void setSize(int width, int height) {
        if (this.getParent().getParent().getParent() instanceof Modal) {
            Modal modal = (Modal)this.getParent().getParent().getParent();
            modal.setWidth(width + "px");
            modal.setHeight(height + "px");
            modal.getElement().getStyle().setMarginLeft((double)(width / 2 * -1), Style.Unit.PX);
            modal.getElement().getStyle().setMarginTop((double)(height / 2 * -1), Style.Unit.PX);
            this.getParent().getParent().removeStyleName("modal-body");
            super.setSize(width + "px", height - 51 + "px");
        }
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

